/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import se.ericsson.wcdma.rbs.boam.common.log.AiMessageLog;
import se.ericsson.wcdma.rbs.boam.common.xmlutil.NlhFileEncryptDecryption;
import se.ericsson.wcdma.rbs.boam.common.xmlutil.SimpleXMLParser;

public class XmlFileAttrParser {
    private SimpleXMLParser parser;
    private File xmlFile;

    public XmlFileAttrParser(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public boolean decryptAndParseXML(String decryptPassword) {
        AiMessageLog.traceEnter(this.getClass(), "Decrypt file:" + this.xmlFile);
        boolean decryptRet = NlhFileEncryptDecryption.decryptFile(this.xmlFile.getAbsolutePath(), this.xmlFile.getAbsolutePath(), decryptPassword);
        if (decryptRet) {
            this.parser = new SimpleXMLParser(this.xmlFile);
        }
        return this.parser != null;
    }

    public void decryptAndParseXML() {
        AiMessageLog.info(this.getClass(), "xmlFile" + this.xmlFile);
        AiMessageLog.traceEnter(this.getClass(), "Decrypt file:" + this.xmlFile);
        this.parser = new SimpleXMLParser(this.xmlFile);
    }

    public void encryptXmlFile(String decryptPassword) throws GeneralSecurityException, IOException {
        NlhFileEncryptDecryption.encryptFile(this.xmlFile.getAbsolutePath(), this.xmlFile.getAbsolutePath(), decryptPassword);
    }

    public void parseAndValidate() {
        AiMessageLog.traceEnter(this.getClass(), "Parse file:" + this.xmlFile);
        if (null != this.parser) {
            this.parser.run();
        }
    }

    public String getAttributeValue(String elements, String attribute) {
        if (this.parser == null) {
            return "";
        }
        SimpleXMLParser.Element element = this.parser.getElement(elements);
        return this.getAttribute(element, attribute);
    }

    private String getAttribute(SimpleXMLParser.Element element, String attrName) {
        return element != null ? (String)element.attributes.get(attrName) : null;
    }
}

