/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.geo;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.sync.GpsSyncRefMo;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.wcdma.rbs.boam.common.log.AiMessageLog;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.geo.CoordinateValidationFailedException;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.geo.GeoLocationCheckHandler;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.geo.GpsPosition;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsConfigurationMo;

public class GeoLocationCheckHandlerImpl
implements GeoLocationCheckHandler,
Runnable {
    private static Map startReasonMap = new HashMap();
    private static final String GEO_LOCATION_CHECK_THREAD_NAME = "RbsConfiguration_GeoLocationCheck_start";
    private static int TIMER_BFR_RBS_POSITION_UNAVAILABLE_ALARM_RAISED;
    private static int TIMER_AFTER_RBS_POSITION_UNAVAILABLE_ALARM_RAISED;
    private static int TIMER_MAX_WAIT_GPS_TIME_SECONDS;
    private static int POSITIVE_SIGN;
    private static int NEGATIVE_SIGN;
    private static int UNAVAILABLE_ALARM;
    private static int MISMATCH_ALARM;
    private static TransactionFactory transFact;
    private static final int TX_TIMEOUT = 0;
    private final RbsConfigurationMo rbsConfigurationMo;
    private Thread geoLocCheckThread = null;
    public Integer tolerance = new Integer(0);
    private int totalTimeElapsed = 0;
    private int startReason = 0;
    private Boolean geoCheckResultReady = Boolean.FALSE;
    private Object lock = new Object();
    private String actLongitudeCopy = "";
    private String actLatitudeCopy = "";
    private String actAltitudeCopy = "";
    private String wantedLongitudeCopy = "";
    private String wantedLatitudeCopy = "";
    private String wantedAltitudeCopy = "";
    private String hwSerialNumCopy = "";
    private Sleeper sleeper = new SleeperImpl();

    public GeoLocationCheckHandlerImpl(int inStartReason, RbsConfigurationMo inRbsConfigurationMo) {
        this.rbsConfigurationMo = inRbsConfigurationMo;
        this.setStartReason(inStartReason);
    }

    public void start() {
        AiMessageLog.traceEnter(this.getClass(), "start() with start reason: " + this.getStartReasonName(this.getStartReason()));
        this.setGeoLocCheckThread(new Thread((Runnable)this, GEO_LOCATION_CHECK_THREAD_NAME));
        this.getGeoLocCheckThread().start();
        AiMessageLog.trace(2, this.getClass(), "Started geographic location check handling in a separate thread: " + this.getGeoLocCheckThread().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetVariables() {
        Object object = this.lock;
        synchronized (object) {
            this.geoCheckResultReady = Boolean.FALSE;
        }
        if (this.getStartReason() == 2) {
            this.setTotalTimeElapsed(TIMER_MAX_WAIT_GPS_TIME_SECONDS);
        } else {
            this.setTotalTimeElapsed(0);
        }
    }

    public void run() {
        try {
            this.resetVariables();
            if (this.getStartReason() == 1) {
                this.getSleeper().sleepMinutes(1);
            }
            this.geoLocationCheck();
        }
        catch (MoAccessException e) {
            AiMessageLog.traceError(this.getClass(), "Geographic Location Check failed due to a MO access violation", e);
        }
        catch (InterruptedException e) {
            AiMessageLog.trace(2, this.getClass(), "Geographic Location Check was interrupted by another job with start reason: " + this.getStartReasonName(this.getStartReason()) + " (" + this.getStartReason() + ")");
        }
        catch (TransactionRolledBackException e) {
            AiMessageLog.traceError(this.getClass(), "Geographic Location Check rolled back and could not be performed", e);
        }
        catch (InactiveTransactionException e) {
            AiMessageLog.traceError(this.getClass(), "Geographic Location Check could not be performed due to no association of transaction", e);
        }
        catch (Exception e) {
            AiMessageLog.traceError(this.getClass(), "Geographic Location Check could not be performed due to exception", e);
        }
    }

    public void interruptThread() {
        if (this.getGeoLocCheckThread() != null) {
            this.getGeoLocCheckThread().interrupt();
        }
    }

    public int getStartReason() {
        return this.startReason;
    }

    private String getStartReasonName(int startReason) {
        return (String)startReasonMap.get(new Integer(startReason));
    }

    protected void geoLocationCheck() throws MoAccessException, InterruptedException, TransactionRolledBackException, InactiveTransactionException {
        AiMessageLog.traceEnter(this.getClass(), "geoLocationCheck()");
        GpsPosition wantedPos = this.getWantedPosition();
        if (wantedPos != null) {
            GpsPosition actualPos = this.getActualPosition();
            this.getSerialNumber();
            if (actualPos == null || actualPos.allValuesZero()) {
                boolean positionAvailable = false;
                while (!positionAvailable) {
                    if (!this.resultReady() && this.getTotalTimeElapsed() >= TIMER_MAX_WAIT_GPS_TIME_SECONDS) {
                        this.setGeoCheckResult(11);
                    }
                    if (this.resultReady()) {
                        this.getSleeper().sleepMinutes(TIMER_AFTER_RBS_POSITION_UNAVAILABLE_ALARM_RAISED);
                    } else {
                        this.getSleeper().sleepSeconds(TIMER_BFR_RBS_POSITION_UNAVAILABLE_ALARM_RAISED);
                    }
                    actualPos = this.getActualPosition();
                    positionAvailable = actualPos != null && !actualPos.allValuesZero();
                }
                wantedPos = this.getWantedPosition();
            }
            if (wantedPos != null && this.tolerance != null) {
                double distance = GpsPosition.distance(wantedPos, actualPos);
                AiMessageLog.trace(2, this.getClass(), " geoLocationCheck(): distance = " + distance + ", tolerance = " + this.tolerance);
                if (distance > this.tolerance.doubleValue()) {
                    this.setGeoCheckResult(10);
                } else {
                    this.setGeoCheckResult(8);
                }
            }
        } else {
            this.setGeoCheckResult(9);
        }
    }

    public GpsPosition getWantedPosition() throws MoAccessException {
        GpsPosition retVal;
        block10: {
            AiMessageLog.traceEnter(this.getClass(), "getWantedPosition()");
            retVal = null;
            try {
                boolean altitudeEmpty;
                Struct wantedPos = this.rbsConfigurationMo.getWantedPosition(null);
                String latitudeString = (String)wantedPos.getValue("latitude");
                String longitudeString = (String)wantedPos.getValue("longitude");
                String altitudeString = (String)wantedPos.getValue("altitude");
                this.tolerance = (Integer)wantedPos.getValue("tolerance");
                this.setWantedLatitudeCopy(latitudeString);
                this.setWantedLongitudeCopy(longitudeString);
                this.setWantedAltitudeCopy(altitudeString);
                boolean latitudeEmpty = latitudeString == null || latitudeString.equals("") || latitudeString.equals("-");
                boolean longitudeEmpty = longitudeString == null || longitudeString.equals("") || longitudeString.equals("-");
                boolean bl = altitudeEmpty = altitudeString == null || altitudeString.equals("") || altitudeString.equals("-");
                if (!latitudeEmpty && !longitudeEmpty) {
                    try {
                        if (altitudeEmpty) {
                            retVal = new GpsPosition(GeoLocationCheckHandlerImpl.parseLatitude(latitudeString), GeoLocationCheckHandlerImpl.parseLongitude(longitudeString));
                            break block10;
                        }
                        retVal = new GpsPosition(GeoLocationCheckHandlerImpl.parseLatitude(latitudeString), GeoLocationCheckHandlerImpl.parseLongitude(longitudeString), Double.parseDouble(altitudeString.trim()));
                    }
                    catch (NumberFormatException e) {
                        AiMessageLog.traceError(this.getClass(), "wantedPosition is not properly formatted. Geographic location check feature deactivated :" + e.getMessage(), e);
                    }
                    break block10;
                }
                if (!(!latitudeEmpty && !longitudeEmpty || latitudeEmpty && longitudeEmpty && altitudeEmpty)) {
                    AiMessageLog.traceError(this.getClass(), "Some parts of wantedPosition are not set or incorrectly set. Geographic location check feature deactivated");
                }
            }
            catch (NoSuchAttributeException e) {
                AiMessageLog.traceError(this.getClass(), "There is no such attribute. Received NoSuchAttributeException exception when setting wanted position", e);
            }
        }
        if (retVal != null) {
            AiMessageLog.trace(2, this.getClass(), "getWantedPosition() : " + retVal.toString() + " Tolerance: " + this.tolerance);
        }
        return retVal;
    }

    public GpsPosition getActualPosition() throws MoAccessException, TransactionRolledBackException, InactiveTransactionException {
        AiMessageLog.traceEnter(this.getClass(), "getActualPosition()");
        GpsSyncRefMo gpsMo = (GpsSyncRefMo)BoamHelper.getFirstMatchingMo("GpsSyncRef");
        GpsPosition retVal = null;
        if (gpsMo == null) {
            AiMessageLog.traceError(this.getClass(), "getActualPosition(). The GpsSyncRef MO is not found.");
            return null;
        }
        try {
            String longitudeString = gpsMo.getLongitude(null);
            String latitudeString = gpsMo.getLatitude(null);
            String altitudeString = gpsMo.getAltitude(null);
            this.setActLongitudeCopy(longitudeString);
            this.setActLatitudeCopy(latitudeString);
            this.setActAltitudeCopy(altitudeString);
            if (!(longitudeString == null || "".equals(longitudeString) || latitudeString == null || "".equals(latitudeString) || altitudeString == null || "".equals(altitudeString))) {
                retVal = new GpsPosition(GeoLocationCheckHandlerImpl.parseLatitude(latitudeString), GeoLocationCheckHandlerImpl.parseLongitude(longitudeString), Double.parseDouble(altitudeString.trim()));
            }
        }
        catch (NumberFormatException e) {
            AiMessageLog.info(this.getClass(), "gpsSyncRef has incorrectly formatted GPS position. Geographic location check feature deactivated: " + e.getMessage());
        }
        if (retVal != null) {
            AiMessageLog.trace(2, this.getClass(), "getActualPosition() : " + retVal.toString() + " Tolerance: " + this.tolerance);
        }
        return retVal;
    }

    /*
     * WARNING - void declaration
     */
    public static double parseLatitude(String inValue) throws NumberFormatException {
        void var2_2;
        int sign;
        if ((inValue = inValue.trim()).length() < 2) {
            throw new NumberFormatException("Empty latitude string is not allowed");
        }
        char directionChar = inValue.toUpperCase(Locale.getDefault()).charAt(0);
        if (directionChar == 'N') {
            sign = POSITIVE_SIGN;
        } else if (directionChar == 'S') {
            sign = NEGATIVE_SIGN;
        } else {
            throw new NumberFormatException("Bad latitude formatting: " + inValue);
        }
        return (double)var2_2 * GeoLocationCheckHandlerImpl.parseLongitudeLatitude(inValue.substring(1).trim());
    }

    /*
     * WARNING - void declaration
     */
    public static double parseLongitude(String inValue) throws NumberFormatException {
        void var2_2;
        int sign;
        if ((inValue = inValue.trim()).length() < 2) {
            throw new NumberFormatException("Empty longitude string is not allowed");
        }
        char directionChar = inValue.toUpperCase(Locale.getDefault()).charAt(0);
        if (directionChar == 'E') {
            sign = POSITIVE_SIGN;
        } else if (directionChar == 'W') {
            sign = NEGATIVE_SIGN;
        } else {
            throw new NumberFormatException("Bad longitude formatting: " + inValue);
        }
        return (double)var2_2 * GeoLocationCheckHandlerImpl.parseLongitudeLatitude(inValue.substring(1).trim());
    }

    private static double parseLongitudeLatitude(String inValue) throws NumberFormatException {
        int dotIndex = inValue.indexOf(46);
        if (dotIndex == -1) {
            throw new NumberFormatException("Bad formatting (the format should contains dot between degree and decimal minutes value)" + inValue);
        }
        String degreesString = inValue.substring(0, dotIndex);
        int degrees = Integer.parseInt(degreesString);
        if (degrees < 0) {
            throw new NumberFormatException("Bad formatting (negative degrees not allowed): " + inValue);
        }
        String minutesString = inValue.substring(dotIndex + 1);
        double minutes = Double.parseDouble(minutesString);
        if (minutes < 0.0 || minutes > 60.0) {
            throw new NumberFormatException("Bad formatting (minutes out of range): " + inValue);
        }
        return (double)degrees + minutes / 60.0;
    }

    public static void verifyWantedPositionFormatting(String latitude, String longitude, String altitude) throws CoordinateValidationFailedException {
        boolean longitudeEmpty;
        boolean latitudeEmpty = latitude == null || "".equals(latitude) || "-".equals(latitude);
        boolean bl = longitudeEmpty = longitude == null || "".equals(longitude) || "-".equals(longitude);
        if (latitudeEmpty && longitudeEmpty) {
            return;
        }
        if (latitudeEmpty || longitudeEmpty) {
            throw new CoordinateValidationFailedException("Latitude or longitude are empty. Longitude = " + longitude + " Latitude = " + latitude);
        }
        try {
            GeoLocationCheckHandlerImpl.parseLatitude(latitude);
            GeoLocationCheckHandlerImpl.parseLongitude(longitude);
            if (!"".equals(altitude) && !"-".equals(altitude)) {
                Double.parseDouble(altitude);
            }
        }
        catch (NumberFormatException e) {
            throw new CoordinateValidationFailedException("NumberFormatException caught during validation: " + e.getMessage());
        }
    }

    public void getSerialNumber() throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getSerialNumber()");
        String serialNum = null;
        this.setHwSerialNumCopy("-");
        serialNum = GeoLocationCheckHandlerImpl.getSerialNumberCommon();
        if (serialNum != null) {
            this.setHwSerialNumCopy(serialNum);
        }
    }

    public static String getSerialNumberCommon() throws MoAccessException {
        AiMessageLog.traceEnter(GeoLocationCheckHandlerImpl.class, "getSerialNumber_Common()");
        String serialNum = null;
        try {
            serialNum = GeoLocationCheckHandlerImpl.getSerialNumberFromSlot(true);
            if (serialNum == null) {
                serialNum = GeoLocationCheckHandlerImpl.getSerialNumberFromCabinet();
            }
        }
        catch (TransactionRolledBackException e) {
            AiMessageLog.traceError(GeoLocationCheckHandlerImpl.class, "Received TransactionRolledBackException exception when fetching hardware serial number", e);
        }
        catch (InactiveTransactionException e) {
            AiMessageLog.traceError(GeoLocationCheckHandlerImpl.class, "Received InactiveTransactionException exception when fetching hardware serial number", e);
        }
        if (serialNum == null) {
            AiMessageLog.traceError(GeoLocationCheckHandlerImpl.class, "The returned HW serial number is null.");
        }
        return serialNum;
    }

    public static String getSerialNumberFromSlot(boolean isVerifyProductName) throws MoAccessException, TransactionRolledBackException, InactiveTransactionException {
        String hwSerialNum = null;
        String hwProductName = null;
        SlotMo slotMo = (SlotMo)BoamHelper.getFirstMatchingMo("Slot", "1");
        if (slotMo != null) {
            Struct productData = null;
            try {
                productData = slotMo.getProductData(null);
            }
            catch (NullPointerException e) {
                productData = null;
            }
            if (productData != null) {
                hwSerialNum = (String)productData.getValue("serialNumber");
                hwProductName = (String)productData.getValue("productName");
                if (hwSerialNum == null || hwSerialNum.equals("") || hwProductName == null || isVerifyProductName && hwProductName.trim().startsWith("ODS")) {
                    hwSerialNum = null;
                }
            }
        }
        return hwSerialNum;
    }

    protected static String getSerialNumberFromCabinet() throws MoAccessException, TransactionRolledBackException, InactiveTransactionException {
        String hwSerialNum = null;
        ManagedObject cabinetMo = BoamHelper.getFirstMatchingMo("Cabinet");
        if (cabinetMo != null) {
            Struct productData = null;
            productData = (Struct)cabinetMo.getAttribute("productData", null);
            if (productData != null) {
                hwSerialNum = (String)productData.getValue("serialNumber");
            }
        }
        return hwSerialNum;
    }

    public AdditionalInfo[] getAdditionalInfo(int alarmType, double distance) {
        AiMessageLog.traceEnter(this.getClass(), "getAdditionalInfo()");
        AdditionalInfo[] additionalInfo = null;
        if (alarmType == MISMATCH_ALARM) {
            additionalInfo = new AdditionalInfo[]{new AdditionalInfo("Physical position", this.getActLatitudeCopy() + " " + this.getActLongitudeCopy() + " " + this.getActAltitudeCopy()), new AdditionalInfo("Configured position", this.getWantedLatitudeCopy() + " " + this.getWantedLongitudeCopy() + " " + this.getWantedAltitudeCopy()), new AdditionalInfo("Difference (m)", new DecimalFormat("#.##").format(distance)), new AdditionalInfo("Hardware serial number", this.getHwSerialNumCopy())};
        } else if (alarmType == UNAVAILABLE_ALARM) {
            additionalInfo = new AdditionalInfo[]{new AdditionalInfo("Hardware serial number", this.getHwSerialNumCopy())};
        }
        if (additionalInfo != null) {
            for (int i = 0; i < additionalInfo.length; ++i) {
                AiMessageLog.trace(2, this.getClass(), additionalInfo[i].getName() + ": " + additionalInfo[i].getValue());
            }
        }
        return additionalInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGeoCheckResult(int result2) throws MoAccessException, TransactionRolledBackException, InactiveTransactionException {
        AiMessageLog.traceEnter(this.getClass(), "setGeoCheckResult( " + this.rbsConfigurationMo.getRbsConfigLevelName(result2) + ") (" + result2 + ")  ");
        if (this.getStartReason() == 3) {
            Control control = transFact.create(0);
            Coordinator coordinator = control.getCoordinator();
            try {
                this.rbsConfigurationMo.setRbsConfigLevel(result2, coordinator);
                control.getTerminator().commit();
            }
            catch (MoAccessException e) {
                control.getTerminator().rollback();
                throw e;
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.geoCheckResultReady = Boolean.TRUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultReady() {
        boolean value;
        Object object = this.lock;
        synchronized (object) {
            value = this.geoCheckResultReady;
        }
        return value;
    }

    public static void validateGeoPosition(Struct wantedPosition) throws MoAccessException {
        String latitude = (String)wantedPosition.getValue("latitude");
        String longitude = (String)wantedPosition.getValue("longitude");
        String altitude = (String)wantedPosition.getValue("altitude");
        GeoLocationCheckHandlerImpl.verifyWantedPositionFormatting(latitude, longitude, altitude);
    }

    public void setSleeper(Sleeper inSleeper) {
        this.sleeper = inSleeper;
    }

    public Thread getGeoLocCheckThread() {
        return this.geoLocCheckThread;
    }

    public void setGeoLocCheckThread(Thread geoLocCheckThread) {
        this.geoLocCheckThread = geoLocCheckThread;
    }

    public void setStartReason(int startReason) {
        this.startReason = startReason;
    }

    public int getTotalTimeElapsed() {
        return this.totalTimeElapsed;
    }

    public void setTotalTimeElapsed(int totalTimeElapsed) {
        this.totalTimeElapsed = totalTimeElapsed;
    }

    public String getHwSerialNumCopy() {
        return this.hwSerialNumCopy;
    }

    public void setHwSerialNumCopy(String hwSerialNumCopy) {
        this.hwSerialNumCopy = hwSerialNumCopy;
    }

    public String getActLatitudeCopy() {
        return this.actLatitudeCopy;
    }

    public void setActLatitudeCopy(String actLatitudeCopy) {
        this.actLatitudeCopy = actLatitudeCopy;
    }

    public String getActLongitudeCopy() {
        return this.actLongitudeCopy;
    }

    public void setActLongitudeCopy(String actLongitudeCopy) {
        this.actLongitudeCopy = actLongitudeCopy;
    }

    public String getActAltitudeCopy() {
        return this.actAltitudeCopy;
    }

    public void setActAltitudeCopy(String actAltitudeCopy) {
        this.actAltitudeCopy = actAltitudeCopy;
    }

    public String getWantedLatitudeCopy() {
        return this.wantedLatitudeCopy;
    }

    public void setWantedLatitudeCopy(String wantedLatitudeCopy) {
        this.wantedLatitudeCopy = wantedLatitudeCopy;
    }

    public String getWantedLongitudeCopy() {
        return this.wantedLongitudeCopy;
    }

    public void setWantedLongitudeCopy(String wantedLongitudeCopy) {
        this.wantedLongitudeCopy = wantedLongitudeCopy;
    }

    public String getWantedAltitudeCopy() {
        return this.wantedAltitudeCopy;
    }

    public void setWantedAltitudeCopy(String wantedAltitudeCopy) {
        this.wantedAltitudeCopy = wantedAltitudeCopy;
    }

    public Sleeper getSleeper() {
        return this.sleeper;
    }

    static {
        startReasonMap.put(new Integer(3), "GEO_CHECK_START_REASON_GPS_CHECK_POSITION");
        startReasonMap.put(new Integer(1), "GEO_CHECK_START_REASON_RESTART");
        startReasonMap.put(new Integer(2), "GEO_CHECK_START_REASON_WANTED_POS_CHANGED");
        TIMER_BFR_RBS_POSITION_UNAVAILABLE_ALARM_RAISED = 30;
        TIMER_AFTER_RBS_POSITION_UNAVAILABLE_ALARM_RAISED = 5;
        TIMER_MAX_WAIT_GPS_TIME_SECONDS = 750;
        POSITIVE_SIGN = 1;
        NEGATIVE_SIGN = -1;
        UNAVAILABLE_ALARM = 0;
        MISMATCH_ALARM = 1;
        transFact = TransactionServiceImpl.instance().getTransactionFactory();
    }

    public class SleeperImpl
    implements Sleeper {
        public boolean isSleeping = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sleepMinutes(int minutes) throws InterruptedException {
            SleeperImpl sleeperImpl = this;
            synchronized (sleeperImpl) {
                this.isSleeping = true;
            }
            TimeUnit.MINUTES.sleep((long)minutes);
            GeoLocationCheckHandlerImpl.this.setTotalTimeElapsed(GeoLocationCheckHandlerImpl.this.getTotalTimeElapsed() + minutes * 60);
            sleeperImpl = this;
            synchronized (sleeperImpl) {
                this.isSleeping = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sleepSeconds(int seconds) throws InterruptedException {
            SleeperImpl sleeperImpl = this;
            synchronized (sleeperImpl) {
                this.isSleeping = true;
            }
            if (GeoLocationCheckHandlerImpl.this.getStartReason() != 2) {
                TimeUnit.SECONDS.sleep((long)seconds);
            }
            GeoLocationCheckHandlerImpl.this.setTotalTimeElapsed(GeoLocationCheckHandlerImpl.this.getTotalTimeElapsed() + seconds);
            sleeperImpl = this;
            synchronized (sleeperImpl) {
                this.isSleeping = false;
            }
        }
    }

    public static interface Sleeper {
        public void sleepMinutes(int var1) throws InterruptedException;

        public void sleepSeconds(int var1) throws InterruptedException;
    }
}

