/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice;

import enea.ose.system.InSignal;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalObserver;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.cello.upgradepackage.control.UpgradeController;
import se.ericsson.cello.upgradepackage.main.interfaces.TriggerCentral;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMaster;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcAuxPiuProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcProgramProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcSwUpgradeIndS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScRfAccessProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccWiltCellsIndS;

public class UpgradeManager
implements Runnable,
SignalObserver,
UpgradeParticipator {
    private static UpgradeManager theOneAndOnly;
    private static int CLIENT_ID;
    public static final String RBSINITIATE = "RBSINITIATE";
    public static final String SOFT_LOCK = "SOFT_LOCK";
    private static SignalPort portManager;
    private boolean preloadsuccess = false;
    private EqcSwUpgradeIndS eqcSwUpgradeIndS = null;
    private SccWiltCellsIndS sccWiltCellsInd = null;
    private Object lock = null;
    private EqcAuxPiuProxy eqcAuxPiuProxy = EqcAuxPiuProxy.instance();
    private ScRfAccessProxy scRfAccessProxy = ScRfAccessProxy.instance();
    private int _testTimeOut = 10;
    private boolean _isTest = false;

    private UpgradeManager() {
        MessageLog.traceEnter(this.getClass(), "UpgradeManager()");
        this.lock = new Object();
        TriggerCentral.subscribeAdmin().addUpgradeParticipator((UpgradeParticipator)this);
        UpgradeController.upgradeRegistry().addPlugInUnitMoTypeName("AuxPlugInUnit");
        this.addSignalObservers();
        EqcProgramProxy.instance();
    }

    public static synchronized UpgradeManager instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new UpgradeManager();
        }
        return theOneAndOnly;
    }

    public void run() {
        while (true) {
            // Infinite loop
        }
    }

    public String participatorName() {
        return "BOAM Upgrade Manager";
    }

    public void triggerIndicated(UpgradeMaster master, String triggerName) {
        MessageLog.info(this.getClass(), " triggerIndicated(),Trigger " + triggerName + " received");
        boolean success = false;
        Exception exception = null;
        try {
            success = triggerName.equals(RBSINITIATE) ? this.triggerRbsInitiate() : (triggerName.equals(SOFT_LOCK) ? this.triggerSoftLock() : (triggerName.equals("START") ? this.triggerStart() : (triggerName.equals("INITIATE") ? this.triggerInitiate() : (triggerName.equals("PRELOAD") ? this.triggerPreload() : (triggerName.equals("CONVERT") ? this.triggerConvert() : (triggerName.equals("EXECUTE") ? this.triggerExecute() : (triggerName.equals("FINISH") ? this.triggerFinish() : (triggerName.equals("CONFIRMED") ? this.triggerConfirmed() : this.handleOtherTrigger(triggerName)))))))));
        }
        catch (Exception e) {
            exception = e;
            MessageLog.traceError(this.getClass(), "triggerIndicated(), Error!! operation failed du to Excep: " + e.toString());
        }
        MessageLog.writeTraceToSystemLog(master, this, triggerName, success, exception);
        MessageLog.info(this.getClass(), "triggerIndicated(), trigger: " + triggerName + " confirmed: " + success);
    }

    public void addSignalObservers() {
        MessageLog.traceEnter(this.getClass(), "addSignalObservers()");
        portManager.addSignalObserver((SignalObserver)this, EqcSwUpgradeIndS.class);
        portManager.addSignalObserver((SignalObserver)this, SccWiltCellsIndS.class);
        MessageLog.trace(2, this.getClass(), "addSignalObservers() executed");
    }

    public void removeSignalObservers() {
        MessageLog.traceEnter(this.getClass(), "removeSignalObservers()");
        portManager.removeSignalObserver((SignalObserver)this, EqcSwUpgradeIndS.class);
        MessageLog.trace(2, this.getClass(), "removeSignalObservers() executed ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalReceived(InSignal receiveSig) {
        MessageLog.traceEnter(this.getClass(), "UpgradeManagerMo:signalReceived() Signal: " + receiveSig.getClass().getName() + ", Signal No:" + receiveSig.getSigNo());
        Object object = this.lock;
        synchronized (object) {
            if (receiveSig instanceof SccWiltCellsIndS) {
                this.sccWiltCellsInd = (SccWiltCellsIndS)receiveSig;
                MessageLog.info(this.getClass(), "SccWiltCellsIndS is received.");
            } else if (receiveSig instanceof EqcSwUpgradeIndS) {
                this.eqcSwUpgradeIndS = (EqcSwUpgradeIndS)receiveSig;
                if (this.eqcSwUpgradeIndS.preloadResult == 3) {
                    MessageLog.info(this.getClass(), "EqcSwUpgradeIndS is received with result: failedRolBack");
                    this.preloadsuccess = false;
                } else if (this.eqcSwUpgradeIndS.preloadResult == 1 || this.eqcSwUpgradeIndS.preloadResult == 2) {
                    MessageLog.info(this.getClass(), "EqcSwUpgradeIndS is received with result: OK or Continue");
                    this.preloadsuccess = true;
                } else {
                    MessageLog.info(this.getClass(), "EqcSwUpgradeIndS is received with result undefined!! preloadResult: " + this.eqcSwUpgradeIndS.preloadResult);
                    this.preloadsuccess = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPreloadIndRec() {
        Object object = this.lock;
        synchronized (object) {
            return this.eqcSwUpgradeIndS != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPreloadState(boolean success) {
        Object object = this.lock;
        synchronized (object) {
            this.preloadsuccess = success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getPreloadState() {
        Object object = this.lock;
        synchronized (object) {
            return this.preloadsuccess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSoftLockIndRec() {
        Object object = this.lock;
        synchronized (object) {
            return this.sccWiltCellsInd != null;
            {
            }
        }
    }

    private boolean triggerRbsInitiate() {
        MessageLog.traceEnter(this.getClass(), "triggerRbsInitiate()");
        boolean success = true;
        try {
            this.eqcAuxPiuProxy.upgradeSwPhase(CLIENT_ID, 1);
        }
        catch (Exception e) {
            MessageLog.traceError(this.getClass(), "triggerRbsInitiate(), EqcSwUpgradeReqS(triggerRbsInitiate) failed. No Respons or EC returned result NOT OK!! " + e);
            success = false;
        }
        return success;
    }

    private boolean triggerStart() {
        MessageLog.traceEnter(this.getClass(), "triggerStart()");
        boolean success = true;
        return success;
    }

    private boolean triggerInitiate() {
        MessageLog.traceEnter(this.getClass(), "triggerInitiate()");
        boolean success = true;
        return success;
    }

    private boolean triggerPreload() {
        MessageLog.traceEnter(this.getClass(), "triggerPreload()");
        this.eqcSwUpgradeIndS = null;
        this.setPreloadState(false);
        boolean success = true;
        try {
            this.eqcAuxPiuProxy.upgradeSwPhase(CLIENT_ID, 2);
            success = true;
        }
        catch (Exception e) {
            success = false;
            MessageLog.traceError(this.getClass(), "triggerPreload(), EqcSwUpgradeReqS(Preload) failed: No Respons or EC returned result NOT OK!! " + e.toString());
        }
        int preloadTime = 0;
        if (success) {
            int i = 0;
            int times = 330;
            if (this._isTest) {
                times = this._testTimeOut;
            }
            while (!this.isPreloadIndRec() && i < times) {
                try {
                    MessageLog.trace(2, this.getClass(), "triggerPreload(), No eqcSwUpgradeIndS is received in order to confirm the preload. Going to sleep 10 sec before next check. Time passed sec.: " + preloadTime + "(" + times * 10 + ")");
                    Thread.sleep(10000L);
                    preloadTime += 10;
                }
                catch (Exception e1) {
                    MessageLog.traceError(this.getClass(), "triggerPreload(), SW Error!! Exception: " + e1);
                }
                ++i;
            }
        }
        if (!this.getPreloadState()) {
            if (this.isPreloadIndRec()) {
                MessageLog.traceError(this.getClass(), "triggerPreload() failed: EC returned Preload failed!!");
            } else {
                MessageLog.traceError(this.getClass(), "triggerPreload() failed: Preload failed!! Timeout, No eqcSwUpgradeIndS is recieved. Timeout(sec):" + preloadTime);
            }
        }
        return true;
    }

    private boolean triggerSoftLock() {
        MessageLog.traceEnter(this.getClass(), "triggerSoftLock()");
        boolean success = true;
        this.sccWiltCellsInd = null;
        try {
            this.scRfAccessProxy.startWiltCells();
            success = true;
        }
        catch (Exception e) {
            success = false;
            MessageLog.traceError(this.getClass(), "SccWiltCellsReqS(SoftLock) failed. No Respons or Scc returned SccWiltCellsRspS with result NOT OK!! " + e);
        }
        int wiltTime = 0;
        if (success) {
            int i = 0;
            int times = 15;
            if (this._isTest) {
                times = this._testTimeOut;
            }
            while (!this.isSoftLockIndRec() && i < times) {
                try {
                    MessageLog.trace(2, this.getClass(), "triggerSoftLock(), No sccWiltCellsInd is received in order to confirm the SOFT_LOCK. Going to sleep 10 sec before next check. Time passed: " + wiltTime + "(" + times * 10 + ")");
                    Thread.sleep(10000L);
                    wiltTime += 10;
                }
                catch (Exception e1) {
                    MessageLog.traceError(this.getClass(), "triggerSoftLock(), SW Error!! Exception:" + e1);
                }
                ++i;
            }
        }
        if (!this.isSoftLockIndRec() && success) {
            MessageLog.info(this.getClass(), "triggerSoftLock() SOFT_LOCK failed!! Timeout, No sccWiltCellsInd is recieved. Timeout(sec):" + wiltTime);
        }
        return true;
    }

    private boolean triggerConvert() {
        MessageLog.traceEnter(this.getClass(), "triggerConvert()");
        boolean success = true;
        return success;
    }

    private boolean triggerExecute() {
        MessageLog.traceEnter(this.getClass(), "triggerExecute()");
        boolean success = false;
        try {
            this.eqcAuxPiuProxy.upgradeSwPhase(CLIENT_ID, 3);
            success = true;
        }
        catch (Exception e) {
            MessageLog.traceError(this.getClass(), " triggerExecute()  EqcSwUpgradeReqS(Execute) failed: No response or EqcSwUpgradeReqS returned result NOK!!   " + e);
        }
        return success;
    }

    private boolean triggerFinish() {
        MessageLog.traceEnter(this.getClass(), "triggerFinish()");
        boolean success = true;
        return success;
    }

    private boolean triggerConfirmed() {
        MessageLog.traceEnter(this.getClass(), "triggerConfirmed()");
        boolean success = true;
        return success;
    }

    private boolean handleOtherTrigger(String triggerName) {
        MessageLog.traceEnter(this.getClass(), "An Undefined trigger received :  " + triggerName);
        return true;
    }

    public void _reset_onlyForTest(boolean value, int timeOut_i10Sec) {
        this._isTest = value;
        this._testTimeOut = timeOut_i10Sec;
    }

    static {
        CLIENT_ID = 0;
        portManager = PortManager.instance();
    }
}

