/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.device;

import enea.ose.system.InSignal;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.FroObjectTypeDefs;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.MoEventable;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcBdhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceGroupProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetGroupParametersRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGroupEventIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGroupHwLogConfigIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGroupStartedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcTestGroupEndIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsGroupFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.AttrListImpl;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.common.MoHelper;
import se.ericsson.wcdma.rbs.boam.mao.emo.bb.DownlinkBaseBandPoolMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.emo.bb.UplinkBaseBandPoolMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.event.MoEvents;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.AlreadyInitiatedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FunctionNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.MoNotLockedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationFailedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationNotAllowedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.TestBoardDependencyException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DbDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsSynchronizationMo;

public abstract class DbDeviceGroupMoImpl
extends BoamManagedObjectWithAlarms
implements DbDeviceGroupMo,
MoEventable,
MaoHasFro {
    protected static final int SUP_CLIENT_ID = 0;
    public static final String GROUP_FRO_ID = "groupFroId";
    public static final String USER_LABEL_NAME = "userLabel";
    public static final String USER_LABEL_DEF_VAL = "";
    private static final int USER_LABEL_MIN_LENGTH = 0;
    private static final int USER_LABEL_MAX_LENGTH = 128;
    public static final String USAGE_STATE_NAME = "usageState";
    public static final int USAGE_STATE_DEF_VAL = 0;
    public static final int USAGE_STATE_MIN_VAL = 0;
    public static final int USAGE_STATE_MAX_VAL = 2;
    protected MoEvents myMoEvents;
    protected int thisFroId = 0;
    protected EqcDeviceGroupProxy eqcDeviceGroupProxy = EqcDeviceGroupProxy.instance();
    protected EqcBdhIndProxy eqcBdhIndProxy = EqcBdhIndProxy.instance();

    public DbDeviceGroupMoImpl(ManagedObject parent, String thisMoName, AttrList attributes, String identity, Coordinator context, int maxNoOfChildren) throws MoAccessException {
        super(parent, thisMoName, identity, context, maxNoOfChildren);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        IntegerAttribute tmpIntegerAttr = new IntegerAttribute("hwTestResult", false);
        tmpIntegerAttr.setValue(3);
        this.myData.registerTransientAttr((Attribute)tmpIntegerAttr);
    }

    public DbDeviceGroupMoImpl(ManagedObject parent, String thisMoName, String identity, Coordinator context, int maxNoOfChildren) throws MoAccessException {
        super(parent, thisMoName, identity, context, maxNoOfChildren);
    }

    public DbDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
        this.thisFroId = this.getGroupFroId(null);
        IntegerAttribute tmpIntegerAttr = new IntegerAttribute("hwTestResult", false);
        tmpIntegerAttr.setValue(3);
        this.myData.registerTransientAttr((Attribute)tmpIntegerAttr);
    }

    public RbsGroupFroInfoT createDeviceGroupResource(ManagedObject parent, int groupType, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createDeviceGroupResource()");
        return this.createDeviceGroupResourceRsps((ManagedObject)parent, (int)groupType, (Coordinator)context).groupFroInfo;
    }

    public EqcCreateGroupRspS createDeviceGroupResourceRsps(ManagedObject parent, int groupType, Coordinator context) throws MoAccessException {
        PlugInUnitMo plugInUnit;
        MessageLog.traceEnter(this.getClass(), "createDeviceGroupResourceRsps()");
        int piuFroId = this.getParentFroId(context);
        SlotMo slotMo = (SlotMo)DbDeviceGroupMoImpl.getAncestor((ManagedObject)this, "Slot");
        SubrackMo subrackMo = (SubrackMo)slotMo.getParent();
        Integer subrackId = subrackMo.getResourceId(context);
        int slotId = slotMo.getSlotNumber(context);
        ManagedObject positionRef = null;
        ManagedObject grandParent = parent.getParent();
        if (parent instanceof PlugInUnitMo) {
            plugInUnit = (PlugInUnitMo)parent;
            positionRef = plugInUnit.getPositionRef(context);
        } else if (grandParent instanceof PlugInUnitMo) {
            plugInUnit = (PlugInUnitMo)grandParent;
            positionRef = plugInUnit.getPositionRef(context);
        }
        String posRef = USER_LABEL_DEF_VAL;
        if (positionRef != null) {
            posRef = positionRef.getLocalDistinguishedName();
        }
        String boardLDN = parent.getLocalDistinguishedName();
        EqcCreateGroupRspS rsp = this.eqcDeviceGroupProxy.createGroup(this.getTxIdTransactional(context), 0L, groupType, piuFroId, subrackId, slotId, posRef, boardLDN);
        this.thisFroId = (int)rsp.groupFroInfo.groupFroId;
        IntegerAttribute tmpIntAttr = new IntegerAttribute(GROUP_FRO_ID, false);
        tmpIntAttr.setValue(this.thisFroId);
        this.myData.registerPersistentAttr((Attribute)tmpIntAttr);
        MessageLog.trace(1, this.getClass(), "Device Group created with groupFroId = " + this.thisFroId);
        return rsp;
    }

    public static void createSystemMos(int poolId, int rbsGroupType, ManagedObject forMO, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(DbDeviceGroupMoImpl.class, "createSystemMos()");
        switch (rbsGroupType) {
            case 49575: 
            case 49576: 
            case 49577: 
            case 49582: {
                ManagedObject parent = DbDeviceGroupMoImpl.getAncestor(forMO, "Subrack");
                AttrListImpl attrList = new AttrListImpl();
                DownlinkBaseBandPoolMoFactory.instance().createSystemMo(parent, attrList, poolId, forMO, null, context);
                UplinkBaseBandPoolMoFactory.instance().createSystemMo(parent, attrList, poolId, forMO, null, context);
                break;
            }
            default: {
                MessageLog.traceError(forMO.getClass(), "Invalid Create attempt, this is a System Created MO : ");
                throw new OperationNotAllowedException();
            }
        }
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        ValidateAttributes.checkTransaction(context);
        if (this.isReserved(context)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        if (this.isAnyChildReserved(context)) {
            throw new ResourceLockedException("this MO has a child that is reserved");
        }
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.eqcDeviceGroupProxy.deleteGroup(this.getTxIdTransactional(context), 0L, this.getGroupFroId(context));
        MoIterator iter = this.getChildren();
        MessageLog.trace(1, this.getClass(), "delete device sets");
        if (iter != null) {
            while (iter.hasMoreElements()) {
                ManagedObject child = iter.nextMo();
                if (!(child instanceof DeviceSetMo)) continue;
                ((DeviceSetMo)child).sysDelete(context);
            }
        }
        this.removeObservers(context);
        super.delete(context);
    }

    public void superDelete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "superDelete()");
        ValidateAttributes.checkTransaction(context);
        if (this.isReserved(context)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.eqcDeviceGroupProxy.deleteGroup(this.getTxIdTransactional(context), 0L, this.getGroupFroId(context));
        MoIterator iter = this.getChildren();
        MessageLog.trace(1, this.getClass(), "delete device sets");
        if (iter != null) {
            while (iter.hasMoreElements()) {
                ManagedObject child = iter.nextMo();
                if (!(child instanceof DeviceSetMo)) continue;
                ((DeviceSetMo)child).sysDelete(context);
            }
        }
        this.removeObservers(context);
        super.delete(context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute(USER_LABEL_NAME, context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute(USER_LABEL_NAME, value, 0, 128, this.getType(), context);
        this.sendAVC(USER_LABEL_NAME, value, context);
    }

    public int getUsageState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUsageState()");
        EqcGetGroupParametersRspS rspSig = this.eqcDeviceGroupProxy.getGroupParameters(this.getTxIdNonTransactional(context), 0L, this.getGroupFroId(context));
        return rspSig.usageState;
    }

    public void actionStartHwTest(String testId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStartHwTest()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.boardDependencyCheckUc1Fs6(context);
        try {
            this.eqcDeviceGroupProxy.startDeviceGroupHwTest(0L, this.getGroupFroId(context), testId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 9) {
                throw new MoNotLockedException();
            }
            if (e.getOrgErrorCode() == 13) {
                this.updateHwTestResult(2);
                throw new AlreadyInitiatedException();
            }
            if (e.getOrgErrorCode() == 39) {
                this.updateHwTestResult(3);
                throw new TestBoardDependencyException();
            }
            if (e.getOrgErrorCode() == 25) {
                throw new FunctionNotSupportedException();
            }
            this.updateHwTestResult(3);
            throw new OperationFailedException();
        }
        this.updateHwTestResult(2);
    }

    public int getHwTestResult(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getHwTestResult()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        IntegerAttribute attribute = (IntegerAttribute)this.myData.getAttribute("hwTestResult");
        int result2 = attribute.getValue(context);
        return result2;
    }

    public void updateHwTestResult(int newResult) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "updateHwTestResult()");
        IntegerAttribute intAttribute = (IntegerAttribute)this.myData.getAttribute("hwTestResult");
        intAttribute.setValue(newResult);
        String[] attrArr = new String[]{"hwTestResult"};
        Object[] valArr = new Object[]{new Integer(newResult)};
        NotificationSender.instance().pushAVC((ManagedObject)this, attrArr, valArr);
    }

    public int getOperationalState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        EqcGetGroupParametersRspS rspSig = this.eqcDeviceGroupProxy.getGroupParameters(this.getTxIdNonTransactional(context), 0L, this.getGroupFroId(context));
        return rspSig.opState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        EqcGetGroupParametersRspS rspSig = this.eqcDeviceGroupProxy.getGroupParameters(this.getTxIdNonTransactional(context), 0L, this.getGroupFroId(context));
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.availStatus);
    }

    public int getGroupFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getGroupFroId()");
        IntegerAttribute attribute = (IntegerAttribute)this.myData.getAttribute(GROUP_FRO_ID);
        MessageLog.traceEnter(this.getClass(), "getGroupFroId() returned" + attribute.getValue(context));
        return attribute.getValue(context);
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.getGroupFroId(context);
    }

    public int getParentFroId(Coordinator c) throws MoAccessException {
        return BoamHelper.getPlugInUnitFroId(this.getParent(), c);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public void eventRaised(InSignal eventInd) {
        MessageLog.traceEnter(this.getClass(), "eventRaised()");
        String objectClass = this.getType();
        String managedObjectInstance = this.getFullDistinguishedName();
        String eventType = "0";
        String eventTime = USER_LABEL_DEF_VAL;
        if (eventInd instanceof EqcGroupEventIndS) {
            MessageLog.trace(6, this.getClass(), "EqcGroupEventIndS received");
            EqcGroupEventIndS recSig = (EqcGroupEventIndS)eventInd;
            String specificEvent = USER_LABEL_DEF_VAL;
            AdditionalInfo[] additionalInfo = null;
            int eventIs = recSig.groupEventType;
            if (eventIs == 49153) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedBoardRestart";
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
            } else if (eventIs == 49154) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedWarmReset";
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
            } else if (eventIs == 49157) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedSwitchedClockSource";
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
            } else if (eventIs == 49156) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedReestablishLink";
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
                int nrOfResources = recSig.reportingUnits.nrOfResources;
                additionalInfo = new AdditionalInfo[nrOfResources];
                for (int i = 0; i < additionalInfo.length; ++i) {
                    String LDN = BoamHelper.getLdnForMo(FroObjectTypeDefs.getMoTypeName(recSig.reportingUnits.resourceType[i]), new Long(recSig.reportingUnits.resourceFroId[i]).intValue());
                    if (LDN == null) continue;
                    additionalInfo[i] = new AdditionalInfo("Gamma link failure reported by:", LDN);
                }
            } else if (eventIs == 49158) {
                specificEvent = this.getType() + "_PreloadFailed";
                MessageLog.trace(6, this.getClass(), " " + specificEvent);
            } else {
                MessageLog.traceError(this.getClass(), "Unknown event received");
                return;
            }
            String additionalText = this.bcmGetMEUserLabel();
            new Event(objectClass, managedObjectInstance, eventType, eventTime, specificEvent, additionalText, additionalInfo);
            MessageLog.trace(6, this.getClass(), "Event raised MO = " + objectClass + " " + "eventType = " + eventType + " " + "specificEvent = " + specificEvent);
        } else if (eventInd instanceof EqcTestGroupEndIndS) {
            MessageLog.trace(6, this.getClass(), "EqcTestGroupEndIndS received");
            EqcTestGroupEndIndS recSig = (EqcTestGroupEndIndS)eventInd;
            if ((long)this.thisFroId == recSig.groupFroId) {
                try {
                    String specificEvent = this.getType() + "_HardwareTestEndIndication";
                    String additionalText = recSig.testId.name;
                    AdditionalInfo[] additionalInfoList = new AdditionalInfo[4];
                    this.updateTestResult(additionalInfoList, recSig);
                    new Event(objectClass, managedObjectInstance, eventType, eventTime, specificEvent, additionalText, additionalInfoList);
                    this.updateHwTestResult(recSig.testResult);
                }
                catch (MoAccessException e) {
                    MessageLog.trace(6, this.getClass(), "Can not update HW Test Result.");
                }
            }
        } else if (eventInd instanceof EqcGroupStartedIndS) {
            try {
                if ((long)this.thisFroId == ((EqcGroupStartedIndS)eventInd).groupFroId) {
                    this.updateHwLogSiteConfig();
                }
            }
            catch (MoAccessException e) {
                MessageLog.trace(6, this.getClass(), "Can not update HW Log.");
            }
        } else if (eventInd instanceof EqcGroupHwLogConfigIndS) {
            try {
                if ((long)this.thisFroId == ((EqcGroupHwLogConfigIndS)eventInd).groupFroId) {
                    MoHelper.updateHwLogConfig(this.getFroId(null), 0, (ManagedObject)this);
                }
            }
            catch (MoAccessException e) {
                MessageLog.trace(6, this.getClass(), "Can not update HW Log.");
            }
        }
    }

    private void checkRfifStateNonDuvBased(Coordinator context) throws MoAccessException {
        if ("TrxDeviceGroup".equalsIgnoreCase(this.getType())) {
            ManagedElementMo me = (ManagedElementMo)MibMgr.instance().getMib().getRootMo();
            String rbsType = me.getProductName(context);
            SlotMo slotMo = (SlotMo)DbDeviceGroupMoImpl.getAncestor((ManagedObject)this, "Slot");
            SlotMo slotMoNr2 = null;
            SlotMo slotMoNr3 = null;
            ManagedObject rfifMo = null;
            SubrackMo srMo = (SubrackMo)slotMo.getParent();
            MoIterator moIter = BoamHelper.findMOs("Slot", (ManagedObject)srMo, 1);
            while (moIter.hasMoreElements() && slotMoNr2 == null && slotMoNr3 == null) {
                SlotMo element = (SlotMo)moIter.nextMo();
                if (2 == element.getSlotNumber(context)) {
                    slotMoNr2 = element;
                    continue;
                }
                if (3 != element.getSlotNumber(context)) continue;
                slotMoNr3 = element;
            }
            int trxSlotNo = slotMo.getSlotNumber(context);
            if ("3101".equalsIgnoreCase(rbsType) || "3202".equalsIgnoreCase(rbsType)) {
                if (trxSlotNo == 4 || trxSlotNo == 7 || trxSlotNo == 10) {
                    rfifMo = BoamHelper.getFirstMatchingMo(slotMoNr2, "RfifDeviceGroup");
                } else if (trxSlotNo == 5 || trxSlotNo == 8 || trxSlotNo == 11) {
                    rfifMo = BoamHelper.getFirstMatchingMo((ManagedObject)slotMoNr3, "RfifDeviceGroup");
                }
            } else if ("3103".equalsIgnoreCase(rbsType) || "3104".equalsIgnoreCase(rbsType)) {
                rfifMo = BoamHelper.getFirstMatchingMo("RfifDeviceGroup");
            }
            if (rfifMo != null && !this.checkRefState(rfifMo, context)) {
                MessageLog.trace(2, this.getClass(), "startHwTest refused: The Rfif must be unlocked and enabled !!rfifMo:" + rfifMo.getLocalDistinguishedName());
                throw new TestBoardDependencyException("startHwTest refused: The Rfif must be unlocked and enabled !!rfifMo:" + rfifMo.getLocalDistinguishedName());
            }
        }
    }

    private void boardDependencyCheckUc1Fs6(Coordinator context) throws MoAccessException, TestBoardDependencyException {
        RbsSynchronizationMo rbsSync;
        MessageLog.trace(2, this.getClass(), "boardDependencyCheckUc1Fs6(),Start precondition 1");
        if (this.getHwTestResult(context) == 2) {
            MessageLog.trace(2, this.getClass(), "startHwTest refused: The test is already initiated!!");
            throw new AlreadyInitiatedException();
        }
        String typeName = this.getType();
        if (this.isDuw() && ("TxDeviceGroup".equalsIgnoreCase(typeName) || "RaxDeviceGroup".equalsIgnoreCase(typeName))) {
            this.updateHwTestResult(3);
            throw new FunctionNotSupportedException("startHwTest refused: function is not supported on DUW for type: " + this.getLocalDistinguishedName());
        }
        MessageLog.trace(2, this.getClass(), "boardDependencyCheckUc1Fs6(),Start precondition 2");
        if (("TxDeviceGroup".equalsIgnoreCase(typeName) || "RaxDeviceGroup".equalsIgnoreCase(typeName) || "RfifDeviceGroup".equalsIgnoreCase(typeName) || "TrxDeviceGroup".equalsIgnoreCase(typeName) || "AiuDeviceGroup".equalsIgnoreCase(typeName) || "RuDeviceGroup".equalsIgnoreCase(typeName) || "RruDeviceGroup".equalsIgnoreCase(typeName) || "ObifDeviceGroup".equalsIgnoreCase(typeName)) && !(rbsSync = (RbsSynchronizationMo)BoamHelper.getFirstMatchingMo("RbsSynchronization")).getNodeIsSynchronized(context) && !rbsSync.getNodeIsStable(context)) {
            MessageLog.trace(2, this.getClass(), "startHwTest refused: The base band clock must be distributed. Attribute NodeIsSynchronized or NodeIsStable on the RbsSynchronizationMo must be true! !!");
            throw new TestBoardDependencyException("startHwTest refused: The base band clock must be distributed. Attribute NodeIsSynchronized or NodeIsStable on the RbsSynchronizationMo must be true! !!");
        }
        MessageLog.trace(2, this.getClass(), "boardDependencyCheckUc1Fs6(),Start precondition 3");
        if (!this.getParent().getType().equals("PiuDevice")) {
            this.checkRfifStateNonDuvBased(context);
        }
    }

    private boolean checkRefState(ManagedObject moRef, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkRefState()");
        if (moRef instanceof PlugInUnitMo) {
            PlugInUnitMo piu = (PlugInUnitMo)moRef;
            MessageLog.trace(2, this.getClass(), "Instance of PlugInUnitMo" + moRef + " with OperationalState: " + piu.getOperationalState(context) + " and administrativeState " + piu.getAdministrativeState(context));
            if (piu.getOperationalState(context) == 1 && piu.getAdministrativeState(context) == 1) {
                return true;
            }
        } else if (moRef instanceof AuxPlugInUnitMo) {
            AuxPlugInUnitMo auxPiu = (AuxPlugInUnitMo)moRef;
            MessageLog.trace(2, this.getClass(), "Instance of AuxPlugInUnitMo" + moRef + " with OperationalState: " + auxPiu.getOperationalState(context) + " and administrativeState " + auxPiu.getAdministrativeState(context));
            if (auxPiu.getOperationalState(context) == 1 && auxPiu.getAdministrativeState(context) == 1) {
                return true;
            }
        }
        return false;
    }

    private void updateHwLogSiteConfig() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "updateHwLogSiteConfig()");
        ManagedElementMo rootmo = (ManagedElementMo)MibMgr.instance().getMib().getRootMo();
        String rbstype = rootmo.getProductName(null);
        String logName = rootmo.getLogicalName(null);
        long LOG_ID = 0L;
        SlotMo slotMo = (SlotMo)DbDeviceGroupMoImpl.getAncestor((ManagedObject)this, "Slot");
        SubrackMo subrackMo = (SubrackMo)slotMo.getParent();
        String freeText = rbstype + ";" + "Site " + logName + ";" + "subrack " + subrackMo.getSubrackPosition(null) + ";" + "slot " + slotMo.getSlotNumber(null);
        this.eqcDeviceGroupProxy.updateGroupHwLog(0L, this.getGroupFroId(null), 0L, freeText);
    }

    protected void updateTestResult(AdditionalInfo[] infoList, EqcTestGroupEndIndS recSig) throws MoAccessException {
        if (recSig.testResult == 2) {
            recSig.testResult = 3;
        }
        switch (recSig.testResult) {
            case 0: {
                infoList[0] = new AdditionalInfo("Result", "Passed");
                break;
            }
            case 1: {
                infoList[0] = new AdditionalInfo("Result", "Failed");
                break;
            }
            case 3: {
                infoList[0] = new AdditionalInfo("Result", "Undetermined");
                break;
            }
            default: {
                infoList[0] = new AdditionalInfo("Result", "Unknown");
            }
        }
        infoList[1] = new AdditionalInfo("Test Time", Integer.toString(recSig.testTime == 0 ? 1 : recSig.testTime) + " sec");
        infoList[2] = new AdditionalInfo("Start Test Time", recSig.startTestTime);
        infoList[3] = new AdditionalInfo("Stop Test Time", recSig.stopTestTime);
    }

    protected static synchronized void checkParent(ManagedObject parent, String moTypeName) throws IllegalParentException {
        String type = parent.getType();
        if (!type.equals("PlugInUnit") && !type.equals("PiuDevice")) {
            IllegalParentException e = new IllegalParentException(moTypeName);
            throw e;
        }
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcBdhIndProxy, froType, this.getFroId(context), context);
        this.myMoEvents = new MoEvents(this, this.eqcBdhIndProxy, this.getFroId(context), context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
        this.myMoEvents.delete(context);
    }

    private boolean isDuw() {
        return this.getParent().getType().equals("PiuDevice");
    }
}

