/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.power;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsGroupFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.common.ErrorMgr;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.AlreadyInitiatedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FunctionNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.MoNotLockedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationFailedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.TestBoardDependencyException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.BfuDeviceGroupMo;

public class BfuDeviceGroupMoImpl
extends AuxDeviceGroupMoImpl
implements BfuDeviceGroupMo {
    public static final int MO_DATA_REVISION = 3020001;

    public BfuDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "BfuDeviceGroupMoImpl() recovered constructor <---");
        ErrorMgr.shotDownIfNull(recoveredData.getAttribute("alarmStatus"), "alarmStatus");
        ErrorMgr.shotDownIfNull(recoveredData.getAttribute("userLabel"), "userLabel");
        ErrorMgr.shotDownIfNull(recoveredData.getAttribute("auxGroupFroId"), "auxGroupFroId");
        try {
            this.addObservers(49567, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    private BfuDeviceGroupMoImpl(ManagedObject parent, String thisMoName, String identity, int alarmStatus, String userLabel, Coordinator context) throws MoAccessException {
        super(parent, "BfuDeviceGroup", identity, context);
        EqcCreateGroupRspS rsp = this.createAuxDeviceGroupResource(parent, 49567, context);
        RbsGroupFroInfoT groupFroInfo = rsp.groupFroInfo;
        int auxGroupFroId = (int)rsp.groupFroInfo.groupFroId;
        this.initMoData(userLabel, auxGroupFroId, context);
        this.initAlarmStatus(alarmStatus, context);
        AuxDeviceGroupMoFactory.instance(49567).createDeviceGroupMoTree((ManagedObject)this, groupFroInfo, "", context);
        this.addObservers(49567, context);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(BfuDeviceGroupMoImpl.class, "create() <---");
        ValidateAttributes.checkTransaction(context);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "BfuDeviceGroup");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, BfuDeviceGroupMo.ALARM_STATUS_MIN_VALUES, BfuDeviceGroupMo.ALARM_STATUS_MAX_VALUES, "BfuDeviceGroup");
        ValidateAttributes.checkOtherAttributes(attributes, "BfuDeviceGroup");
        return new BfuDeviceGroupMoImpl(parent, "BfuDeviceGroup", identity, checkedAlarmStatus, checkedUserLabel, context);
    }

    public String getType() {
        return "BfuDeviceGroup";
    }

    public void setAlarmStatus(int alarmStatusType, Coordinator context) throws MoAccessException, TransactionRequiredException {
        super.setAlarmStatus(alarmStatusType, context);
        MessageLog.traceEnter(this.getClass(), "setAlarmStatus() <---");
    }

    public int getOperationalState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState() <---");
        return super.getOperationalState(context);
    }

    public void actionStartHwTest(String testId, Coordinator context) throws MoAccessException, AlreadyInitiatedException, MoNotLockedException, OperationFailedException, FunctionNotSupportedException, TestBoardDependencyException {
        super.actionStartHwTest(testId, context);
        MessageLog.traceEnter(this.getClass(), "actionStartHwTest() <---");
    }

    private void initMoData(String userLabel, int auxGroupFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() <---");
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterIntAttribute("auxGroupFroId", auxGroupFroId);
        this.getMyMoData().setRevision(3020001);
    }
}

