/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.power;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PcuDeviceGroupMo;

public class PcuDeviceGroupMoImpl
extends AuxDeviceGroupMoImpl
implements PcuDeviceGroupMo {
    public static final int MO_DATA_REVISION = 70701;

    private PcuDeviceGroupMoImpl(ManagedObject parent, String userLabel, int alarmStatus, String identity, Coordinator context) throws MoAccessException {
        super(parent, "PcuDeviceGroup", identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        EqcCreateGroupRspS rsp = this.createAuxDeviceGroupResource(parent, 49556, context);
        this.initMoData(userLabel, alarmStatus, (int)rsp.groupFroInfo.groupFroId, context);
        this.addObservers(49556, context);
    }

    public PcuDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        try {
            this.addObservers(49556, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(PcuDeviceGroupMoImpl.class, "create()");
        PcuDeviceGroupMoImpl.checkTransaction(context);
        ValidateAttributes.checkParent(parent, "AuxPlugInUnit");
        if (((AuxPlugInUnitMo)parent).getAuType(null) != 4) {
            throw new IllegalParentException("PcuDeviceGroup");
        }
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "PcuDeviceGroup");
        int checkedAlarmStatus = PcuDeviceGroupMoImpl.checkAndGetAlarmStatus(attributes, 0, "PcuDeviceGroup", context);
        ValidateAttributes.checkOtherAttributes(attributes, "PcuDeviceGroup");
        return new PcuDeviceGroupMoImpl(parent, checkedUserLabel, checkedAlarmStatus, identity, context);
    }

    public String getType() {
        return "PcuDeviceGroup";
    }

    public String getPcuDeviceGroupId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPcuDeviceGroupId()");
        return this.getIdentity(context);
    }

    private void initMoData(String userLabel, int alarmStatus, int auxGroupFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterIntAttribute("auxGroupFroId", auxGroupFroId);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.initAlarmStatus(alarmStatus, context);
        this.myData.setRevision(70701);
    }
}

