/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.power;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.mao.common.ErrorMgr;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PsuDeviceGroupMo;

public class PsuDeviceGroupMoImpl
extends AuxDeviceGroupMoImpl
implements PsuDeviceGroupMo {
    public static final int MO_DATA_REVISION = 3020001;
    private StringAttribute userLabel;
    private IntegerAttribute alarmStatus;

    private PsuDeviceGroupMoImpl(ManagedObject parent, int alarmStatus, String userLabel, String identity, Coordinator context) throws MoAccessException {
        super(parent, "PsuDeviceGroup", identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        EqcCreateGroupRspS rsp = this.createAuxDeviceGroupResource(parent, 49566, context);
        this.initMoData(userLabel, alarmStatus, (int)rsp.groupFroInfo.groupFroId, context);
        AuxDeviceGroupMoFactory.instance(49566).createDeviceGroupMoTree((ManagedObject)this, rsp.groupFroInfo, "", context);
        this.addObservers(49566, context);
    }

    public PsuDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "PsuDeviceGroupMoImpl Recovery constructor");
        this.alarmStatus = (IntegerAttribute)recoveredData.getAttribute("alarmStatus");
        this.userLabel = (StringAttribute)recoveredData.getAttribute("userLabel");
        ErrorMgr.shotDownIfNull(this.alarmStatus, "Recovered attribute alarmStatusis null");
        ErrorMgr.shotDownIfNull(this.userLabel, "Recovered attribute userLabelis null");
        try {
            this.addObservers(49566, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(PsuDeviceGroupMoImpl.class, "create()");
        PsuDeviceGroupMoImpl.checkTransaction(context);
        ValidateAttributes.checkParent(parent, "AuxPlugInUnit");
        if (((AuxPlugInUnitMo)parent).getAuType(null) != 14) {
            throw new IllegalParentException("PsuDeviceGroup");
        }
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "PsuDeviceGroup");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "PsuDeviceGroup");
        ValidateAttributes.checkOtherAttributes(attributes, "PsuDeviceGroup");
        return new PsuDeviceGroupMoImpl(parent, checkedAlarmStatus, checkedUserLabel, identity, context);
    }

    public String getType() {
        return "PsuDeviceGroup";
    }

    private void initMoData(String userLabel, int alarmStatus, int auxGroupFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterIntAttribute("auxGroupFroId", auxGroupFroId);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.initAlarmStatus(alarmStatus, context);
        this.myData.setRevision(3020001);
    }
}

