/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.rru;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcGetObifGroupParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DbDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.emo.bb.DownlinkBaseBandPoolMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.bb.UplinkBaseBandPoolMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ObifDeviceGroupMo;

public class ObifDeviceGroupMoImpl
extends DbDeviceGroupMoImpl
implements ObifDeviceGroupMo {
    public static final int MAX_NO_OF_CHILDREN = 1;
    public static final int MO_DATA_REVISION = 2040001;

    public ObifDeviceGroupMoImpl(ManagedObject parent, String userLabel, int checkedAlarmStatus, int checkedConfGroup, String identity, Coordinator context) throws MoAccessException {
        super(parent, "ObifDeviceGroup", null, identity, context, 1);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.initAlarmStatus(checkedAlarmStatus, context);
        EqcCreateGroupRspS RspS = this.createDeviceGroupResourceRsps(parent, 49576, context);
        this.setConfigurationGroup(checkedConfGroup, context);
        DeviceGroupMoFactory.instance(49576).createDeviceGroupMoTree(this, RspS, "", context);
        this.addObservers(49576, context);
        this.myData.setRevision(2040001);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    public ObifDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        try {
            this.addObservers(49576, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(ObifDeviceGroupMoImpl.class, "create()");
        ObifDeviceGroupMoImpl.checkTransaction(context);
        ObifDeviceGroupMoImpl.checkParent(parent, "ObifDeviceGroup");
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "ObifDeviceGroup");
        int checkedAlarmStatus = ObifDeviceGroupMoImpl.checkAndGetAlarmStatus(attributes, 0, "ObifDeviceGroup", context);
        int checkedConfigurationGroup = ValidateAttributes.checkAndGetIntAttribute(attributes, "configurationGroup", "optional", 0, 0, 4, "ObifDeviceGroup");
        ValidateAttributes.checkOtherAttributes(attributes, "ObifDeviceGroup");
        return new ObifDeviceGroupMoImpl(parent, checkedUserLabel, checkedAlarmStatus, checkedConfigurationGroup, identity, context);
    }

    public void actionStartHwTest(String testId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStartHwTest()");
        super.actionStartHwTest(testId, context);
    }

    public String getType() {
        return "ObifDeviceGroup";
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public void delete(Coordinator context) throws MoAccessException {
        ManagedObject existingMo;
        MessageLog.trace(1, this.getClass(), "delete()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        MoIterator MoTypeExistsItr = MoRepository.instance().lookupType("DownlinkBaseBandPool");
        if (MoTypeExistsItr != null) {
            while (MoTypeExistsItr.hasMoreElements()) {
                existingMo = MoTypeExistsItr.nextMo();
                ((DownlinkBaseBandPoolMoImpl)existingMo).sysDelete(this, context);
            }
        }
        if ((MoTypeExistsItr = MoRepository.instance().lookupType("UplinkBaseBandPool")) != null) {
            while (MoTypeExistsItr.hasMoreElements()) {
                existingMo = MoTypeExistsItr.nextMo();
                ((UplinkBaseBandPoolMoImpl)existingMo).sysDelete(this, context);
            }
        }
        super.delete(context);
    }

    private int deviceGroupConfigToEcMi(int dgAsInMom) throws ValueOutOfRangeException {
        switch (dgAsInMom) {
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
            case 4: {
                return 4;
            }
        }
        throw new ValueOutOfRangeException("ObifDeviceGroup", "configurationGroup");
    }

    public int getConfigurationGroup(Coordinator c) throws MoAccessException {
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        EcGetObifGroupParamRspS rsp = this.eqcDeviceGroupProxy.getObifGroupParam(0, this.thisFroId, this.getTxIdNonTransactional(c));
        switch (rsp.configurationGroup) {
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
            case 4: {
                return 4;
            }
        }
        MessageLog.traceError(this.getClass(), "FRO Returned an unhandeled configuration group :" + rsp.configurationGroup);
        return -1;
    }

    public void setConfigurationGroup(int value, Coordinator c) throws MoAccessException {
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        int froValue = this.deviceGroupConfigToEcMi(value);
        this.eqcDeviceGroupProxy.setObifGroupParam(0, this.thisFroId, this.getTxIdNonTransactional(c), froValue);
        this.sendAVC("configurationGroup", value, c);
    }
}

