/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.tr;

import enea.ose.system.InSignal;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcBdhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceSetProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcDevSetEventIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetDevSetParametersRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ErrorMgr;
import se.ericsson.wcdma.rbs.boam.mao.event.MoEvents;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.HsDbchDeviceSetMo;

public class HsDbchDeviceSetMoImpl
extends BoamManagedObjectWithAlarms
implements HsDbchDeviceSetMo {
    public static final String DEV_SET_FRO_ID = "devSetFroId";
    public static final int INITIAL_ALARM_STATUS = 0;
    public static final int MO_DATA_REVISION = 3040001;
    private MoEvents myMoEvents = null;
    protected EqcDeviceSetProxy eqcDeviceSetProxy = EqcDeviceSetProxy.instance();
    protected EqcBdhIndProxy eqcBdhIndProxy = EqcBdhIndProxy.instance();

    public HsDbchDeviceSetMoImpl(ManagedObject parent, String thisMoName, int devSetFroId, String identity, String userLabel, Coordinator context) throws MoAccessException {
        super(parent, thisMoName, identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.initAlarmStatus(0, context);
        this.bcmStoreAndRegisterIntAttribute(DEV_SET_FRO_ID, devSetFroId);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.myData.setRevision(3040001);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.addObservers(19, context);
    }

    public HsDbchDeviceSetMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        this.myData = recoveredData;
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        MessageLog.trace(1, this.getClass(), "Version Attribute in MoData = " + this.myData.getRevision());
        IntegerAttribute froId = (IntegerAttribute)this.myData.getAttribute(DEV_SET_FRO_ID);
        ErrorMgr.shotDownIfNull(froId, DEV_SET_FRO_ID);
        try {
            this.addObservers(19, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()<---");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void sysDelete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sysDelete() device set");
        if (this.isReserved(context)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        MoIterator iter = this.getChildren();
        MessageLog.trace(1, this.getClass(), "delete devices");
        while (iter.hasMoreElements()) {
            Object child = iter.nextElement();
            if (!(child instanceof DeviceMo)) continue;
            ((DeviceMo)child).sysDelete(context);
        }
        this.myData.delete(context);
        this.removeObservers(context);
        super.delete(context);
    }

    public String getType() {
        return "HsDbchDeviceSet";
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public int getOperationalState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        EqcGetDevSetParametersRspS rspSig = this.eqcDeviceSetProxy.getDevSetParameters(this.getTxIdNonTransactional(context), 0L, this.getDevSetFroId(context));
        return rspSig.opState;
    }

    public int getUsageState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getUsageState()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        EqcGetDevSetParametersRspS rspSig = this.eqcDeviceSetProxy.getDevSetParameters(this.getTxIdNonTransactional(context), 0L, this.getDevSetFroId(context));
        return rspSig.usageState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        EqcGetDevSetParametersRspS rspSig = this.eqcDeviceSetProxy.getDevSetParameters(this.getTxIdNonTransactional(context), 0L, this.getDevSetFroId(context));
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.availStatus);
    }

    public int getDevSetFroId(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDevSetFroId()");
        return super.bcmGetIntAttribute(DEV_SET_FRO_ID, c);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getUserLabel() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public void eventRaised(InSignal eventInd) {
        MessageLog.traceEnter(this.getClass(), "eventRaised()");
        String objectClass = this.getType();
        String managedObjectInstance = this.getFullDistinguishedName();
        String eventType = "0";
        String eventTime = "";
        if (eventInd instanceof EqcDevSetEventIndS) {
            MessageLog.trace(6, this.getClass(), "EqcDevSetEventIndS received");
            EqcDevSetEventIndS recSig = (EqcDevSetEventIndS)eventInd;
            String specificEvent = "";
            int eventIs = recSig.devSetEventType;
            if (eventIs == 49153) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedBoardRestart";
                MessageLog.trace(6, this.getClass(), "MO = " + objectClass + " specificEvent = _SuccessfulRecoveryActionPerformedBoardRestart");
            } else if (eventIs == 49154) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedWarmReset";
                MessageLog.trace(6, this.getClass(), "MO = " + objectClass + " specificEvent = _SuccessfulRecoveryActionPerformedWarmReset");
            } else if (eventIs == 49157) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedSwitchedClockSource";
                MessageLog.trace(6, this.getClass(), "MO = " + objectClass + " specificEvent = _SuccessfulRecoveryActionPerformedSwitchedClockSource");
            } else if (eventIs == 49156) {
                specificEvent = this.getType() + "_SuccessfulRecoveryActionPerformedReestablishLink";
                MessageLog.trace(6, this.getClass(), "MO = " + objectClass + " specificEvent = _SuccessfulRecoveryActionPerformedReestablishLink");
            } else {
                MessageLog.traceError(this.getClass(), "Unknown event received");
                return;
            }
            String additionalText = this.bcmGetMEUserLabel();
            new Event(objectClass, managedObjectInstance, eventType, eventTime, specificEvent, additionalText, null);
            MessageLog.trace(6, this.getClass(), "Event raised MO = " + objectClass + " " + "eventType = " + eventType + " " + "specificEvent = " + specificEvent);
        }
    }

    private void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcBdhIndProxy, froType, this.getDevSetFroId(context), context);
        this.myMoEvents = new MoEvents(this, this.eqcBdhIndProxy, this.getDevSetFroId(context), context);
    }

    private void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
        this.myMoEvents.delete(context);
    }
}

