/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.tr;

import java.util.StringTokenizer;
import se.ericsson.cello.equipment.PiuDeviceMo;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceGroupProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcCreateRdbtTestPortRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcGetRdbtTestPortParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationNotAllowedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RaxDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RdbtTestPortMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TxDeviceGroupMo;

public class RdbtTestPortMoImpl
extends BoamManagedObject
implements RdbtTestPortMo {
    private static final int MO_DATA_REVISION = 8012001;
    private MoData myData;
    private EqcDeviceGroupProxy eqcDeviceGroupProxy = EqcDeviceGroupProxy.instance();

    private RdbtTestPortMoImpl(ManagedObject parent, String moTypeName, String identity, Coordinator context, int txmId, int[] internalMac, ManagedObject PiuDeviceRef) throws MoNameAlreadyTakenException, MoAccessException {
        super(parent, moTypeName, identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal Constructor");
        long piuDeviceId = ((PiuDeviceMo)PiuDeviceRef).getFroId(context);
        int froId = this.createRo(context, piuDeviceId, txmId, internalMac);
        ((Reservable)PiuDeviceRef).reserve((ManagedObject)this, context);
        this.initMoData(froId, PiuDeviceRef, context);
        MessageLog.trace(1, this.getClass(), "MO is created" + this.getFullDistinguishedName());
    }

    public RdbtTestPortMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(this.getClass(), "Recovery Constructor");
        this.myData = recoveredData;
        MessageLog.trace(1, this.getClass(), "MAO is recovered");
    }

    private void initMoData(int froId, ManagedObject piuDeviceRef, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData()");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.bcmStoreAndRegisterIntAttribute("froId", froId);
        this.bcmStoreAndRegisterReferenceAttribute("piuDeviceRef", piuDeviceRef);
        this.myData.setRevision(8012001);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(RdbtTestPortMoImpl.class, "create()");
        ValidateAttributes.checkTransaction(context);
        ValidateAttributes.checkParent(parent, "TransportNetwork");
        ManagedObject checkedpiuDeviceRef = ValidateAttributes.checkAndGetReferenceAttribute("piuDeviceRef", attributes, "mandatory", new String[]{"PiuDevice"}, "RdbtTestPort");
        InternalMacHandler internalMacHandler = new InternalMacHandler(attributes, "internalMac", "mandatory", "", Integer.MIN_VALUE, Integer.MAX_VALUE, "RdbtTestPort", context);
        int[] checkedinternalMac = internalMacHandler.getCheckedInternalMac();
        int checkedTxmId = ValidateAttributes.checkAndGetIntAttribute(attributes, "txmId", "optional", -1, RdbtTestPortMo.TXM_ID_MIN_VALUES, RdbtTestPortMo.TXM_ID_MAX_VALUES, "RdbtTestPort");
        ValidateAttributes.checkOtherAttributes(attributes, "RdbtTestPort");
        MoIterator iter = checkedpiuDeviceRef.getChildren();
        while (iter.hasMoreElements()) {
            ManagedObject piuDeviceChild = iter.nextMo();
            if (piuDeviceChild instanceof TxDeviceGroupMo && checkedTxmId < 0) {
                throw new OperationNotAllowedException("The PiuDevice has a TxDeviceGroup child and TxmId < 0, configration is not supported");
            }
            if (!(piuDeviceChild instanceof RaxDeviceGroupMo) || checkedTxmId < 0) continue;
            throw new OperationNotAllowedException("The PiuDevice has a RaxDeviceGroup child and TxmId >= 0, configration is not supported");
        }
        RdbtTestPortMoImpl createdMo = new RdbtTestPortMoImpl(parent, "RdbtTestPort", identity, context, checkedTxmId, checkedinternalMac, checkedpiuDeviceRef);
        return createdMo;
    }

    private int createRo(Coordinator context, long piuDeviceId, int txmId, int[] internalMacAddress) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "createRo()");
        EcCreateRdbtTestPortRspS rspSig = this.eqcDeviceGroupProxy.createRdbtTestPort(this.getTxIdTransactional(context), 0L, piuDeviceId, txmId, internalMacAddress);
        return (int)rspSig.froId;
    }

    public int getFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.bcmGetIntAttribute("froId", context);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        return true;
    }

    public void delete(Coordinator context) throws MoHasChildrenException, MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete() " + this.getFullDistinguishedName());
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int froId = this.getFroId(context);
        this.eqcDeviceGroupProxy.deleteRdbtTestPort(this.getTxIdTransactional(context), 0L, froId);
        ((Reservable)this.getPiuDeviceRef(context)).release((ManagedObject)this, context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), this.getType() + " Mo is Deleted");
    }

    public String getType() {
        return "RdbtTestPort";
    }

    public String getInternalMac(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getInternalMac()");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        StringBuffer internalMacAddressStringBuff = new StringBuffer();
        EcGetRdbtTestPortParamRspS rspsSig = this.eqcDeviceGroupProxy.getRdbtTestPortParam(ValidateAttributes.getTxIdNonTransactional(c), 0L, this.getFroId(c));
        for (int i = 0; i < 6; ++i) {
            String hexString = Integer.toHexString(rspsSig.internalMacAddress[i]);
            internalMacAddressStringBuff.append((hexString.length() == 1 ? "0" + hexString : hexString) + (i < 5 ? InternalMacHandler.separatorHolder : ""));
        }
        return internalMacAddressStringBuff.toString();
    }

    public ManagedObject getPiuDeviceRef(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPiuDeviceRef()");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        return this.bcmGetReferenceAttribute("piuDeviceRef", c);
    }

    public int getTxmId(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTxmId()");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        return (int)this.eqcDeviceGroupProxy.getRdbtTestPortParam((long)((long)ValidateAttributes.getTxIdNonTransactional((Coordinator)c)), (long)0L, (long)((long)this.getFroId((Coordinator)c))).txmId;
    }

    static class InternalMacHandler {
        static String separatorHolder;
        static final int MAC_ADD_NUM_OF_BYTES = 6;
        static final String linuxSeparator = ":";
        static final String winSeparator = "-";
        static final String macSeparator = " ";
        final int[] internalMacAddress;

        InternalMacHandler(AttrList attributes, String attrName, String attrType, String defaultValue, int minLength, int maxLength, String thisTypeName, Coordinator context) throws MoAccessException {
            this.internalMacAddress = this.checkAndGetInternalMac(attributes, attrName, attrType, defaultValue, minLength, maxLength, thisTypeName, context);
        }

        private int[] checkAndGetInternalMac(AttrList attributes, String attrName, String attrType, String defaultValue, int minLength, int maxLength, String thisTypeName, Coordinator context) throws MoAccessException {
            String _internalMacAddress = ValidateAttributes.checkAndGetStringAttribute(attributes, attrName, attrType, defaultValue, minLength, maxLength, thisTypeName);
            StringTokenizer stringTok = null;
            int[] internalMacAddressInt = new int[6];
            if (_internalMacAddress.indexOf(linuxSeparator) != -1) {
                stringTok = new StringTokenizer(_internalMacAddress, linuxSeparator);
                separatorHolder = linuxSeparator;
            } else if (_internalMacAddress.indexOf(winSeparator) != -1) {
                stringTok = new StringTokenizer(_internalMacAddress, winSeparator);
                separatorHolder = winSeparator;
            } else if (_internalMacAddress.indexOf(macSeparator) != -1) {
                stringTok = new StringTokenizer(_internalMacAddress, macSeparator);
                separatorHolder = macSeparator;
            } else {
                throw new ValueOutOfRangeException("RdbtTestPort", "internalMac", "Unknown separator used in internalMacAddress:" + _internalMacAddress);
            }
            if (stringTok.countTokens() != 6) {
                throw new ValueOutOfRangeException("RdbtTestPort", "internalMac", "invalid number of bytes in internalMacAddress 6 !=" + stringTok.countTokens());
            }
            for (int i = 0; i < 6 && stringTok.hasMoreTokens(); ++i) {
                internalMacAddressInt[i] = Integer.parseInt(stringTok.nextToken(), 16);
            }
            return internalMacAddressInt;
        }

        int[] getCheckedInternalMac() {
            return this.internalMacAddress;
        }
    }
}

