/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.tr;

import java.util.StringTokenizer;
import se.ericsson.cello.equipment.PiuDeviceMo;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceGroupProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcCreateRdbtUdpRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcGetRdbtUdpParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationNotAllowedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RaxDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RdbtUdpTpMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TxDeviceGroupMo;

public class RdbtUdpTpMoImpl
extends BoamManagedObject
implements RdbtUdpTpMo {
    private static final int MO_DATA_REVISION = 8012601;
    private static EqcDeviceGroupProxy eqcDeviceGroupProxy = EqcDeviceGroupProxy.instance();
    private MoData myData;

    private RdbtUdpTpMoImpl(ManagedObject parent, String moTypeName, String identity, Coordinator context, int txmId, int[] remoteIpAddress, long remoteUdpPort, ManagedObject piuDeviceRef, ManagedObject ipAccessHostEtRef) throws MoNameAlreadyTakenException, MoAccessException {
        super(parent, moTypeName, identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal Constructor");
        long piuDeviceId = ((PiuDeviceMo)piuDeviceRef).getFroId(context);
        long ipAccessHostEtFroId = ((IpAccessHostEtMo)ipAccessHostEtRef).getFroId(context);
        this.initMoData(context, piuDeviceId, txmId, ipAccessHostEtFroId, remoteIpAddress, remoteUdpPort, piuDeviceRef, ipAccessHostEtRef);
        MessageLog.trace(1, this.getClass(), "MAO is created");
    }

    public RdbtUdpTpMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(this.getClass(), "Recovery Constructor");
        this.myData = recoveredData;
        MessageLog.trace(1, this.getClass(), "MAO is recovered");
    }

    private void initMoData(Coordinator context, long piuDeviceId, int txmId, long ipAccessHostEtFroId, int[] remoteIpAddress, long remoteUdpPort, ManagedObject piuDeviceRef, ManagedObject ipAccessHostEtRef) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData()");
        this.myData = new MoData(super.getLocalDistinguishedName(), this.getType(), true, context);
        int froId = this.createRo(context, piuDeviceId, txmId, ipAccessHostEtFroId, remoteIpAddress, remoteUdpPort);
        ((Reservable)piuDeviceRef).reserve((ManagedObject)this, context);
        ((Reservable)ipAccessHostEtRef).reserve((ManagedObject)this, context);
        this.bcmStoreAndRegisterIntAttribute("froId", froId);
        this.bcmStoreAndRegisterReferenceAttribute("piuDeviceRef", piuDeviceRef);
        this.bcmStoreAndRegisterReferenceAttribute("ipAccessHostEtRef", ipAccessHostEtRef);
        this.myData.setRevision(8012601);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(RdbtUdpTpMoImpl.class, "create()");
        ValidateAttributes.checkTransaction(context);
        ValidateAttributes.checkParent(parent, "TransportNetwork");
        ManagedObject checkedpiuDeviceRef = ValidateAttributes.checkAndGetReferenceAttribute("piuDeviceRef", attributes, "mandatory", new String[]{"PiuDevice"}, "RdbtUdpTp");
        ManagedObject ipAccessHostEtRef = ValidateAttributes.checkAndGetReferenceAttribute("ipAccessHostEtRef", attributes, "mandatory", new String[]{"IpAccessHostEt"}, "RdbtUdpTp");
        int checkedTxmId = ValidateAttributes.checkAndGetIntAttribute(attributes, "txmId", "optional", -1, RdbtUdpTpMo.TXM_ID_MIN_VALUES, RdbtUdpTpMo.TXM_ID_MAX_VALUES, "RdbtUdpTp");
        int[] checkedRemoteIpAddress = RemoteIpAddressHandler.checkAndGetRemoteIpAddress(attributes, "remoteIpAddress", "mandatory", "", Integer.MIN_VALUE, Integer.MAX_VALUE, "RdbtUdpTp", context);
        int checkedRemoteUdpPort = ValidateAttributes.checkAndGetIntAttribute(attributes, "remoteUdpPort", "mandatory", 0, RdbtUdpTpMo.REMOTE_UDP_PORT_MIN_VALUES, RdbtUdpTpMo.REMOTE_UDP_PORT_MAX_VALUES, "RdbtUdpTp");
        ValidateAttributes.checkOtherAttributes(attributes, "RdbtUdpTp");
        MoIterator iter = checkedpiuDeviceRef.getChildren();
        while (iter.hasMoreElements()) {
            ManagedObject piuDeviceChild = iter.nextMo();
            if (piuDeviceChild instanceof TxDeviceGroupMo && checkedTxmId < 0) {
                throw new OperationNotAllowedException("The PiuDevice has a TxDeviceGroup child and TxmId < 0, configration is not supported");
            }
            if (!(piuDeviceChild instanceof RaxDeviceGroupMo) || checkedTxmId < 0) continue;
            throw new OperationNotAllowedException("The PiuDevice has a RaxDeviceGroup child and TxmId >= 0, configration is not supported");
        }
        RdbtUdpTpMoImpl createdMo = new RdbtUdpTpMoImpl(parent, "RdbtUdpTp", identity, context, checkedTxmId, checkedRemoteIpAddress, checkedRemoteUdpPort, checkedpiuDeviceRef, ipAccessHostEtRef);
        return createdMo;
    }

    private int createRo(Coordinator context, long piuDeviceId, int txmId, long ipAccessHostEtFroId, int[] remoteIpAddress, long remoteUdpPort) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "createRo()");
        EcCreateRdbtUdpRspS rspSig = eqcDeviceGroupProxy.createRdbtUdpTp(this.getTxIdTransactional(context), 0L, piuDeviceId, txmId, ipAccessHostEtFroId, remoteIpAddress, remoteUdpPort);
        return (int)rspSig.froId;
    }

    public int getFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.bcmGetIntAttribute("froId", context);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        return true;
    }

    public void delete(Coordinator context) throws MoHasChildrenException, MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete() " + this.getFullDistinguishedName());
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int froId = this.getFroId(context);
        eqcDeviceGroupProxy.deleteRdbtUdpTp(this.getTxIdTransactional(context), 0L, froId);
        ((Reservable)this.getPiuDeviceRef(context)).release((ManagedObject)this, context);
        ((Reservable)this.getIpAccessHostEtRef(context)).release((ManagedObject)this, context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), this.getType() + " Mo is Deleted");
    }

    public String getType() {
        return "RdbtUdpTp";
    }

    public ManagedObject getIpAccessHostEtRef(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getIpAccessHostEtRef()");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        return this.bcmGetReferenceAttribute("ipAccessHostEtRef", c);
    }

    public ManagedObject getPiuDeviceRef(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPiuDeviceRef()");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        return this.bcmGetReferenceAttribute("piuDeviceRef", c);
    }

    public String getRemoteIpAddress(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRemoteIpAddress()");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        EcGetRdbtUdpParamRspS rspsSig = eqcDeviceGroupProxy.getRdbtUdpTpParam(ValidateAttributes.getTxIdNonTransactional(c), 0L, this.getFroId(c));
        return RemoteIpAddressHandler.getRemoteIpAddress(rspsSig.remoteIpAddress);
    }

    public int getRemoteUdpPort(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRemoteUdpPort()");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        return (int)RdbtUdpTpMoImpl.eqcDeviceGroupProxy.getRdbtUdpTpParam((long)((long)ValidateAttributes.getTxIdNonTransactional((Coordinator)c)), (long)0L, (long)((long)this.getFroId((Coordinator)c))).remoteUdpPort;
    }

    public int getTxmId(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTxmId()");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        return (int)RdbtUdpTpMoImpl.eqcDeviceGroupProxy.getRdbtUdpTpParam((long)((long)ValidateAttributes.getTxIdNonTransactional((Coordinator)c)), (long)0L, (long)((long)this.getFroId((Coordinator)c))).txmId;
    }

    static class RemoteIpAddressHandler {
        static final int IPV4_NUM_OF_BYTES = 4;

        RemoteIpAddressHandler() {
        }

        private static int[] checkAndGetRemoteIpAddress(AttrList attributes, String attrName, String attrType, String defaultValue, int minLength, int maxLength, String thisTypeName, Coordinator context) throws ValueOutOfRangeException, MoAccessException, NotHandledAttributeTypeException, AttrMissingAtCreateException, WrongAttributeTypeException, SoftwareErrorException {
            String remoteIpAddress = ValidateAttributes.checkAndGetStringAttribute(attributes, attrName, attrType, defaultValue, minLength, maxLength, thisTypeName);
            StringTokenizer stringTok = new StringTokenizer(remoteIpAddress, ".");
            if (stringTok.countTokens() != 4) {
                throw new ValueOutOfRangeException("RdbtUdpTp", "remoteIpAddress", "Invalid IP Address format : " + remoteIpAddress);
            }
            int[] remoteIpAddressInt = new int[4];
            int i = 0;
            while (stringTok.hasMoreTokens()) {
                remoteIpAddressInt[i] = Integer.parseInt(stringTok.nextToken());
                ++i;
            }
            return remoteIpAddressInt;
        }

        public static String getRemoteIpAddress(int[] remoteIpAddress) throws MoAccessException {
            StringBuffer remoteIpAddressStringBuff = new StringBuffer();
            for (int i = 0; i < remoteIpAddress.length; ++i) {
                remoteIpAddressStringBuff.append(remoteIpAddress[i] + (i < remoteIpAddress.length - 1 ? "." : ""));
            }
            return remoteIpAddressStringBuff.toString();
        }
    }
}

