/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.tr;

import se.ericsson.cello.moframework.AttrNotSettableException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.FroProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScRfAccessProxy;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TpaDeviceMo;

public class TpaDeviceMoImpl
extends AuxDeviceMoImpl
implements TpaDeviceMo {
    public static final int MO_DATA_REVISION = 1030301;
    private ScRfAccessProxy scRfAccessProxy = ScRfAccessProxy.instance();

    public TpaDeviceMoImpl(ManagedObject parent, String thisMoName, int deviceFroId, String identity, String userLabel, Coordinator context) throws MoAccessException {
        super(parent, thisMoName, 8, deviceFroId, identity, context, userLabel);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.bcmStoreAndRegisterBooleanAttribute("txPowerPersistentLock", false);
        int checkedAlarmStatus = 0;
        this.initAlarmStatus(checkedAlarmStatus, context);
        this.myData.setRevision(1030301);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.addObservers(8, context);
    }

    public TpaDeviceMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        try {
            this.addObservers(8, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public void sysDelete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sysDelete()");
        if (this.getTxPowerPersistentLock(context)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        super.sysDelete(context);
    }

    public String getTpaDeviceId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTpaDeviceId()");
        return this.getIdentity(context);
    }

    public String getType() {
        return "TpaDevice";
    }

    public int getMaxTotalOutputPower(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMaxTotalOutputPower()");
        return TpaDeviceMoImpl.eqcDeviceProxy.getMaxTotalOutputPower((long)((long)this.getTxIdNonTransactional((Coordinator)c)), (long)0L, (long)((long)this.getAuxDeviceFroId((Coordinator)c))).maxTotalOutputPower;
    }

    public void setMaxTotalOutputPower(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setMaxTotalOutputPower()");
        ValidateAttributes.intValueRangeCheck("maxTotalOutputPower", value, MAX_TOTAL_OUTPUT_POWER_MIN_VALUES, MAX_TOTAL_OUTPUT_POWER_MAX_VALUES, this.getType());
        int currentMaxTotalOutputPowerLow = this.getMaxTotalOutputPowerLow(c);
        if (value != -1 && currentMaxTotalOutputPowerLow != -1) {
            String msg = "Attribute MaxTotalOutputPower cannot be set to this value, because it's conflict with attribute MaxTotalOutputPowerLow";
            throw new AttrNotSettableException(this.getType(), msg);
        }
        eqcDeviceProxy.setMaxTotalOutputPower(this.getTxIdNonTransactional(c), 0L, this.getAuxDeviceFroId(c), value, currentMaxTotalOutputPowerLow);
        this.sendAVC("maxTotalOutputPower", value, c);
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, new FroProxy[]{eqcBdhIndProxy, this.scRfAccessProxy}, froType, this.getFroId(context), context);
    }

    public int getMaxTotalOutputPowerLow(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMaxTotalOutputPowerLow()");
        return TpaDeviceMoImpl.eqcDeviceProxy.getMaxTotalOutputPower((long)((long)this.getTxIdNonTransactional((Coordinator)c)), (long)0L, (long)((long)this.getAuxDeviceFroId((Coordinator)c))).maxTotalOutputPowerLow;
    }

    public void setMaxTotalOutputPowerLow(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setMaxTotalOutputPowerLow ()");
        ValidateAttributes.intValueRangeCheck("maxTotalOutputPowerLow", value, MAX_TOTAL_OUTPUT_POWER_LOW_MIN_VALUES, MAX_TOTAL_OUTPUT_POWER_LOW_MAX_VALUES, this.getType());
        int currentMaxTotalOutputPower = this.getMaxTotalOutputPower(c);
        if (this.bcmGetBooleanAttribute("txPowerPersistentLock", c)) {
            String msg = "Attribute maxTotalOutputPowerLow cannot be set to this value, because txPowerPersistentLock is set as true";
            throw new AttrNotSettableException(this.getType(), msg);
        }
        if (value != -1 && currentMaxTotalOutputPower != -1) {
            String msg = "Attribute MaxTotalOutputPowerLow cannot be set to this value, because it's conflict with attribute MaxTotalOutputPower";
            throw new AttrNotSettableException(this.getType(), msg);
        }
        eqcDeviceProxy.setMaxTotalOutputPower(this.getTxIdNonTransactional(c), 0L, this.getAuxDeviceFroId(c), currentMaxTotalOutputPower, value);
        this.sendAVC("maxTotalOutputPowerLow", value, c);
    }

    public boolean getTxPowerPersistentLock(Coordinator c) throws MoAccessException {
        return this.bcmGetBooleanAttribute("txPowerPersistentLock", c);
    }

    public void setTxPowerPersistentLock(boolean value, Coordinator c) throws MoAccessException {
        if (value != this.getTxPowerPersistentLock(c)) {
            if (this.getTxPowerPersistentLock(c)) {
                String msg = "Attribute txPowerPersistentLock cannot be change, because it is set as true";
                throw new AttrNotSettableException(this.getType(), msg);
            }
            if (this.getMaxTotalOutputPowerLow(c) == -1) {
                String msg = "Attribute txPowerPersistentLock cannot be set as true, because maxTotalOutputPowerLow is set as default";
                throw new AttrNotSettableException(this.getType(), msg);
            }
            this.bcmSetBooleanAttribute("txPowerPersistentLock", value, this.getType(), c);
            this.sendAVC("txPowerPersistentLock", value, c);
        }
    }

    public int getExtraPowerHsdpaMixedModePowerSharing(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getExtraPowerHsdpaMixedModePowerSharing()");
        return TpaDeviceMoImpl.eqcDeviceProxy.getMaxTotalOutputPower((long)((long)this.getTxIdNonTransactional((Coordinator)c)), (long)0L, (long)((long)this.getAuxDeviceFroId((Coordinator)c))).extraPowerHsdpaMixedModePowerSharing;
    }

    public void setExtraPowerHsdpaMixedModePowerSharing(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setExtraPowerHsdpaMixedModePowerSharing()");
        ValidateAttributes.intValueRangeCheck("extraPowerHsdpaMixedModePowerSharing", value, EXTRA_POWER_HSDPA_MIXED_MODE_POWER_SHARING_MIN_VALUES, EXTRA_POWER_HSDPA_MIXED_MODE_POWER_SHARING_MAX_VALUES, this.getType());
        eqcDeviceProxy.setMixedModePowerSharing(this.getTxIdNonTransactional(c), 0L, this.getAuxDeviceFroId(c), value);
        this.sendAVC("extraPowerHsdpaMixedModePowerSharing", value, c);
    }
}

