/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.tr;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.mao.common.MoTypeFilter;
import se.ericsson.wcdma.rbs.boam.mao.common.RbsVariants;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DbDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.TestBoardDependencyException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RfifDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TrxDeviceGroupMo;

public class TrxDeviceGroupMoImpl
extends DbDeviceGroupMoImpl
implements TrxDeviceGroupMo {
    public static final int MO_DATA_REVISION = 2031001;

    public TrxDeviceGroupMoImpl(ManagedObject parent, AttrList attributes, String userLabel, int checkedAlarmStatus, String identity, Coordinator context) throws MoAccessException {
        super(parent, "TrxDeviceGroup", attributes, identity, context, 1);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.initAlarmStatus(checkedAlarmStatus, context);
        EqcCreateGroupRspS RspS = this.createDeviceGroupResourceRsps(parent, 49572, context);
        DeviceGroupMoFactory.instance(49572).createDeviceGroupMoTree(this, RspS, "", context);
        this.myData.setRevision(2031001);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.addObservers(49572, context);
    }

    public TrxDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        try {
            this.addObservers(49572, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(TrxDeviceGroupMoImpl.class, "create()");
        TrxDeviceGroupMoImpl.checkTransaction(context);
        TrxDeviceGroupMoImpl.checkParent(parent, "TrxDeviceGroup");
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "TrxDeviceGroup");
        int checkedAlarmStatus = TrxDeviceGroupMoImpl.checkAndGetAlarmStatus(attributes, 0, "TrxDeviceGroup", context);
        ValidateAttributes.checkOtherAttributes(attributes, "TrxDeviceGroup");
        return new TrxDeviceGroupMoImpl(parent, attributes, checkedUserLabel, checkedAlarmStatus, identity, context);
    }

    private void hWTestBoardDependencyCheckNoneDuwRbs(String testId, Coordinator context) throws MoAccessException, TestBoardDependencyException {
        MessageLog.trace(2, this.getClass(), "hWTestBoardDependencyCheckNoneDuwRbs()");
        ManagedObject trxSlot = this.getParent().getParent();
        String trxSlotId = this.idOfMo(this);
        ManagedObject subrack = trxSlot.getParent();
        String rbsModel = RbsVariants.getVariant(context);
        boolean preCheckPassed = false;
        String rfifSlotId = null;
        if (rbsModel.equals("RBS3101") || rbsModel.equals("RBS3202")) {
            if (trxSlotId.equals("4") || trxSlotId.equals("7") || trxSlotId.equals("10")) {
                rfifSlotId = "2";
                MessageLog.trace(2, this.getClass(), " Checking startHwTest precond.s for TRX in slot " + trxSlotId + " of an `" + rbsModel + "';" + " depends on RFIF in slot " + rfifSlotId + ".");
            } else if (trxSlotId.equals("5") || trxSlotId.equals("8") || trxSlotId.equals("11")) {
                rfifSlotId = "3";
                MessageLog.trace(2, this.getClass(), " Checking startHwTest precond.s for TRX in slot " + trxSlotId + " of an `" + rbsModel + "';" + " depends on RFIF in slot " + rfifSlotId + ".");
            } else {
                MessageLog.trace(2, this.getClass(), " Precondition unknown for  TRX in slot " + trxSlotId + " of an `" + rbsModel + "':" + " startHwTest accepted by default.");
                preCheckPassed = true;
            }
        } else if (rbsModel.equals("RBS3103") || rbsModel.equals("RBS3104") || rbsModel.equals("RBS3203")) {
            MessageLog.trace(2, this.getClass(), " Checking startHwTest precond.s for TRX in slot " + trxSlotId + " of an `" + rbsModel + "';" + " depends on RFIF (in any slot).");
        } else {
            MessageLog.trace(2, this.getClass(), "Precondition unknown for `" + rbsModel + "'" + ": startHwTest accepted by default.");
            preCheckPassed = true;
        }
        if (!preCheckPassed) {
            MoIterator rfifIter = null;
            if (rfifSlotId != null) {
                MoIterator slotIter = MoRepository.instance().select(subrack, 1, (MoFilter)new MoTypeFilter("Slot"));
                ManagedObject rfifSlot = null;
                while (slotIter.hasMoreElements()) {
                    ManagedObject slot = (ManagedObject)slotIter.nextElement();
                    if (!this.idOfMo(slot).equals(rfifSlotId)) continue;
                    rfifSlot = slot;
                }
                rfifIter = MoRepository.instance().select(rfifSlot, 2, (MoFilter)new MoTypeFilter("RfifDeviceGroup"));
            } else {
                rfifIter = MoRepository.instance().select(subrack, 3, (MoFilter)new MoTypeFilter("RfifDeviceGroup"));
            }
            while (rfifIter.hasMoreElements()) {
                RfifDeviceGroupMo rfifToCheck = (RfifDeviceGroupMo)rfifIter.nextElement();
                if (rfifToCheck.getOperationalState(context) != 1 || rfifToCheck.getAvailabilityStatus(context) != 0) continue;
                preCheckPassed = true;
            }
        }
        if (!preCheckPassed) {
            MessageLog.trace(2, this.getClass(), "startHwTest refused: precondition on RfifDeviceGroup not met.");
            throw new TestBoardDependencyException();
        }
        super.actionStartHwTest(testId, context);
    }

    public void actionStartHwTest(String testId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStartHwTest()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        if (!this.getParent().getType().equals("PiuDevice")) {
            this.hWTestBoardDependencyCheckNoneDuwRbs(testId, context);
        }
    }

    private String idOfMo(ManagedObject mo) {
        MessageLog.traceEnter(this.getClass(), "idOfMo() ");
        String ldName = mo.getLocalDistinguishedName();
        String slotID = "-1";
        StringTokenizer paramTokenizer = new StringTokenizer(ldName, ",");
        while (paramTokenizer.hasMoreElements()) {
            String parameter = paramTokenizer.nextToken();
            StringTokenizer valueTokenizer = new StringTokenizer(parameter, "=");
            String paramName = null;
            String value = null;
            try {
                paramName = valueTokenizer.nextToken();
                value = valueTokenizer.nextToken();
            }
            catch (NoSuchElementException e) {
                continue;
            }
            if (!(paramName = paramName.trim()).equals("Slot")) continue;
            slotID = value.trim();
        }
        return slotID;
    }

    public String getType() {
        return "TrxDeviceGroup";
    }
}

