/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.cable;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.equipment.PlugInUnitMaoi;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcCableProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcRrhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateCableRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetTrxRfCableParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TrxRfCableMo;

public class TrxRfCableMoImpl
extends BoamManagedObjectWithAlarms
implements TrxRfCableMo {
    public static final int CLIENT_ID = 0;
    public static final String TRX_RF_CABLE_FRO_ID = "TrxRfCableFroId";
    public static final int MO_DATA_REVISION = 3010001;
    private EqcCableProxy eqcCableProxy = EqcCableProxy.instance();
    private EqcRrhIndProxy eqcRrhIndProxy = EqcRrhIndProxy.instance();
    private int trxRfCableFroId;
    private ManagedObject trxPlugInUnitRef;
    private ManagedObject aiuPlugInUnitRef;
    private int trxConnector;
    private int aiuConnector;
    private int dlAttenuation;
    private int dlDelay;
    private String userLabel;

    public TrxRfCableMoImpl(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        super(parent, "TrxRfCable", identity, context);
        if (!(parent instanceof EquipmentMo)) {
            super.delete(context);
            MessageLog.trace(1, this.getClass(), "Illegal parent");
            throw new IllegalParentException("Expecting EquipmentMo, received:" + parent.getClass().getName());
        }
        MessageLog.traceEnter(this.getClass(), "TrxRfCableMoImpl Normal constructor");
        this.initMoData(identity, attributes, context);
        this.createRo(context);
        this.addObservers(50156, context);
    }

    public TrxRfCableMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "TrxRfCableMoImpl Recovery constructor");
        this.myData = recoveredData;
        try {
            this.addObservers(50156, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(TrxRfCableMoImpl.class, "create() ");
        TrxRfCableMoImpl.checkTransaction(context);
        TrxRfCableMoImpl createdMo = new TrxRfCableMoImpl(parent, attributes, identity, source, context);
        return createdMo;
    }

    public void delete(Coordinator context) throws MoAccessException, MoRemovedException, UndeletableMoException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        IntegerAttribute trxRfCableFroIdAttr = (IntegerAttribute)this.myData.getAttribute(TRX_RF_CABLE_FRO_ID);
        int trxRfCableFroId = trxRfCableFroIdAttr.getValue(context);
        this.eqcCableProxy.deleteCable(this.getTxIdTransactional(context), 0, trxRfCableFroId, 50156);
        this.removeObservers(context);
        this.releaseReservations(context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), "Mo is Deleted");
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        int result2 = 0;
        try {
            this.myData.handleTransaction(context, MoData.READ_ACCESS);
            IntegerAttribute froId = (IntegerAttribute)this.myData.getAttribute(TRX_RF_CABLE_FRO_ID);
            result2 = froId == null ? 0 : froId.getValue(context);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "FroId could not be retrieved");
        }
        return result2;
    }

    public int getTrxRfCableFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTrxRfCableFroId()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        IntegerAttribute trxRfCableFroIdAttr = (IntegerAttribute)this.myData.getAttribute(TRX_RF_CABLE_FRO_ID);
        this.trxRfCableFroId = trxRfCableFroIdAttr.getValue(context);
        return this.trxRfCableFroId;
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        StringAttribute userLabelAttr = (StringAttribute)this.myData.getAttribute("userLabel");
        return userLabelAttr.getValue(context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public void createRo(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException, FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "createRo()");
        int aiuPiuInstanceId = ((PlugInUnitMaoi)this.getAiuPlugInUnitRef(context)).getFroId(context);
        int trxPiuInstanceId = ((PlugInUnitMaoi)this.getTrxPlugInUnitRef(context)).getFroId(context);
        EqcCreateCableRspS rspSig = this.eqcCableProxy.createCable(this.getTxIdTransactional(context), 0L, 50156, 0L, aiuPiuInstanceId, this.aiuConnector, trxPiuInstanceId, this.trxConnector);
        this.trxRfCableFroId = (int)rspSig.cableFroId;
        IntegerAttribute trxRfCableFroIdAttr = (IntegerAttribute)this.myData.getAttribute(TRX_RF_CABLE_FRO_ID);
        trxRfCableFroIdAttr.setValue(this.trxRfCableFroId);
        this.setDlAttenuation(this.dlAttenuation, context);
        this.setElectricalDlDelay(this.dlDelay, context);
        MessageLog.trace(1, this.getClass(), " RO is created, trxRfCableFroId: " + this.trxRfCableFroId);
    }

    public ManagedObject getAiuPlugInUnitRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAiuPlugInUnitRef()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ReferenceAttribute aiuPlugInUnitRefAttr = (ReferenceAttribute)this.myData.getAttribute("aiuPlugInUnitRef");
        if (aiuPlugInUnitRefAttr == null) {
            return null;
        }
        this.aiuPlugInUnitRef = aiuPlugInUnitRefAttr.getValue(context);
        return this.aiuPlugInUnitRef;
    }

    public int getTrxConnector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTrxConnector()");
        this.trxRfCableFroId = this.getTrxRfCableFroId(context);
        EqcGetTrxRfCableParamRspS rspSig = this.eqcCableProxy.getTrxRfCableParameters(this.getTxIdNonTransactional(context), 0, this.trxRfCableFroId);
        this.trxConnector = rspSig.trxConnectorId;
        if (this.trxConnector == 0) {
            this.trxConnector = 1;
        } else if (this.trxConnector == 1) {
            this.trxConnector = 2;
        } else {
            MessageLog.trace(2, this.getClass(), "The attribute trxConnector is Out of range: " + this.trxConnector);
        }
        return this.trxConnector;
    }

    public int getAiuConnector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAiuConnector()");
        this.trxRfCableFroId = this.getTrxRfCableFroId(context);
        EqcGetTrxRfCableParamRspS rspSig = this.eqcCableProxy.getTrxRfCableParameters(this.getTxIdNonTransactional(context), 0, this.trxRfCableFroId);
        this.aiuConnector = rspSig.aiuConnectorId;
        if (this.aiuConnector == 14) {
            this.aiuConnector = 1;
        } else if (this.aiuConnector == 15) {
            this.aiuConnector = 2;
        } else if (this.aiuConnector == 16) {
            this.aiuConnector = 3;
        } else if (this.aiuConnector == 17) {
            this.aiuConnector = 4;
        } else if (this.aiuConnector == 12) {
            this.aiuConnector = 5;
        } else if (this.aiuConnector == 34) {
            this.aiuConnector = 6;
        } else if (this.aiuConnector == 35) {
            this.aiuConnector = 7;
        } else {
            MessageLog.trace(2, this.getClass(), "The attribute aiuConnector is Out of range: " + this.aiuConnector);
        }
        return this.aiuConnector;
    }

    public int getDlAttenuation(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDlAttenuation()");
        this.trxRfCableFroId = this.getTrxRfCableFroId(context);
        MessageLog.trace(2, this.getClass(), "**trxRfCableFroId: " + this.trxRfCableFroId);
        EqcGetTrxRfCableParamRspS rspSig = this.eqcCableProxy.getTrxRfCableParameters(this.getTxIdNonTransactional(context), 0, this.trxRfCableFroId);
        this.dlAttenuation = rspSig.dlAttenuation;
        return this.dlAttenuation;
    }

    public void setDlAttenuation(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setDlAttenuation()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("dlAttenuation", value, DL_ATTENUATION_MIN_VALUES, DL_ATTENUATION_MAX_VALUES, this.getType());
        this.trxRfCableFroId = this.getTrxRfCableFroId(context);
        this.eqcCableProxy.setTrxRfCableParameters(this.getTxIdTransactional(context), 0, this.trxRfCableFroId, 1, value, 0);
    }

    public int getElectricalDlDelay(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getElectricalDlDelay()");
        this.trxRfCableFroId = this.getTrxRfCableFroId(context);
        MessageLog.trace(2, this.getClass(), "**trxRfCableFroId: " + this.trxRfCableFroId);
        EqcGetTrxRfCableParamRspS rspSig = this.eqcCableProxy.getTrxRfCableParameters(this.getTxIdNonTransactional(context), 0, this.trxRfCableFroId);
        this.dlDelay = rspSig.electricalDlDelay;
        return this.dlDelay;
    }

    public void setElectricalDlDelay(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setElectricalDlDelay()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("electricalDlDelay", value, ELECTRICAL_DL_DELAY_MIN_VALUES, ELECTRICAL_DL_DELAY_MAX_VALUES, this.getType());
        this.trxRfCableFroId = this.getTrxRfCableFroId(context);
        this.eqcCableProxy.setTrxRfCableParameters(this.getTxIdTransactional(context), 0, this.trxRfCableFroId, 2, 0, value);
    }

    public ManagedObject getTrxPlugInUnitRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTrxPlugInUnitRef()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ReferenceAttribute trxPlugInUnitRefAttr = (ReferenceAttribute)this.myData.getAttribute("trxPlugInUnitRef");
        if (trxPlugInUnitRefAttr == null) {
            return null;
        }
        this.trxPlugInUnitRef = trxPlugInUnitRefAttr.getValue(context);
        return this.trxPlugInUnitRef;
    }

    private void initMoData(String identity, AttrList attributes, Coordinator context) throws MoAccessException, TransactionRequiredException, AttrMissingAtCreateException, WrongAttributeTypeException, NotHandledAttributeTypeException, ValueOutOfRangeException {
        MessageLog.trace(1, this.getClass(), "initMoData()");
        this.myData = new MoData(super.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.checkAndSaveUserLabel(attributes);
        this.checkAndSaveDlDelay(attributes);
        this.checkAndSaveDlAttenuation(attributes);
        this.checkAndSaveAiuConnector(attributes);
        this.checkAndSaveTrxConnector(attributes);
        this.checkAndSaveAiuPlugInUnitRef(attributes);
        this.checkAndSaveTrxPlugInUnitRef(attributes);
        IntegerAttribute trxRfCableFroIdAttr = new IntegerAttribute(TRX_RF_CABLE_FRO_ID, false);
        this.myData.registerPersistentAttr((Attribute)trxRfCableFroIdAttr);
        ((Reservable)this.aiuPlugInUnitRef).reserve((ManagedObject)this, context);
        ((Reservable)this.trxPlugInUnitRef).reserve((ManagedObject)this, context);
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, TrxRfCableMo.ALARM_STATUS_MIN_VALUES, TrxRfCableMo.ALARM_STATUS_MAX_VALUES, "TrxRfCable");
        this.initAlarmStatus(checkedAlarmStatus, context);
        ValidateAttributes.checkOtherAttributes(attributes, "TrxRfCable");
        this.myData.setRevision(3010001);
    }

    private void releaseReservations(Coordinator context) throws MoAccessException, MoRemovedException, UndeletableMoException {
        MessageLog.traceEnter(this.getClass(), "releaseReservations()");
        if (this.getAiuPlugInUnitRef(context) != null) {
            ((Reservable)this.getAiuPlugInUnitRef(context)).release((ManagedObject)this, context);
        }
        if (this.getTrxPlugInUnitRef(context) != null) {
            ((Reservable)this.getTrxPlugInUnitRef(context)).release((ManagedObject)this, context);
        }
    }

    private void checkAndSaveTrxPlugInUnitRef(AttrList attributes) throws MoAccessException {
        int trxPlugInUnitRefAttrIndex = attributes.indexOf("trxPlugInUnitRef");
        if (trxPlugInUnitRefAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "trxPlugInUnitRefAttrIndex is not included in the attribute list");
            throw new AttrMissingAtCreateException("trxPlugInUnitRef", this.getType());
        }
        if (!(attributes.getValue(trxPlugInUnitRefAttrIndex) instanceof PlugInUnitMo)) {
            MessageLog.trace(1, this.getClass(), "trxPlugInUnitRef has wrong type");
            throw new WrongAttributeTypeException("trxPlugInUnitRef", this.getType());
        }
        this.trxPlugInUnitRef = (ManagedObject)attributes.getValue(trxPlugInUnitRefAttrIndex);
        ReferenceAttribute trxPlugInUnitRefAttr = new ReferenceAttribute("trxPlugInUnitRef", false);
        this.myData.registerPersistentAttr((Attribute)trxPlugInUnitRefAttr);
        trxPlugInUnitRefAttr.setValue(this.trxPlugInUnitRef);
        attributes.removeElementAt(trxPlugInUnitRefAttrIndex);
    }

    private void checkAndSaveAiuPlugInUnitRef(AttrList attributes) throws MoAccessException {
        int aiuPlugInUnitRefAttrIndex = attributes.indexOf("aiuPlugInUnitRef");
        if (aiuPlugInUnitRefAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "aiuPlugInUnitRef is not included in the attribute list");
            throw new AttrMissingAtCreateException("aiuPlugInUnitRef", this.getType());
        }
        if (!(attributes.getValue(aiuPlugInUnitRefAttrIndex) instanceof PlugInUnitMo)) {
            MessageLog.trace(1, this.getClass(), "aiuPlugInUnitRef has wrong type");
            throw new WrongAttributeTypeException("aiuPlugInUnitRef", this.getType());
        }
        ReferenceAttribute aiuPlugInUnitRefAttr = new ReferenceAttribute("aiuPlugInUnitRef", false);
        this.aiuPlugInUnitRef = (ManagedObject)attributes.getValue(aiuPlugInUnitRefAttrIndex);
        this.myData.registerPersistentAttr((Attribute)aiuPlugInUnitRefAttr);
        aiuPlugInUnitRefAttr.setValue(this.aiuPlugInUnitRef);
        attributes.removeElementAt(aiuPlugInUnitRefAttrIndex);
    }

    private void checkAndSaveTrxConnector(AttrList attributes) throws MoAccessException {
        int trxConnectorAttrIndex = attributes.indexOf("trxConnector");
        if (trxConnectorAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "trxConnector is not included in the attribute list");
            throw new AttrMissingAtCreateException("trxConnector", this.getType());
        }
        if (!(attributes.getValue(trxConnectorAttrIndex) instanceof Integer)) {
            MessageLog.trace(1, this.getClass(), "trxConnector has wrong type");
            throw new WrongAttributeTypeException("trxConnector", this.getType());
        }
        this.trxConnector = (Integer)attributes.getValue(trxConnectorAttrIndex);
        if (this.trxConnector < 1 || this.trxConnector > 2) {
            String msg = "The attribute trxConnector is Out of range" + this.trxConnector;
            MessageLog.trace(1, this.getClass(), msg);
            throw new ValueOutOfRangeException(msg, this.getType());
        }
        if (this.trxConnector == 1) {
            this.trxConnector = 0;
        } else if (this.trxConnector == 2) {
            this.trxConnector = 1;
        } else {
            String msg = "The attribute trxConnector is Out of range" + this.trxConnector;
            MessageLog.trace(1, this.getClass(), msg);
            throw new ValueOutOfRangeException(msg, this.getType());
        }
        IntegerAttribute trxConnectorAttr = new IntegerAttribute("trxConnector", false);
        this.myData.registerPersistentAttr((Attribute)trxConnectorAttr);
        trxConnectorAttr.setValue(this.trxConnector);
        attributes.removeElementAt(trxConnectorAttrIndex);
    }

    private void checkAndSaveAiuConnector(AttrList attributes) throws MoAccessException {
        int aiuConnectorAttrIndex = attributes.indexOf("aiuConnector");
        if (aiuConnectorAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "aiuConnector is not included in the attribute list");
            throw new AttrMissingAtCreateException("aiuConnector", this.getType());
        }
        if (!(attributes.getValue(aiuConnectorAttrIndex) instanceof Integer)) {
            MessageLog.trace(1, this.getClass(), "aiuConnector has wrong type");
            throw new WrongAttributeTypeException("aiuConnector", this.getType());
        }
        this.aiuConnector = (Integer)attributes.getValue(aiuConnectorAttrIndex);
        if (this.aiuConnector < 1 || this.aiuConnector > 7) {
            String msg = "The attribute aiuConnector is Out of range" + this.aiuConnector;
            MessageLog.trace(1, this.getClass(), msg);
            throw new ValueOutOfRangeException(msg, this.getType());
        }
        if (this.aiuConnector == 1) {
            this.aiuConnector = 14;
        } else if (this.aiuConnector == 2) {
            this.aiuConnector = 15;
        } else if (this.aiuConnector == 3) {
            this.aiuConnector = 16;
        } else if (this.aiuConnector == 4) {
            this.aiuConnector = 17;
        } else if (this.aiuConnector == 5) {
            this.aiuConnector = 12;
        } else if (this.aiuConnector == 6) {
            this.aiuConnector = 34;
        } else if (this.aiuConnector == 7) {
            this.aiuConnector = 35;
        } else {
            String msg = "The attribute aiuConnector is Out of range" + this.aiuConnector;
            MessageLog.trace(1, this.getClass(), msg);
            throw new ValueOutOfRangeException(msg, this.getType());
        }
        IntegerAttribute aiuConnectorAttr = new IntegerAttribute("aiuConnector", false);
        this.myData.registerPersistentAttr((Attribute)aiuConnectorAttr);
        aiuConnectorAttr.setValue(this.aiuConnector);
        attributes.removeElementAt(aiuConnectorAttrIndex);
    }

    private void checkAndSaveDlAttenuation(AttrList attributes) throws MoAccessException {
        int dlAttenuationAttrIndex = attributes.indexOf("dlAttenuation");
        if (dlAttenuationAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "dlAttenuation is not included in the attribute list");
            throw new AttrMissingAtCreateException("dlAttenuation", this.getType());
        }
        if (!(attributes.getValue(dlAttenuationAttrIndex) instanceof Integer)) {
            MessageLog.trace(1, this.getClass(), "dlAttenuation has wrong type");
            throw new WrongAttributeTypeException("dlAttenuation", this.getType());
        }
        this.dlAttenuation = (Integer)attributes.getValue(dlAttenuationAttrIndex);
        ValidateAttributes.intValueRangeCheck("dlAttenuation", this.dlAttenuation, DL_ATTENUATION_MIN_VALUES, DL_ATTENUATION_MAX_VALUES, this.getType());
        IntegerAttribute dlAttenuationAttr = new IntegerAttribute("dlAttenuation", false);
        this.myData.registerPersistentAttr((Attribute)dlAttenuationAttr);
        dlAttenuationAttr.setValue(this.dlAttenuation);
        attributes.removeElementAt(dlAttenuationAttrIndex);
    }

    private void checkAndSaveDlDelay(AttrList attributes) throws MoAccessException {
        int dlDelayAttrIndex = attributes.indexOf("electricalDlDelay");
        if (dlDelayAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "dlDelay is not included in the attribute list");
            throw new AttrMissingAtCreateException("electricalDlDelay", this.getType());
        }
        if (!(attributes.getValue(dlDelayAttrIndex) instanceof Integer)) {
            MessageLog.trace(1, this.getClass(), "dlDelay has wrong type");
            throw new WrongAttributeTypeException("electricalDlDelay", this.getType());
        }
        this.dlDelay = (Integer)attributes.getValue(dlDelayAttrIndex);
        ValidateAttributes.intValueRangeCheck("electricalDlDelay", this.dlDelay, ELECTRICAL_DL_DELAY_MIN_VALUES, ELECTRICAL_DL_DELAY_MAX_VALUES, this.getType());
        IntegerAttribute dlDelayAttr = new IntegerAttribute("electricalDlDelay", false);
        this.myData.registerPersistentAttr((Attribute)dlDelayAttr);
        dlDelayAttr.setValue(this.dlDelay);
        attributes.removeElementAt(dlDelayAttrIndex);
    }

    private void checkAndSaveUserLabel(AttrList attributes) throws MoAccessException {
        int userLabelAttrIndex = attributes.indexOf("userLabel");
        if (userLabelAttrIndex == -1) {
            this.userLabel = "";
        } else {
            this.userLabel = (String)attributes.getValue(userLabelAttrIndex);
            if (this.userLabel.length() > 128) {
                String errMsg = "userLabel has WRONG size ! Expected :128 ; received :" + this.userLabel.length();
                MessageLog.trace(1, this.getClass(), errMsg);
                throw new ValueOutOfRangeException(errMsg, this.getType());
            }
            attributes.removeElementAt(userLabelAttrIndex);
        }
        StringAttribute userLabelAttr = new StringAttribute("userLabel", false);
        this.myData.registerPersistentAttr((Attribute)userLabelAttr);
        userLabelAttr.setValue(this.userLabel);
    }

    public String getType() {
        return "TrxRfCable";
    }

    private void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcRrhIndProxy, froType, this.getFroId(context), context);
    }

    private void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }
}

