/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.climate;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.MoTypeFilter;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.productinventory.HardwareProductData;
import se.ericsson.cello.productinventory.ProductRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.MoTypeCheckMoTypeAndIdFilter;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.common.DefaultFaultDevFroId;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcBdhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetDeviceBHwPidRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsBasicHwPidT;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.common.ProductDataUtil;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceSetMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ClDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ClDeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CluMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PcuDeviceGroupMo;

public class CluMoImpl
extends BoamManagedObjectWithAlarms
implements CluMo,
HardwareProductData,
MaoHasFro {
    private static final EqcDeviceProxy eqcDeviceProxy = EqcDeviceProxy.instance();
    private static final EqcBdhIndProxy eqcBdhIndProxy = EqcBdhIndProxy.instance();
    private static final int SLOTPOSITION = 0;
    private static final String SUBRACKID = "";
    public static final int MO_DATA_REVISION = 274433;
    private ManagedObject pcuDevGroup = null;
    private int clDeviceFroId = 0;
    private int pcuDevGrFroId = 0;
    private int myFroId = 0;

    public CluMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, String checkedUserLabel, int checkedAlarmStatus, ManagedObject source) throws MoAccessException {
        super(parent, motypeName, identity, context);
        MessageLog.traceEnter(this.getClass(), " Clu Normal constructor");
        int deviceFroId = 0;
        int devSetFroId = 0;
        ManagedObject pcuDevGr = this.checkPcuDevGroupExistence(parent, context);
        ManagedObject clSet = AuxDeviceSetMoFactory.instance(49764).createTheMo(pcuDevGr, devSetFroId, "1", SUBRACKID, context);
        ManagedObject clDev = AuxDeviceMoFactory.instance(12).createTheMo(clSet, deviceFroId, "1", SUBRACKID, context);
        ClDeviceMo clDeviceRef = (ClDeviceMo)clDev;
        this.initMoData(checkedUserLabel, clDeviceRef, checkedAlarmStatus, context);
        clDeviceRef.reserve(this, context);
        this.addObservers(49168, context);
        MessageLog.trace(1, this.getClass(), "Clu Mo is Created ");
    }

    public CluMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), " Clu recovery constructor");
        this.myData = recoveredData;
        ReferenceAttribute deviceRefAttr = (ReferenceAttribute)recoveredData.getAttribute("deviceRef");
        if (deviceRefAttr == null) {
            MessageLog.traceError(this.getClass(), "Recovered attribute deviceRefAttr is null");
        }
        ProductRepository.instance().registerHw((HardwareProductData)this);
        try {
            this.addObservers(49168, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Clu MO is Restored ");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(CluMoImpl.class, "create()");
        CluMoImpl.checkTransaction(context);
        CluMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", SUBRACKID, 0, 128, "Clu");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "Clu");
        ValidateAttributes.checkOtherAttributes(attributes, "Clu");
        CluMoImpl createdMo = new CluMoImpl(parent, "Clu", identity, context, checkedUserLabel, checkedAlarmStatus, source);
        return createdMo;
    }

    public void delete(Coordinator c) throws MoAccessException, MoHasChildrenException {
        MessageLog.traceEnter(this.getClass(), "delete() ");
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ClDeviceMo clDeviceRef = (ClDeviceMo)this.getDeviceRef(c);
        ClDeviceSetMo clDevSetRef = (ClDeviceSetMo)clDeviceRef.getParent();
        clDeviceRef.release(this, c);
        clDeviceRef.npuDelete(c, 12);
        clDevSetRef.sysDelete(c);
        ProductRepository.instance().deregisterHw((HardwareProductData)this);
        this.removeObservers(c);
        this.myData.delete(c);
        super.delete(c);
        MessageLog.trace(1, this.getClass(), "Clu Mo is Deleted ");
    }

    public String getType() {
        return "Clu";
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public String getCluId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCluId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, "Clu", context);
        this.sendAVC("userLabel", value, context);
    }

    public ManagedObject getDeviceRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDeviceRef()");
        return this.bcmGetReferenceAttribute("deviceRef", context);
    }

    private RbsBasicHwPidT getRbsBasicHwPidT(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRbsBasicHwPidT()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        RbsBasicHwPidT rbsBasicHwPidT = null;
        this.clDeviceFroId = ((ClDeviceMo)this.getDeviceRef(context)).getAuxDeviceFroId(context);
        EqcGetDeviceBHwPidRspS rspSig = eqcDeviceProxy.getRbsBasicHwPidT(0L, this.clDeviceFroId);
        if (rspSig != null && rspSig.result == 0) {
            rbsBasicHwPidT = rspSig.basicHwPid;
        }
        return rbsBasicHwPidT;
    }

    public String getProductNumber(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getProductNumber()");
        String productNumber = SUBRACKID;
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productNumber = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductNumber);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productNumber;
    }

    public String getProductRevision(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getProductRevision()");
        String productRevision = SUBRACKID;
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productRevision = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductRevision);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productRevision;
    }

    public String getProductName(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getProductName()");
        String productName = SUBRACKID;
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productName = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductName);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productName;
    }

    public String getProductType(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getProductType()");
        String productType = "HW";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productType = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductType);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productType;
    }

    public String getProductionDate(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getProductionDate()");
        String productionDate = "00000000";
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                productionDate = ProductDataUtil.verifyDateFormat(rbsBasicHwPidT);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return productionDate;
    }

    public String getSerialNumber(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getSerialNumber()");
        String serialNumber = SUBRACKID;
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                serialNumber = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwSerialNumber);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return serialNumber;
    }

    public String getRState(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getRState()");
        String rState = SUBRACKID;
        try {
            RbsBasicHwPidT rbsBasicHwPidT = this.getRbsBasicHwPidT(context);
            if (rbsBasicHwPidT != null) {
                rState = Strings.removeNonPrintableAscii(rbsBasicHwPidT.hwProductRevision);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return rState;
    }

    public int getSlotPosition(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getSlotPosition()");
        return 0;
    }

    public String getSubrackId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getSubrackId()");
        return SUBRACKID;
    }

    public int getGreenLed(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getGreenLed()");
        return 1;
    }

    public int getRedLed(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRedLed()");
        return 1;
    }

    public int getYellowLed(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getYellowLed()");
        return 1;
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        if (parent == null || !(parent instanceof EquipmentMo)) {
            String msg = parent != null ? " Illegal parent, Expecting EquipmentMo, received: " + parent.getClass().getName() : "parent is null";
            throw new IllegalParentException(msg);
        }
    }

    private ManagedObject checkPcuDevGroupExistence(ManagedObject parent, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkPcuDevGroupExistence()");
        ManagedObject mo = null;
        MoIterator moIter = MoRepository.instance().select(parent, 4, (MoFilter)new MoTypeFilter("PcuDeviceGroup"));
        if (moIter.size() == 0) {
            moIter = MoRepository.instance().select(parent, 5, (MoFilter)new MoTypeCheckMoTypeAndIdFilter("DeviceGroup", "PCU"));
        }
        if (moIter.size() == 0) {
            throw new IllegalParentException(this.getType() + "MaoNotAllocated");
        }
        if (moIter.hasMoreElements()) {
            this.pcuDevGroup = mo = moIter.nextMo();
            if (mo instanceof PcuDeviceGroupMo) {
                this.pcuDevGrFroId = ((PcuDeviceGroupMo)this.pcuDevGroup).getAuxGroupFroId(context);
            } else if (mo instanceof DeviceGroupMo) {
                this.pcuDevGrFroId = ((DeviceGroupMo)this.pcuDevGroup).getAuxGroupFroId(context);
            }
            MessageLog.trace(1, this.getClass(), "Clu checkPcuDevGroupExistence() executed pcuDevGrFroId :" + this.pcuDevGrFroId);
        }
        return mo;
    }

    private void initMoData(String checkedUserLabel, ManagedObject checkedDeviceRef, int checkedAlarmStatus, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.myData.setRevision(274433);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterReferenceAttribute("deviceRef", checkedDeviceRef);
        this.initAlarmStatus(checkedAlarmStatus, context);
        ProductRepository.instance().registerHw((HardwareProductData)this);
        this.myData.setRevision(274433);
    }

    public void start() {
        MessageLog.traceEnter(this.getClass(), "start()");
        try {
            this.addObservers(12, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myFroId = DefaultFaultDevFroId.getNextNpuFroId();
        this.myMoAlarms = new MoAlarms((ManagedObject)this, eqcBdhIndProxy, froType, this.myFroId, context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }

    public void setAlarmStatus(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setAlarmStatus()");
        super.setAlarmStatus(value, c);
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.myFroId;
    }
}

