/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.mechanics;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.emo.mechanics.BfSubrackMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.mechanics.CuSubrackMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.mechanics.McpaSubrackMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.mechanics.RbsSubrackMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.power.AccuSubrackMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.power.PowerSupplySubrackMoImpl;

public class BoamSubrackMoFactory
implements MoFactory {
    private static BoamSubrackMoFactory rbsInstance;
    private static BoamSubrackMoFactory mcpaInstance;
    private static BoamSubrackMoFactory cuInstance;
    private static BoamSubrackMoFactory pwrInstance;
    private static BoamSubrackMoFactory accuInstance;
    private static BoamSubrackMoFactory bfInstance;
    private int rbsSubrackType = 0;

    private BoamSubrackMoFactory(int subrackType) {
        MessageLog.traceEnter(this.getClass(), "subrackType = " + subrackType + ", Normal constructor");
        this.rbsSubrackType = subrackType;
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
    }

    public static synchronized BoamSubrackMoFactory instance(int subrackType) {
        BoamSubrackMoFactory instance = null;
        switch (subrackType) {
            case 8: {
                if (rbsInstance == null) {
                    rbsInstance = new BoamSubrackMoFactory(subrackType);
                }
                instance = rbsInstance;
                break;
            }
            case 1: {
                if (mcpaInstance == null) {
                    mcpaInstance = new BoamSubrackMoFactory(subrackType);
                }
                instance = mcpaInstance;
                break;
            }
            case 2: {
                if (cuInstance == null) {
                    cuInstance = new BoamSubrackMoFactory(subrackType);
                }
                instance = cuInstance;
                break;
            }
            case 3: {
                if (pwrInstance == null) {
                    pwrInstance = new BoamSubrackMoFactory(subrackType);
                }
                instance = pwrInstance;
                break;
            }
            case 800005: {
                if (accuInstance == null) {
                    accuInstance = new BoamSubrackMoFactory(subrackType);
                }
                instance = accuInstance;
                break;
            }
            case 7: {
                if (bfInstance == null) {
                    bfInstance = new BoamSubrackMoFactory(subrackType);
                }
                instance = bfInstance;
                break;
            }
            default: {
                instance = null;
            }
        }
        return instance;
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMo()");
        ManagedObject createdMo = this.createTheMo(parent, attributes, identity, source, context);
        MessageLog.trace(1, this.getClass(), "Rbs Subrack MO Created");
        return createdMo;
    }

    public ManagedObject createTheMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createTheMo()");
        ManagedObject mo = null;
        switch (this.rbsSubrackType) {
            case 8: {
                mo = RbsSubrackMoImpl.create(parent, attributes, identity, source, context);
                break;
            }
            case 1: {
                mo = McpaSubrackMoImpl.create(parent, attributes, identity, source, context);
                break;
            }
            case 2: {
                mo = CuSubrackMoImpl.create(parent, attributes, identity, source, context);
                break;
            }
            case 3: {
                mo = PowerSupplySubrackMoImpl.create(parent, attributes, identity, source, context);
                break;
            }
            case 800005: {
                mo = AccuSubrackMoImpl.create(parent, attributes, identity, source, context);
                break;
            }
            case 7: {
                mo = BfSubrackMoImpl.create(parent, attributes, identity, source, context);
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "Software Error in BOAM, illegal subrack type");
            }
        }
        MessageLog.trace(1, this.getClass(), "createTheMo() return");
        return mo;
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo for rbs subrack type : " + this.rbsSubrackType);
        BoamManagedObject mo = null;
        switch (this.rbsSubrackType) {
            case 8: {
                mo = new RbsSubrackMoImpl(recoveredData);
                break;
            }
            case 1: {
                mo = new McpaSubrackMoImpl(recoveredData);
                break;
            }
            case 2: {
                mo = new CuSubrackMoImpl(recoveredData);
                break;
            }
            case 3: {
                mo = new PowerSupplySubrackMoImpl(recoveredData);
                break;
            }
            case 800005: {
                mo = new AccuSubrackMoImpl(recoveredData);
                break;
            }
            case 7: {
                mo = new BfSubrackMoImpl(recoveredData);
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "Software Error in BOAM, illegal subrack type");
            }
        }
        return mo;
    }

    public String getMoTypeName() {
        String name = "UnknownSubrack";
        switch (this.rbsSubrackType) {
            case 8: {
                name = "RbsSubrack";
                break;
            }
            case 1: {
                name = "McpaSubrack";
                break;
            }
            case 2: {
                name = "CuSubrack";
                break;
            }
            case 3: {
                name = "PowerSupplySubrack";
                break;
            }
            case 800005: {
                name = "AccuSubrack";
                break;
            }
            case 7: {
                name = "BfSubrack";
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "Software Error in BOAM, illegal subrack type");
            }
        }
        return name;
    }
}

