/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.mechanics;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.ServiceNotPublishedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcSubrackProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateSubrackRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsSubrackFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CuSubrackMo;

public class CuSubrackMoImpl
extends BoamManagedObject
implements CuSubrackMo {
    public static final String SUBRACK_FRO_ID = "subrackFroId";
    public static final String NUMBER_OF_SLOTS = "numberOfSlots";
    private static final int CU_SUBRACK_MAX_NO_OF_SLOTS = 0;
    public static final int MO_DATA_REVISION = 3010001;
    private MoData myData;
    private EqcSubrackProxy eqcSubrackProxy = EqcSubrackProxy.instance();

    public CuSubrackMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, String checkedUserLabel, String checkedSubrackPosition, String checkedCabinetPosition, ManagedObject source) throws MoAccessException {
        super(parent, motypeName, identity, context);
        MessageLog.traceEnter(this.getClass(), " CuSubrackMoImpl()");
        this.initMoData(checkedUserLabel, checkedSubrackPosition, checkedCabinetPosition, context);
    }

    public CuSubrackMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(this.getClass(), " CuSubrackMoImpl()");
        this.myData = recoveredData;
        MessageLog.trace(1, this.getClass(), "MO is Restored, version Attribute in MoData = " + this.myData.getRevision());
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(CuSubrackMoImpl.class, "create()");
        CuSubrackMoImpl.checkTransaction(context);
        CuSubrackMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "CuSubrack");
        String checkedSubrackPosition = ValidateAttributes.checkAndGetStringAttribute(attributes, "subrackPosition", "mandatory", "", Integer.MIN_VALUE, Integer.MAX_VALUE, "CuSubrack");
        String checkedCabinetPosition = ValidateAttributes.checkAndGetStringAttribute(attributes, "cabinetPosition", "optional", "", 0, 2, "CuSubrack");
        ValidateAttributes.checkOtherAttributes(attributes, "CuSubrack");
        CuSubrackMoImpl createdMo = new CuSubrackMoImpl(parent, "CuSubrack", identity, context, checkedUserLabel, checkedSubrackPosition, checkedCabinetPosition, source);
        return createdMo;
    }

    public void delete(Coordinator c) throws MoAccessException, MoHasChildrenException, UndeletableMoException {
        MessageLog.traceEnter(this.getClass(), "delete() ");
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (super.isReserved(c)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.deleteRo(c);
        this.myData.delete(c);
        super.delete(c);
        MessageLog.trace(1, this.getClass(), "CuSubrack Mo is Deleted ");
    }

    public int getCuSubrackFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCuSubrackFroId()");
        return this.bcmGetIntAttribute(SUBRACK_FRO_ID, context);
    }

    public String getType() {
        return "CuSubrack";
    }

    public void proxiesUnavailable() {
        MessageLog.traceEnter(this.getClass(), "proxiesUnavailable");
    }

    public void proxiesAvailable() throws ServiceNotPublishedException {
        MessageLog.traceEnter(this.getClass(), "proxiesAvailable()");
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, "CuSubrack", context);
        this.sendAVC("userLabel", value, context);
    }

    public String getSubrackPosition(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSubrackPosition() ");
        return this.bcmGetStringAttribute("subrackPosition", context);
    }

    public void setSubrackPosition(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSubrackPosition() ");
        this.bcmSetStringAttribute("subrackPosition", value, Integer.MIN_VALUE, Integer.MAX_VALUE, "CuSubrack", context);
        this.sendAVC("subrackPosition", value, context);
    }

    public String getCabinetPosition(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCabinetPosition() ");
        return this.bcmGetStringAttribute("cabinetPosition", context);
    }

    public void setCabinetPosition(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setCabinetPosition() ");
        this.bcmSetStringAttribute("cabinetPosition", value, 0, 2, "CuSubrack", context);
        this.sendAVC("cabinetPosition", value, context);
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        if (parent == null || !(parent instanceof EquipmentMo)) {
            String msg = parent != null ? " Illegal parent, Expecting EquipmentMo, received: " + parent.getClass().getName() : "parent is null";
            throw new IllegalParentException(msg);
        }
    }

    private void initMoData(String checkedUserLabel, String checkedSubrackPosition, String checkedCabinetPosition, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.myData.setRevision(3010001);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterStringAttribute("subrackPosition", checkedSubrackPosition);
        this.bcmStoreAndRegisterStringAttribute("cabinetPosition", checkedCabinetPosition);
        RbsSubrackFroInfoT subrackFroInfo = this.createRo(context);
        this.bcmStoreAndRegisterIntAttribute(SUBRACK_FRO_ID, (int)subrackFroInfo.subrackFroId);
        this.bcmStoreAndRegisterIntAttribute(NUMBER_OF_SLOTS, subrackFroInfo.numberOfSlots);
    }

    private RbsSubrackFroInfoT createRo(Coordinator context) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException {
        EqcCreateSubrackRspS cfmSig;
        MessageLog.traceEnter(this.getClass(), "createRo() ");
        try {
            cfmSig = this.eqcSubrackProxy.createSubrack(this.getTxIdTransactional(context), 0L, 2);
        }
        catch (FroNotAccessibleException e) {
            super.delete(context);
            throw e;
        }
        catch (FroRequestFailedException e) {
            super.delete(context);
            throw e;
        }
        if (cfmSig.subrackFroInfo.subrackType != 2) {
            String msg2 = "EqcCreateSubrackRspS.subrackType differs to the sent type from BOAM to EQC ";
            MessageLog.traceError(this.getClass(), msg2);
        }
        if (cfmSig.subrackFroInfo.numberOfSlots > 0) {
            String msg3 = "EqcCreateSubrackRspS.numberOfSlots is " + Integer.toString(cfmSig.subrackFroInfo.numberOfSlots) + " This number exceeds the max number of slots which is " + Integer.toString(0);
            MessageLog.traceError(this.getClass(), msg3);
        }
        return cfmSig.subrackFroInfo;
    }

    private void deleteRo(Coordinator context) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "deleteRo() ");
        this.eqcSubrackProxy.deleteSubrack(this.getTxIdTransactional(context), 0, this.getCuSubrackFroId(context));
    }
}

