/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.cell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import se.ericsson.cello.mao.ActionNotAllowedException;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcEulProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcMeasurementProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcPccpchProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulGetCarrierParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulSettableCarrierParamsT;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcSectorProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcAddSectorCarrierRspS;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.FroProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScCellCarrierProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScRfAccessCarrierProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsCarrierGetParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsCarrierNbapGetParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsCcTrtxBbPowRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsCellGetParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsCreateCellCarrierRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsEnableTxLoadSharingRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapAddCarrierRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapDeviceS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapGetAvpowerRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsStartFmPowMeasRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ConfigNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.common.MoTypeFilter;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.emo.bb.DownlinkBaseBandPoolMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.CarrierQueueSelectAlgorithm;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.AlreadyActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.CellNotSetupException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ConfigurationNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.DeviceDisabledException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.MacHsIsSetupException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.MoDisabledException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotHsdpaCapableException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotInitiatedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationNotAllowedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.struct.EulOptimalNoiseFloorLockDataStruct;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.BchMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CarrierMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DbccDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DownlinkBaseBandPoolMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PcpichMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PschMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RadioLinksMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsLocalCellMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SschMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.CarrierMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.SectorHelper;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.SectorMoAdditional;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.HsDschResourcesMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.links.RadioLinksMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.links.RadioLinksMoImpl;
import se.ericsson.wcdma.rbs.boam.pms.iface.ProxyScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;

public class CarrierMoImpl
extends BoamManagedObjectWithAlarms
implements CarrierMo {
    public static final int CQI_ERROR_RESOLUTION = 5;
    public static final int CQI_ERROR_FOR_RESOLUTION_MIN_VALUE = 15;
    public static final int CQI_ERROR_FOR_RESOLUTION_MAX_VALUE = 100;
    public static final int CQI_ERROR_ABSENT_RESOLUTION = 5;
    public static final int CQI_ERROR_FOR_ABSENT_RESOLUTION_MIN_VALUE = 15;
    public static final int CQI_ERROR_FOR_ABSENT_RESOLUTION_MAX_VALUE = 100;
    public static final String UARFCN = "uarfcn";
    public static final String UARFCN_NU = "uarfcnNu";
    public static final String UARFCN_ND = "uarfcnNd";
    public static final String CPICH_IS_ACTIVE = "cpichIsActive";
    public static final String SCH_IS_ACTIVE = "schIsActive";
    private static final String PCPICH_REF = "pcpichRef";
    private static final String SCPICH_REF = "scpichRef";
    private static final String PSCH_REF = "pschRef";
    private static final String SSCH_REF = "sschRef";
    public static final String DUI_DEVICE_GROUP_REF = "duiDeviceGroupRef";
    public static final int EUL_SLIDING_WINDOW_TIME_RESOLUTION = 10;
    public static final int EUL_SLIDING_WINDOW_TIME_FOR_RESOLUTION_MIN_VALUE = 10;
    public static final int EUL_SLIDING_WINDOW_TIME_FOR_RESOLUTION_MAX_VALUE = 864000;
    private static final String PARENT_TYPE = "Sector";
    private static final int MAX_NO_OF_CARRIERS_PER_SECTOR = 8;
    public static final int MO_DATA_REVISION = 7040001;
    private final ScCellCarrierProxy lrsProxy = ScCellCarrierProxy.instance();
    private final ChcMeasurementProxy chcMeasurementProxy = ChcMeasurementProxy.instance();
    private final ScRfAccessCarrierProxy scRfAccessCarrierProxy = ScRfAccessCarrierProxy.instance();
    private final EqcSectorProxy eqcSectorProxy = EqcSectorProxy.instance();
    private final MoScanner sccScanner;
    private final MoScanner chcScanner;
    private final ChcEulProxy chcEulProxy = ChcEulProxy.instance();

    public CarrierMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, String checkedUserLabel, int checkedFrequencyPlane, int checkedAlarmStatus, int checkedTxGainCalType, int checkedTxGainCalValue, int checkedNumberOfTxBranches, int checkedNumberOfRxBranches, int checkedDlBandwidth, int checkedUlBandwidth, int checkedDlFilterProfile, int checkedUlFilterProfile, ManagedObject checkedDownlinkBaseBandPoolRef, int checkedTxBranchConfigured, int[] checkedTxBranchesConfigured, int checkedCellRange, int checkedEulMaxOwnUuLoad, int checkedEulMaxRotCoverage, Struct checkedEulOptimalNoiseFloorLock, int checkedEulSlidingWindowTime, int checkedEulThermalLevelPrior, int checkedFccRotMarginHigh, int checkedFccRotMarginLow, AttrList attrList) throws MoAccessException {
        super(parent, motypeName, identity, context, 8);
        int checkedExtraCompForSigHsFach;
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        SectorMo sector = (SectorMo)this.getParent();
        SectorHelper.checkSectorAntennasPrecondition(sector, checkedNumberOfRxBranches, context);
        if (sector.isSectorInitialized(context) && checkedNumberOfTxBranches > 1) {
            throw new ConfigNotSupportedException("If Sector is initialized, Carrier::numberOfTxBranches must be 1");
        }
        this.initMoData(checkedUserLabel, checkedAlarmStatus, checkedDownlinkBaseBandPoolRef, context);
        int sectorFroId = sector.getFroId(context);
        int rfapFroId = sector.getRfAccessPointFroId(context);
        int bbPoolId = this.checkAndGetbbPoolId(checkedDownlinkBaseBandPoolRef, context);
        int txBranchConfigured = checkedTxBranchConfigured - 1;
        int[] txBranchesConfigured = new int[]{checkedTxBranchesConfigured[0] - 1, checkedTxBranchesConfigured[1] - 1};
        LrsCreateCellCarrierRspS lrsCreateRsp = this.createRo(checkedFrequencyPlane, sectorFroId, rfapFroId, checkedTxGainCalType, checkedTxGainCalValue, checkedNumberOfTxBranches, checkedNumberOfRxBranches, bbPoolId, txBranchConfigured, txBranchesConfigured, checkedCellRange, context);
        int cellCarrierFroId = lrsCreateRsp.cellCarrierFroId;
        this.bcmStoreAndRegisterIntAttribute("cellCarrierFroId", cellCarrierFroId);
        this.addObservers(27, context);
        this.lrsProxy.setDlBandwidth(0, this.getTxIdTransactional(context), cellCarrierFroId, checkedDlBandwidth);
        this.lrsProxy.setUlBandwidth(0, this.getTxIdTransactional(context), cellCarrierFroId, checkedUlBandwidth);
        this.lrsProxy.setDlFilterProfile(0, this.getTxIdTransactional(context), cellCarrierFroId, checkedDlFilterProfile);
        this.lrsProxy.setUlFilterProfile(0, this.getTxIdTransactional(context), cellCarrierFroId, checkedUlFilterProfile);
        if (attrList.indexOf("airRateTypeSelector") != -1) {
            int checkedAirRateTypeSelector = ValidateAttributes.checkAndGetIntAttribute(attrList, "airRateTypeSelector", "optional", 1, 0, 2, "Carrier");
            this.setAirRateTypeSelector(checkedAirRateTypeSelector, context);
        }
        if (attrList.indexOf("hsdpaMcActivityBufferThreshold") != -1) {
            int checkedHsdpaMcActivityBufferThreshold = ValidateAttributes.checkAndGetIntAttribute(attrList, "hsdpaMcActivityBufferThreshold", "optional", 2, HSDPA_MC_ACTIVITY_BUFFER_THRESHOLD_MIN_VALUES, HSDPA_MC_ACTIVITY_BUFFER_THRESHOLD_MAX_VALUES, "Carrier");
            this.setHsdpaMcActivityBufferThreshold(checkedHsdpaMcActivityBufferThreshold, context);
        }
        if (attrList.indexOf("hsdpaMcInactivityTimer") != -1) {
            int checkedHsdpaMcInActivityTimer = ValidateAttributes.checkAndGetIntAttribute(attrList, "hsdpaMcInactivityTimer", "optional", 2, HSDPA_MC_INACTIVITY_TIMER_MIN_VALUES, HSDPA_MC_INACTIVITY_TIMER_MAX_VALUES, "Carrier");
            this.setHsdpaMcInactivityTimer(checkedHsdpaMcInActivityTimer, context);
        }
        if (attrList.indexOf("chQualOffset") != -1) {
            int checkedChQualOffset = ValidateAttributes.checkAndGetIntAttribute(attrList, "chQualOffset", "optional", 14, CH_QUAL_OFFSET_MIN_VALUES, CH_QUAL_OFFSET_MAX_VALUES, "Carrier");
            this.setChQualOffset(checkedChQualOffset, context);
        }
        if (attrList.indexOf("cqiAdjustmentOn") != -1) {
            boolean checkedCqiAdjustmentOn = ValidateAttributes.checkAndGetBooleanAttribute(attrList, "cqiAdjustmentOn", "optional", false, false, true, "Carrier");
            this.setCqiAdjustmentOn(checkedCqiAdjustmentOn, context);
        }
        if (attrList.indexOf("cqiErrors") != -1) {
            int checkedCqiErrors = ValidateAttributes.checkAndGetIntAttribute(attrList, "cqiErrors", "optional", 10, CQI_ERRORS_MIN_VALUES, CQI_ERRORS_MAX_VALUES, "Carrier");
            this.setCqiErrors(checkedCqiErrors, context);
        }
        if (attrList.indexOf("cqiErrorsAbsent") != -1) {
            int checkedCqiErrorsAbsent = ValidateAttributes.checkAndGetIntAttribute(attrList, "cqiErrorsAbsent", "optional", 10, CQI_ERRORS_ABSENT_MIN_VALUES, CQI_ERRORS_ABSENT_MAX_VALUES, "Carrier");
            this.setCqiErrorsAbsent(checkedCqiErrorsAbsent, context);
        }
        if (attrList.indexOf("defaultCqiHsFach") != -1) {
            int checkedDefaultCqiHsFach = ValidateAttributes.checkAndGetIntAttribute(attrList, "defaultCqiHsFach", "optional", 1, DEFAULT_CQI_HS_FACH_MIN_VALUES, DEFAULT_CQI_HS_FACH_MAX_VALUES, "Carrier");
            this.setDefaultCqiHsFach(checkedDefaultCqiHsFach, context);
        }
        if (attrList.indexOf("extraCompEnhUeDrx") != -1) {
            int checkedExtraCompEnhUeDrx = ValidateAttributes.checkAndGetIntAttribute(attrList, "extraCompEnhUeDrx", "optional", 10, EXTRA_COMP_ENH_UE_DRX_MIN_VALUES, EXTRA_COMP_ENH_UE_DRX_MAX_VALUES, "Carrier");
            this.setExtraCompEnhUeDrx(checkedExtraCompEnhUeDrx, context);
        }
        if (attrList.indexOf("extraCompForSigHsFach") != -1) {
            checkedExtraCompForSigHsFach = ValidateAttributes.checkAndGetIntAttribute(attrList, "extraCompForSigHsFach", "optional", 10, EXTRA_COMP_FOR_SIG_HS_FACH_MIN_VALUES, EXTRA_COMP_FOR_SIG_HS_FACH_MAX_VALUES, "Carrier");
            this.setExtraCompForSigHsFach(checkedExtraCompForSigHsFach, context);
        }
        if (attrList.indexOf("extraCompForSigHsFach") != -1) {
            checkedExtraCompForSigHsFach = ValidateAttributes.checkAndGetIntAttribute(attrList, "extraCompForSigHsFach", "optional", 10, EXTRA_COMP_FOR_SIG_HS_FACH_MIN_VALUES, EXTRA_COMP_FOR_SIG_HS_FACH_MAX_VALUES, "Carrier");
            this.setExtraCompForSigHsFach(checkedExtraCompForSigHsFach, context);
        }
        if (attrList.indexOf("extraCompHsFach") != -1) {
            int checkedExtraCompHsFach = ValidateAttributes.checkAndGetIntAttribute(attrList, "extraCompHsFach", "optional", 40, EXTRA_COMP_HS_FACH_MIN_VALUES, EXTRA_COMP_HS_FACH_MAX_VALUES, "Carrier");
            this.setExtraCompHsFach(checkedExtraCompHsFach, context);
        }
        if (attrList.indexOf("extraHsScchCompEnhUeDrx") != -1) {
            int checkedExtraHsScchCompEnhUeDrx = ValidateAttributes.checkAndGetIntAttribute(attrList, "extraHsScchCompEnhUeDrx", "optional", 10, EXTRA_HS_SCCH_COMP_ENH_UE_DRX_MIN_VALUES, EXTRA_HS_SCCH_COMP_ENH_UE_DRX_MAX_VALUES, "Carrier");
            this.setExtraCompHsFach(checkedExtraHsScchCompEnhUeDrx, context);
        }
        if (attrList.indexOf("extraHsScchCompForSigHsFach") != -1) {
            int checkedExtraHsScchCompForSigHsFach = ValidateAttributes.checkAndGetIntAttribute(attrList, "extraHsScchCompForSigHsFach", "optional", 10, EXTRA_HS_SCCH_COMP_FOR_SIG_HS_FACH_MIN_VALUES, EXTRA_HS_SCCH_COMP_FOR_SIG_HS_FACH_MAX_VALUES, "Carrier");
            this.setExtraHsScchCompForSigHsFach(checkedExtraHsScchCompForSigHsFach, context);
        }
        if (attrList.indexOf("extraHsScchCompHsFach") != -1) {
            int checkedExtraHsScchCompHsFach = ValidateAttributes.checkAndGetIntAttribute(attrList, "extraHsScchCompHsFach", "optional", 40, EXTRA_HS_SCCH_COMP_HS_FACH_MIN_VALUES, EXTRA_HS_SCCH_COMP_HS_FACH_MAX_VALUES, "Carrier");
            this.setExtraCompHsFach(checkedExtraHsScchCompHsFach, context);
        }
        if (attrList.indexOf("extraHsScchPowerForSrbOnHsdpa") != -1) {
            int checkedExtraHsScchPowerForSrbOnHsdpa = ValidateAttributes.checkAndGetIntAttribute(attrList, "extraHsScchPowerForSrbOnHsdpa", "optional", 0, EXTRA_HS_SCCH_POWER_FOR_SRB_ON_HSDPA_MIN_VALUES, EXTRA_HS_SCCH_POWER_FOR_SRB_ON_HSDPA_MAX_VALUES, "Carrier");
            this.setExtraHsScchPowerForSrbOnHsdpa(checkedExtraHsScchPowerForSrbOnHsdpa, context);
        }
        if (attrList.indexOf("extraPowerForSrbOnHsdpa") != -1) {
            int checkedExtraPowerForOnHsdpa = ValidateAttributes.checkAndGetIntAttribute(attrList, "extraPowerForSrbOnHsdpa", "optional", 0, EXTRA_POWER_FOR_SRB_ON_HSDPA_MIN_VALUES, EXTRA_POWER_FOR_SRB_ON_HSDPA_MAX_VALUES, "Carrier");
            this.setExtraPowerForSrbOnHsdpa(checkedExtraPowerForOnHsdpa, context);
        }
        if (attrList.indexOf("hsPowerMargin") != -1) {
            int checkedHsPowerMargin = ValidateAttributes.checkAndGetIntAttribute(attrList, "hsPowerMargin", "optional", 2, HS_POWER_MARGIN_MIN_VALUES, HS_POWER_MARGIN_MAX_VALUES, "Carrier");
            this.setHsPowerMargin(checkedHsPowerMargin, context);
        }
        if (attrList.indexOf("hsScchMaxCodePower") != -1) {
            int checkedHsScchMaxCodePower = ValidateAttributes.checkAndGetIntAttribute(attrList, "hsScchMaxCodePower", "optional", -20, HS_SCCH_MAX_CODE_POWER_MIN_VALUES, HS_SCCH_MAX_CODE_POWER_MAX_VALUES, "Carrier");
            this.setHsScchMaxCodePower(checkedHsScchMaxCodePower, context);
        }
        if (attrList.indexOf("hsScchMinCodePower") != -1) {
            int checkedHsScchMinCodePower = ValidateAttributes.checkAndGetIntAttribute(attrList, "hsScchMinCodePower", "optional", -150, HS_SCCH_MIN_CODE_POWER_MIN_VALUES, HS_SCCH_MIN_CODE_POWER_MAX_VALUES, "Carrier");
            this.setHsScchMinCodePower(checkedHsScchMinCodePower, context);
        }
        if (attrList.indexOf("minBitRate") != -1) {
            int[] checkedMinBitRate = ValidateAttributes.checkAndGetIntSeqAttribute(attrList, "minBitRate", "optional", MIN_BIT_RATE_DEF_VALUE, MIN_BIT_RATE_MIN_VALUES, MIN_BIT_RATE_MAX_VALUES, 16, "Carrier");
            this.setMinBitRate(checkedMinBitRate, context);
        }
        if (attrList.indexOf("minBitRateMinCqi") != -1) {
            int checkedMinBitRateMinCqi = ValidateAttributes.checkAndGetIntAttribute(attrList, "minBitRateMinCqi", "optional", 8, MIN_BIT_RATE_MIN_CQI_MIN_VALUES, MIN_BIT_RATE_MIN_CQI_MAX_VALUES, "Carrier");
            this.setMinBitRateMinCqi(checkedMinBitRateMinCqi, context);
        }
        if (attrList.indexOf("qualityCheckPower") != -1) {
            int checkedQualityCheckPower = ValidateAttributes.checkAndGetIntAttribute(attrList, "qualityCheckPower", "optional", 0, QUALITY_CHECK_POWER_MIN_VALUES, QUALITY_CHECK_POWER_MAX_VALUES, "Carrier");
            this.setQualityCheckPower(checkedQualityCheckPower, context);
        }
        if (attrList.indexOf("queueSelectAlgorithm") != -1) {
            int checkedQueueSelectAlgorith = ValidateAttributes.checkAndGetIntAttribute(attrList, "queueSelectAlgorithm", "optional", 0, 0, 6, "Carrier");
            this.setQueueSelectAlgorithm(checkedQueueSelectAlgorith, context);
        }
        if (attrList.indexOf("schCongPeriodGbr") != -1) {
            int checkedSchCongPeriodGbr = ValidateAttributes.checkAndGetIntAttribute(attrList, "schCongPeriodGbr", "optional", 50, SCH_CONG_PERIOD_GBR_MIN_VALUES, SCH_CONG_PERIOD_GBR_MAX_VALUES, "Carrier");
            this.setSchCongPeriodGbr(checkedSchCongPeriodGbr, context);
        }
        if (attrList.indexOf("schCongThreshGbr") != -1) {
            int checkedSchCongThreshGbr = ValidateAttributes.checkAndGetIntAttribute(attrList, "schCongThreshGbr", "optional", 5, SCH_CONG_THRESH_GBR_MIN_VALUES, SCH_CONG_THRESH_GBR_MAX_VALUES, "Carrier");
            this.setSchCongPeriodGbr(checkedSchCongThreshGbr, context);
        }
        if (attrList.indexOf("schCongThreshNonGbr") != -1) {
            int checkedSchCongThreshNonGbr = ValidateAttributes.checkAndGetIntAttribute(attrList, "schCongThreshNonGbr", "optional", 2, SCH_CONG_THRESH_NON_GBR_MIN_VALUES, SCH_CONG_THRESH_NON_GBR_MAX_VALUES, "Carrier");
            this.setSchCongThreshNonGbr(checkedSchCongThreshNonGbr, context);
        }
        if (attrList.indexOf("schMaxDelay") != -1) {
            int[] checkedSchMaxDelay = ValidateAttributes.checkAndGetIntSeqAttribute(attrList, "schMaxDelay", "optional", SCH_MAX_DELAY_DEF_VALUE, SCH_MAX_DELAY_MIN_VALUES, SCH_MAX_DELAY_MAX_VALUES, 16, "Carrier");
            this.setSchMaxDelay(checkedSchMaxDelay, context);
        }
        if (attrList.indexOf("schWeight") != -1) {
            int[] checkedSchWeight = ValidateAttributes.checkAndGetIntSeqAttribute(attrList, "schWeight", "optional", SCH_WEIGHT_DEF_VALUE, SCH_WEIGHT_MIN_VALUES, SCH_WEIGHT_MAX_VALUES, 16, "Carrier");
            this.setSchWeight(checkedSchWeight, context);
        }
        if (attrList.indexOf("throughputPqxHsFach") != -1) {
            int[] checkedThroughputPqxHsFach = ValidateAttributes.checkAndGetIntSeqAttribute(attrList, "throughputPqxHsFach", "optional", THROUGHPUT_PQX_HS_FACH_DEF_VALUE, THROUGHPUT_PQX_HS_FACH_MIN_VALUES, THROUGHPUT_PQX_HS_FACH_MAX_VALUES, 15, "Carrier");
            this.setThroughputPqxHsFach(checkedThroughputPqxHsFach, context);
        }
        if (attrList.indexOf("schMinPowerNonGbrHsUsers") != -1) {
            int checkedSchMinPowerNonGbrHsUsers = ValidateAttributes.checkAndGetIntAttribute(attrList, "schMinPowerNonGbrHsUsers", "optional", 0, SCH_MIN_POWER_NON_GBR_HS_USERS_MIN_VALUES, SCH_MIN_POWER_NON_GBR_HS_USERS_MAX_VALUES, "Carrier");
            this.setSchMinPowerNonGbrHsUsers(checkedSchMinPowerNonGbrHsUsers, context);
        }
        if (attrList.indexOf("schNoCongPeriodGbr") != -1) {
            int checkedSchNoCongPeriodGbr = ValidateAttributes.checkAndGetIntAttribute(attrList, "schNoCongPeriodGbr", "optional", 25, SCH_NO_CONG_PERIOD_GBR_MIN_VALUES, SCH_NO_CONG_PERIOD_GBR_MAX_VALUES, "Carrier");
            this.setSchNoCongPeriodGbr(checkedSchNoCongPeriodGbr, context);
        }
        if (attrList.indexOf("schNoCongThreshGbr") != -1) {
            int checkedSchNoCongThreshGbr = ValidateAttributes.checkAndGetIntAttribute(attrList, "schNoCongThreshGbr", "optional", 15, SCH_NO_CONG_THRESH_GBR_MIN_VALUES, SCH_NO_CONG_THRESH_GBR_MAX_VALUES, "Carrier");
            this.setSchNoCongThreshGbr(checkedSchNoCongThreshGbr, context);
        }
        if (attrList.indexOf("schPowerDeltaCongGbr") != -1) {
            int checkedSchPowerDeltaCongGbr = ValidateAttributes.checkAndGetIntAttribute(attrList, "schPowerDeltaCongGbr", "optional", 15, SCH_POWER_DELTA_CONG_GBR_MIN_VALUES, SCH_POWER_DELTA_CONG_GBR_MAX_VALUES, "Carrier");
            this.setSchPowerDeltaCongGbr(checkedSchPowerDeltaCongGbr, context);
        }
        if (attrList.indexOf("schPrioForAbsResSharing") != -1) {
            int checkedSchPrioForAbsResSharing = ValidateAttributes.checkAndGetIntAttribute(attrList, "schPrioForAbsResSharing", "optional", 15, SCH_PRIO_FOR_ABS_RES_SHARING_MIN_VALUES, SCH_PRIO_FOR_ABS_RES_SHARING_MAX_VALUES, "Carrier");
            this.setSchPrioForAbsResSharing(checkedSchPrioForAbsResSharing, context);
        }
        ValidateAttributes.checkOtherAttributes(attrList, "Carrier");
        int eulNoiseFloorLockValue = ValidateAttributes.intValue(false);
        int eulOptimalNoiseFloorEstimateValue = -1040;
        if (checkedEulOptimalNoiseFloorLock != null && checkedEulOptimalNoiseFloorLock.size() != 0) {
            try {
                eulNoiseFloorLockValue = (Boolean)checkedEulOptimalNoiseFloorLock.getValue("eulNoiseFloorLock") != false ? 1 : 0;
                eulOptimalNoiseFloorEstimateValue = (Integer)checkedEulOptimalNoiseFloorLock.getValue("eulOptimalNoiseFloorEstimate");
                ValidateAttributes.intValueRangeCheck("eulOptimalNoiseFloorEstimate", eulOptimalNoiseFloorEstimateValue, CarrierMo.EUL_OPTIMAL_NOISE_FLOOR_LOCK__EUL_OPTIMAL_NOISE_FLOOR_ESTIMATE_MIN_VALUES, CarrierMo.EUL_OPTIMAL_NOISE_FLOOR_LOCK__EUL_OPTIMAL_NOISE_FLOOR_ESTIMATE_MAX_VALUES, "Carrier");
            }
            catch (MoAccessException e) {
                // empty catch block
            }
        }
        ChcEulSettableCarrierParamsT[] carrierParams = new ChcEulSettableCarrierParamsT[]{new ChcEulSettableCarrierParamsT(1, checkedEulMaxOwnUuLoad), new ChcEulSettableCarrierParamsT(0, checkedEulMaxRotCoverage), new ChcEulSettableCarrierParamsT(3, eulNoiseFloorLockValue), new ChcEulSettableCarrierParamsT(4, eulOptimalNoiseFloorEstimateValue), new ChcEulSettableCarrierParamsT(5, checkedEulThermalLevelPrior), new ChcEulSettableCarrierParamsT(7, checkedFccRotMarginHigh), new ChcEulSettableCarrierParamsT(6, checkedFccRotMarginLow), new ChcEulSettableCarrierParamsT(2, checkedEulSlidingWindowTime)};
        this.chcEulProxy.setEulCarrierParameters(ValidateAttributes.getTxIdTransactional(context), 0, cellCarrierFroId, carrierParams.length, carrierParams);
        if (sector.isSectorInitialized(context)) {
            EqcAddSectorCarrierRspS eqcAddRsp = this.eqcAddCarrier(sectorFroId, lrsCreateRsp.frequencyPlane, context);
            LrsRfapAddCarrierRspS rspSig = this.lrsAddCarrier(rfapFroId, cellCarrierFroId, eqcAddRsp.aiReallocation, context);
            this.setupDevices(new int[]{rspSig.dpclDevFroId}, "dpclDevicesRef", "DpclDevice", context);
            this.setupDevices(new int[]{rspSig.tpaDevFroId}, "tpaDeviceRef", "TpaDevice", context);
            int[] newDbccFroIds = new int[rspSig.noOfDbccDev];
            for (int i = 0; i < newDbccFroIds.length; ++i) {
                newDbccFroIds[i] = rspSig.dbccDevFroIds[i];
            }
            this.setupDevices(newDbccFroIds, "dbccDeviceRef", "DbccDevice", context);
            this.setupDevices(rspSig.trDevFroIds, "trDeviceRef", "TrDevice", context);
            if (eqcAddRsp.aiReallocation == 1) {
                this.upDateAiDevAllocation4AllCarrierMos(rspSig, cellCarrierFroId, context);
            } else {
                int[] aiDevices = this.getDeviceFroIds(rspSig.ai, rspSig.noOfAiDev, context);
                this.setupDevices(aiDevices, "aiDeviceRef", "AiDevice", context);
            }
        }
        this.createRadioLinksMoImpl(context);
        this.sccScanner = new MoScanner(this, this.lrsProxy, cellCarrierFroId, 0, CarrierMoFactory.instance().getSccCounters(), null, false, context);
        this.chcScanner = new MoScanner(this, this.chcMeasurementProxy, cellCarrierFroId, 0, CarrierMoFactory.instance().getChcCounters(), null, false, context);
        MessageLog.trace(1, this.getClass(), "MO is Created");
    }

    public CarrierMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
        this.myData.registerTransientAttr((Attribute)new ReferenceAttribute(PCPICH_REF, false));
        this.myData.registerTransientAttr((Attribute)new ReferenceAttribute(SCPICH_REF, false));
        this.myData.registerTransientAttr((Attribute)new ReferenceAttribute(PSCH_REF, false));
        this.myData.registerTransientAttr((Attribute)new ReferenceAttribute(SSCH_REF, false));
        this.checkAttributeExists(recoveredData, "tpaDeviceRef");
        this.checkAttributeExists(recoveredData, "aiDeviceRef");
        this.checkAttributeExists(recoveredData, "dbccDeviceRef");
        this.checkAttributeExists(recoveredData, "trDeviceRef");
        this.checkAttributeExists(recoveredData, "dpclDevicesRef");
        try {
            this.addObservers(27, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        this.sccScanner = this.createMoScanner(this.lrsProxy, CarrierMoFactory.instance().getSccCounters());
        this.chcScanner = this.createMoScanner(this.chcMeasurementProxy, CarrierMoFactory.instance().getChcCounters());
        MessageLog.trace(1, this.getClass(), "Version Attribute in MoData = " + this.myData.getRevision());
        MessageLog.trace(1, this.getClass(), "Carrier MO is recovered ");
    }

    private void checkAttributeExists(MoData recoveredData, String attrName) {
        if ((SequenceAttribute)recoveredData.getAttribute(attrName) == null) {
            MessageLog.traceError(this.getClass(), "Recovered attribute " + attrName + " is null");
        }
    }

    private MoScanner createMoScanner(ProxyScanner proxy, List counters) {
        try {
            return new MoScanner(this, proxy, this.getCellCarrierFroId(null), 0, counters, null, true, null);
        }
        catch (Exception pmse) {
            MessageLog.traceError(this.getClass(), "could not create MoScanner: " + pmse);
            return null;
        }
    }

    public static synchronized ManagedObject create(ManagedObject parent, String motypeName, String identity, Coordinator context, AttrList attributes, ManagedObject source) throws MoAccessException {
        MessageLog.traceEnter(CarrierMoImpl.class, "create()<---");
        ValidateAttributes.checkTransaction(context);
        ValidateAttributes.checkParent(parent, PARENT_TYPE);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "Carrier");
        boolean FREQUENCY_PLANE_DEF_VALUE = false;
        int oldSize = CarrierMo.FREQUENCY_PLANE_MIN_VALUES.length;
        int[] FREQUENCY_PLANE_MIN_VALUES = new int[oldSize + 1];
        int[] FREQUENCY_PLANE_MAX_VALUES = new int[oldSize + 1];
        for (int i = 0; i < oldSize; ++i) {
            FREQUENCY_PLANE_MIN_VALUES[i] = CarrierMo.FREQUENCY_PLANE_MIN_VALUES[i];
            FREQUENCY_PLANE_MAX_VALUES[i] = CarrierMo.FREQUENCY_PLANE_MAX_VALUES[i];
        }
        FREQUENCY_PLANE_MIN_VALUES[oldSize] = 0;
        FREQUENCY_PLANE_MAX_VALUES[oldSize] = 0;
        int checkedFrequencyPlane = ValidateAttributes.checkAndGetIntAttribute(attributes, "frequencyPlane", "optional", 0, FREQUENCY_PLANE_MIN_VALUES, FREQUENCY_PLANE_MAX_VALUES, "Carrier");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "Carrier");
        int checkedTxGainCalType = ValidateAttributes.checkAndGetIntAttribute(attributes, "txGainCalType", "optional", 1, 0, 1, "Carrier");
        int checkedTxGainCalValue = ValidateAttributes.checkAndGetIntAttribute(attributes, "txGainCalValue", "optional", 0, CarrierMo.TX_GAIN_CAL_VALUE_MIN_VALUES, CarrierMo.TX_GAIN_CAL_VALUE_MAX_VALUES, "Carrier");
        int checkedNumberOfTxBranches = ValidateAttributes.checkAndGetIntAttribute(attributes, "numberOfTxBranches", "optional", 1, CarrierMo.NUMBER_OF_TX_BRANCHES_MIN_VALUES, CarrierMo.NUMBER_OF_TX_BRANCHES_MAX_VALUES, "Carrier");
        int checkedNumberOfRxBranches = ValidateAttributes.checkAndGetIntAttribute(attributes, "numberOfRxBranches", "optional", 2, CarrierMo.NUMBER_OF_RX_BRANCHES_MIN_VALUES, CarrierMo.NUMBER_OF_RX_BRANCHES_MAX_VALUES, "Carrier");
        int checkedDlBandwidth = ValidateAttributes.checkAndGetIntAttribute(attributes, "dlBandwidth", "optional", 50, CarrierMo.DL_BANDWIDTH_MIN_VALUES, CarrierMo.DL_BANDWIDTH_MAX_VALUES, "Carrier");
        int checkedUlBandwidth = ValidateAttributes.checkAndGetIntAttribute(attributes, "ulBandwidth", "optional", 50, CarrierMo.UL_BANDWIDTH_MIN_VALUES, CarrierMo.UL_BANDWIDTH_MAX_VALUES, "Carrier");
        int checkedDlFilterProfile = ValidateAttributes.checkAndGetIntAttribute(attributes, "dlFilterProfile", "optional", 0, 0, 1, "Carrier");
        int checkedUlFilterProfile = ValidateAttributes.checkAndGetIntAttribute(attributes, "ulFilterProfile", "optional", 0, 0, 1, "Carrier");
        ManagedObject checkedDownlinkBaseBandPoolRef = ValidateAttributes.checkAndGetReferenceAttribute("downlinkBaseBandPoolRef", attributes, "optional", new String[]{"DownlinkBaseBandPool"}, "Carrier");
        int checkedTxBranchConfigured = ValidateAttributes.checkAndGetIntAttribute(attributes, "txBranchConfigured", "optional", 0, 0, 6, "Carrier");
        int[] checkedTxBranchesConfigured = ValidateAttributes.checkAndGetIntSeqAttribute(attributes, "txBranchesConfigured", "optional", CarrierMo.TX_BRANCHES_CONFIGURED_DEF_VALUE, 0, 6, 2, "Carrier");
        int checkedCellRange = ValidateAttributes.checkAndGetIntAttribute(attributes, "cellRange", "optional", 35000, CarrierMo.CELL_RANGE_MIN_VALUES, CarrierMo.CELL_RANGE_MAX_VALUES, "Carrier");
        int checkedEulMaxOwnUuLoad = ValidateAttributes.checkAndGetIntAttribute(attributes, "eulMaxOwnUuLoad", "optional", 100, CarrierMo.EUL_MAX_OWN_UU_LOAD_MIN_VALUES, CarrierMo.EUL_MAX_OWN_UU_LOAD_MAX_VALUES, "Carrier");
        int checkedEulMaxRotCoverage = ValidateAttributes.checkAndGetIntAttribute(attributes, "eulMaxRotCoverage", "optional", 100, CarrierMo.EUL_MAX_ROT_COVERAGE_MIN_VALUES, CarrierMo.EUL_MAX_ROT_COVERAGE_MAX_VALUES, "Carrier");
        Struct checkedEulOptimalNoiseFloorLock = ValidateAttributes.checkAndGetStructAttribute(attributes, "eulOptimalNoiseFloorLock", "optional", "Carrier");
        int checkedEulSlidingWindowTime = ValidateAttributes.checkAndGetIntAttribute(attributes, "eulSlidingWindowTime", "optional", 72000, CarrierMo.EUL_SLIDING_WINDOW_TIME_MIN_VALUES, CarrierMo.EUL_SLIDING_WINDOW_TIME_MAX_VALUES, "Carrier");
        if (!CarrierMoImpl.intResolutionValueRangeCheck(checkedEulSlidingWindowTime, 10, 10, 864000)) {
            throw new ValueOutOfRangeException("eulSlidingWindowTime", "Carrier");
        }
        int checkedEulThermalLevelPrior = ValidateAttributes.checkAndGetIntAttribute(attributes, "eulThermalLevelPrior", "optional", -1040, CarrierMo.EUL_THERMAL_LEVEL_PRIOR_MIN_VALUES, CarrierMo.EUL_THERMAL_LEVEL_PRIOR_MAX_VALUES, "Carrier");
        int checkedFccRotMarginHigh = ValidateAttributes.checkAndGetIntAttribute(attributes, "fccRotMarginHigh", "optional", 40, CarrierMo.FCC_ROT_MARGIN_HIGH_MIN_VALUES, CarrierMo.FCC_ROT_MARGIN_HIGH_MAX_VALUES, "Carrier");
        int checkedFccRotMarginLow = ValidateAttributes.checkAndGetIntAttribute(attributes, "fccRotMarginLow", "optional", 25, CarrierMo.FCC_ROT_MARGIN_LOW_MIN_VALUES, CarrierMo.FCC_ROT_MARGIN_LOW_MAX_VALUES, "Carrier");
        CarrierMoImpl createdMo = new CarrierMoImpl(parent, motypeName, identity, context, checkedUserLabel, checkedFrequencyPlane, checkedAlarmStatus, checkedTxGainCalType, checkedTxGainCalValue, checkedNumberOfTxBranches, checkedNumberOfRxBranches, checkedDlBandwidth, checkedUlBandwidth, checkedDlFilterProfile, checkedUlFilterProfile, checkedDownlinkBaseBandPoolRef, checkedTxBranchConfigured, checkedTxBranchesConfigured, checkedCellRange, checkedEulMaxOwnUuLoad, checkedEulMaxRotCoverage, checkedEulOptimalNoiseFloorLock, checkedEulSlidingWindowTime, checkedEulThermalLevelPrior, checkedFccRotMarginHigh, checkedFccRotMarginLow, attributes);
        return createdMo;
    }

    public void delete(Coordinator context) throws MoAccessException, MoRemovedException, UndeletableMoException {
        ManagedObject radioLinksRef;
        MessageLog.traceEnter(this.getClass(), "delete()");
        if (this.isReserved(context)) {
            MessageLog.trace(1, this.getClass(), "This MO is reserved and can not be deleted.");
            throw new UndeletableMoException((ManagedObject)this);
        }
        SectorMo sector = (SectorMo)this.getParent();
        if (sector.isSectorInitialized(context)) {
            MessageLog.trace(1, this.getClass(), "This MO has a parent Sector that is initialized and thus cannot be deleted.");
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ManagedObject syncChRef = this.getPcpichRef(context);
        if (syncChRef != null) {
            ((PcpichMo)syncChRef).delete(context);
        }
        if ((syncChRef = this.getPschRef(context)) != null) {
            ((PschMo)syncChRef).delete(context);
        }
        if ((syncChRef = this.getSschRef(context)) != null) {
            ((SschMo)syncChRef).delete(context);
        }
        if ((radioLinksRef = this.getRadioLinksRef(context)) != null) {
            ((RadioLinksMo)radioLinksRef).delete(context, this.getType());
        }
        if (this.sccScanner != null) {
            this.sccScanner.delete(context);
        }
        if (this.chcScanner != null) {
            this.chcScanner.delete(context);
        }
        this.lrsDeleteCarrier(context);
        HsDschResourcesMoImpl hsDschDeResMo = this.getHsDschResMoIfIsInPlace(context);
        if (hsDschDeResMo != null) {
            hsDschDeResMo.sysDelete(context);
        }
        this.removeObservers(context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), "Mo is Deleted");
    }

    private HsDschResourcesMoImpl getHsDschResMoIfIsInPlace(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getHsDschResMoIfIsInPlace()");
        HsDschResourcesMoImpl result2 = null;
        MoIterator iter = this.getChildren();
        while (iter.hasMoreElements()) {
            Object child = iter.nextElement();
            if (!(child instanceof HsDschResourcesMoImpl)) continue;
            result2 = (HsDschResourcesMoImpl)child;
        }
        return result2;
    }

    public void actionTurnAveragePowLimOff(Coordinator context) throws MoAccessException, NotActiveException, NotInitiatedException, InternalErrorException, DeviceDisabledException {
        MessageLog.traceEnter(this.getClass(), "actionTurnAveragePowLimOff()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        try {
            this.scRfAccessCarrierProxy.avpowerOff(0, this.getRfAccessPointFroId(context), this.getCellCarrierFroId(context));
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 24) {
                throw new NotActiveException();
            }
            if (e.getOrgErrorCode() == 22) {
                throw new NotInitiatedException();
            }
            if (e.getOrgErrorCode() == 26) {
                throw new DeviceDisabledException();
            }
            if (e.getOrgErrorCode() == 11) {
                throw new InternalErrorException();
            }
            throw e;
        }
    }

    public void actionTurnAveragePowLimOn(Coordinator context) throws MoAccessException, InternalErrorException, AlreadyActiveException {
        MessageLog.traceEnter(this.getClass(), "actionTurnAveragePowLimOn()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        try {
            this.scRfAccessCarrierProxy.avpowerOn(0, this.getRfAccessPointFroId(context), this.getCellCarrierFroId(context));
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 25) {
                throw new AlreadyActiveException();
            }
            if (e.getOrgErrorCode() == 11) {
                throw new InternalErrorException();
            }
            throw e;
        }
    }

    public Struct actionPerformRfPowMeas(Coordinator context) throws InternalErrorException, MoAccessException {
        LrsStartFmPowMeasRspS rspSig;
        MessageLog.traceEnter(this.getClass(), "actionPerformRfPowMeas(): Start");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ManagedObject sector = this.getParent();
        int rfapFroId = ((SectorMoAdditional)sector).getRfAccessPointFroId(context);
        int frequencyPlane = this.getFrequencyPlane(context);
        try {
            rspSig = this.scRfAccessCarrierProxy.rfPowMeas(0, rfapFroId, frequencyPlane);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 22) {
                throw new NotInitiatedException();
            }
            if (e.getOrgErrorCode() == 23) {
                throw new CellNotSetupException();
            }
            if (e.getOrgErrorCode() == 11) {
                throw new InternalErrorException();
            }
            throw e;
        }
        return this.convertRfPowSigToStruct(rspSig);
    }

    public Struct actionReadNbapData(Coordinator context) throws MoAccessException, CellNotSetupException {
        MessageLog.traceEnter(this.getClass(), "actionReadNbapData()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        int cellCarrierFroId = this.getCellCarrierFroId(context);
        try {
            LrsCarrierNbapGetParamRspS rspSig = this.lrsProxy.carrierNbapGetParam(0, this.getTxIdNonTransactional(context), cellCarrierFroId);
            return this.convertSigToStruct(rspSig);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 12) {
                throw new CellNotSetupException();
            }
            throw e;
        }
    }

    public void actionStartNonModulated(int txPower, Coordinator context) throws MoAccessException, InternalErrorException, CellNotSetupException, AlreadyActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStartNonModulated(): Start");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("nonModCarrierPower", txPower, NON_MOD_CARRIER_POWER_MIN_VALUES, NON_MOD_CARRIER_POWER_MAX_VALUES, "Carrier");
        int cellCarrierFroId = this.getCellCarrierFroId(context);
        try {
            this.lrsProxy.startNonmodCarrier(0, cellCarrierFroId, txPower);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new MoDisabledException();
            }
            if (e.getOrgErrorCode() == 4) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 12) {
                throw new CellNotSetupException();
            }
            if (e.getOrgErrorCode() == 8) {
                throw new AlreadyActiveException();
            }
            throw e;
        }
        MessageLog.trace(2, this.getClass(), "actionStartNonModulated(): End");
    }

    public void actionStopNonModulated(Coordinator context) throws MoAccessException, InternalErrorException, NotActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStopNonModulated(): Start");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        int cellCarrierFroId = this.getCellCarrierFroId(context);
        try {
            this.lrsProxy.stopNonmodCarrier(0, cellCarrierFroId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 4) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 9) {
                throw new NotActiveException();
            }
            throw e;
        }
        MessageLog.trace(2, this.getClass(), "actionStopNonModulated(): End");
    }

    public int getCellCarrierFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCellCarrierFroId()");
        return this.bcmGetIntAttribute("cellCarrierFroId", context);
    }

    public boolean getAveragePowLimSwitchOn(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAveragePowLimSwitchOn()");
        LrsRfapGetAvpowerRspS rspSig = this.scRfAccessCarrierProxy.getPowLimSwitchOn(0, this.getRfAccessPointFroId(null), this.getCellCarrierFroId(null));
        switch (rspSig.avPowerLimiterStatus) {
            case 0: {
                MessageLog.trace(2, this.getClass(), "Not on!");
                return false;
            }
            case 1: {
                MessageLog.trace(2, this.getClass(), "On!");
                return true;
            }
        }
        MessageLog.trace(2, this.getClass(), "Wrong value from ro!");
        return true;
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public int getOperationalState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        int operationalState = this.getCarrierAttribute(context, "operationalState");
        return operationalState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        int availabilityStatus = this.getCarrierAttribute(context, "availabilityStatus");
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(availabilityStatus);
    }

    public int getFrequencyPlane(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFrequencyPlane()");
        int frequencyPlane = this.getCarrierAttribute(context, "frequencyPlane");
        return frequencyPlane;
    }

    public int getNonModCarrierIsActive(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNonModCarrierIsActive()");
        int nonModCarrierIsActive = this.getCarrierAttribute(context, "nonModCarrierIsActive");
        return nonModCarrierIsActive;
    }

    public int getNonModCarrierPower(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNonModCarrierPower()");
        int nonModCarrierPower = this.getCarrierAttribute(context, "nonModCarrierPower");
        return nonModCarrierPower;
    }

    public ManagedObject[] getTrDeviceRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTrDeviceRef() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        SequenceAttribute deviceRefAttrList = (SequenceAttribute)this.myData.getAttribute("trDeviceRef");
        return this.getMoRefArr(deviceRefAttrList, context);
    }

    public ManagedObject[] getDbccDeviceRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDbccDeviceRef() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        SequenceAttribute deviceRefAttrList = (SequenceAttribute)this.myData.getAttribute("dbccDeviceRef");
        return this.getMoRefArr(deviceRefAttrList, context);
    }

    public ManagedObject[] getTpaDeviceRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTpaDeviceRef() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        SequenceAttribute tpaDeviceRefAttrList = (SequenceAttribute)this.myData.getAttribute("tpaDeviceRef");
        return this.getMoRefArr(tpaDeviceRefAttrList, context);
    }

    public int getTxBranchConfigured(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTxBranchConfigured");
        int tempTxBranchConfigured = this.getCarrierAttribute(context, "txBranchConfigured");
        return tempTxBranchConfigured + 1;
    }

    public ManagedObject[] getAiDeviceRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAiDeviceRef() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        SequenceAttribute aiDeviceRefAttrList = (SequenceAttribute)this.myData.getAttribute("aiDeviceRef");
        return this.getMoRefArr(aiDeviceRefAttrList, context);
    }

    public int getTxGainCalType(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTxGainCalType()");
        return this.getCarrierAttribute(context, "txGainCalType");
    }

    public int getTxGainCalValue(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTxGainCalValue()");
        return this.getCarrierAttribute(context, "txGainCalValue");
    }

    public int getSchIsActive(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSchIsActive()");
        return this.getCellAttribute(context, SCH_IS_ACTIVE);
    }

    public int getCpichIsActive(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCpichIsActive()");
        return this.getCellAttribute(context, CPICH_IS_ACTIVE);
    }

    private RadioLinksMo createRadioLinksMoImpl(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createRadioLinksMoImpl()");
        RadioLinksMoFactory factoryRef = RadioLinksMoFactory.instance();
        try {
            RadioLinksMoImpl radioLinksRef = (RadioLinksMoImpl)factoryRef.createMo(this, null, "1", null, context);
            MessageLog.trace(1, this.getClass(), "RadioLinks is created ");
            return radioLinksRef;
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Initiation of RadioLinksMoImpl failed");
            throw e;
        }
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData() ");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent() ");
        return true;
    }

    public String getType() {
        return CarrierMoFactory.instance().getMoTypeName();
    }

    private int getRfAccessPointFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRfAccessPointFroId()");
        SectorMo sector = (SectorMo)this.getParent();
        int rfapFroId = sector.getRfAccessPointFroId(context);
        return rfapFroId;
    }

    private LrsCreateCellCarrierRspS createRo(int frequencyPlane, int sectorFroId, int rfapFroId, int txGainCalType, int txGainCalValue, int numberOfTxBranches, int numberOfRxBranches, int bbPoolIdRef, int txBranchConfigured, int[] txBranchesConfigured, int cellRange, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createRo()");
        LrsCreateCellCarrierRspS rspSig = this.lrsProxy.createCellCarrier(this.getTxIdTransactional(context), 0, frequencyPlane, sectorFroId, rfapFroId, txGainCalType, txGainCalValue, numberOfTxBranches, numberOfRxBranches, bbPoolIdRef, txBranchConfigured, txBranchesConfigured, cellRange, this.getRelativeDistinguishedName());
        MessageLog.trace(1, this.getClass(), " RO is created ");
        return rspSig;
    }

    private void lrsDeleteCarrier(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "lrsDeleteCarrier()");
        int cellCarrierFroId = this.getCellCarrierFroId(context);
        this.lrsProxy.deleteCellCarrier(this.getTxIdTransactional(context), 0, cellCarrierFroId);
        MessageLog.trace(1, this.getClass(), " RO is deleted ");
    }

    private EqcAddSectorCarrierRspS eqcAddCarrier(int sectorFroId, int frequencyPlane, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "eqcAddCarrier()");
        return this.eqcSectorProxy.addSectorCarrier(this.getTxIdTransactional(context), 0, sectorFroId, frequencyPlane);
    }

    private LrsRfapAddCarrierRspS lrsAddCarrier(int rfapFroId, int cellCarrierFroId, int aiReallocation, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "lrsAddCarrier()");
        LrsRfapAddCarrierRspS rspSig = this.scRfAccessCarrierProxy.rfapAddCarrier(this.getTxIdTransactional(context), 0, rfapFroId, cellCarrierFroId, aiReallocation);
        return rspSig;
    }

    private ManagedObject getPcpichRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPcpichRef()");
        return this.bcmGetReferenceAttribute(PCPICH_REF, context);
    }

    private ManagedObject getPschRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPschRef()");
        return this.bcmGetReferenceAttribute(PSCH_REF, context);
    }

    private ManagedObject getSschRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSschRef()");
        return this.bcmGetReferenceAttribute(SSCH_REF, context);
    }

    private ManagedObject getRadioLinksRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRadioLinksRef()");
        MoIterator iter = this.getChildren();
        while (iter.hasMoreElements()) {
            ManagedObject child = iter.nextMo();
            if (!(child instanceof RadioLinksMo)) continue;
            return child;
        }
        return null;
    }

    private Struct convertSigToStruct(LrsCarrierNbapGetParamRspS rspSig) throws MoAccessException {
        String[] names = new String[]{"primaryScramblingCode", UARFCN_NU, UARFCN_ND};
        Object[] values = new Object[3];
        Integer primaryScramblingCode = new Integer(rspSig.primaryScramblingCode);
        Integer uarfcnNu = new Integer(rspSig.uarfcnNu);
        Integer uarfcnNd = new Integer(rspSig.uarfcnNd);
        values[0] = primaryScramblingCode;
        values[1] = uarfcnNu;
        values[2] = uarfcnNd;
        StructImpl status = new StructImpl(names, values);
        return status;
    }

    private Struct convertRfPowSigToStruct(LrsStartFmPowMeasRspS rspSig) throws MoAccessException {
        String[] names = new String[]{"rfPowerBranchA", "rfPowerBranchB", "rfPowerBranchC", "rfPowerBranchD"};
        Object[] values = new Object[4];
        Integer rfPowerBranchA = new Integer(rspSig.fmPowerAntennaBranchA);
        Integer rfPowerBranchB = new Integer(rspSig.fmPowerAntennaBranchB);
        Integer rfPowerBranchC = new Integer(rspSig.fmPowerAntennaBranchC);
        Integer rfPowerBranchD = new Integer(rspSig.fmPowerAntennaBranchD);
        values[0] = rfPowerBranchA;
        values[1] = rfPowerBranchB;
        values[2] = rfPowerBranchC;
        values[3] = rfPowerBranchD;
        return new StructImpl(names, values);
    }

    private Struct convertCcTrtxBbPowSigToStruct(LrsCcTrtxBbPowRspS rspSig) throws MoAccessException {
        String[] names = new String[]{"bbPowerBranchA", "bbPowerBranchB", "bbPowerBranchC", "bbPowerBranchD"};
        Object[] values = new Object[4];
        Integer bbPowerBranchA = new Integer(rspSig.measPowerAntennaBranchA);
        Integer bbPowerBranchB = new Integer(rspSig.measPowerAntennaBranchB);
        Integer bbPowerBranchC = new Integer(rspSig.measPowerAntennaBranchC);
        Integer bbPowerBranchD = new Integer(rspSig.measPowerAntennaBranchD);
        values[0] = bbPowerBranchA;
        values[1] = bbPowerBranchB;
        values[2] = bbPowerBranchC;
        values[3] = bbPowerBranchD;
        return new StructImpl(names, values);
    }

    private int getCarrierAttribute(Coordinator context, String attributeName) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCarrierAttribute()");
        int cellCarrierFroId = this.getCellCarrierFroId(context);
        int attValue = 0;
        LrsCarrierGetParamRspS rspSig = this.lrsProxy.carrierGetParam(0, this.getTxIdNonTransactional(context), cellCarrierFroId);
        if (attributeName.equals("operationalState")) {
            attValue = rspSig.operationalState;
        } else if (attributeName.equals("availabilityStatus")) {
            attValue = rspSig.availStatus;
        } else if (attributeName.equals("frequencyPlane")) {
            attValue = rspSig.frequencyPlane;
        } else if (attributeName.equals("nonModCarrierIsActive")) {
            attValue = rspSig.nonModulatedCarrier;
        } else if (attributeName.equals("nonModCarrierPower")) {
            attValue = rspSig.txPower;
        } else if (attributeName.equals("txGainCalType")) {
            attValue = rspSig.txGainCalType;
        } else if (attributeName.equals("txGainCalValue")) {
            attValue = rspSig.txGainCalValue;
        } else if (attributeName.equals("numberOfTxBranches")) {
            attValue = rspSig.numberOfTxBranches;
        } else if (attributeName.equals("dlBandwidth")) {
            attValue = rspSig.dlBandwidth;
        } else if (attributeName.equals("ulBandwidth")) {
            attValue = rspSig.ulBandwidth;
        } else if (attributeName.equals("dlFilterProfile")) {
            attValue = rspSig.dlFilterProfile;
        } else if (attributeName.equals("ulFilterProfile")) {
            attValue = rspSig.ulFilterProfile;
        } else if (attributeName.equals("numberOfRxBranches")) {
            attValue = rspSig.numberOfRxBranches;
        } else if (attributeName.equals("txBranchConfigured")) {
            attValue = rspSig.txBranchConfigured;
        } else if (attributeName.equals("maxDlPowerCapability")) {
            attValue = rspSig.maxDlPowerCapability;
        } else if (attributeName.equals("minDlPowerCapability")) {
            attValue = rspSig.minDlPowerCapability;
        } else if (attributeName.equals("cellRange")) {
            attValue = rspSig.cellRange;
        } else if (attributeName.equals("periodDtxHsOlpc")) {
            attValue = rspSig.periodDtxHsOlpc;
        } else if (attributeName.equals("numOfDtxHsOlpc")) {
            attValue = rspSig.numOfDtxHsOlpc;
        } else if (attributeName.equals("badBerFramesDtxHsOlpc")) {
            attValue = rspSig.badBerFramesDtxHsOlpc;
        } else if (attributeName.equals("badBerFramesHsOlpc")) {
            attValue = rspSig.badBerFramesHsOlpc;
        } else if (attributeName.equals("sirTargetStepHsOlpc")) {
            attValue = rspSig.sirTargetStepHsOlpc;
        } else if (attributeName.equals("dlPowerOffsetCombinedCell")) {
            attValue = rspSig.dlPowerOffsetCombinedCell;
        } else if (attributeName.equals("downlinkBaseBandPoolRef")) {
            attValue = rspSig.bbPoolId;
        } else if (attributeName.equals("nbirAlgorithm")) {
            attValue = rspSig.nbirAlgorithm;
        } else if (attributeName.equals("nbirFixedNotchPosition")) {
            attValue = rspSig.nbirFixedNotchPosition;
        } else if (attributeName.equals("numOfBranchWithNbir")) {
            attValue = rspSig.numOfBranchWithNbir;
        }
        return attValue;
    }

    private int getCellAttribute(Coordinator context, String attributeName) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCellAttribute()");
        int cellCarrierFroId = this.getCellCarrierFroId(context);
        int attValue = 0;
        LrsCellGetParamRspS rspSig = this.lrsProxy.cellGetParam(0, this.getTxIdNonTransactional(context), cellCarrierFroId);
        if (attributeName.equals(CPICH_IS_ACTIVE)) {
            attValue = rspSig.cpichIsActive;
        } else if (attributeName.equals(SCH_IS_ACTIVE)) {
            attValue = rspSig.schIsActive;
        }
        return attValue;
    }

    private void releaseDeviceMos(SequenceAttribute MoRefAttrList, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " releaseDeviceMos() ");
        ManagedObject[] moRefArr = this.getMoRefArr(MoRefAttrList, context);
        for (int i = 0; i < moRefArr.length; ++i) {
            if (moRefArr[i] != null) {
                ((Reservable)moRefArr[i]).release((ManagedObject)this, context);
                this.removeMoRefFromSequenceAttr(MoRefAttrList, moRefArr[i], context);
                continue;
            }
            String msg = "Device to be released is missing in the list ";
            MessageLog.traceError(this.getClass(), msg);
        }
    }

    private void removeMoRefFromSequenceAttr(SequenceAttribute moRefAttrList, ManagedObject mo, Coordinator context) throws MoAccessException {
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        Attribute[] attrList = moRefAttrList.getValue(context);
        if (attrList == null) {
            MessageLog.trace(2, this.getClass(), "SequenceAttribute == null !?");
        } else {
            for (int i = 0; i < attrList.length; ++i) {
                ReferenceAttribute moRefArr = (ReferenceAttribute)attrList[i];
                if (!mo.getLocalDistinguishedName().equals(moRefArr.getReferenceAsLDN())) continue;
                moRefAttrList.removeElement((Attribute)moRefArr);
            }
        }
    }

    private void upDateAiDevAllocation4AllCarrierMos(LrsRfapAddCarrierRspS rspSig, int thisCarrierFroId, Coordinator context) throws MoAccessException {
        HashMap<Integer, CarrierMoImpl> releasedCarrierList = new HashMap<Integer, CarrierMoImpl>(1);
        MessageLog.traceEnter(this.getClass(), " releaseAiDev4AllCarrierMos() ");
        for (int i = 0; i < rspSig.noOfAiDev; ++i) {
            LrsRfapDeviceS aiAlocationInfo = rspSig.ai[i];
            if (aiAlocationInfo.cellCarrierFroId == thisCarrierFroId) {
                this.setupDevices(new int[]{aiAlocationInfo.deviceFroId}, "aiDeviceRef", "AiDevice", context);
                continue;
            }
            CarrierMoImpl c = (CarrierMoImpl)BoamHelper.getMoForFroId("Carrier", aiAlocationInfo.cellCarrierFroId);
            if (c == null) continue;
            c.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
            SequenceAttribute aiDeviceRefAttrList = (SequenceAttribute)c.getMyMoData().getAttribute("aiDeviceRef");
            if (!releasedCarrierList.containsKey(new Integer(c.getFroId(context)))) {
                releasedCarrierList.put(new Integer(c.getFroId(context)), c);
                c.releaseDeviceMos(aiDeviceRefAttrList, context);
            }
            c.setupDevices(new int[]{aiAlocationInfo.deviceFroId}, "aiDeviceRef", "AiDevice", context);
            c.sendAVC("aiDeviceRef", c.getAiDeviceRef(context), context);
        }
    }

    private ManagedObject[] getMoRefArr(SequenceAttribute moRefAttrList, Coordinator context) throws MoAccessException {
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        Attribute[] attrList = moRefAttrList.getValue(context);
        if (attrList == null) {
            MessageLog.trace(2, this.getClass(), "SequenceAttribute == null !?");
            return new ManagedObject[0];
        }
        Vector<ManagedObject> validMos = new Vector<ManagedObject>();
        Vector<ReferenceAttribute> removedRefs = new Vector<ReferenceAttribute>();
        for (int i = 0; i < attrList.length; ++i) {
            ReferenceAttribute ra = (ReferenceAttribute)attrList[i];
            try {
                validMos.add(ra.getValue(context));
                continue;
            }
            catch (MoRemovedException ex) {
                MessageLog.trace(2, this.getClass(), "TR WRNad69692, WARNING!!! moRef " + ra.getReferenceAsLDN() + " is not valid (mo removed), removing from sequence");
                removedRefs.add(ra);
            }
        }
        this.removeRefs(context, moRefAttrList, removedRefs);
        return validMos.toArray(new ManagedObject[validMos.size()]);
    }

    private void removeRefs(Coordinator context, SequenceAttribute refAttrList, Collection refsToRemove) {
        Control tx = null;
        if (context == null) {
            try {
                tx = TransactionServiceImpl.instance().getTransactionFactory().create(5000);
                context = tx.getCoordinator();
            }
            catch (Exception e) {
                MessageLog.trace(2, this.getClass(), "Warning: Could not create transaction. Exeption was " + e);
                return;
            }
        }
        this.removeRefsWithContext(context, refAttrList, refsToRemove);
        if (tx != null) {
            try {
                tx.getTerminator().commit();
            }
            catch (Exception e) {
                MessageLog.trace(2, this.getClass(), "Warning: Could not commit removals from attrlist " + refAttrList.getName() + ". Exeption was " + e);
            }
        }
    }

    private void removeRefsWithContext(Coordinator context, SequenceAttribute refAttrList, Collection refsToRemove) {
        try {
            this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        }
        catch (Exception e) {
            MessageLog.trace(2, this.getClass(), "Warning: Could not get write access for removing MO refs. Exception was " + e);
            return;
        }
        Iterator iterator = refsToRemove.iterator();
        while (iterator.hasNext()) {
            refAttrList.removeElement((Attribute)((ReferenceAttribute)iterator.next()));
        }
    }

    private void initMoData(String userLabel, int alarmStatus, ManagedObject downlinkBaseBandPoolRef, Coordinator context) throws MoAccessException {
        MessageLog.trace(1, this.getClass(), "initMoData()");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.myData.registerPersistentAttr((Attribute)new SequenceAttribute("dpclDevicesRef", false));
        this.myData.registerPersistentAttr((Attribute)new SequenceAttribute("tpaDeviceRef", false));
        this.myData.registerPersistentAttr((Attribute)new SequenceAttribute("aiDeviceRef", false));
        this.myData.registerPersistentAttr((Attribute)new SequenceAttribute("trDeviceRef", false));
        this.myData.registerPersistentAttr((Attribute)new SequenceAttribute("dbccDeviceRef", false));
        this.myData.registerPersistentAttr((Attribute)new ReferenceAttribute("downlinkBaseBandPoolRef", false, downlinkBaseBandPoolRef));
        this.initAlarmStatus(alarmStatus, context);
        this.myData.registerTransientAttr((Attribute)new ReferenceAttribute(PCPICH_REF, false));
        this.myData.registerTransientAttr((Attribute)new ReferenceAttribute(SCPICH_REF, false));
        this.myData.registerTransientAttr((Attribute)new ReferenceAttribute(PSCH_REF, false));
        this.myData.registerTransientAttr((Attribute)new ReferenceAttribute(SSCH_REF, false));
        this.myData.setRevision(7040001);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    private void releaseSingleDbccDeviceMo(int dbccDevFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " releaseSingleDbccDeviceMo () ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        SequenceAttribute dbccDeviceRefAttrList = (SequenceAttribute)this.myData.getAttribute("dbccDeviceRef");
        Attribute[] moRefList = dbccDeviceRefAttrList.getValue(context);
        for (int i = 0; i < moRefList.length; ++i) {
            ManagedObject moRef = ((ReferenceAttribute)moRefList[i]).getValue(context);
            if (moRef == null || ((DbccDeviceMo)moRef).getDeviceFroId(context) != dbccDevFroId) continue;
            ((Reservable)moRef).release((ManagedObject)this, context);
            dbccDeviceRefAttrList.removeElement(moRefList[i]);
            MessageLog.trace(2, this.getClass(), moRef.getLocalDistinguishedName() + " released.");
            return;
        }
    }

    public void sectorInitiated(int noOfDpclDev, LrsRfapDeviceS[] dpcl, int noOfTpaDev, LrsRfapDeviceS[] tpa, int noOfAiDev, LrsRfapDeviceS[] ai, int noOfDbccDev, LrsRfapDeviceS[] dbcc, int noOfTrDev, LrsRfapDeviceS[] tr, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sectorInitiated()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int[] devices = this.getDeviceFroIds(dpcl, noOfDpclDev, context);
        this.setupDevices(devices, "dpclDevicesRef", "DpclDevice", context);
        this.sendAVC("dpclDevicesRef", this.getDpclDevicesRef(context), context);
        devices = this.getDeviceFroIds(tpa, noOfTpaDev, context);
        this.setupDevices(devices, "tpaDeviceRef", "TpaDevice", context);
        this.sendAVC("tpaDeviceRef", this.getTpaDeviceRef(context), context);
        devices = this.getDeviceFroIds(ai, noOfAiDev, context);
        this.setupDevices(devices, "aiDeviceRef", "AiDevice", context);
        this.sendAVC("aiDeviceRef", this.getAiDeviceRef(context), context);
        devices = this.getDeviceFroIds(dbcc, noOfDbccDev, context);
        this.setupDevices(devices, "dbccDeviceRef", "DbccDevice", context);
        this.sendAVC("dbccDeviceRef", this.getDbccDeviceRef(context), context);
        devices = this.getDeviceFroIds(tr, noOfTrDev, context);
        this.setupDevices(devices, "trDeviceRef", "TrDevice", context);
        this.sendAVC("trDeviceRef", this.getTrDeviceRef(context), context);
    }

    public void sectorUnInitiated(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sectorUnInitiated()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        if (this.myData.getAttribute("dpclDevicesRef") instanceof SequenceAttribute) {
            SequenceAttribute dpclDeviceRefAttrList = (SequenceAttribute)this.myData.getAttribute("dpclDevicesRef");
            this.releaseDeviceMos(dpclDeviceRefAttrList, context);
            dpclDeviceRefAttrList.setValue(new Attribute[0]);
        }
        this.sendAVC("dpclDevicesRef", this.getDpclDevicesRef(context), context);
        SequenceAttribute tpaDeviceRefAttrList = (SequenceAttribute)this.myData.getAttribute("tpaDeviceRef");
        this.releaseDeviceMos(tpaDeviceRefAttrList, context);
        tpaDeviceRefAttrList.setValue(new Attribute[0]);
        this.sendAVC("tpaDeviceRef", this.getTpaDeviceRef(context), context);
        SequenceAttribute aiDeviceRefAttrList = (SequenceAttribute)this.myData.getAttribute("aiDeviceRef");
        this.releaseDeviceMos(aiDeviceRefAttrList, context);
        aiDeviceRefAttrList.setValue(new Attribute[0]);
        this.sendAVC("aiDeviceRef", this.getAiDeviceRef(context), context);
        SequenceAttribute dbccDeviceRefAttrList = (SequenceAttribute)this.myData.getAttribute("dbccDeviceRef");
        this.releaseDeviceMos(dbccDeviceRefAttrList, context);
        dbccDeviceRefAttrList.setValue(new Attribute[0]);
        this.sendAVC("dbccDeviceRef", this.getDbccDeviceRef(context), context);
        SequenceAttribute trDeviceRefAttrList = (SequenceAttribute)this.myData.getAttribute("trDeviceRef");
        this.releaseDeviceMos(trDeviceRefAttrList, context);
        trDeviceRefAttrList.setValue(new Attribute[0]);
        this.sendAVC("trDeviceRef", this.getTrDeviceRef(context), context);
    }

    public void addingTxGroup(ManagedObject txDeviceGroup, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "addingTxGroup()");
        int cellCarrierFroId = this.getCellCarrierFroId(context);
        int dbccDevFroId = 0;
        try {
            LrsEnableTxLoadSharingRspS rspSig = this.lrsProxy.enableTxLoadSharing(this.getTxIdTransactional(context), 0, cellCarrierFroId);
            dbccDevFroId = rspSig.dbccDevFroId;
        }
        catch (MoAccessException e) {
            try {
                context.rollbackOnly();
            }
            catch (InactiveTransactionException e1) {
                // empty catch block
            }
            throw e;
        }
        MessageLog.trace(2, this.getClass(), " Adding DbccDevice for TX Loadsharing: dbccDevFroId  = " + dbccDevFroId);
        MoIterator dbccIter = MoRepository.instance().select(txDeviceGroup, 2, (MoFilter)new MoTypeFilter("DbccDevice"));
        SequenceAttribute dbccDeviceRefAttrList = (SequenceAttribute)this.myData.getAttribute("dbccDeviceRef");
        while (dbccIter.hasMoreElements()) {
            DbccDeviceMo dbccDev = (DbccDeviceMo)dbccIter.nextMo();
            if (dbccDev.getDeviceFroId(context) != dbccDevFroId) continue;
            this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
            ReferenceAttribute attribute = new ReferenceAttribute("dbccDeviceRef", false, (ManagedObject)dbccDev);
            dbccDev.reserve(this, context);
            dbccDeviceRefAttrList.addElement((Attribute)attribute);
            MessageLog.trace(2, this.getClass(), dbccDev.getLocalDistinguishedName() + " reserved and added to " + "dbccDeviceRef");
            return;
        }
        MessageLog.trace(2, this.getClass(), " Could not find DbccDevice with dbccDevFroId  = " + dbccDevFroId + " under " + txDeviceGroup.getLocalDistinguishedName());
        throw new MoCanNotBeCreatedException("Carrier");
    }

    public void deletingDbccDevice(ManagedObject dbccDevice, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deletingDbccDevice()");
        int cellCarrierFroId = this.getCellCarrierFroId(context);
        int dbccDevFroId = ((DbccDeviceMo)dbccDevice).getDeviceFroId(context);
        try {
            this.lrsProxy.disableTxLoadSharing(this.getTxIdTransactional(context), 0, cellCarrierFroId, dbccDevFroId);
        }
        catch (MoAccessException e) {
            try {
                context.rollbackOnly();
            }
            catch (InactiveTransactionException e1) {
                // empty catch block
            }
            throw e;
        }
        this.releaseSingleDbccDeviceMo(dbccDevFroId, context);
    }

    private void setupDevices(int[] froIds, String attrName, String deviceType, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setupDevices(): " + attrName);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        SequenceAttribute devAttr = (SequenceAttribute)this.myData.getAttribute(attrName);
        boolean[] matchedFroId = new boolean[froIds.length];
        StringBuffer foundDevices = new StringBuffer("\nDevices found:\n");
        MoIterator devices = BoamHelper.findMOs(deviceType);
        while (devices.hasMoreElements()) {
            ManagedObject device = devices.nextMo();
            for (int i = 0; i < froIds.length; ++i) {
                if (froIds[i] < 0) {
                    matchedFroId[i] = true;
                    MessageLog.trace(1, this.getClass(), "Skipping negative froId");
                    continue;
                }
                if (((MaoHasFro)device).getFroId(context) != froIds[i]) continue;
                foundDevices.append("froId[").append(i).append("] = ").append(froIds[i]).append(", Found mo = ").append(device.getLocalDistinguishedName()).append("\n");
                devAttr.addElement((Attribute)new ReferenceAttribute("", false, device));
                ((Reservable)device).reserve((ManagedObject)this, context);
                matchedFroId[i] = true;
            }
        }
        for (int i = 0; i < matchedFroId.length; ++i) {
            if (matchedFroId[i]) continue;
            String errorMessage = "couldn't find " + deviceType + " matching froId = " + froIds[i];
            try {
                MessageLog.traceError(this.getClass(), errorMessage + foundDevices);
                context.rollbackOnly();
            }
            catch (InactiveTransactionException e) {
                // empty catch block
            }
            throw new MoNotFoundException(errorMessage + foundDevices);
        }
        MessageLog.trace(1, this.getClass(), foundDevices + ", is reserved by:" + this.getLocalDistinguishedName());
    }

    private int[] getDeviceFroIds(LrsRfapDeviceS[] devices, int noOfDev, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDeviceFroIds() ");
        MessageLog.trace(2, this.getClass(), "getDeviceFroIds devices.length = " + devices.length);
        MessageLog.trace(2, this.getClass(), "getDeviceFroIds noOfDev        = " + noOfDev);
        ArrayList<Integer> result2 = new ArrayList<Integer>();
        int carrierFroId = this.getCellCarrierFroId(context);
        MessageLog.trace(2, this.getClass(), "getDeviceFroIds carrierFroId   = " + carrierFroId);
        int j = 0;
        for (int i = 0; i < noOfDev; ++i) {
            MessageLog.trace(2, this.getClass(), "getDeviceFroIds devices[i].cellCarrierFroId  = " + devices[i].cellCarrierFroId);
            if (devices[i].cellCarrierFroId != carrierFroId || j >= noOfDev) continue;
            int val = devices[i].deviceFroId;
            result2.add(new Integer(val));
            MessageLog.trace(2, this.getClass(), "getDeviceFroIds result nr :" + j + " = " + devices[i].deviceFroId);
            ++j;
        }
        MessageLog.trace(2, this.getClass(), "getDeviceFroIds result.size() :" + result2.size());
        int[] intResult = new int[result2.size()];
        for (int i = 0; i < result2.size(); ++i) {
            intResult[i] = (Integer)result2.get(i);
        }
        return intResult;
    }

    public void setAlarmStatus(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setAlarmStatus(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("alarmStatus", value, CarrierMo.ALARM_STATUS_MIN_VALUES, CarrierMo.ALARM_STATUS_MAX_VALUES, this.getType());
        ValidateAttributes.checkTransaction(c);
        super.setAlarmStatus(value, c);
    }

    public boolean getCqiAdjustmentOn(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCqiAdjustmentOn()<---");
        ManagedObject[] reservedBy = this.getReservedBy(c);
        RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
        if (cell != null) {
            if (!cell.isCombinedCell(c)) {
                return cell.getCqiAdjustmentOn(c);
            }
            return false;
        }
        try {
            return this.bcmGetBooleanAttribute("cqiAdjustmentOn", c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetBooleanAttribute fail, return the undefined value");
            return false;
        }
    }

    public void setCqiAdjustmentOn(boolean value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setCqiAdjustmentOn(" + value + ") <---");
        ValidateAttributes.checkTransaction(c);
        ManagedObject[] reservedBy = this.getReservedBy(c);
        RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
        if (cell != null) {
            if (!cell.isCombinedCell(c)) {
                cell.setCqiAdjustmentOn(value, c);
                this.sendAVC("cqiAdjustmentOn", value, c);
                return;
            }
            throw new ConfigurationNotSupportedException("For combined cell, set its value in RbsLocalCell");
        }
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        MessageLog.info(this.getClass(), "Cell is not found, register it in carrier MoData");
        this.storeAttribute("cqiAdjustmentOn", value, c);
        this.sendAVC("cqiAdjustmentOn", value, c);
    }

    public int getCqiErrors(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCqiErrors()<---");
        try {
            return this.handleGetIntHsAttr("cqiErrors", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public void setCqiErrors(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setCqiErrors(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("cqiErrors", value, CarrierMo.CQI_ERRORS_MIN_VALUES, CarrierMo.CQI_ERRORS_MAX_VALUES, this.getType());
        if (!CarrierMoImpl.intResolutionValueRangeCheck(value, 5, 15, 100)) {
            throw new ValueOutOfRangeException("cqiErrors", "Carrier");
        }
        this.handleSetIntHsAttr("cqiErrors", value, c);
    }

    public int getCqiErrorsAbsent(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCqiErrorsAbsent()<---");
        try {
            return this.handleGetIntHsAttr("cqiErrorsAbsent", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public void setCqiErrorsAbsent(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setCqiErrorsAbsent(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("cqiErrorsAbsent", value, CarrierMo.CQI_ERRORS_MIN_VALUES, CarrierMo.CQI_ERRORS_MAX_VALUES, this.getType());
        if (!CarrierMoImpl.intResolutionValueRangeCheck(value, 5, 15, 100)) {
            throw new ValueOutOfRangeException("cqiErrorsAbsent", "Carrier");
        }
        this.handleSetIntHsAttr("cqiErrorsAbsent", value, c);
    }

    public boolean getDlTestModelTransmissionHsOn(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDlTestModelTransmissionHsOn()<---");
        ManagedObject[] reservedBy = this.getReservedBy(c);
        RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
        if (cell != null) {
            if (!cell.isCombinedCell(c)) {
                return cell.getDlTestModelTransmissionHsOn(c);
            }
            return false;
        }
        return false;
    }

    public int getHsPowerMargin(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getHsPowerMargin()<---");
        try {
            return this.handleGetIntHsAttr("hsPowerMargin", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public void setHsPowerMargin(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setHsPowerMargin(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("hsPowerMargin", value, CarrierMo.HS_POWER_MARGIN_MIN_VALUES, CarrierMo.HS_POWER_MARGIN_MAX_VALUES, this.getType());
        this.handleSetIntHsAttr("hsPowerMargin", value, c);
    }

    public int getHsScchMaxCodePower(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getHsScchMaxCodePower()<---");
        try {
            return this.handleGetIntHsAttr("hsScchMaxCodePower", -999, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -999;
        }
    }

    public void setHsScchMaxCodePower(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setHsScchMaxCodePower(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("hsScchMaxCodePower", value, CarrierMo.HS_SCCH_MAX_CODE_POWER_MIN_VALUES, CarrierMo.HS_SCCH_MAX_CODE_POWER_MAX_VALUES, this.getType());
        this.handleSetIntHsAttr("hsScchMaxCodePower", value, c);
    }

    public int getQueueSelectAlgorithm(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getQueueSelectAlgorithm()<---");
        try {
            return this.handleGetIntHsAttr("queueSelectAlgorithm", 6, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return 6;
        }
    }

    public void setQueueSelectAlgorithm(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setQueueSelectAlgorithm(" + value + ") <---");
        ValidateAttributes.intValueInEnumerationCheck("queueSelectAlgorithm", value, CarrierQueueSelectAlgorithm.class, this.getType());
        this.handleSetIntHsAttr("queueSelectAlgorithm", value, c);
    }

    public ManagedObject[] getReservedBy(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getReservedBy()<---");
        return super.getReservedBy(c);
    }

    public void actionStartHsDlTestModelTran(int hsBranch, int numberOfHsPdschCodes, int transmissionMode, int[] hsPdschCodes, int[] hsPdschPower, int numberOfHsScchCodes, int[] hsScchCodes, int[] hsScchPower, Coordinator c) throws MoAccessException, InternalErrorException, CellNotSetupException, NotHsdpaCapableException, MacHsIsSetupException, AlreadyActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStartHsDlTestModelTran()<---");
        ManagedObject[] reservedBy = this.getReservedBy(c);
        RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
        if (cell != null) {
            if (!cell.isCombinedCell(c)) {
                cell.actionStartHsDlTestModelTran(hsBranch, numberOfHsPdschCodes, transmissionMode, hsPdschCodes, hsPdschPower, numberOfHsScchCodes, hsScchCodes, hsScchPower, c);
                return;
            }
        } else {
            throw new ConfigurationNotSupportedException();
        }
    }

    public void actionStopHsDlTestModelTran(Coordinator c) throws MoAccessException, InternalErrorException, NotActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStopHsDlTestModelTran()<---");
        ManagedObject[] reservedBy = this.getReservedBy(c);
        RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
        if (cell != null) {
            if (!cell.isCombinedCell(c)) {
                cell.actionStopHsDlTestModelTran(c);
                return;
            }
        } else {
            throw new ConfigurationNotSupportedException();
        }
    }

    public int getTxGainAdjustHidden(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTxGainAdjustHidden()<---");
        int defValue = 0;
        try {
            defValue = this.lrsProxy.getTxGainAdjustHidden(0, this.getCellCarrierFroId(c));
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "FroRequestFailedException caught when calling actionGetTxGainAdjustHidden() :" + e.getMessage());
        }
        return defValue;
    }

    public Struct actionPerformTrTxBbPowMeasHidden(Coordinator c) throws MoAccessException {
        LrsCcTrtxBbPowRspS rspSig;
        MessageLog.traceEnter(this.getClass(), "actionPerformTrTxBbPowMeasHidden()<---");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        try {
            rspSig = this.lrsProxy.performTrTxBbPowMeasHidden(0, this.getCellCarrierFroId(c));
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 4) {
                throw new InternalErrorException();
            }
            throw e;
        }
        return this.convertCcTrtxBbPowSigToStruct(rspSig);
    }

    private void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, new FroProxy[]{this.lrsProxy, this.scRfAccessCarrierProxy}, froType, this.getCellCarrierFroId(context), context);
    }

    private void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getFroId() ");
        int froId = 0;
        try {
            froId = this.getCellCarrierFroId(c);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "MoAccessException caught in getFroId" + e.getMessage());
        }
        return froId;
    }

    private static boolean intResolutionValueRangeCheck(int value, int resolution, int resolutionMin, int resolutionMax) {
        MessageLog.traceEnter(CarrierMoImpl.class, "intResolutionValueRangeCheck() ");
        boolean bool = true;
        if (value >= resolutionMin && value <= resolutionMax && value % resolution != 0) {
            bool = false;
        }
        return bool;
    }

    public int[] getScannerValue(String counterName) throws MoAccessException {
        if (this.sccScanner == null || this.chcScanner == null) {
            throw new PmsException("MoScanner not available");
        }
        if (this.isChcMeasCounter(counterName)) {
            return this.chcScanner.getValue(counterName);
        }
        return this.sccScanner.getValue(counterName);
    }

    public int getHsScchMinCodePower(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getHsScchMinCodePower()<---");
        try {
            return this.handleGetIntHsAttr("hsScchMinCodePower", -999, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -999;
        }
    }

    public void setHsScchMinCodePower(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setHsScchMinCodePower(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("hsScchMinCodePower", value, CarrierMo.HS_SCCH_MIN_CODE_POWER_MIN_VALUES, CarrierMo.HS_SCCH_MIN_CODE_POWER_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("hsScchMinCodePower", value, c);
    }

    public int getQualityCheckPower(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getQualityCheckPower()<---");
        try {
            return this.handleGetIntHsAttr("qualityCheckPower", -9, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -9;
        }
    }

    public void setQualityCheckPower(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setQualityCheckPower(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("qualityCheckPower", value, CarrierMo.QUALITY_CHECK_POWER_MIN_VALUES, CarrierMo.QUALITY_CHECK_POWER_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("qualityCheckPower", value, c);
    }

    public int getAirRateTypeSelector(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAirRateTypeSelector()<---");
        try {
            return this.handleGetIntHsAttr("airRateTypeSelector", 2, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the undefined value");
            return 2;
        }
    }

    public void setAirRateTypeSelector(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setAirRateTypeSelector(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("airRateTypeSelector", value, 0, 2, "Carrier");
        this.handleSetIntHsAttr("airRateTypeSelector", value, c);
    }

    public void actionTurnCpichOff(Coordinator c) throws MoAccessException, InternalErrorException, MoDisabledException, NotActiveException {
        MessageLog.traceEnter(this.getClass(), "actionTurnCpichOff() ");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        try {
            this.lrsProxy.turnCpichTransOff(0, this.getFroId(c));
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 12) {
                throw new CellNotSetupException();
            }
            if (e.getOrgErrorCode() == 5) {
                throw new MoDisabledException();
            }
            if (e.getOrgErrorCode() == 7) {
                throw new NotActiveException();
            }
            throw e;
        }
        MessageLog.trace(2, this.getClass(), "actionTurnCpichOff has been successfully performed ");
    }

    public void actionResumeCpich(Coordinator c) throws MoAccessException, InternalErrorException, AlreadyActiveException {
        MessageLog.traceEnter(this.getClass(), "actionResumeCpich() ");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        try {
            this.lrsProxy.resumeCpichTrans(0, this.getFroId(c));
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 4) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 6) {
                throw new AlreadyActiveException();
            }
            throw e;
        }
    }

    public void actionTurnSchBchOff(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionTurnSchBchOff() ");
        this.actionTurnOffOrResumeSchBchOff(false, c);
    }

    public void actionResumeSchBch(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionResumeSchBch() ");
        this.actionTurnOffOrResumeSchBchOff(true, c);
    }

    public void actionTurnOffOrResumeSchBchOff(boolean resume, Coordinator c) throws MoAccessException {
        FroRequestFailedException e;
        MessageLog.traceEnter(this.getClass(), "actionTurnOffOrResumeSchBchOff() ");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        MoIterator moIter = MoRepository.instance().select((ManagedObject)this, 2, (MoFilter)new MoTypeFilter("Bch"));
        BchMo bchRef = null;
        if (moIter.hasMoreElements()) {
            bchRef = (BchMo)moIter.nextMo();
            MessageLog.trace(2, this.getClass(), " The Bch MO has been found ");
        } else {
            ManagedObject[] reservedBy = this.getReservedBy(c);
            RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
            MoIterator nMoIter = MoRepository.instance().select((ManagedObject)cell, 2, (MoFilter)new MoTypeFilter("Bch"));
            if (nMoIter.hasMoreElements()) {
                bchRef = (BchMo)nMoIter.nextMo();
            } else {
                throw new MoNotFoundException("Bch");
            }
        }
        boolean schAlreadyOnOrOff = false;
        try {
            if (resume) {
                this.lrsProxy.resumeSchTrans(0, this.getFroId(c));
                MessageLog.trace(2, this.getClass(), " resumeSchTrans has been performed ");
            } else {
                this.lrsProxy.turnSchTransOff(0, this.getFroId(c));
                MessageLog.trace(2, this.getClass(), " turnSchTransOff has been performed ");
            }
        }
        catch (MoAccessException exe) {
            if (exe instanceof FroRequestFailedException) {
                e = (FroRequestFailedException)exe;
                if (e.getOrgErrorCode() == 5) {
                    throw new MoDisabledException();
                }
                if (e.getOrgErrorCode() == 12) {
                    throw new CellNotSetupException();
                }
                if (e.getOrgErrorCode() == 4) {
                    throw new InternalErrorException();
                }
                if (e.getOrgErrorCode() == 7 || e.getOrgErrorCode() == 6) {
                    schAlreadyOnOrOff = true;
                }
                throw exe;
            }
            throw exe;
        }
        try {
            if (resume) {
                bchRef.actionResumeBch(c);
                MessageLog.trace(2, this.getClass(), " bchRef.actionResumeBch has been performed ");
            } else {
                bchRef.actionTurnBchOff(c);
                MessageLog.trace(2, this.getClass(), " bchRef.actionTurnBchOff has been performed ");
            }
        }
        catch (MoAccessException exe) {
            if (exe instanceof FroRequestFailedException) {
                ChcPccpchProxy.instance();
                e = (FroRequestFailedException)exe;
                if (e.getOrgErrorCode() == 2) {
                    throw new MoDisabledException();
                }
                if (e.getOrgErrorCode() == 1) {
                    this.lrsProxy.turnSchTransOff(0, this.getFroId(c));
                    MessageLog.trace(2, this.getClass(), "Because of H/W reject, action turnSchTransOff() has been performed !");
                    throw new InternalErrorException();
                }
                if (e.getOrgErrorCode() == 6) {
                    if (schAlreadyOnOrOff) {
                        throw new NotActiveException();
                    }
                }
                if (e.getOrgErrorCode() == 5) {
                    if (schAlreadyOnOrOff) {
                        throw new AlreadyActiveException();
                    }
                }
                throw e;
            }
            throw exe;
        }
    }

    public int getBchIsActive(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBchIsActive() ");
        int getBchIsActive = 0;
        BchMo bchRef = null;
        MoIterator moIter = MoRepository.instance().select((ManagedObject)this, 2, (MoFilter)new MoTypeFilter("Bch"));
        while (moIter.hasMoreElements()) {
            MessageLog.trace(2, this.getClass(), " The Bch MO has been found ");
            bchRef = (BchMo)moIter.nextMo();
            getBchIsActive = bchRef.getBchIsActive(c);
        }
        if (bchRef == null) {
            MessageLog.trace(2, this.getClass(), "The BchMo has not been found.");
        } else {
            getBchIsActive = bchRef.getBchIsActive(c);
        }
        MessageLog.trace(2, this.getClass(), "getBchIsActive = " + getBchIsActive);
        return getBchIsActive;
    }

    public int getSchCongPeriodGbr(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSchCongPeriodGbr()<---");
        try {
            return this.handleGetIntHsAttr("schCongPeriodGbr", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public int getSchCongThreshGbr(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSchCongThreshGbr()<---");
        try {
            return this.handleGetIntHsAttr("schCongThreshGbr", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public int getSchCongThreshNonGbr(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSchCongThreshNonGbr()<---");
        try {
            return this.handleGetIntHsAttr("schCongThreshNonGbr", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public int[] getSchMaxDelay(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSchMaxDelay()<---");
        ManagedObject[] reservedBy = this.getReservedBy(c);
        RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
        if (cell != null) {
            if (!cell.isCombinedCell(c)) {
                return cell.getSchMaxDelay(c);
            }
            return new int[]{-1};
        }
        try {
            return this.bcmGetIntArray("schMaxDelay", c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return new int[]{-1};
        }
    }

    public int getSchMinPowerNonGbrHsUsers(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSchMinPowerNonGbrHsUsers()<---");
        try {
            return this.handleGetIntHsAttr("schMinPowerNonGbrHsUsers", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public int getSchNoCongPeriodGbr(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSchNoCongPeriodGbr()<---");
        try {
            return this.handleGetIntHsAttr("schNoCongPeriodGbr", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public int getSchNoCongThreshGbr(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSchNoCongThreshGbr()<---");
        try {
            return this.handleGetIntHsAttr("schNoCongThreshGbr", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public int getSchPowerDeltaCongGbr(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSchPowerDeltaCongGbr()<---");
        try {
            return this.handleGetIntHsAttr("schPowerDeltaCongGbr", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public int getSchPrioForAbsResSharing(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSchPrioForAbsResSharing()<---");
        try {
            return this.handleGetIntHsAttr("schPrioForAbsResSharing", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public int[] getSchWeight(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSchWeight()<---");
        ManagedObject[] reservedBy = this.getReservedBy(c);
        RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
        if (cell != null) {
            if (!cell.isCombinedCell(c)) {
                return cell.getSchWeight(c);
            }
            return new int[]{-1};
        }
        try {
            return this.bcmGetIntArray("schWeight", c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return new int[]{-1};
        }
    }

    public void setSchCongPeriodGbr(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSchCongPeriodGbr(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("schCongPeriodGbr", value, CarrierMo.SCH_CONG_PERIOD_GBR_MIN_VALUES, CarrierMo.SCH_CONG_PERIOD_GBR_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("schCongPeriodGbr", value, c);
    }

    public void setSchCongThreshGbr(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSchCongThreshGbr(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("schCongThreshGbr", value, CarrierMo.SCH_CONG_THRESH_GBR_MIN_VALUES, CarrierMo.SCH_CONG_THRESH_GBR_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("schCongThreshGbr", value, c);
    }

    public void setSchCongThreshNonGbr(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSchCongThreshNonGbr(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("schCongThreshNonGbr", value, CarrierMo.SCH_CONG_THRESH_NON_GBR_MIN_VALUES, CarrierMo.SCH_CONG_THRESH_NON_GBR_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("schCongThreshNonGbr", value, c);
    }

    public void setSchMinPowerNonGbrHsUsers(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSchMinPowerNonGbrHsUsers(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("schMinPowerNonGbrHsUsers", value, CarrierMo.SCH_MIN_POWER_NON_GBR_HS_USERS_MIN_VALUES, CarrierMo.SCH_MIN_POWER_NON_GBR_HS_USERS_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("schMinPowerNonGbrHsUsers", value, c);
    }

    public void setSchNoCongPeriodGbr(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSchNoCongPeriodGbr(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("schNoCongPeriodGbr", value, CarrierMo.SCH_NO_CONG_PERIOD_GBR_MIN_VALUES, CarrierMo.SCH_NO_CONG_PERIOD_GBR_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("schNoCongPeriodGbr", value, c);
    }

    public void setSchNoCongThreshGbr(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSchNoCongThreshGbr(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("schNoCongThreshGbr", value, CarrierMo.SCH_NO_CONG_THRESH_GBR_MIN_VALUES, CarrierMo.SCH_NO_CONG_THRESH_GBR_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("schNoCongThreshGbr", value, c);
    }

    public void setSchPowerDeltaCongGbr(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSchPowerDeltaCongGbr(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("schPowerDeltaCongGbr", value, CarrierMo.SCH_POWER_DELTA_CONG_GBR_MIN_VALUES, CarrierMo.SCH_POWER_DELTA_CONG_GBR_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("schPowerDeltaCongGbr", value, c);
    }

    public void setSchPrioForAbsResSharing(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSchPrioForAbsResSharing(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("schPrioForAbsResSharing", value, CarrierMo.SCH_PRIO_FOR_ABS_RES_SHARING_MIN_VALUES, CarrierMo.SCH_PRIO_FOR_ABS_RES_SHARING_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("schPrioForAbsResSharing", value, c);
    }

    public void setSchMaxDelay(int[] value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSchMaxDelay(" + Strings.toString(value) + ") <---");
        ValidateAttributes.checkTransaction(c);
        ManagedObject[] reservedBy = this.getReservedBy(c);
        RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
        if (cell != null) {
            if (!cell.isCombinedCell(c)) {
                cell.setSchMaxDelay(value, c);
                this.sendAVC("schMaxDelay", value, c);
                return;
            }
            throw new ConfigurationNotSupportedException("For combined cell, set its value in RbsLocalCell");
        }
        if (value != null) {
            if (value.length != 16) {
                MessageLog.trace(2, this.getClass(), "schMaxDelay must have 16 elements");
                throw new WrongAttributeTypeException("schMaxDelay", "Carrier");
            }
        } else {
            MessageLog.trace(2, this.getClass(), "schMaxDelay is null!");
            throw new WrongAttributeTypeException("schMaxDelay", "Carrier");
        }
        for (int i = 0; i < value.length; ++i) {
            ValidateAttributes.intValueRangeCheck("schMaxDelay", value[i], SCH_MAX_DELAY_MIN_VALUES, SCH_MAX_DELAY_MAX_VALUES, "Carrier");
        }
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        MessageLog.info(this.getClass(), "Cell is not found, register it in carrier MoData");
        this.storeAttribute("schMaxDelay", value, c);
        this.sendAVC("schMaxDelay", value, c);
    }

    public void setSchWeight(int[] value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSchWeight(" + Strings.toString(value) + ") <---");
        ValidateAttributes.checkTransaction(c);
        ManagedObject[] reservedBy = this.getReservedBy(c);
        RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
        if (cell != null) {
            if (!cell.isCombinedCell(c)) {
                cell.setSchWeight(value, c);
                this.sendAVC("schWeight", value, c);
                return;
            }
            throw new ConfigurationNotSupportedException("For combined cell, set its value in RbsLocalCell");
        }
        if (value != null) {
            if (value.length != 16) {
                MessageLog.trace(2, this.getClass(), "schWeight must have 16 elements");
                throw new WrongAttributeTypeException("schWeight", "Carrier");
            }
        } else {
            MessageLog.trace(2, this.getClass(), "schWeight is null!");
            throw new WrongAttributeTypeException("schWeight", "Carrier");
        }
        for (int i = 0; i < value.length; ++i) {
            ValidateAttributes.intValueRangeCheck("schWeight", value[i], SCH_WEIGHT_MIN_VALUES, SCH_WEIGHT_MAX_VALUES, "Carrier");
        }
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        MessageLog.info(this.getClass(), "Cell is not found, register it in carrier MoData");
        this.storeAttribute("schWeight", value, c);
        this.sendAVC("schWeight", value, c);
    }

    public int getNumberOfTxBranches(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNumberOfTxBranches()");
        return this.getCarrierAttribute(context, "numberOfTxBranches");
    }

    public void setNumberOfTxBranches(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setNumberOfTxBranches(" + value + ") <---");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        SectorMo sector = (SectorMo)this.getParent();
        if (sector.isSectorInitialized(context)) {
            throw new ConfigNotSupportedException("It is not possible to set numberOfTxBranches for Carrier when Sector is initialized.");
        }
        ValidateAttributes.intValueRangeCheck("numberOfTxBranches", value, CarrierMo.NUMBER_OF_TX_BRANCHES_MIN_VALUES, CarrierMo.NUMBER_OF_TX_BRANCHES_MAX_VALUES, "Carrier");
        this.lrsProxy.setNumberOfTxBranches(0, this.getTxIdTransactional(context), this.getCellCarrierFroId(context), value);
        this.sendAVC("numberOfTxBranches", value, context);
    }

    public ManagedObject[] getDpclDevicesRef(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDpclDevicesRef() ");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        SequenceAttribute deviceRefAttrList = (SequenceAttribute)this.myData.getAttribute("dpclDevicesRef");
        return this.getMoRefArr(deviceRefAttrList, c);
    }

    public int getDlBandwidth(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDlBandwidth()");
        return this.getCarrierAttribute(c, "dlBandwidth");
    }

    public int getDlFilterProfile(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDlFilterProfile()");
        return this.getCarrierAttribute(c, "dlFilterProfile");
    }

    public int getNumberOfRxBranches(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNumberOfRxBranches()");
        return this.getCarrierAttribute(c, "numberOfRxBranches");
    }

    public int getUlBandwidth(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUlBandwidth()");
        return this.getCarrierAttribute(c, "ulBandwidth");
    }

    public int getUlFilterProfile(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUlFilterProfile()");
        return this.getCarrierAttribute(c, "ulFilterProfile");
    }

    public void setDlBandwidth(int value, Coordinator c) throws MoAccessException {
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("dlBandwidth", value, CarrierMo.DL_BANDWIDTH_MIN_VALUES, CarrierMo.DL_BANDWIDTH_MAX_VALUES, "Carrier");
        this.lrsProxy.setDlBandwidth(0, this.getTxIdTransactional(c), this.getCellCarrierFroId(c), value);
        this.sendAVC("dlBandwidth", value, c);
    }

    public void setDlFilterProfile(int value, Coordinator c) throws MoAccessException {
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("dlFilterProfile", value, 0, 1, "Carrier");
        this.lrsProxy.setDlFilterProfile(0, this.getTxIdTransactional(c), this.getCellCarrierFroId(c), value);
        this.sendAVC("dlFilterProfile", value, c);
    }

    public void setNumberOfRxBranches(int value, Coordinator c) throws MoAccessException {
        ValidateAttributes.checkTransaction(c);
        SectorMo sector = (SectorMo)this.getParent();
        if (sector.isSectorInitialized(c)) {
            throw new ConfigurationNotSupportedException("Sector is initialized, not possible to set the attribute!");
        }
        SectorHelper.checkSectorAntennasPrecondition(sector, value, c);
        ValidateAttributes.intValueRangeCheck("numberOfRxBranches", value, CarrierMo.NUMBER_OF_RX_BRANCHES_MIN_VALUES, CarrierMo.NUMBER_OF_RX_BRANCHES_MAX_VALUES, "Carrier");
        this.lrsProxy.setCarrierParam(0, this.getTxIdTransactional(c), this.getCellCarrierFroId(c), 4, value);
        this.sendAVC("numberOfRxBranches", value, c);
    }

    public void setUlBandwidth(int value, Coordinator c) throws MoAccessException {
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("ulBandwidth", value, CarrierMo.UL_BANDWIDTH_MIN_VALUES, CarrierMo.UL_BANDWIDTH_MAX_VALUES, "Carrier");
        this.lrsProxy.setUlBandwidth(0, this.getTxIdTransactional(c), this.getCellCarrierFroId(c), value);
        this.sendAVC("ulBandwidth", value, c);
    }

    public void setUlFilterProfile(int value, Coordinator c) throws MoAccessException {
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("ulFilterProfile", value, 0, 1, "Carrier");
        this.lrsProxy.setUlFilterProfile(0, this.getTxIdTransactional(c), this.getCellCarrierFroId(c), value);
        this.sendAVC("ulFilterProfile", value, c);
    }

    public int getHsdpaMcActivityBufferThreshold(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getHsdpaMcActivityBufferThreshold()");
        try {
            return this.handleGetIntHsAttr("hsdpaMcActivityBufferThreshold", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public int getHsdpaMcInactivityTimer(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getHsdpaMcInactivityTimer()");
        try {
            return this.handleGetIntHsAttr("hsdpaMcInactivityTimer", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public void setHsdpaMcActivityBufferThreshold(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setHsdpaMcActivityBufferThreshold()");
        ValidateAttributes.intValueRangeCheck("hsdpaMcActivityBufferThreshold", value, HSDPA_MC_ACTIVITY_BUFFER_THRESHOLD_MIN_VALUES, HSDPA_MC_ACTIVITY_BUFFER_THRESHOLD_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("hsdpaMcActivityBufferThreshold", value, c);
    }

    public void setHsdpaMcInactivityTimer(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setHsdpaMcInactivityTimer()");
        ValidateAttributes.intValueRangeCheck("hsdpaMcInactivityTimer", value, HSDPA_MC_INACTIVITY_TIMER_MIN_VALUES, HSDPA_MC_INACTIVITY_TIMER_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("hsdpaMcInactivityTimer", value, c);
    }

    public int getExtraHsScchPowerForSrbOnHsdpa(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getExtraHsScchPowerForSrbOnHsdpa()<---");
        try {
            return this.handleGetIntHsAttr("extraHsScchPowerForSrbOnHsdpa", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public int getExtraPowerForSrbOnHsdpa(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getExtraPowerForSrbOnHsdpa()<---");
        try {
            return this.handleGetIntHsAttr("extraPowerForSrbOnHsdpa", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public void setExtraHsScchPowerForSrbOnHsdpa(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setExtraHsScchPowerForSrbOnHsdpa()<---");
        ValidateAttributes.intValueRangeCheck("extraHsScchPowerForSrbOnHsdpa", value, CarrierMo.EXTRA_HS_SCCH_POWER_FOR_SRB_ON_HSDPA_MIN_VALUES, CarrierMo.EXTRA_HS_SCCH_POWER_FOR_SRB_ON_HSDPA_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("extraHsScchPowerForSrbOnHsdpa", value, c);
    }

    public void setExtraPowerForSrbOnHsdpa(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setExtraPowerForSrbOnHsdpa()<---");
        ValidateAttributes.checkTransaction(c);
        ValidateAttributes.intValueRangeCheck("extraPowerForSrbOnHsdpa", value, CarrierMo.EXTRA_POWER_FOR_SRB_ON_HSDPA_MIN_VALUES, CarrierMo.EXTRA_POWER_FOR_SRB_ON_HSDPA_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("extraPowerForSrbOnHsdpa", value, c);
    }

    public int[] getMinBitRate(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMinBitRate()<---");
        ManagedObject[] reservedBy = this.getReservedBy(c);
        RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
        if (cell != null) {
            if (!cell.isCombinedCell(c)) {
                return cell.getMinBitRate(c);
            }
            return new int[]{-1};
        }
        try {
            return this.bcmGetIntArray("minBitRate", c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return new int[]{-1};
        }
    }

    public int getMinBitRateMinCqi(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMinBitRateMinCqi()<---");
        try {
            return this.handleGetIntHsAttr("minBitRateMinCqi", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public void setMinBitRate(int[] value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setMinBitRate(" + Strings.toString(value) + ") <---");
        ValidateAttributes.checkTransaction(c);
        ManagedObject[] reservedBy = this.getReservedBy(c);
        RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
        if (cell != null) {
            if (!cell.isCombinedCell(c)) {
                cell.setMinBitRate(value, c);
                this.sendAVC("minBitRate", value, c);
                return;
            }
            throw new ConfigurationNotSupportedException("For combined cell, set its value in RbsLocalCell");
        }
        if (value != null) {
            if (value.length != 16) {
                MessageLog.trace(2, this.getClass(), "minBitRate must have 16 elements");
                throw new WrongAttributeTypeException("minBitRate", "Carrier");
            }
        } else {
            MessageLog.trace(2, this.getClass(), "minBitRate is null!");
            throw new WrongAttributeTypeException("minBitRate", "Carrier");
        }
        for (int i = 0; i < value.length; ++i) {
            ValidateAttributes.intValueRangeCheck("minBitRate", value[i], MIN_BIT_RATE_MIN_VALUES, MIN_BIT_RATE_MAX_VALUES, "Carrier");
        }
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        MessageLog.info(this.getClass(), "Cell is not found, register it in carrier MoData");
        this.storeAttribute("minBitRate", value, c);
        this.sendAVC("minBitRate", value, c);
    }

    public void setMinBitRateMinCqi(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setMinBitRateMinCqi( " + value + " )");
        ValidateAttributes.intValueRangeCheck("minBitRateMinCqi", value, CarrierMo.MIN_BIT_RATE_MIN_CQI_MIN_VALUES, CarrierMo.MIN_BIT_RATE_MIN_CQI_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("minBitRateMinCqi", value, c);
    }

    public int getDefaultCqiHsFach(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDefaultCqiHsFach()<---");
        try {
            return this.handleGetIntHsAttr("defaultCqiHsFach", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public int getExtraCompForSigHsFach(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getExtraCompForSigHsFach()<---");
        try {
            return this.handleGetIntHsAttr("extraCompForSigHsFach", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public int getExtraCompHsFach(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getExtraCompHsFach()<---");
        try {
            return this.handleGetIntHsAttr("extraCompHsFach", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public int getExtraHsScchCompForSigHsFach(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getExtraHsScchCompForSigHsFach()<---");
        try {
            return this.handleGetIntHsAttr("extraHsScchCompForSigHsFach", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public int getExtraHsScchCompHsFach(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getExtraHsScchCompHsFach()<---");
        try {
            return this.handleGetIntHsAttr("extraHsScchCompHsFach", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public int[] getThroughputPqxHsFach(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getThroughputPqxHsFach()<---");
        ManagedObject[] reservedBy = this.getReservedBy(c);
        RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
        if (cell != null) {
            if (!cell.isCombinedCell(c)) {
                return cell.getThroughputPqxHsFach(c);
            }
            return new int[]{-1};
        }
        try {
            return this.bcmGetIntArray("throughputPqxHsFach", c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return new int[]{-1};
        }
    }

    public void setDefaultCqiHsFach(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setDefaultCqiHsFach( " + value + " )");
        ValidateAttributes.intValueRangeCheck("defaultCqiHsFach", value, CarrierMo.DEFAULT_CQI_HS_FACH_MIN_VALUES, CarrierMo.DEFAULT_CQI_HS_FACH_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("defaultCqiHsFach", value, c);
    }

    public void setExtraCompForSigHsFach(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setExtraCompForSigHsFach( " + value + " )");
        ValidateAttributes.intValueRangeCheck("extraCompForSigHsFach", value, CarrierMo.EXTRA_COMP_FOR_SIG_HS_FACH_MIN_VALUES, CarrierMo.EXTRA_COMP_FOR_SIG_HS_FACH_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("extraCompForSigHsFach", value, c);
    }

    public void setExtraCompHsFach(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setExtraCompHsFach( " + value + " )");
        ValidateAttributes.intValueRangeCheck("extraCompHsFach", value, CarrierMo.EXTRA_COMP_HS_FACH_MIN_VALUES, CarrierMo.EXTRA_COMP_HS_FACH_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("extraCompHsFach", value, c);
    }

    public void setExtraHsScchCompForSigHsFach(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setExtraHsScchCompForSigHsFach( " + value + " )");
        ValidateAttributes.intValueRangeCheck("extraHsScchCompForSigHsFach", value, CarrierMo.EXTRA_HS_SCCH_COMP_FOR_SIG_HS_FACH_MIN_VALUES, CarrierMo.EXTRA_HS_SCCH_COMP_FOR_SIG_HS_FACH_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("extraHsScchCompForSigHsFach", value, c);
    }

    public void setExtraHsScchCompHsFach(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setExtraHsScchCompHsFach( " + value + " )");
        ValidateAttributes.intValueRangeCheck("extraHsScchCompHsFach", value, CarrierMo.EXTRA_HS_SCCH_COMP_HS_FACH_MIN_VALUES, CarrierMo.EXTRA_HS_SCCH_COMP_HS_FACH_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("extraHsScchCompHsFach", value, c);
    }

    public void setThroughputPqxHsFach(int[] value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setThroughputPqxHsFach()");
        ValidateAttributes.checkTransaction(c);
        ManagedObject[] reservedBy = this.getReservedBy(c);
        RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
        if (cell != null) {
            if (!cell.isCombinedCell(c)) {
                cell.setThroughputPqxHsFach(value, c);
                this.sendAVC("throughputPqxHsFach", value, c);
                return;
            }
            throw new ConfigurationNotSupportedException("For combined cell, set its value in RbsLocalCell");
        }
        if (value != null) {
            if (value.length != 15) {
                MessageLog.trace(2, this.getClass(), "throughputPqxHsFach must have 15 elements");
                throw new WrongAttributeTypeException("throughputPqxHsFach", "Carrier");
            }
        } else {
            MessageLog.trace(2, this.getClass(), "throughputPqxHsFach is null!");
            throw new WrongAttributeTypeException("throughputPqxHsFach", "Carrier");
        }
        for (int i = 0; i < value.length; ++i) {
            ValidateAttributes.intValueRangeCheck("throughputPqxHsFach", value[i], THROUGHPUT_PQX_HS_FACH_MIN_VALUES, THROUGHPUT_PQX_HS_FACH_MAX_VALUES, "Carrier");
        }
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        MessageLog.info(this.getClass(), "Cell is not found, register it in carrier MoData");
        this.storeAttribute("throughputPqxHsFach", value, c);
        this.sendAVC("throughputPqxHsFach", value, c);
    }

    public int getExtraCompEnhUeDrx(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getExtraCompEnhUeDrx()<---");
        try {
            return this.handleGetIntHsAttr("extraCompEnhUeDrx", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public int getExtraHsScchCompEnhUeDrx(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getExtraHsScchCompEnhUeDrx()<---");
        try {
            return this.handleGetIntHsAttr("extraHsScchCompEnhUeDrx", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public void setExtraCompEnhUeDrx(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setExtraCompEnhUeDrx(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("extraCompEnhUeDrx", value, CarrierMo.EXTRA_COMP_ENH_UE_DRX_MIN_VALUES, CarrierMo.EXTRA_COMP_ENH_UE_DRX_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("extraCompEnhUeDrx", value, c);
    }

    public void setExtraHsScchCompEnhUeDrx(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setExtraHsScchCompEnhUeDrx(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("extraHsScchCompEnhUeDrx", value, CarrierMo.EXTRA_HS_SCCH_COMP_ENH_UE_DRX_MIN_VALUES, CarrierMo.EXTRA_HS_SCCH_COMP_ENH_UE_DRX_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("extraHsScchCompEnhUeDrx", value, c);
    }

    public int getIntHsAttribute(String name, Coordinator context) throws MoAccessException {
        return this.bcmGetIntAttribute(name, context);
    }

    public boolean getBooleanHsAttribute(String name, Coordinator context) throws MoAccessException {
        return this.bcmGetBooleanAttribute(name, context);
    }

    public int[] getIntArrayHsAttribute(String name, Coordinator context) throws MoAccessException {
        return this.bcmGetIntArray(name, context);
    }

    public void deregisterHsAttribute(String name, Coordinator context) throws MoAccessException {
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.myData.deregisterAttribute(name);
    }

    public ManagedObject getDuiDeviceGroupRef(Coordinator c) throws MoAccessException {
        return this.bcmGetReferenceAttribute(DUI_DEVICE_GROUP_REF, c);
    }

    public void setDuiDeviceGroupRef(ManagedObject value, Coordinator c) throws MoAccessException {
        throw new OperationNotAllowedException("duiDeviceGroupRef is not settable");
    }

    private int checkAndGetbbPoolId(ManagedObject downlinkBaseBandPoolMo, Coordinator context) throws MoAccessException {
        int bbPoolId = -1;
        if (downlinkBaseBandPoolMo != null) {
            if (downlinkBaseBandPoolMo instanceof DownlinkBaseBandPoolMo) {
                bbPoolId = Integer.parseInt(((DownlinkBaseBandPoolMoImpl)downlinkBaseBandPoolMo).getDownlinkBaseBandPoolId(context));
                if (bbPoolId < 1 || bbPoolId > 4) {
                    throw new IllegalAttributeValueException("For downlinkBaseBandPool,it's allowed to reference DownlinkBaseBandPool that has DownlinkBaseBandPoolId = 1, 2, 3 or 4", "downlinkBaseBandPoolRef", "Carrier");
                }
            } else {
                throw new IllegalAttributeValueException("downlinkBaseBandPoolRef references an MO that is not a DownlinkBaseBandPoolMo", "downlinkBaseBandPoolRef", "Carrier");
            }
        }
        return bbPoolId;
    }

    public int getChQualOffset(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getChQualOffset()<---");
        try {
            return this.handleGetIntHsAttr("chQualOffset", -1, c);
        }
        catch (MoAccessException e) {
            MessageLog.info(this.getClass(), "bcmGetIntAttribute fail, return the default value");
            return -1;
        }
    }

    public void setChQualOffset(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setChQualOffset(" + value + ") <---");
        ValidateAttributes.intValueRangeCheck("chQualOffset", value, CarrierMo.CH_QUAL_OFFSET_MIN_VALUES, CarrierMo.CH_QUAL_OFFSET_MAX_VALUES, "Carrier");
        this.handleSetIntHsAttr("chQualOffset", value, c);
    }

    private void handleSetIntHsAttr(String attrName, int value, Coordinator c) throws MoAccessException {
        ValidateAttributes.checkTransaction(c);
        ManagedObject[] reservedBy = this.getReservedBy(c);
        RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
        if (cell != null) {
            if (!cell.isCombinedCell(c)) {
                cell.setAttribute(attrName, new Integer(value), c);
                this.sendAVC(attrName, value, c);
                return;
            }
            throw new ConfigurationNotSupportedException("For combined cell, set its value in RbsLocalCell");
        }
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        MessageLog.trace(2, this.getClass(), "Cell is not found, register it in Carrier's MoData");
        this.storeAttribute(attrName, value, c);
        this.sendAVC(attrName, value, c);
    }

    private void storeAttribute(String attrName, int value, Coordinator c) throws MoAccessException {
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        IntegerAttribute attribute = (IntegerAttribute)this.myData.getAttribute(attrName);
        if (attribute == null) {
            this.bcmStoreAndRegisterIntAttribute(attrName, value);
            return;
        }
        attribute.setValue(value);
    }

    private void storeAttribute(String attrName, int[] value, Coordinator c) throws MoAccessException {
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        SequenceAttribute attribute = (SequenceAttribute)this.myData.getAttribute(attrName);
        if (attribute == null) {
            this.bcmStoreAndRegisterIntArrayAttribute(attrName, value);
            return;
        }
        Attribute[] attributes = new Attribute[value.length];
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i] = new IntegerAttribute("int" + i, false, value[i]);
        }
        attribute.setValue(attributes);
    }

    private void storeAttribute(String attrName, boolean value, Coordinator c) throws MoAccessException {
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        BooleanAttribute attribute = (BooleanAttribute)this.myData.getAttribute(attrName);
        if (attribute == null) {
            this.bcmStoreAndRegisterBooleanAttribute(attrName, value);
            return;
        }
        attribute.setValue(value);
    }

    private int handleGetIntHsAttr(String attrName, int undefinedValue, Coordinator c) throws MoAccessException {
        ManagedObject[] reservedBy = this.getReservedBy(c);
        RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
        if (cell != null) {
            if (!cell.isCombinedCell(c)) {
                return (Integer)cell.getAttribute(attrName, c);
            }
            MessageLog.trace(2, this.getClass(), "It is a combined cell, return the undefined value");
            return undefinedValue;
        }
        MessageLog.trace(2, this.getClass(), "The cell hasn't be created, read it from database");
        return this.bcmGetIntAttribute(attrName, c);
    }

    public int getCellRange(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "Enter getCellRange");
        int cellRange = this.getCarrierAttribute(c, "cellRange");
        return cellRange;
    }

    public int getMaxDlPowerCapability(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMaxDlPowerCapability()<---");
        int tempMaxDlPowerCapability = this.getCarrierAttribute(c, "maxDlPowerCapability");
        return tempMaxDlPowerCapability;
    }

    public int getMinDlPowerCapability(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMinDlPowerCapability()<---");
        int tempMinDlPowerCapability = this.getCarrierAttribute(c, "minDlPowerCapability");
        return tempMinDlPowerCapability;
    }

    public void setCellRange(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "Enter setCellRange");
        ValidateAttributes.checkTransaction(c);
        ValidateAttributes.intValueRangeCheck("cellRange", value, CarrierMo.CELL_RANGE_MIN_VALUES, CarrierMo.CELL_RANGE_MAX_VALUES, "Carrier");
        this.lrsProxy.setCarrierParam(0, c.getTransactionID(), this.getCellCarrierFroId(c), 5, value);
        this.sendAVC("cellRange", value, c);
        MessageLog.trace(2, this.getClass(), "CellRange is set");
        ManagedObject[] reservedBy = this.getReservedBy(c);
        if (reservedBy == null) {
            return;
        }
        if (reservedBy.length == 0) {
            return;
        }
        if (((RbsLocalCellMo)reservedBy[0]).isCombinedCell(c)) {
            ((BoamManagedObject)reservedBy[0]).sendAVC("cellRange", value, c);
        }
    }

    public int getDlPowerOffsetCombinedCell(Coordinator c) throws MoAccessException {
        return this.getCarrierAttribute(c, "dlPowerOffsetCombinedCell");
    }

    public int getEulLockedOptimalNoiseFloorEstimate(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getEulLockedOptimalNoiseFloorEstimate()<---");
        ChcEulGetCarrierParamRspS rspSig = this.chcEulProxy.getEulCarrierParameter(ValidateAttributes.getTxIdNonTransactional(c), 0, this.getCellCarrierFroId(c));
        if (rspSig.eulNoiseFloorLock == 1) {
            return rspSig.eulLockOptimalNoiseFloor;
        }
        return -1;
    }

    public int getEulMaxOwnUuLoad(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getEulMaxOwnUuLoad()<---");
        ChcEulGetCarrierParamRspS rspSig = this.chcEulProxy.getEulCarrierParameter(ValidateAttributes.getTxIdNonTransactional(c), 0, this.getCellCarrierFroId(c));
        return rspSig.eulMaxOwnUuLoad;
    }

    public int getEulMaxRotCoverage(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getEulMaxRotCoverage()<---");
        ChcEulGetCarrierParamRspS rspSig = this.chcEulProxy.getEulCarrierParameter(ValidateAttributes.getTxIdNonTransactional(c), 0, this.getCellCarrierFroId(c));
        return rspSig.eulMaxRotCoverage;
    }

    public Struct getEulOptimalNoiseFloorLock(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getEulOptimalNoiseFloorLock()<---");
        ChcEulGetCarrierParamRspS rspSig = this.chcEulProxy.getEulCarrierParameter(ValidateAttributes.getTxIdNonTransactional(c), 0, this.getCellCarrierFroId(c));
        int tmpEulNoiseFloorLockValue = rspSig.eulNoiseFloorLock;
        int tmpEulOptimalNoiseFloorEstimateValue = rspSig.eulOptimalNoiseFloorEstimate;
        return new EulOptimalNoiseFloorLockDataStruct(tmpEulNoiseFloorLockValue == 1, tmpEulOptimalNoiseFloorEstimateValue);
    }

    public int getEulSlidingWindowTime(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getEulSlidingWindowTime()<---");
        ChcEulGetCarrierParamRspS rspSig = this.chcEulProxy.getEulCarrierParameter(ValidateAttributes.getTxIdNonTransactional(c), 0, this.getCellCarrierFroId(c));
        return rspSig.eulSlidingWindowTime;
    }

    public int getEulThermalLevelPrior(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getEulThermalLevelPrior()<---");
        ChcEulGetCarrierParamRspS rspSig = this.chcEulProxy.getEulCarrierParameter(ValidateAttributes.getTxIdNonTransactional(c), 0, this.getCellCarrierFroId(c));
        return rspSig.eulThermalLevelPrior;
    }

    public int getFccRotMarginHigh(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFccRotMarginHigh()<---");
        ChcEulGetCarrierParamRspS rspSig = this.chcEulProxy.getEulCarrierParameter(ValidateAttributes.getTxIdNonTransactional(c), 0, this.getCellCarrierFroId(c));
        return rspSig.fccRotMarginHigh;
    }

    public int getFccRotMarginLow(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFccRotMarginLow()<---");
        ChcEulGetCarrierParamRspS rspSig = this.chcEulProxy.getEulCarrierParameter(ValidateAttributes.getTxIdNonTransactional(c), 0, this.getCellCarrierFroId(c));
        return rspSig.fccRotMarginLow;
    }

    public void setDlPowerOffsetCombinedCell(int value, Coordinator c) throws MoAccessException {
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("dlPowerOffsetCombinedCell", value, CarrierMo.DL_POWER_OFFSET_COMBINED_CELL_MIN_VALUES, CarrierMo.DL_POWER_OFFSET_COMBINED_CELL_MAX_VALUES, "Carrier");
        ManagedObject[] reservedBy = this.getReservedBy(c);
        RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
        if (cell != null) {
            if (cell.isCombinedCell(c)) {
                this.lrsProxy.setDlPowerOffsetCombinedCell(0, this.getTxIdTransactional(c), this.getCellCarrierFroId(c), value);
                this.sendAVC("dlPowerOffsetCombinedCell", value, c);
                return;
            }
            throw new ConfigurationNotSupportedException("For not a combined cell, it's not supported to set dlPowerOffsetCombinedCell in carrier");
        }
        throw new ActionNotAllowedException("CarrierMo", "No Cell is found!!!");
    }

    public void setEulMaxOwnUuLoad(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setEulMaxOwnUuLoad(" + value + ") <---");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("eulMaxOwnUuLoad", value, CarrierMo.EUL_MAX_OWN_UU_LOAD_MIN_VALUES, CarrierMo.EUL_MAX_OWN_UU_LOAD_MAX_VALUES, this.getType());
        ChcEulSettableCarrierParamsT[] params = new ChcEulSettableCarrierParamsT[]{new ChcEulSettableCarrierParamsT(1, value)};
        this.chcEulProxy.setEulCarrierParameters(this.getTxIdTransactional(c), 0, this.getCellCarrierFroId(c), params.length, params);
        this.sendAVC("eulMaxOwnUuLoad", value, c);
    }

    public void setEulMaxRotCoverage(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setEulMaxRotCoverage(" + value + ") <---");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("eulMaxRotCoverage", value, CarrierMo.EUL_MAX_ROT_COVERAGE_MIN_VALUES, CarrierMo.EUL_MAX_ROT_COVERAGE_MAX_VALUES, this.getType());
        ChcEulSettableCarrierParamsT[] params = new ChcEulSettableCarrierParamsT[]{new ChcEulSettableCarrierParamsT(0, value)};
        this.chcEulProxy.setEulCarrierParameters(this.getTxIdTransactional(c), 0, this.getCellCarrierFroId(c), params.length, params);
        this.sendAVC("eulMaxRotCoverage", value, c);
    }

    public void setEulOptimalNoiseFloorLock(Struct value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setEulOptimalNoiseFloorLock() <---");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        int tmpEulOptimalNoiseFloorEstimateValue = (Integer)value.getValue("eulOptimalNoiseFloorEstimate");
        int tmpEulNoiseFloorLockValue = (Boolean)value.getValue("eulNoiseFloorLock") != false ? 1 : 0;
        ValidateAttributes.intValueRangeCheck("eulOptimalNoiseFloorEstimate", tmpEulOptimalNoiseFloorEstimateValue, CarrierMo.EUL_OPTIMAL_NOISE_FLOOR_LOCK__EUL_OPTIMAL_NOISE_FLOOR_ESTIMATE_MIN_VALUES, CarrierMo.EUL_OPTIMAL_NOISE_FLOOR_LOCK__EUL_OPTIMAL_NOISE_FLOOR_ESTIMATE_MAX_VALUES, this.getType());
        ChcEulSettableCarrierParamsT[] params = new ChcEulSettableCarrierParamsT[]{new ChcEulSettableCarrierParamsT(3, tmpEulNoiseFloorLockValue), new ChcEulSettableCarrierParamsT(4, tmpEulOptimalNoiseFloorEstimateValue)};
        this.chcEulProxy.setEulCarrierParameters(this.getTxIdTransactional(c), 0, this.getCellCarrierFroId(c), params.length, params);
        this.sendAVC("eulOptimalNoiseFloorLock", value, c);
    }

    public void setEulSlidingWindowTime(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setEulSlidingWindowTime(" + value + ") <---");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("eulSlidingWindowTime", value, CarrierMo.EUL_SLIDING_WINDOW_TIME_MIN_VALUES, CarrierMo.EUL_SLIDING_WINDOW_TIME_MAX_VALUES, this.getType());
        if (!CarrierMoImpl.intResolutionValueRangeCheck(value, 10, 10, 864000)) {
            throw new ValueOutOfRangeException("eulSlidingWindowTime", "Carrier");
        }
        ChcEulSettableCarrierParamsT[] params = new ChcEulSettableCarrierParamsT[]{new ChcEulSettableCarrierParamsT(2, value)};
        this.chcEulProxy.setEulCarrierParameters(this.getTxIdTransactional(c), 0, this.getCellCarrierFroId(c), params.length, params);
        this.sendAVC("eulSlidingWindowTime", value, c);
    }

    public void setEulThermalLevelPrior(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setEulThermalLevelPrior(" + value + ") <---");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("eulThermalLevelPrior", value, CarrierMo.EUL_THERMAL_LEVEL_PRIOR_MIN_VALUES, CarrierMo.EUL_THERMAL_LEVEL_PRIOR_MAX_VALUES, this.getType());
        ChcEulSettableCarrierParamsT[] params = new ChcEulSettableCarrierParamsT[]{new ChcEulSettableCarrierParamsT(5, value)};
        this.chcEulProxy.setEulCarrierParameters(this.getTxIdTransactional(c), 0, this.getCellCarrierFroId(c), params.length, params);
        this.sendAVC("eulThermalLevelPrior", value, c);
    }

    public void setFccRotMarginHigh(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setFccRotMarginHigh(" + value + ") <---");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("fccRotMarginHigh", value, CarrierMo.FCC_ROT_MARGIN_HIGH_MIN_VALUES, CarrierMo.FCC_ROT_MARGIN_HIGH_MAX_VALUES, this.getType());
        ChcEulSettableCarrierParamsT[] params = new ChcEulSettableCarrierParamsT[]{new ChcEulSettableCarrierParamsT(7, value)};
        this.chcEulProxy.setEulCarrierParameters(this.getTxIdTransactional(c), 0, this.getCellCarrierFroId(c), params.length, params);
        this.sendAVC("fccRotMarginHigh", value, c);
    }

    public void setFccRotMarginLow(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setFccRotMarginLow(" + value + ") <---");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("fccRotMarginLow", value, CarrierMo.FCC_ROT_MARGIN_LOW_MIN_VALUES, CarrierMo.FCC_ROT_MARGIN_LOW_MAX_VALUES, this.getType());
        ChcEulSettableCarrierParamsT[] params = new ChcEulSettableCarrierParamsT[]{new ChcEulSettableCarrierParamsT(6, value)};
        this.chcEulProxy.setEulCarrierParameters(this.getTxIdTransactional(c), 0, this.getCellCarrierFroId(c), params.length, params);
        this.sendAVC("fccRotMarginLow", value, c);
    }

    public int getBadBerFramesDtxHsOlpc(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBadBerFramesDtxHsOlpc()");
        return this.getCarrierAttribute(c, "badBerFramesDtxHsOlpc");
    }

    public int getBadBerFramesHsOlpc(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBadBerFramesHsOlpc()");
        return this.getCarrierAttribute(c, "badBerFramesHsOlpc");
    }

    public int getNumOfDtxHsOlpc(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNumOfDtxHsOlpc()");
        return this.getCarrierAttribute(c, "numOfDtxHsOlpc");
    }

    public int getPeriodDtxHsOlpc(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPeriodDtxHsOlpc()");
        return this.getCarrierAttribute(c, "periodDtxHsOlpc");
    }

    public int getSirTargetStepHsOlpc(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSirTargetStepHsOlpc()");
        return this.getCarrierAttribute(c, "sirTargetStepHsOlpc");
    }

    public void setBadBerFramesDtxHsOlpc(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setBadBerFramesDtxHsOlpc(" + value + ") <---");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("badBerFramesDtxHsOlpc", value, CarrierMo.BAD_BER_FRAMES_DTX_HS_OLPC_MIN_VALUES, CarrierMo.BAD_BER_FRAMES_DTX_HS_OLPC_MAX_VALUES, "Carrier");
        this.lrsProxy.setBadBerFramesDtxHsOlpc(0, this.getTxIdTransactional(c), this.getCellCarrierFroId(c), value);
        this.sendAVC("badBerFramesDtxHsOlpc", value, c);
    }

    public void setBadBerFramesHsOlpc(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setBadBerFramesHsOlpc(" + value + ") <---");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("badBerFramesHsOlpc", value, CarrierMo.BAD_BER_FRAMES_HS_OLPC_MIN_VALUES, CarrierMo.BAD_BER_FRAMES_HS_OLPC_MAX_VALUES, "Carrier");
        this.lrsProxy.setBadBerFramesHsOlpc(0, this.getTxIdTransactional(c), this.getCellCarrierFroId(c), value);
        this.sendAVC("badBerFramesHsOlpc", value, c);
    }

    public void setNumOfDtxHsOlpc(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setNumOfDtxHsOlpc(" + value + ") <---");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("numOfDtxHsOlpc", value, CarrierMo.NUM_OF_DTX_HS_OLPC_MIN_VALUES, CarrierMo.NUM_OF_DTX_HS_OLPC_MAX_VALUES, "Carrier");
        this.lrsProxy.setNumOfDtxHsOlpc(0, this.getTxIdTransactional(c), this.getCellCarrierFroId(c), value);
        this.sendAVC("numOfDtxHsOlpc", value, c);
    }

    public void setPeriodDtxHsOlpc(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setPeriodDtxHsOlpc(" + value + ") <---");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("periodDtxHsOlpc", value, CarrierMo.PERIOD_DTX_HS_OLPC_MIN_VALUES, CarrierMo.PERIOD_DTX_HS_OLPC_MAX_VALUES, "Carrier");
        this.lrsProxy.setPeriodDtxHsOlpc(0, this.getTxIdTransactional(c), this.getCellCarrierFroId(c), value);
        this.sendAVC("periodDtxHsOlpc", value, c);
    }

    public void setSirTargetStepHsOlpc(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSirTargetStepHsOlpc(" + value + ") <---");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("sirTargetStepHsOlpc", value, CarrierMo.SIR_TARGET_STEP_HS_OLPC_MIN_VALUES, CarrierMo.SIR_TARGET_STEP_HS_OLPC_MAX_VALUES, "Carrier");
        this.lrsProxy.setSirTargetStepHsOlpc(0, this.getTxIdTransactional(c), this.getCellCarrierFroId(c), value);
        this.sendAVC("sirTargetStepHsOlpc", value, c);
    }

    public ManagedObject getDownlinkBaseBandPoolRef(Coordinator c) throws MoAccessException {
        return this.bcmGetReferenceAttribute("downlinkBaseBandPoolRef", c);
    }

    public void updateDownlinkBaseBandPoolRef(ManagedObject value, Coordinator c) throws MoAccessException {
        if (null != value && value instanceof DownlinkBaseBandPoolMo) {
            this.bcmSetReferenceAttribute("downlinkBaseBandPoolRef", value, "", c);
        }
    }

    public int[] getTxBranchesConfigured(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTxBranchesConfigured");
        int cellCarrierFroId = this.getCellCarrierFroId(c);
        LrsCarrierGetParamRspS rspSig = this.lrsProxy.carrierGetParam(0, this.getTxIdNonTransactional(c), cellCarrierFroId);
        int[] txBranchesConfigured = rspSig.txBranchesConfigured;
        txBranchesConfigured[0] = txBranchesConfigured[0] + 1;
        txBranchesConfigured[1] = txBranchesConfigured[1] + 1;
        return txBranchesConfigured;
    }

    public int getBaseBandPoolId(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBaseBandPoolId()");
        return this.getCarrierAttribute(c, "downlinkBaseBandPoolRef");
    }

    public int getNbirAlgorithm(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNbirAlgorithm()");
        return this.getCarrierAttribute(c, "nbirAlgorithm");
    }

    public void setNbirAlgorithm(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setNbirAlgorithm( " + value + " )");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("nbirAlgorithm", value, 1, 3, "Carrier");
        this.lrsProxy.setNbirAlgorithm(0, this.getTxIdTransactional(c), this.getCellCarrierFroId(c), value);
        this.sendAVC("nbirAlgorithm", value, c);
    }

    public int getNumOfBranchWithNbir(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNumOfBranchWithNbir()");
        return this.getCarrierAttribute(c, "numOfBranchWithNbir");
    }

    public int getNbirFixedNotchPosition(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNbirFixedNotchPosition()");
        return this.getCarrierAttribute(c, "nbirFixedNotchPosition");
    }

    public void setNbirFixedNotchPosition(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setNbirFixedNotchPosition( " + value + " )");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("nbirFixedNotchPosition", value, CarrierMo.NBIR_FIXED_NOTCH_POSITION_MIN_VALUES, CarrierMo.NBIR_FIXED_NOTCH_POSITION_MAX_VALUES, "Carrier");
        this.lrsProxy.setNbirFixedNotchPosition(0, this.getTxIdTransactional(c), this.getCellCarrierFroId(c), value);
        this.sendAVC("nbirFixedNotchPosition", value, c);
    }

    private boolean isChcMeasCounter(String name) {
        Iterator iter = CarrierMoFactory.instance().getChcCounters().iterator();
        boolean result2 = false;
        while (iter.hasNext()) {
            Counter counter = (Counter)iter.next();
            if (!counter.getName().equals(name)) continue;
            result2 = true;
            break;
        }
        return result2;
    }
}

