/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.cell;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcSectorAntennaProxy;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RiuMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;

public final class RiuMoImpl
extends BoamManagedObject
implements RiuMo {
    private static final Class SELF = RiuMoImpl.class;
    private static final boolean IS_MODATA_PERSISTENT = true;
    private static final int MO_DATA_REVISION = 8052200;
    private final EqcSectorAntennaProxy sectorAntennaProxy = EqcSectorAntennaProxy.instance();
    private final MoData moData;

    private RiuMoImpl(ManagedObject parent, String identity, String userLabel, Coordinator c) throws MoAccessException {
        super(parent, "Riu", identity, c, 1);
        MessageLog.traceEnter(SELF, "Normal constructor");
        int saFroid = ((SectorAntennaMo)parent).getFroId(c);
        this.sectorAntennaProxy.createDeleteRiu(this.getTxIdTransactional(c), 0, saFroid, true);
        this.moData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, c);
        this.initMoData(parent, userLabel, c);
        MessageLog.trace(1, SELF, "Riu MO is created: " + this);
    }

    public RiuMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(SELF, "Recovery constructor");
        this.moData = recoveredData;
        MessageLog.trace(1, SELF, "Riu MO is restored");
    }

    public static synchronized RiuMoImpl create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(RiuMoImpl.class, "create()");
        ValidateAttributes.checkTransaction(c);
        ValidateAttributes.checkParent(parent, "SectorAntenna");
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "Riu");
        ValidateAttributes.checkOtherAttributes(attributes, "Riu");
        return new RiuMoImpl(parent, identity, checkedUserLabel, c);
    }

    private MoData initMoData(ManagedObject parent, String userLabel, Coordinator c) throws MoAccessException {
        MessageLog.trace(1, SELF, "initMoData()");
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.moData.setRevision(8052200);
        this.moData.handleTransaction(c, MoData.WRITE_ACCESS);
        return null;
    }

    public void delete(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "delete()");
        this.moData.handleTransaction(c, MoData.WRITE_ACCESS);
        int saFroid = ((SectorAntennaMo)this.getParent()).getFroId(c);
        this.sectorAntennaProxy.createDeleteRiu(this.getTxIdTransactional(c), 0, saFroid, false);
        super.delete(c);
        MessageLog.trace(1, SELF, "Riu MO is deleted");
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(SELF, "getMyMoData()");
        return this.moData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(SELF, "isMyMoDataPersistent()");
        return true;
    }

    public String getType() {
        MessageLog.traceEnter(SELF, "getType()");
        return "Riu";
    }

    public String getUserLabel(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getUserLabel()");
        return this.bcmGetStringAttribute("userLabel", c);
    }

    public void setUserLabel(String value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setUserLabel()");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), c);
        this.sendAVC("userLabel", value, c);
    }
}

