/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import se.ericsson.cello.moframework.AttrNotReadableException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcPccpchProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetPccpchParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.BchMo;

public class BchMoImpl
extends BoamManagedObject
implements BchMo {
    private int pccpchFroId;
    private int bchFroId;
    private MoData myData;
    private ChcPccpchProxy chcPccpchProxy = ChcPccpchProxy.instance();

    public BchMoImpl(ManagedObject parent, int pccpchFroId, int bchFroId, String thisMoName, String identity) throws MoAccessException {
        super(parent, thisMoName, identity, null);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), false, null);
        this.pccpchFroId = pccpchFroId;
        this.bchFroId = bchFroId;
        MessageLog.trace(1, this.getClass(), "MO Created");
    }

    public static synchronized ManagedObject create(ManagedObject parent, int pccpchFroId, int bchFroId, String thisMoName, String identity) throws MoAccessException {
        MessageLog.traceEnter(BchMoImpl.class, "create()");
        BchMoImpl createdMo = new BchMoImpl(parent, pccpchFroId, bchFroId, thisMoName, identity);
        return createdMo;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteBch(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteBch()");
        if (super.isReserved(context)) {
            MessageLog.trace(1, this.getClass(), " this Mo is reserved and can not be deleted ");
            throw new UndeletableMoException((ManagedObject)this);
        }
        super.delete(context);
    }

    public String getType() {
        return "Bch";
    }

    public int getOperationalState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        LrsGetPccpchParamRspS rspSig = this.chcPccpchProxy.getPccpchParam(0, this.pccpchFroId);
        return rspSig.bchOpState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        LrsGetPccpchParamRspS rspSig = this.chcPccpchProxy.getPccpchParam(0, this.pccpchFroId);
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.bchAvailStatus);
    }

    public Struct actionReadNbapData(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionReadNbapData()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        LrsGetPccpchParamRspS rspSig = this.chcPccpchProxy.getPccpchParam(0, this.pccpchFroId);
        return this.convertSigToStruct(context, rspSig);
    }

    private Struct convertSigToStruct(Coordinator context, LrsGetPccpchParamRspS rspSig) throws MoAccessException {
        String[] names = new String[2];
        Object[] values = new Object[2];
        names[0] = "bchPower";
        names[1] = "trChId";
        Integer bchTranspChId = new Integer(rspSig.bchTranspChId);
        Integer bchPower = new Integer(rspSig.bchPower);
        values[0] = bchPower;
        values[1] = bchTranspChId;
        if (rspSig.nbapIsValid == 1) {
            StructImpl status = new StructImpl(names, values);
            return status;
        }
        String msg = " Nbap data is not valid ";
        MessageLog.traceError(this.getClass(), msg);
        throw new AttrNotReadableException((ManagedObject)this, this.getType() + "DataNotValid");
    }

    public int getBchIsActive(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBchIsActive()");
        LrsGetPccpchParamRspS rspSig = this.chcPccpchProxy.getPccpchParam(0, this.pccpchFroId);
        return rspSig.bchIsActive;
    }

    public void actionTurnBchOff(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionTurnBchOff(): Start");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.chcPccpchProxy.turnBchTransOff(0, this.pccpchFroId);
    }

    public void actionResumeBch(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionResumeBch(): Start");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.chcPccpchProxy.resumeBch(0, this.pccpchFroId);
    }

    public int getPccpchFroId() {
        MessageLog.traceEnter(this.getClass(), "getPccpchFroId()");
        return this.pccpchFroId;
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return false;
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.bchFroId;
    }
}

