/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.AttrNotSettableException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcCommContextsProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcRlsProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.BcGetCcParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetOngoingRlsActRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsRlsGetCcMacl1RspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.AlreadyActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.AlreadyActiveOnRelatedDchException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.MeasurementPeriodOverlapException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.UnknownCcIdException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.struct.MacHsL1ParamCcStruct;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CommContextsMo;

public class CommContextsMoImpl
extends BoamManagedObject
implements CommContextsMo {
    private static CommContextsMoImpl theOneAndOnly;
    private static final String BER_MODE = "berMode";
    private static int[] START_BLER_MEAS_TIME_POSSIBLE_VALUES;
    private static int[] START_BER_DPCCH_MEAS_TIME_POSSIBLE_VALUES;
    private static int[] START_BER_MEAS_TIME_POSSIBLE_VALUES;
    public static final int MO_DATA_REVISION = 4030001;
    private MoData myData;
    private ChcCommContextsProxy chcCommContextsProxy = ChcCommContextsProxy.instance();
    private ChcRlsProxy chcRlsProxy = ChcRlsProxy.instance();

    public CommContextsMoImpl(ManagedObject parent, String motypeName, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        super(parent, motypeName, identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.initMoData(attributes, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        MessageLog.trace(1, this.getClass(), "MO Created");
    }

    public CommContextsMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(this.getClass(), "Recovery constructor, CommContextsImpl()");
        this.myData = recoveredData;
        theOneAndOnly = this;
        MessageLog.trace(1, this.getClass(), "MO is Recovered, version Attribute in MoData = " + this.myData.getRevision());
    }

    public static synchronized CommContextsMoImpl instance(ManagedObject parent, String thisMoName, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(CommContextsMoImpl.class, "instance()");
        if (theOneAndOnly != null) {
            throw new MoCanNotBeCreatedException(thisMoName);
        }
        theOneAndOnly = new CommContextsMoImpl(parent, thisMoName, attributes, identity, source, context);
        return theOneAndOnly;
    }

    public static synchronized CommContextsMoImpl getTheOneAndOnly() {
        MessageLog.traceEnter(CommContextsMoImpl.class, "getTheOneAndOnly()");
        return theOneAndOnly;
    }

    public static synchronized void _reset_onlyForTest() {
        MessageLog.traceEnter(CommContextsMoImpl.class, "_reset_onlyForTest()");
        theOneAndOnly = null;
    }

    public String getType() {
        return "CommContexts";
    }

    public String getCommContextsId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCommContextsId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public int getNoOfCommContexts(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNoOfCommContexts()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        BcGetCcParamRspS rspSig = this.chcCommContextsProxy.getCcParam(0, this.getTxIdNonTransactional(context));
        return rspSig.noOfCommContexts;
    }

    public void actionStartOutOfSyncDuration(int ccId, int measPeriod, int measTime, int l3ReportPeriod, String fileName, Coordinator context) throws MoAccessException, UnknownCcIdException, AlreadyActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStartOutOfSyncDuration()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        ValidateAttributes.intValueRangeCheck("measPeriod", measPeriod, 1, 65535, "CommContexts");
        ValidateAttributes.intValueRangeCheck("measTime", measTime, 1, 65535, "CommContexts");
        if (l3ReportPeriod == 6000 || l3ReportPeriod < 1 || l3ReportPeriod > 6060) {
            throw new ValueOutOfRangeException("l3ReportPeriodhas bad incoming value : " + l3ReportPeriod, "CommContexts");
        }
        if (fileName == null) {
            String msg = "fileName == null";
            MessageLog.trace(2, this.getClass(), msg);
            throw new AttrNotSettableException((ManagedObject)this, msg);
        }
        try {
            this.chcRlsProxy.startOosDurDpch(0, ccId, measPeriod, measTime, l3ReportPeriod, fileName);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 6) {
                throw new UnknownCcIdException();
            }
            if (e.getOrgErrorCode() == 29) {
                throw new AlreadyActiveException();
            }
            throw e;
        }
    }

    public void actionStopOutOfSyncDuration(int ccId, Coordinator context) throws MoAccessException, UnknownCcIdException, NotActiveException, MeasurementPeriodOverlapException {
        MessageLog.traceEnter(this.getClass(), "actionStopOutOfSyncDuration()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        try {
            this.chcRlsProxy.stopOosDurDpch(0, ccId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 6) {
                throw new UnknownCcIdException();
            }
            if (e.getOrgErrorCode() == 30) {
                throw new NotActiveException();
            }
            if (e.getOrgErrorCode() == 4) {
                throw new MeasurementPeriodOverlapException();
            }
            throw e;
        }
    }

    public void actionStartSir(int ccId, String fileName, Coordinator context) throws MoAccessException, UnknownCcIdException, AlreadyActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStartSir()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        if (fileName == null) {
            String msg = "fileName == null";
            MessageLog.trace(2, this.getClass(), msg);
            throw new AttrNotSettableException((ManagedObject)this, msg);
        }
        try {
            this.chcRlsProxy.startUlSirDpch(0, ccId, fileName);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 6) {
                throw new UnknownCcIdException();
            }
            if (e.getOrgErrorCode() == 29) {
                throw new AlreadyActiveException();
            }
            throw e;
        }
    }

    public void actionStopSir(int ccId, Coordinator context) throws MoAccessException, UnknownCcIdException, NotActiveException, InternalErrorException {
        MessageLog.traceEnter(this.getClass(), "actionStopSir()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        try {
            this.chcRlsProxy.stopUlSirDpch(0, ccId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 6) {
                throw new UnknownCcIdException();
            }
            if (e.getOrgErrorCode() == 30) {
                throw new NotActiveException();
            }
            if (e.getOrgErrorCode() == 5) {
                throw new InternalErrorException();
            }
            throw e;
        }
    }

    public void actionStartPn(int ccId, int dchId, int pnTfi, Coordinator context) throws MoAccessException, InternalErrorException, AlreadyActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStartPn()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        ValidateAttributes.intValueRangeCheck("dchId", dchId, 0, 255, "CommContexts");
        ValidateAttributes.intValueRangeCheck("pnTfi", pnTfi, 0, 31, "CommContexts");
        try {
            this.chcRlsProxy.startPnGenDch(0, ccId, dchId, pnTfi);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 8) {
                throw new AlreadyActiveException();
            }
            throw e;
        }
    }

    public void actionStopPn(int ccId, int dchId, Coordinator context) throws MoAccessException, InternalErrorException, NotActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStopPn()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        ValidateAttributes.intValueRangeCheck("dchId", dchId, 0, 255, "CommContexts");
        try {
            this.chcRlsProxy.stopPnGenDch(0, ccId, dchId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 11) {
                throw new NotActiveException();
            }
            throw e;
        }
    }

    public Struct actionGetActivePn(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionGetActivePn()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        LrsGetOngoingRlsActRspS rspSig = this.chcRlsProxy.getOngoingRlsAct(0, 15, 6);
        return this.convertSigToStructTwoParam(rspSig, "noOfActivePn");
    }

    public void actionStartPnDpdch(int ccId, Coordinator context) throws MoAccessException, InternalErrorException, AlreadyActiveOnRelatedDchException, UnknownCcIdException {
        MessageLog.traceEnter(this.getClass(), "actionStartPnDpdch()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        try {
            this.chcRlsProxy.startPnGenDpdch(0, ccId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 10) {
                throw new AlreadyActiveException();
            }
            if (e.getOrgErrorCode() == 12) {
                throw new AlreadyActiveOnRelatedDchException();
            }
            if (e.getOrgErrorCode() == 6) {
                throw new UnknownCcIdException();
            }
            throw e;
        }
    }

    public void actionStopPnDpdch(int ccId, Coordinator context) throws MoAccessException, InternalErrorException, NotActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStopPnDpdch()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        try {
            this.chcRlsProxy.stopPnGenDpdch(0, ccId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 11) {
                throw new NotActiveException();
            }
            throw e;
        }
    }

    public Struct actionGetActivePnDpdch(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionGetActivePnDpdch()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        LrsGetOngoingRlsActRspS rspSig = this.chcRlsProxy.getOngoingRlsAct(0, 10, 6);
        return this.convertSigToStructOneParam(rspSig, "noOfActivePn");
    }

    public void actionStartBler(int ccId, int dchId, int measTime, String fileName, Coordinator context) throws MoAccessException, InternalErrorException, AlreadyActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStartBler()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        ValidateAttributes.intValueRangeCheck("dchId", dchId, 0, 255, "CommContexts");
        ValidateAttributes.intValueInSetCheck("measTime", measTime, START_BLER_MEAS_TIME_POSSIBLE_VALUES, "CommContexts");
        if (fileName == null) {
            String msg = "fileName == null";
            MessageLog.trace(2, this.getClass(), msg);
            throw new AttrNotSettableException((ManagedObject)this, msg);
        }
        try {
            this.chcRlsProxy.startBlerDch(0, ccId, dchId, measTime, fileName);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 27) {
                throw new AlreadyActiveException();
            }
            throw e;
        }
    }

    public void actionStartBerDpcch(int ccId, int measTime, String fileName, Coordinator context) throws MoAccessException, InternalErrorException, AlreadyActiveException, AlreadyActiveOnRelatedDchException {
        MessageLog.traceEnter(this.getClass(), "actionStartBerDpcch()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        ValidateAttributes.intValueInSetCheck("measTime", measTime, START_BER_DPCCH_MEAS_TIME_POSSIBLE_VALUES, "CommContexts");
        if (fileName == null) {
            String msg = "fileName == null";
            MessageLog.trace(2, this.getClass(), msg);
            throw new AttrNotSettableException((ManagedObject)this, msg);
        }
        try {
            this.chcRlsProxy.startBerDpcch(0, ccId, measTime, fileName);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 23) {
                throw new AlreadyActiveException();
            }
            if (e.getOrgErrorCode() == 20) {
                throw new AlreadyActiveOnRelatedDchException();
            }
            throw e;
        }
    }

    public void actionStartBerDpdch(int ccId, int dchId, int measPeriod, String fileName, Coordinator context) throws MoAccessException, InternalErrorException, AlreadyActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStartBerDpdch()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        ValidateAttributes.intValueRangeCheck("dchId", dchId, 0, 255, "CommContexts");
        ValidateAttributes.intValueRangeCheck("measPeriod", measPeriod, 1, 50, "CommContexts");
        if (fileName == null) {
            String msg = "fileName == null";
            MessageLog.trace(2, this.getClass(), msg);
            throw new AttrNotSettableException((ManagedObject)this, msg);
        }
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        try {
            this.chcRlsProxy.startBerDpdch(0, ccId, dchId, measPeriod, fileName);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 23) {
                throw new AlreadyActiveException();
            }
            throw e;
        }
    }

    public void actionStopBerDpcch(int ccId, Coordinator context) throws MoAccessException, InternalErrorException, NotActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStopBerDpcch()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        try {
            this.chcRlsProxy.stopBerDpcch(0, ccId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 24) {
                throw new NotActiveException();
            }
            throw e;
        }
    }

    public void actionStopBerDpdch(int ccId, int dchId, Coordinator context) throws MoAccessException, InternalErrorException, NotActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStopBerDpdch()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        ValidateAttributes.intValueRangeCheck("dchId", dchId, 0, 255, "CommContexts");
        try {
            this.chcRlsProxy.stopBerDpdch(0, ccId, dchId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 16) {
                throw new NotActiveException();
            }
            throw e;
        }
    }

    public Struct actionGetActiveBerDpdch(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionGetActiveBerDpdch()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        LrsGetOngoingRlsActRspS rspSig = this.chcRlsProxy.getOngoingRlsAct(0, 10, 0);
        return this.convertSigToStructTwoParam(rspSig, "noOfActiveBer");
    }

    public Struct actionGetActiveBerDpcch(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionGetActiveBerDpcch()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        LrsGetOngoingRlsActRspS rspSig = this.chcRlsProxy.getOngoingRlsAct(0, 9, 0);
        return this.convertSigToStructOneParam(rspSig, "noOfActiveBer");
    }

    public void actionStopBler(int ccId, int dchId, Coordinator context) throws MoAccessException, InternalErrorException, NotActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStopBler()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        ValidateAttributes.intValueRangeCheck("dchId", dchId, 0, 255, "CommContexts");
        try {
            this.chcRlsProxy.stopBlerDch(0, ccId, dchId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 28) {
                throw new NotActiveException();
            }
            throw e;
        }
    }

    public Struct actionGetActiveBler(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionGetActiveBler()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        LrsGetOngoingRlsActRspS rspSig = this.chcRlsProxy.getOngoingRlsAct(0, 15, 3);
        return this.convertSigToStructTwoParam(rspSig, "noOfActiveBler");
    }

    public void actionStartBer(int ccId, int dchId, int pnMeasType, int measTime, String fileName, Coordinator context) throws MoAccessException, InternalErrorException, AlreadyActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStartBer()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        ValidateAttributes.intValueRangeCheck("dchId", dchId, 0, 255, "CommContexts");
        ValidateAttributes.intValueRangeCheck("pnMeasType", pnMeasType, 0, 1, "CommContexts");
        ValidateAttributes.intValueInSetCheck("measTime", measTime, START_BER_MEAS_TIME_POSSIBLE_VALUES, "CommContexts");
        if (fileName == null) {
            String msg = "fileName == null";
            MessageLog.trace(2, this.getClass(), msg);
            throw new AttrNotSettableException((ManagedObject)this, msg);
        }
        try {
            this.chcRlsProxy.startBerDch(0, ccId, dchId, pnMeasType, measTime, fileName);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 13) {
                throw new AlreadyActiveException();
            }
            throw e;
        }
        IntegerAttribute intAttr = (IntegerAttribute)this.myData.getAttribute(BER_MODE);
        intAttr.setValue(pnMeasType);
    }

    public void actionStopBer(int ccId, int dchId, Coordinator context) throws MoAccessException, InternalErrorException, NotActiveException {
        MessageLog.traceEnter(this.getClass(), "actionStopBer()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        ValidateAttributes.intValueRangeCheck("dchId", dchId, 0, 255, "CommContexts");
        try {
            this.chcRlsProxy.stopBerDch(0, ccId, dchId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 14) {
                throw new NotActiveException();
            }
            throw e;
        }
    }

    public Struct actionGetActiveBer(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionGetActiveBer()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        IntegerAttribute intAttr = (IntegerAttribute)this.myData.getAttribute(BER_MODE);
        int berMode = intAttr.getValue(context);
        int berModePlus = berMode + 1;
        LrsGetOngoingRlsActRspS rspSig = this.chcRlsProxy.getOngoingRlsAct(0, 15, berModePlus);
        return this.convertSigToStructTwoParam(rspSig, "noOfActiveBer");
    }

    public void actionSetSirTarget(int ccId, int sirTarget, Coordinator context) throws MoAccessException, InternalErrorException {
        MessageLog.traceEnter(this.getClass(), "actionSetSirTarget()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        ValidateAttributes.intValueRangeCheck("sirTarget", sirTarget, -82, 173, "CommContexts");
        try {
            this.chcRlsProxy.setRlsSirTarget(0, ccId, sirTarget);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new InternalErrorException();
            }
            throw e;
        }
    }

    public Struct actionGetActiveSir(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionGetActiveSir()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        LrsGetOngoingRlsActRspS rspSig = this.chcRlsProxy.getOngoingRlsAct(0, 8, 5);
        return this.convertSigToStructOneParam(rspSig, "noOfActiveSir");
    }

    public Struct actionGetActiveOutOfSyncDuration(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionGetActiveOutOfSyncDuration()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        LrsGetOngoingRlsActRspS rspSig = this.chcRlsProxy.getOngoingRlsAct(0, 8, 4);
        return this.convertSigToStructOneParam(rspSig, "noOfActiveOOS");
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(CommContextsMoImpl.class, "isMyMoDataPersistent()");
        return true;
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public void proxiesUnavailable() {
        MessageLog.traceEnter(this.getClass(), "proxiesUnavailable()");
    }

    public void proxiesAvailable() {
        MessageLog.traceEnter(this.getClass(), "proxiesAvailable()");
    }

    public void delete(Coordinator c) throws UndeletableMoException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        MessageLog.trace(1, this.getClass(), "MO is Undeletable");
        throw new UndeletableMoException((ManagedObject)this);
    }

    private void initMoData(AttrList attributes, Coordinator context) throws MoAccessException, TransactionRequiredException, AttrMissingAtCreateException, WrongAttributeTypeException, NotHandledAttributeTypeException, ValueOutOfRangeException {
        try {
            MessageLog.traceEnter(this.getClass(), "initMoData()");
            this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
            IntegerAttribute berMode = new IntegerAttribute(BER_MODE, false);
            this.myData.registerPersistentAttr((Attribute)berMode);
            berMode.setValue(1);
            this.myData.setRevision(4030001);
        }
        catch (MoAccessException e) {
            super.delete(context);
            MessageLog.traceError(this.getClass(), "initiation of the DataBase failed");
            throw e;
        }
    }

    private Struct convertSigToStructOneParam(LrsGetOngoingRlsActRspS rspSig, String activityType) {
        String[] names = new String[2];
        Object[] values = new Object[2];
        Integer[] ccId = new Integer[rspSig.noOfEntries];
        Integer noOfActiveEntries = new Integer(rspSig.noOfEntries);
        for (int i = 0; i < rspSig.noOfEntries; ++i) {
            ccId[i] = new Integer(rspSig.actList[i].ccId);
        }
        values[0] = noOfActiveEntries;
        values[1] = ccId;
        names[0] = activityType;
        names[1] = "ccId";
        StructImpl status = new StructImpl(names, values);
        return status;
    }

    private Struct convertSigToStructTwoParam(LrsGetOngoingRlsActRspS rspSig, String activityType) {
        String[] names = new String[3];
        Object[] values = new Object[3];
        Integer[] ccId = new Integer[rspSig.noOfEntries];
        Integer[] dchId = new Integer[rspSig.noOfEntries];
        Integer noOfActiveEntries = new Integer(rspSig.noOfEntries);
        for (int i = 0; i < rspSig.noOfEntries; ++i) {
            ccId[i] = new Integer(rspSig.actList[i].ccId);
            dchId[i] = new Integer(rspSig.actList[i].dchId);
        }
        values[0] = noOfActiveEntries;
        values[1] = ccId;
        values[2] = dchId;
        names[0] = activityType;
        names[1] = "ccId";
        names[2] = "dchId";
        StructImpl status = new StructImpl(names, values);
        return status;
    }

    public void actionReleaseMacHsL1ParamCcPqHidden(int ccId, Coordinator c) throws MoAccessException, UnknownCcIdException {
        MessageLog.traceEnter(this.getClass(), "actionReleaseMacHsL1ParamCcPqHidden()<---");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 65535, "CommContexts");
        try {
            this.chcRlsProxy.releaseMacHsL1ParamCCPQHidden(0, ccId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 6) {
                throw new UnknownCcIdException();
            }
            throw e;
        }
    }

    public Struct actionReadMacHsL1ParamCcHidden(int ccId, Coordinator c) throws MoAccessException, UnknownCcIdException {
        MessageLog.traceEnter(this.getClass(), "actionReadMacHsL1ParamCcHidden()<---");
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 65535, "CommContexts");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 65535, "CommContexts");
        MacHsL1ParamCcStruct struct = null;
        try {
            LrsRlsGetCcMacl1RspS rspSig = this.chcRlsProxy.readMacHsL1ParamCCHidden(0, ccId);
            struct = new MacHsL1ParamCcStruct(rspSig.aDpchSyncStateMode, rspSig.aDpchSyncState, rspSig.rxQualAchievableMode, rspSig.rxQualAchievable);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 6) {
                throw new UnknownCcIdException();
            }
            throw e;
        }
        return struct;
    }

    public void actionSetMacHsL1ParamCcHidden(int ccId, int aDpchSyncStateMode, int aDpchSyncState, int rxQualAchievableMode, int rxQualAchievable, Coordinator c) throws MoAccessException, UnknownCcIdException, InternalErrorException {
        MessageLog.traceEnter(this.getClass(), "actionSetMacHsL1ParamCcHidden()<---");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        if (aDpchSyncState != 255) {
            ValidateAttributes.intValueRangeCheck("aDpchSyncState", aDpchSyncState, 0, 1, "CommContexts");
        }
        if (rxQualAchievable != 65535) {
            ValidateAttributes.intValueRangeCheck("rxQualAchievable", rxQualAchievable, 0, 3000, "CommContexts");
        }
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 65535, "CommContexts");
        ValidateAttributes.intValueRangeCheck("aDpchSyncStateMode", aDpchSyncStateMode, 0, 3, "CommContexts");
        ValidateAttributes.intValueRangeCheck("rxQualAchievableMode", rxQualAchievableMode, 0, 3, "CommContexts");
        try {
            this.chcRlsProxy.setMacHsL1ParamCCHidden(0, ccId, aDpchSyncStateMode, aDpchSyncState, rxQualAchievableMode, rxQualAchievable);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 6) {
                throw new UnknownCcIdException();
            }
            if (e.getOrgErrorCode() == 5) {
                throw new InternalErrorException();
            }
            throw e;
        }
    }

    public int[] getCcIdHiMonitoringStarted(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCcIdHiMonitoringStarted()<---");
        return this.chcRlsProxy.getHiMonitoring((int)0).ccIdHiMonitoringStarted;
    }

    public void actionStopHiMonitoring(int ccId, Coordinator c) throws MoAccessException, NotActiveException, UnknownCcIdException {
        MessageLog.traceEnter(this.getClass(), "actionStopHiMonitoring()<---");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        try {
            this.chcRlsProxy.stopHiMonitoring(0, ccId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 6) {
                throw new UnknownCcIdException();
            }
            if (e.getOrgErrorCode() == 33) {
                throw new NotActiveException();
            }
            throw e;
        }
    }

    public void actionStartHiMonitoring(int ccId, Coordinator c) throws MoAccessException, InternalErrorException, AlreadyActiveException, UnknownCcIdException {
        MessageLog.traceEnter(this.getClass(), "actionStartHiMonitoring()<---");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        try {
            this.chcRlsProxy.startHiMonitoring(0, ccId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 6) {
                throw new UnknownCcIdException();
            }
            if (e.getOrgErrorCode() == 5) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 32) {
                throw new AlreadyActiveException();
            }
            throw e;
        }
    }

    public void actionSetSirTargetSecondary(int ccId, int sirTarget, Coordinator context) throws MoAccessException, InternalErrorException, UnknownCcIdException {
        MessageLog.traceEnter(this.getClass(), "actionSetSirTargetSecondary()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("ccId", ccId, 0, 1048575, "CommContexts");
        ValidateAttributes.intValueRangeCheck("sirTarget", sirTarget, -82, 173, "CommContexts");
        sirTarget += 1000;
        try {
            this.chcRlsProxy.setRlsSirTarget(0, ccId, sirTarget);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new InternalErrorException();
            }
            throw e;
        }
    }

    static {
        START_BLER_MEAS_TIME_POSSIBLE_VALUES = new int[]{1, 13, 39, 180, 300, 600};
        START_BER_DPCCH_MEAS_TIME_POSSIBLE_VALUES = new int[]{1, 10, 130, 390, 1800, 3000, 6000};
        START_BER_MEAS_TIME_POSSIBLE_VALUES = new int[]{1, 13, 39, 180, 300, 600};
    }
}

