/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import enea.ose.system.InSignal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroStateObserver;
import se.ericsson.wcdma.rbs.boam.common.PlugAndPlayObserver;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcHsdpaProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsHsdpaHsdschCreatedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsHsdpaHsdschDeletedIndS;
import se.ericsson.wcdma.rbs.boam.mao.common.PmCounterSetup;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.HsDschResourcesMoImpl;
import se.ericsson.wcdma.rbs.boam.pms.iface.PmCapableMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterGroup;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScannerAgent;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;
import se.ericsson.wcdma.rbs.boam.pms.impl.PredefinedScannerMgr;

public class HsDschResourcesMoFactory
implements PmCapableMoFactory,
PlugAndPlayObserver,
FroStateObserver {
    private static HsDschResourcesMoFactory instance = null;
    public static final int CLIENT_ID = 0;
    public static final int CM_OPERATION_OK = 0;
    private final List counterList = new ArrayList();
    private HashMap hsDschResList = new HashMap(6);

    private HsDschResourcesMoFactory() {
        MessageLog.traceEnter(this.getClass(), "constructor");
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
        ChcHsdpaProxy.instance().registerForPlugAndPLayInd(null, this, -16L);
        ChcHsdpaProxy.instance().registerForStatePropagation(null, this);
        this.setupCounter();
        this.setupRbsPredefScanner();
    }

    public static synchronized HsDschResourcesMoFactory instance() {
        if (instance == null) {
            instance = new HsDschResourcesMoFactory();
        }
        return instance;
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMo()");
        throw new MoCanNotBeCreatedException(this.getMoTypeName());
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo()");
        return null;
    }

    public synchronized void createInd(InSignal createInd) {
        MessageLog.traceEnter(this.getClass(), "createInd()");
        ManagedObject hsDschResMo = null;
        LrsHsdpaHsdschCreatedIndS indicationSig = (LrsHsdpaHsdschCreatedIndS)createInd;
        try {
            hsDschResMo = HsDschResourcesMoImpl.createHsDschResources(indicationSig);
            Integer froId = new Integer(indicationSig.cellFroId);
            this.hsDschResList.put(froId, hsDschResMo);
        }
        catch (Throwable e) {
            MessageLog.traceError(this.getClass(), "Mo couldn't be created, froId: " + indicationSig.cellFroId + ", " + e);
        }
    }

    public synchronized void deleteInd(InSignal deleteInd) {
        MessageLog.traceEnter(this.getClass(), "deleteInd()");
        LrsHsdpaHsdschDeletedIndS indicationSig = (LrsHsdpaHsdschDeletedIndS)deleteInd;
        try {
            this.deleteHsDschResources(indicationSig.cellFroId);
        }
        catch (Throwable e) {
            MessageLog.traceError(this.getClass(), "Mo couldn't be deleted, froId: " + indicationSig.cellFroId + ", " + e);
        }
    }

    public String getMoTypeName() {
        return "HsDschResources";
    }

    public void serviceAvailable(String proxyName) {
        MessageLog.traceEnter(this.getClass(), "serviceAvailable()" + proxyName);
    }

    public void serviceRemoved(String proxyName) {
        MessageLog.traceEnter(this.getClass(), "serviceRemoved()" + proxyName);
        try {
            this.deleteAll();
        }
        catch (Throwable t) {
            MessageLog.traceError(this.getClass(), "HsDschResourcesMo could not be deleted when res. layer service lost " + t);
        }
    }

    public void plugAndPlayInd(InSignal pnpIndSig) {
        MessageLog.traceEnter(this.getClass(), "plugAndPlayInd()");
        if (pnpIndSig == null) {
            MessageLog.traceError(this.getClass(), "The received signal is null!!");
            return;
        }
        if (pnpIndSig.getClass().getName().equals(LrsHsdpaHsdschCreatedIndS.class.getName())) {
            this.createInd(pnpIndSig);
        } else if (pnpIndSig.getClass().getName().equals(LrsHsdpaHsdschDeletedIndS.class.getName())) {
            this.deleteInd(pnpIndSig);
        } else {
            MessageLog.traceError(this.getClass(), "unexpected signal is received!! recSig:" + pnpIndSig.getClass().getName());
        }
    }

    private synchronized void deleteAll() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteAll()");
        Collection set = this.hsDschResList.values();
        Iterator objs = set.iterator();
        HsDschResourcesMoImpl tmpObj = null;
        while (objs.hasNext()) {
            tmpObj = (HsDschResourcesMoImpl)objs.next();
            tmpObj.moScannerServiceNotAvailable();
            tmpObj.sysDelete(null);
        }
        this.hsDschResList.clear();
    }

    private void deleteHsDschResources(int froId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteHsDschResources()");
        Integer key = new Integer(froId);
        HsDschResourcesMoImpl hsDschResourcesMoImpl = (HsDschResourcesMoImpl)this.hsDschResList.get(key);
        if (hsDschResourcesMoImpl == null) {
            throw new MoNotFoundException("Couldn't find HsDschResourcesMo related to carrier froId:" + froId);
        }
        hsDschResourcesMoImpl.sysDelete(null);
        this.hsDschResList.remove(key);
    }

    public List getCounters() {
        return this.counterList;
    }

    private void setupCounter() {
        try {
            PmCounterSetup.setupCounters(this.getMoTypeName(), this.counterList);
            CounterGroup cntGrp = new CounterGroup("pmsTbsGrp");
            this.counterList.add(new Counter("pmUsedTbs16Qam", 30, cntGrp));
            this.counterList.add(new Counter("pmAck16Qam", 30, cntGrp));
            this.counterList.add(new Counter("pmUsedTbsQpsk", 30, cntGrp));
            this.counterList.add(new Counter("pmAckQpsk", 30, cntGrp));
            this.counterList.add(new Counter("pmUsedTbs64Qam", 30, cntGrp));
            this.counterList.add(new Counter("pmAck64Qam", 30, cntGrp));
            this.counterList.add(new Counter("pmIubMacdPduCellReceivedBits", 1, null));
            cntGrp = new CounterGroup("pmstransmittedCarrierPowerHsGrp1");
            this.counterList.add(new Counter("pmTransmittedCarrierPowerNonHs", 52, cntGrp));
            this.counterList.add(new Counter("pmTransmittedCarrierPowerHs", 54, cntGrp));
            this.counterList.add(new Counter("pmTransmittedCarrierPowerWNonHs", 50, cntGrp));
            this.counterList.add(new Counter("pmTransmittedCarrierPowerWHs", 100, cntGrp));
            cntGrp = new CounterGroup("pmsHsDschDelayDistributionSpiGrp1");
            this.counterList.add(new Counter("pmDelayDistributionSpi00", 11, cntGrp));
            this.counterList.add(new Counter("pmDelayDistributionSpi01", 11, cntGrp));
            this.counterList.add(new Counter("pmDelayDistributionSpi02", 11, cntGrp));
            this.counterList.add(new Counter("pmDelayDistributionSpi03", 11, cntGrp));
            this.counterList.add(new Counter("pmDelayDistributionSpi04", 11, cntGrp));
            this.counterList.add(new Counter("pmDelayDistributionSpi05", 11, cntGrp));
            this.counterList.add(new Counter("pmDelayDistributionSpi06", 11, cntGrp));
            this.counterList.add(new Counter("pmDelayDistributionSpi07", 11, cntGrp));
            this.counterList.add(new Counter("pmDelayDistributionSpi08", 11, cntGrp));
            this.counterList.add(new Counter("pmDelayDistributionSpi09", 11, cntGrp));
            this.counterList.add(new Counter("pmDelayDistributionSpi10", 11, cntGrp));
            this.counterList.add(new Counter("pmDelayDistributionSpi11", 11, cntGrp));
            this.counterList.add(new Counter("pmDelayDistributionSpi12", 11, cntGrp));
            this.counterList.add(new Counter("pmDelayDistributionSpi13", 11, cntGrp));
            this.counterList.add(new Counter("pmDelayDistributionSpi14", 11, cntGrp));
            this.counterList.add(new Counter("pmDelayDistributionSpi15", 11, cntGrp));
            this.counterList.add(new Counter("pmCapacityHsDschUsers", 21, null));
            this.counterList.add(new Counter("pmCapacityAllocAttHsDschUsers", 1, null));
            this.counterList.add(new Counter("pmCapacityAllocRejHsDschUsers", 1, null));
            cntGrp = new CounterGroup("capacityNumHsDschUsers");
            this.counterList.add(new Counter("pmSumCapacityHsDschUsers", 1, cntGrp));
            this.counterList.add(new Counter("pmSumSqrCapacityHsDschUsers", 1, cntGrp));
            this.counterList.add(new Counter("pmSamplesCapacityHsDschUsers", 1, cntGrp));
            this.counterList.add(new Counter("pmCapacityHsPdschCodes", 11, null));
            this.counterList.add(new Counter("pmCapacityAllocAttHsPdschCodes", 1, null));
            this.counterList.add(new Counter("pmCapacityAllocRejHsPdschCodes", 1, null));
            cntGrp = new CounterGroup("capacityNumHsPdschCodes");
            this.counterList.add(new Counter("pmSumCapacityHsPdschCodes", 1, cntGrp));
            this.counterList.add(new Counter("pmSumSqrCapacityHsPdschCodes", 1, cntGrp));
            this.counterList.add(new Counter("pmSamplesCapacityHsPdschCodes", 1, cntGrp));
            this.counterList.add(new Counter("pmAllocRejHwHsDschUsers", 1, null));
            new MoScannerAgent(this.getMoTypeName(), this.counterList);
        }
        catch (PmsException pmse) {
            MessageLog.traceError(this.getClass(), "setupCounter(): Setup counters failed!!", (Throwable)((Object)pmse));
        }
    }

    public ManagedObject lookUpHsDschResMo(int cellCarrierFroId) {
        return (ManagedObject)this.hsDschResList.get(new Integer(cellCarrierFroId));
    }

    private void setupRbsPredefScanner() {
        MessageLog.traceEnter(this.getClass(), "setupRbsPredefScanner()");
        String[] classnames = new String[]{this.getMoTypeName()};
        String[][] counterArray = new String[][]{{"pmTransmittedCarrierPowerWHs", "pmTransmittedCarrierPowerWNonHs", "pmCapacityAllocAttHsDschUsers", "pmCapacityAllocRejHsDschUsers", "pmSumCapacityHsDschUsers", "pmSamplesCapacityHsDschUsers", "pmCapacityAllocAttHsPdschCodes", "pmCapacityAllocRejHsPdschCodes", "pmSumCapacityHsPdschCodes", "pmSamplesCapacityHsPdschCodes"}};
        PredefinedScannerMgr.instance().createPredefinedScanner("PREDEF.PRIMARY.STATS", classnames, counterArray, 5);
    }

    public static synchronized void _setupCounter_onlyForTest() {
        if (instance != null) {
            MoFactoryMgr.instance().deregister(instance.getMoTypeName());
            instance = null;
        }
    }
}

