/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import se.ericsson.cello.moframework.AttrNotReadableException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcSccpchProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetSccpchParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PchMo;

public class PchMoImpl
extends BoamManagedObject
implements PchMo {
    private int sccpchFroId;
    private int pchFroId;
    private MoData myData;
    private ChcSccpchProxy chcSccpchProxy = ChcSccpchProxy.instance();

    private PchMoImpl(ManagedObject parent, int sccpchFroId, int pchFroId, String thisMoName, String identity) throws MoAccessException {
        super(parent, thisMoName, identity, null);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), false, null);
        this.sccpchFroId = sccpchFroId;
        this.pchFroId = pchFroId;
        MessageLog.trace(1, this.getClass(), "MO Created");
    }

    public static synchronized ManagedObject create(ManagedObject parent, int sccpchFroId, int pchFroId, String thisMoName, String identity) throws MoAccessException {
        MessageLog.traceEnter(PchMoImpl.class, "create()");
        return new PchMoImpl(parent, sccpchFroId, pchFroId, thisMoName, identity);
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deletePch(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deletePch()");
        if (super.isReserved(context)) {
            MessageLog.trace(1, this.getClass(), " this Mo is reserved and can not be deleted ");
            throw new UndeletableMoException((ManagedObject)this);
        }
        super.delete(context);
    }

    public String getType() {
        return "Pch";
    }

    public String getPchId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPchId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public int getOperationalState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(0, this.sccpchFroId);
        return rspSig.pchOpState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(0, this.sccpchFroId);
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.pchAvailStatus);
    }

    public Struct actionReadNbapData(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionReadNbapData()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(0, this.sccpchFroId);
        return this.convertSigToStruct(context, rspSig);
    }

    public int getPnIsActive(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getPnIsActive()");
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(0, this.sccpchFroId);
        return rspSig.pchPnGenStatus;
    }

    public int getPnTfi(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getPnTfi()");
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(0, this.sccpchFroId);
        return rspSig.pchPnTfi;
    }

    public void actionStartPn(int pnTfi, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStartPn()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueRangeCheck("pnTfi", pnTfi, PN_TFI_MIN_VALUES, PN_TFI_MAX_VALUES, "Pch");
        this.chcSccpchProxy.startPnGenPchFach(0, this.sccpchFroId, this.pchFroId, 0, pnTfi);
    }

    public void actionStopPn(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStopPn()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.chcSccpchProxy.stopPnGenPchFach(0, this.sccpchFroId, this.pchFroId, 0);
    }

    private Struct convertSigToStruct(Coordinator context, LrsGetSccpchParamRspS rspSig) throws MoAccessException {
        String[] names = new String[8];
        Object[] values = new Object[8];
        names[0] = "trChId";
        names[1] = "pchPower";
        names[2] = "toAws";
        names[3] = "toAwe";
        names[4] = "codingRate";
        names[5] = "transTimeInt";
        names[6] = "crcSize";
        names[7] = "rateMatchingAttr";
        Integer pchTranspChId = new Integer(rspSig.pchTranspChId);
        Integer pchPower = new Integer(rspSig.pchPower);
        Integer pchToAWS = new Integer(rspSig.pchToAWS);
        Integer pchToAWE = new Integer(rspSig.pchToAWE);
        Integer pchCodingMode = new Integer(rspSig.pchCodingMode);
        Integer pchTti = new Integer(rspSig.pchTti);
        Integer pchCrcSize = new Integer(rspSig.pchCrcSize);
        Integer pchRateMatchingAttr = new Integer(rspSig.pchRateMatchingAttr);
        values[0] = pchTranspChId;
        values[1] = pchPower;
        values[2] = pchToAWS;
        values[3] = pchToAWE;
        values[4] = pchCodingMode;
        values[5] = pchTti;
        values[6] = pchCrcSize;
        values[7] = pchRateMatchingAttr;
        if (rspSig.nbapIsValid == 1) {
            StructImpl status = new StructImpl(names, values);
            return status;
        }
        MessageLog.trace(2, this.getClass(), "DataNotValid");
        throw new AttrNotReadableException((ManagedObject)this, this.getType() + "DataNotValid");
    }

    public int getSccpchFroId() {
        MessageLog.traceEnter(this.getClass(), "getSccpchFroId()");
        return this.sccpchFroId;
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return false;
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.pchFroId;
    }
}

