/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScCellCarrierProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsPcpichGetNbapParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsPcpichGetParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.CellNotSetupException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CarrierMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PcpichMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsLocalCellMo;

public class PcpichMoImpl
extends BoamManagedObject
implements PcpichMo {
    private static final String ID = "1";
    private static final String CELL_CARRIER_FRO_ID = "cellCarrierFroId";
    private final MoData myData;
    private final ScCellCarrierProxy lrsProxy = ScCellCarrierProxy.instance();

    public PcpichMoImpl(ManagedObject parent, AttrList attributes) throws MoAccessException {
        super(parent, "Pcpich", ID, null);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        ValidateAttributes.checkParent(parent, new String[]{"Carrier", "RbsLocalCell"});
        this.myData = this.initMoData(ID, attributes);
        MessageLog.trace(1, this.getClass(), "MO is created");
    }

    public void delete(Coordinator context) throws MoAccessException, UndeletableMoException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        if (super.isReserved(context)) {
            MessageLog.trace(1, this.getClass(), " this Mo is reserved and can not be deleted ");
            throw new UndeletableMoException((ManagedObject)this);
        }
        super.delete(context);
        MessageLog.trace(1, this.getClass(), "Mo is Deleted");
    }

    public String getType() {
        return "Pcpich";
    }

    public int getOperationalState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        ManagedObject parent = this.getParent();
        if (parent instanceof CarrierMo) {
            ManagedObject[] reservedBy = ((CarrierMo)parent).getReservedBy(context);
            RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
            return cell.getOperationalState(context);
        }
        return ((RbsLocalCellMo)parent).getOperationalState(context);
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        int availabilityStatus = this.getAttribute(context, "availabilityStatus");
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(availabilityStatus);
    }

    public Struct actionReadNbapData(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionReadNbapData()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        int cellCarrierFroId = ((IntegerAttribute)this.myData.getAttribute(CELL_CARRIER_FRO_ID)).getValue(context);
        try {
            LrsPcpichGetNbapParamRspS rspSig = this.lrsProxy.pcpichGetNbapParam(0, this.getTxIdNonTransactional(context), cellCarrierFroId);
            return this.convertSigToStruct(rspSig);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 12) {
                throw new CellNotSetupException();
            }
            throw e;
        }
    }

    private Struct convertSigToStruct(LrsPcpichGetNbapParamRspS rspSig) throws MoAccessException {
        String[] names = new String[]{"phChId", "pcpichReferencePower", "txDiversityIndicator"};
        Object[] values = new Object[]{new Integer(rspSig.pcpichCommonPhChId), new Integer(rspSig.pcpichReferencePower), new Integer(rspSig.pcpichTxDiversityIndicator)};
        return new StructImpl(names, values);
    }

    private int getAttribute(Coordinator context, String attributeName) throws MoAccessException, NoSuchAttributeException {
        MessageLog.traceEnter(this.getClass(), "getAttribute()");
        IntegerAttribute intAttribute = (IntegerAttribute)this.myData.getAttribute(CELL_CARRIER_FRO_ID);
        int cellCarrierFroId = intAttribute.getValue(context);
        LrsPcpichGetParamRspS rspSig = this.lrsProxy.pcpichGetParam(0, this.getTxIdNonTransactional(context), cellCarrierFroId);
        if (attributeName.equals("operationalState")) {
            return rspSig.pcpichOpState;
        }
        if (attributeName.equals("availabilityStatus")) {
            return rspSig.pcpichAvailStatus;
        }
        String msg = "Attribute LrsPcpichGetParamRspS." + attributeName + " no such attribute";
        MessageLog.trace(2, this.getClass(), msg);
        throw new NoSuchAttributeException(msg, this.getType());
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return false;
    }

    private MoData initMoData(String identity, AttrList attributes) throws TransactionRequiredException, MoNotFoundException, NotHandledAttributeTypeException, AttrMissingAtCreateException {
        MessageLog.traceEnter(this.getClass(), "initMoData()");
        MoData moData = new MoData(this.getLocalDistinguishedName(), "Pcpich", false, null);
        IntegerAttribute cellCarrierFroId = new IntegerAttribute(CELL_CARRIER_FRO_ID, false);
        moData.registerTransientAttr((Attribute)cellCarrierFroId);
        cellCarrierFroId.setValue(ValidateAttributes.checkAndGetIntAttribute(attributes, CELL_CARRIER_FRO_ID, "Pcpich"));
        return moData;
    }
}

