/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrNotReadableException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcSccpchProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetSccpchParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.AlreadyActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.MoDisabledException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DbchDeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PichMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.ChannelHelper;

public class PichMoImpl
extends BoamManagedObject
implements PichMo {
    private int CLIENT_ID = 0;
    private int sccpchFroId;
    private int pichFroId;
    private ManagedObject dbchDeviceSetRef;
    private MoData myData;
    private ChcSccpchProxy chcSccpchProxy = ChcSccpchProxy.instance();

    private PichMoImpl(ManagedObject parent, int sccpchFroId, int pichFroId, int pichDevSetFroId, String thisMoName, String identity) throws MoAccessException {
        super(parent, thisMoName, identity, null);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), false, null);
        this.sccpchFroId = sccpchFroId;
        this.pichFroId = pichFroId;
        this.dbchDeviceSetRef = (DbchDeviceSetMo)ChannelHelper.resolveDeviceSetRefAndReserve(pichDevSetFroId, "DbchDeviceSet", this);
        MessageLog.trace(1, this.getClass(), "MO Created");
    }

    public static synchronized ManagedObject create(ManagedObject parent, int sccpchFroId, int pichFroId, int pichDevSetFroId, String thisMoName, String identity) throws MoAccessException {
        MessageLog.traceEnter(PichMoImpl.class, "create()");
        return new PichMoImpl(parent, sccpchFroId, pichFroId, pichDevSetFroId, thisMoName, identity);
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deletePich(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deletePich()");
        if (super.isReserved(context)) {
            MessageLog.trace(1, this.getClass(), " this Mo is reserved and can not be deleted ");
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.dbchDeviceSetRef = this.getDbchDeviceSetRef(context);
        if (this.dbchDeviceSetRef != null) {
            ((Reservable)this.dbchDeviceSetRef).release((ManagedObject)this, null);
        }
        super.delete(context);
    }

    public String getType() {
        return "Pich";
    }

    public int getOperationalState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(this.CLIENT_ID, this.sccpchFroId);
        return rspSig.pichOpState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(this.CLIENT_ID, this.sccpchFroId);
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.pichAvailStatus);
    }

    public int getPiTestPtrnIsActive(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getPiTestPtrnIsActive()");
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(this.CLIENT_ID, this.sccpchFroId);
        return rspSig.pichTestPatternIsActive;
    }

    public ManagedObject getDbchDeviceSetRef(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getDbchDeviceSetRef()");
        return this.dbchDeviceSetRef;
    }

    public void actionStartPiTestPtrn(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStartPiTestPtrn()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        try {
            this.chcSccpchProxy.startPiTestPattern(this.CLIENT_ID, this.pichFroId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 1) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 8) {
                throw new MoDisabledException();
            }
            if (e.getOrgErrorCode() == 4) {
                throw new AlreadyActiveException();
            }
            throw e;
        }
    }

    public void actionStopPiTestPtrn(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStopPiTestPtrn()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        try {
            this.chcSccpchProxy.stopPiTestPattern(this.CLIENT_ID, this.pichFroId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 1) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 4) {
                throw new NotActiveException();
            }
            throw e;
        }
    }

    public Struct actionReadNbapData(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionReadNbapData()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(this.CLIENT_ID, this.sccpchFroId);
        return this.convertSigToStruct(context, rspSig);
    }

    private Struct convertSigToStruct(Coordinator context, LrsGetSccpchParamRspS rspSig) throws MoAccessException, AttrNotReadableException {
        String[] names = new String[4];
        Object[] values = new Object[4];
        names[0] = "phChId";
        names[1] = "pichDlChannelisationCodeNo";
        names[2] = "pichPower";
        names[3] = "pichMode";
        Integer pichPhysChId = new Integer(rspSig.pichPhysChId);
        Integer pichDlChanCodeNo = new Integer(rspSig.pichDlChanCodeNo);
        Integer pichPower = new Integer(rspSig.pichPower);
        Integer pichMode = new Integer(rspSig.pichMode);
        values[0] = pichPhysChId;
        values[1] = pichDlChanCodeNo;
        values[2] = pichPower;
        values[3] = pichMode;
        if (rspSig.nbapIsValid == 1) {
            StructImpl status = new StructImpl(names, values);
            return status;
        }
        MessageLog.trace(2, this.getClass(), " Nbap data is not valid ");
        throw new AttrNotReadableException((ManagedObject)this, "NbapData");
    }

    public int getSccpchFroId() {
        MessageLog.traceEnter(this.getClass(), "getSccpchFroId()");
        return this.sccpchFroId;
    }

    public int getPichFroId() {
        MessageLog.traceEnter(this.getClass(), "getPichFroId()");
        return this.pichFroId;
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return false;
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.pichFroId;
    }
}

