/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.links;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcCommContextsProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcRlsProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.BcGetRlsParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CarrierMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RadioLinksMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.RbsLocalCellMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.links.RadioLinksMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;

public class RadioLinksMoImpl
extends BoamManagedObject
implements RadioLinksMo {
    private static final Class SELF = RadioLinksMoImpl.class;
    private static final String CELL_CARRIER_FRO_ID = "cellCarrierFroId";
    public static final int MO_DATA_REVISION = 4030001;
    private final MoData myData;
    private final ChcCommContextsProxy chcCommContextsProxy = ChcCommContextsProxy.instance();
    private final ChcRlsProxy chcRlsProxy = ChcRlsProxy.instance();
    private final MoScanner myScanner;

    public RadioLinksMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, AttrList attributes, ManagedObject source) throws MoAccessException {
        super(parent, motypeName, identity, context);
        MessageLog.traceEnter(SELF, "Normal constructor");
        if (!(parent instanceof CarrierMo)) {
            throw new IllegalParentException("Expecting Carrier, received:" + parent.getClass().getName());
        }
        this.myData = this.initMoData(attributes, context);
        int cellCarrierFroId = ((CarrierMo)this.getParent()).getCellCarrierFroId(context);
        this.bcmStoreAndRegisterIntAttribute(CELL_CARRIER_FRO_ID, cellCarrierFroId);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.myScanner = this.createMoScanner(false, context);
        MessageLog.trace(1, SELF, "MO Created");
    }

    public RadioLinksMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(SELF, "Recovery constructor, RadioLinksImpl()");
        this.myData = recoveredData;
        this.myScanner = this.createMoScanner(true, null);
        MessageLog.trace(1, SELF, "Version Attribute in MoData = " + this.myData.getRevision());
        MessageLog.trace(1, SELF, " MO is Recovered ");
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(SELF, "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(SELF, "isMyMoDataPersistent()");
        return true;
    }

    private MoData initMoData(AttrList attributes, Coordinator context) throws MoAccessException {
        try {
            MessageLog.trace(1, SELF, "initMoData()");
            MoData moData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
            moData.setRevision(4030001);
            return moData;
        }
        catch (MoAccessException e) {
            super.delete(context);
            throw e;
        }
    }

    private MoScanner createMoScanner(boolean recovery, Coordinator context) {
        MessageLog.traceEnter(SELF, "createMoScanner()");
        try {
            int[] additionalInfo = new int[]{11111};
            return new MoScanner(this, this.chcRlsProxy, this.bcmGetIntAttribute(CELL_CARRIER_FRO_ID, context), 0, RadioLinksMoFactory.instance().getCounters(), additionalInfo, recovery, context);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(SELF, "could not create MoScanner: " + (Object)((Object)e));
            return null;
        }
    }

    public int[] getScannerValue(String counterName) throws MoAccessException {
        if (this.myScanner == null) {
            throw new PmsException("MoScanner not available");
        }
        return this.myScanner.getValue(counterName);
    }

    public String getType() {
        return "RadioLinks";
    }

    public void delete(Coordinator ignoredContext) throws MoAccessException, UndeletableMoException {
        MessageLog.traceEnter(SELF, "delete()");
        MessageLog.trace(1, SELF, "MO is Undeleteable");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void delete(Coordinator context, String deleterTypeName) throws MoAccessException, UndeletableMoException {
        MessageLog.traceEnter(SELF, "delete()");
        if (deleterTypeName.equals("Carrier")) {
            if (this.isReserved(context)) {
                throw new UndeletableMoException((ManagedObject)this);
            }
            if (this.myScanner != null) {
                this.myScanner.delete(context);
            }
        } else {
            throw new UndeletableMoException((ManagedObject)this);
        }
        super.delete(context);
        MessageLog.trace(1, SELF, "Mo is Deleted");
    }

    public int getNoOfRadioLinks(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getNoOfRadioLinks()");
        ManagedObject[] carrierResveredBy = ((CarrierMo)this.getParent()).getReservedBy(context);
        RbsLocalCellMoImpl localCell = (RbsLocalCellMoImpl)BoamHelper.getFirstMatchingMo(carrierResveredBy, "RbsLocalCell");
        if (localCell == null) {
            return 0;
        }
        int cellFroId = localCell.getCellFroId(context);
        BcGetRlsParamRspS rspSig = this.chcCommContextsProxy.getRlsParam(0, this.getTxIdNonTransactional(context), cellFroId);
        if (localCell.isCombinedCell(context)) {
            return -1;
        }
        return rspSig.noOfRadioLinks;
    }
}

