/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.node;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.commandlog.logcontentcontrol.InspectorMgr;
import se.ericsson.cello.commandlog.logcontentcontrol.LogContentInspector;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.support.thread.Alarm;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroStateObserver;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcRestartServiceProxy;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.NodeBFunctionMoImpl;
import se.ericsson.wcdma.rbs.boam.pms.iface.PmCapableMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterGroup;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScannerAgent;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;

public class NodeBFunctionMoFactory
implements PmCapableMoFactory,
ActionListener,
FroStateObserver,
LogContentInspector {
    private static NodeBFunctionMoFactory theOneAndOnly;
    private boolean subscriptionsDone = false;
    private List counterList = new ArrayList();
    private Alarm clock = null;

    private NodeBFunctionMoFactory() {
        MessageLog.traceEnter(this.getClass(), "NodeBFunctionMoFactory()");
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
        InspectorMgr.instance().register((LogContentInspector)this, this.getMoTypeName());
        NcRestartServiceProxy.instance().registerForStatePropagation(null, this);
        this.setupCounter();
    }

    public static synchronized NodeBFunctionMoFactory instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new NodeBFunctionMoFactory();
        }
        return theOneAndOnly;
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMo()");
        String namingAttribute = this.getMoTypeName();
        NodeBFunctionMoImpl mo = NodeBFunctionMoImpl.create(parent, namingAttribute, attributes, identity, source, context);
        return mo;
    }

    public ManagedObject recoverMo(MoData recoveredGuts) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo()");
        try {
            return new NodeBFunctionMoImpl(recoveredGuts);
        }
        catch (MoNameAlreadyTakenException e) {
            MessageLog.traceError(this.getClass(), " recoverMo failed, Mo Already exist ");
            throw e;
        }
    }

    public String getMoTypeName() {
        return "NodeBFunction";
    }

    public List getCounters() {
        return this.counterList;
    }

    private void startTimer() {
        MessageLog.traceEnter(this.getClass(), " startTimer() ");
        int TIME_OUT_4_RESTART_IND = 5000;
        this.clock = new Alarm(5000, Alarm.ONE_SHOT);
        this.clock.addActionListener((ActionListener)this);
        this.clock.start();
    }

    private void stopTimer() {
        MessageLog.traceEnter(this.getClass(), " stopTimer() ");
        if (this.clock != null) {
            this.clock.stop();
            this.clock = null;
        }
    }

    public void actionPerformed(ActionEvent e) {
        MessageLog.traceEnter(this.getClass(), " actionPerformed() ");
        if (e.getActionCommand().equals("expired")) {
            NodeBFunctionMoImpl nodeBF = NodeBFunctionMoImpl.getTheOneAndOnly();
            try {
                nodeBF.changeState();
            }
            catch (MoAccessException e1) {
                MessageLog.traceError(this.getClass(), e1.getMessage());
            }
            this.stopTimer();
            MessageLog.trace(1, this.getClass(), "The Boam application state changed to normal");
        }
    }

    public void serviceAvailable(String proxyName) {
        MessageLog.traceEnter(this.getClass(), "serviceAvailable(), service Name:" + proxyName);
        if (!this.subscriptionsDone) {
            try {
                this.startTimer();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.subscriptionsDone = true;
        }
    }

    public void serviceRemoved(String proxyName) {
        MessageLog.traceEnter(this.getClass(), "serviceRemoved(), service Name:" + proxyName);
        this.subscriptionsDone = false;
    }

    private void setupCounter() {
        try {
            Counter cnt = new Counter("pmCapacityNodeBDlCe", 11, null);
            this.counterList.add(cnt);
            CounterGroup group = new CounterGroup("capacityNodeBUlCe");
            this.counterList.add(new Counter("pmCapacityNodeBUlCe", 11, group));
            this.counterList.add(new Counter("pmCapacityNodeBUlCeExt", 40, group));
            new MoScannerAgent(this.getMoTypeName(), this.counterList);
        }
        catch (PmsException pmse) {
            MessageLog.traceError(this.getClass(), "setupCounter(): Setup counters failed!!", (Throwable)((Object)pmse));
        }
    }

    public static synchronized void _setupCounter_onlyForTest() {
        if (theOneAndOnly != null) {
            MoFactoryMgr.instance().deregister(theOneAndOnly.getMoTypeName());
            theOneAndOnly = null;
        }
    }

    public Object[] hideHazardousAttributeValues(AttrList paramAttrList) {
        MessageLog.traceEnter(this.getClass(), "hideHazardousAttributeValues()");
        return null;
    }

    public Object[] hideHazardousActionParameters(String paramString, Object[] paramArrayOfObject) {
        MessageLog.traceEnter(this.getClass(), "hideHazardousActionParameters()");
        String ACTION_ANTENNA_DEVICE_SCAN = "antennaDeviceScan";
        int INDEX_TO_HIDE = 4;
        if (paramString.equalsIgnoreCase("antennaDeviceScan")) {
            paramArrayOfObject[4] = "******";
        }
        return paramArrayOfObject;
    }
}

