/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.node;

import enea.ose.system.InSignal;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import se.ericsson.cello.mao.ActionNotAllowedException;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.FtpUtil;
import se.ericsson.wcdma.rbs.boam.common.FtpUtilityException;
import se.ericsson.wcdma.rbs.boam.common.PlugAndPlayObserver;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcUlsaProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateUlsaRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetUlsaCapabilityRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcStartSamplingIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcStartSamplingRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcStopSamplingRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsUlsaCapabilityConfigT;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsUlsaSamplingConfigT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.UlSpectrumSamplingType;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ActionAlreadyInProgressException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NoConnectionWithUnitException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NoLicenseException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ParameterValueErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.struct.UlsaCapabilityConfigStruct;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AiDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.UlSpectrumAnalyzerMo;

public class UlSpectrumAnalyzerMoImpl
extends BoamManagedObjectWithAlarms
implements UlSpectrumAnalyzerMo,
PlugAndPlayObserver {
    private static final Class THIS_CLASS = UlSpectrumAnalyzerMoImpl.class;
    private static final EcUlsaProxy ecUlsaProxy = EcUlsaProxy.instance();
    private static final int MAX_NO_OF_INSTANCE = 4;
    private int froId = -1;
    private int portId = -1;
    private int info = 0;
    private int samplingType = 0;
    private String targetAiDevice = "";
    private int ulSpectrumSamplingStatus = 0;
    private String smrsHostIp;
    private String smrsUserName;
    private String smrsPassword;
    private String smrsUploadDir;
    private RbsUlsaSamplingConfigT samplingConfig;
    private boolean flagFileUploading = false;
    private boolean flagStopSampling = false;
    private boolean flagFailStop = false;
    private boolean flagHandlingInd = false;

    public UlSpectrumAnalyzerMoImpl(ManagedObject parent, String moTypeName, String identity, Coordinator context) throws MoNameAlreadyTakenException, MoAccessException {
        super(parent, moTypeName, identity, context, 4);
        this.myData = new MoData(this.getLocalDistinguishedName(), "UlSpectrumAnalyzer", false, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.froId = this.createRo(context);
        MessageLog.trace(1, THIS_CLASS, "ULSA froId from XXMI = " + this.froId);
        this.addObservers(context);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "create()");
        ValidateAttributes.checkTransaction(context);
        return new UlSpectrumAnalyzerMoImpl(parent, "UlSpectrumAnalyzer", identity, context);
    }

    private int createRo(Coordinator context) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "createRo()");
        try {
            EqcCreateUlsaRspS recSig = ecUlsaProxy.createUlsa(this.getTxIdNonTransactional(context), 0);
            this.info = recSig.result;
            this.sendAVC("info", this.info);
            return (int)recSig.ulsaFroId;
        }
        catch (FroRequestFailedException e) {
            int errorCode = this.errorCodeMapper(e.getOrgErrorCode());
            if (errorCode == 52) {
                throw new NoLicenseException();
            }
            throw e;
        }
    }

    public void delete(Coordinator context) throws MoAccessException, UndeletableMoException {
        MessageLog.traceEnter(THIS_CLASS, "delete()");
        if (this.ulSpectrumSamplingStatus == 1) {
            throw new ActionAlreadyInProgressException();
        }
        this.deleteRo(context);
        this.removeObservers(context);
        super.delete(context);
        MessageLog.trace(1, THIS_CLASS, "UlSpectrumAnalyzer Mo is Deleted ");
    }

    private void deleteRo(Coordinator context) throws MoAccessException, UndeletableMoException {
        MessageLog.traceEnter(THIS_CLASS, "deleteRo()");
        try {
            ecUlsaProxy.deleteUlsa(this.getTxIdNonTransactional(context), 0, this.froId);
        }
        catch (FroRequestFailedException e) {
            this.info = this.errorCodeMapper(e.getOrgErrorCode());
            this.sendAVC("info", this.info);
            throw e;
        }
    }

    private void addObservers(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "addObservers()");
        ecUlsaProxy.registerForPlugAndPLayInd(context, this, this.froId);
    }

    private void removeObservers(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "removeObservers()");
        ecUlsaProxy.deRegisterForPlugAndPLayInd(context, this.froId);
    }

    public void actionStartUlsaSampling(String ipAddress, String username, String password, String uploadDirectory, String targetAiDevice, int samplingType, int centerFrequency, int displayBandwidth, int resolutionBandwidth, int samplingInterval, int samplingTimeout, String triggerTimeOfDay, int powerLevel, Coordinator context) throws MoAccessException, NoLicenseException, NoConnectionWithUnitException, ActionAlreadyInProgressException {
        MessageLog.traceEnter(THIS_CLASS, "actionStartUlsaSampling()");
        if (this.ulSpectrumSamplingStatus == 1 || this.flagHandlingInd) {
            throw new ActionAlreadyInProgressException();
        }
        int todRest = this.checkAndTrans(triggerTimeOfDay);
        if (targetAiDevice != null && !targetAiDevice.startsWith("ManagedElement=1")) {
            targetAiDevice = "ManagedElement=1," + targetAiDevice;
        }
        this.checkParam(todRest, targetAiDevice, ipAddress, context);
        ValidateAttributes.stringValueRangeCheck("username", username, 128, "UlSpectrumAnalyzer");
        ValidateAttributes.stringValueRangeCheck("password", password, 128, "UlSpectrumAnalyzer");
        ValidateAttributes.stringValueRangeCheck("uploadDirectory", uploadDirectory, 256, "UlSpectrumAnalyzer");
        ValidateAttributes.stringValueRangeCheck("targetAiDevice", targetAiDevice, 128, "UlSpectrumAnalyzer");
        ValidateAttributes.intValueInEnumerationCheck("samplingType", samplingType, UlSpectrumSamplingType.class, "UlSpectrumAnalyzer");
        ValidateAttributes.intValueRangeCheck("samplingInterval", samplingInterval, 0, 60, "UlSpectrumAnalyzer");
        ValidateAttributes.intValueRangeCheck("samplingTimeout", samplingTimeout, 10, 7200, "UlSpectrumAnalyzer");
        int apiuFroId = this.getTargetFroId(this.getAuxPlugInUnitLDN(targetAiDevice), context);
        this.portId = Integer.parseInt(this.getMoId(targetAiDevice));
        this.samplingConfig = new RbsUlsaSamplingConfigT(apiuFroId, this.portId, centerFrequency, displayBandwidth, resolutionBandwidth, samplingInterval, samplingTimeout, todRest, powerLevel);
        this.flagStopSampling = false;
        try {
            EqcStartSamplingRspS recSig = ecUlsaProxy.startSampling(this.getTxIdNonTransactional(context), 0, this.froId, samplingType, this.samplingConfig);
            this.info = recSig.result;
            this.ulSpectrumSamplingStatus = 1;
            this.setParameters(ipAddress, username, password, uploadDirectory, targetAiDevice, samplingType, this.samplingConfig);
            MessageLog.trace(9, THIS_CLASS, "action start: ulSpectrumSamplingStatus=" + this.ulSpectrumSamplingStatus);
            this.sendAVC("ulSpectrumSamplingStatus", this.ulSpectrumSamplingStatus);
        }
        catch (FroRequestFailedException e) {
            int errorCode = this.errorCodeMapper(e.getOrgErrorCode());
            if (errorCode == 52) {
                throw new NoLicenseException();
            }
            if (errorCode == 6 || errorCode == 8) {
                throw new NoConnectionWithUnitException();
            }
            if (errorCode == 5) {
                throw new ActionAlreadyInProgressException();
            }
            this.info = errorCode;
            MessageLog.traceError(THIS_CLASS, "StartSampling BOAM received ERROR: info = " + this.info);
            throw e;
        }
        finally {
            this.sendAVC("info", this.info);
        }
    }

    private void checkParam(int triggerTimeOfDay, String targetAiDevice, String ipAddress, Coordinator context) throws MoAccessException {
        if (triggerTimeOfDay < 0 || this.getTargetFroId(targetAiDevice, context) < 0 || !this.checkIP(ipAddress)) {
            throw new ParameterValueErrorException();
        }
    }

    private boolean checkIP(String strIP) {
        String[] addr = new String[5];
        int i = 0;
        while (strIP.indexOf(46) != -1) {
            addr[i] = strIP.substring(0, strIP.indexOf(46));
            strIP = strIP.substring(strIP.indexOf(46) + 1);
            if (++i < 4) continue;
            return false;
        }
        addr[3] = strIP;
        try {
            for (i = 0; i < 4; ++i) {
                if ((addr[i] == null || addr[i].length() <= 3) && Integer.parseInt(addr[i]) >= 0 && Integer.parseInt(addr[i]) <= 255) continue;
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private void setParameters(String ipAddress, String username, String password, String uploadDirectory, String targetAiDevice, int samplingType, RbsUlsaSamplingConfigT samplingConfig) {
        MessageLog.traceEnter(THIS_CLASS, "setParameters()");
        this.smrsHostIp = ipAddress;
        this.smrsUserName = username;
        this.smrsPassword = password;
        this.smrsUploadDir = uploadDirectory;
        this.targetAiDevice = targetAiDevice;
        this.samplingType = samplingType;
        this.samplingConfig = samplingConfig;
    }

    private int checkAndTrans(String tod) {
        int todS;
        int todM;
        int todH;
        MessageLog.traceEnter(THIS_CLASS, "checkAndTrans()");
        if (tod.equalsIgnoreCase("ff:ff:ff.fff")) {
            return 131072;
        }
        if (tod.length() != 12 || tod.charAt(2) != ':' || tod.charAt(5) != ':' || tod.charAt(8) != '.') {
            return -1;
        }
        try {
            todH = Integer.parseInt(tod.substring(0, 2));
            todM = Integer.parseInt(tod.substring(3, 5));
            todS = Integer.parseInt(tod.substring(6, 8));
        }
        catch (NumberFormatException e) {
            return -1;
        }
        if (todH > 23 || todM > 59 || todS > 59) {
            return -1;
        }
        Calendar cal = Calendar.getInstance();
        int nowH = cal.get(11);
        int nowM = cal.get(12);
        int nowS = cal.get(13);
        MessageLog.trace(2, THIS_CLASS, "Right now is " + nowH + ":" + nowM + ":" + nowS);
        int restTime = -1;
        restTime = todH < nowH || todH == nowH && todM < nowM || todH == nowH && todM == nowM && todS < nowS ? (todH + 24 - nowH) * 3600 + (todM - nowM) * 60 + (todS - nowS) : (todH - nowH) * 3600 + (todM - nowM) * 60 + (todS - nowS);
        return restTime;
    }

    private int errorCodeMapper(int codeFromEc) {
        MessageLog.traceEnter(THIS_CLASS, "ErrorCodeMapper()");
        int codeInBoam = 0;
        switch (codeFromEc) {
            case 53: {
                codeInBoam = 1;
                break;
            }
            case 54: {
                codeInBoam = 2;
                break;
            }
            case 55: {
                codeInBoam = 3;
                break;
            }
            case 56: {
                codeInBoam = 4;
                break;
            }
            case 57: {
                codeInBoam = 5;
                break;
            }
            case 58: {
                codeInBoam = 6;
                break;
            }
            case 59: {
                codeInBoam = 7;
                break;
            }
            case 60: {
                codeInBoam = 8;
                break;
            }
            case 52: {
                codeInBoam = 52;
                break;
            }
            default: {
                codeInBoam = codeFromEc;
            }
        }
        return codeInBoam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void plugAndPlayInd(InSignal pnpIndSig) {
        block23: {
            block22: {
                EqcStartSamplingIndS recSig;
                block24: {
                    block20: {
                        block21: {
                            MessageLog.traceEnter(THIS_CLASS, "plugAndPlayInd()");
                            if (!(pnpIndSig instanceof EqcStartSamplingIndS)) break block23;
                            recSig = (EqcStartSamplingIndS)pnpIndSig;
                            this.flagHandlingInd = true;
                            if (recSig.errorCode != 1L) break block24;
                            String localFile = this.pathJoint(recSig.samplingFilePath, recSig.samplingFileName);
                            String desFileName = this.defineFileName();
                            String remoteFile = this.pathJoint(this.smrsUploadDir, desFileName);
                            this.flagFileUploading = true;
                            MessageLog.trace(4, THIS_CLASS, "SFTP transfer started.");
                            try {
                                try {
                                    FtpUtil.ftpPut(true, this.smrsHostIp, this.smrsUserName, this.smrsPassword, localFile, remoteFile);
                                    this.flagFileUploading = false;
                                    this.info = 0;
                                    this.ulSpectrumSamplingStatus = 2;
                                    MessageLog.trace(4, THIS_CLASS, "SFTP transfer finished.");
                                }
                                catch (FtpUtilityException e) {
                                    this.flagFileUploading = false;
                                    if (this.samplingType == 1) {
                                        try {
                                            ecUlsaProxy.stopSampling(this.getTxIdNonTransactional(null), 0, this.froId, this.portId);
                                        }
                                        catch (FroRequestFailedException e1) {
                                            this.info = this.errorCodeMapper(e1.getOrgErrorCode());
                                            this.ulSpectrumSamplingStatus = 3;
                                            MessageLog.traceError(THIS_CLASS, "StopSampling BOAM received ERROR: info = " + this.info, (Throwable)((Object)e1));
                                        }
                                        catch (FroNotAccessibleException e2) {
                                            MessageLog.traceError(THIS_CLASS, "StopSampling BOAM received ERROR", (Throwable)((Object)e2));
                                        }
                                        this.flagFailStop = true;
                                    }
                                    this.info = 2;
                                    this.ulSpectrumSamplingStatus = 3;
                                    MessageLog.traceError(THIS_CLASS, "SFTP BOAM got ERROR: info=" + this.info + ",ulSpectrumSamplingStatus=" + this.ulSpectrumSamplingStatus, e);
                                    Object var9_7 = null;
                                    File file = new File(localFile);
                                    if (file.exists() && file.isFile() && !this.forceDelete(file)) {
                                        MessageLog.traceError(THIS_CLASS, "Unable to delete file: " + localFile);
                                    }
                                    this.sendAVC("info", this.info);
                                    this.sendAVC("ulSpectrumSamplingStatus", this.ulSpectrumSamplingStatus);
                                    break block20;
                                }
                                Object var9_6 = null;
                                File file = new File(localFile);
                                if (!file.exists() || !file.isFile() || this.forceDelete(file)) break block21;
                            }
                            catch (Throwable throwable) {
                                Object var9_8 = null;
                                File file = new File(localFile);
                                if (file.exists() && file.isFile() && !this.forceDelete(file)) {
                                    MessageLog.traceError(THIS_CLASS, "Unable to delete file: " + localFile);
                                }
                                this.sendAVC("info", this.info);
                                this.sendAVC("ulSpectrumSamplingStatus", this.ulSpectrumSamplingStatus);
                                throw throwable;
                            }
                            MessageLog.traceError(THIS_CLASS, "Unable to delete file: " + localFile);
                        }
                        this.sendAVC("info", this.info);
                        this.sendAVC("ulSpectrumSamplingStatus", this.ulSpectrumSamplingStatus);
                    }
                    MessageLog.trace(4, THIS_CLASS, "samplingType=" + this.samplingType + ",ulSpectrumSamplingStatus=" + this.ulSpectrumSamplingStatus + ",recSig.errorCode=" + recSig.errorCode + ",flagStopSampling=" + this.flagStopSampling);
                    if (this.samplingType == 1 && this.ulSpectrumSamplingStatus == 2 && recSig.errorCode == 1L && !this.flagStopSampling) {
                        MessageLog.trace(4, THIS_CLASS, "Continuous sampling, we are going to trigger the next sampling.");
                        try {
                            this.samplingConfig.triggerTimeOfDay = 262144L;
                            ecUlsaProxy.startSampling(this.getTxIdNonTransactional(null), 0, this.froId, this.samplingType, this.samplingConfig);
                            this.info = 0;
                            this.ulSpectrumSamplingStatus = 1;
                            MessageLog.trace(4, THIS_CLASS, "Continuous sampling, we recieved right response. ulSpectrumSamplingStatus=TcpStatus.STARTED");
                        }
                        catch (FroRequestFailedException e) {
                            int errorCode = this.errorCodeMapper(e.getOrgErrorCode());
                            if (errorCode == 12) {
                                this.info = 0;
                                this.ulSpectrumSamplingStatus = 2;
                                MessageLog.trace(4, THIS_CLASS, "Continuous Sampling BOAM received time out, ulSpectrumSamplingStatus=TcpStatus.FINISHED;");
                                break block22;
                            }
                            if (errorCode == 52) {
                                this.ulSpectrumSamplingStatus = 3;
                                MessageLog.traceError(THIS_CLASS, "Continuous Sampling BOAM received ERROR: errorCode=LICENCE_KEY_NOT_ACTIVE,ulSpectrumSamplingStatus=TcpStatus.FAILED");
                                break block22;
                            }
                            this.info = errorCode;
                            this.ulSpectrumSamplingStatus = 3;
                            MessageLog.traceError(THIS_CLASS, "Continuous Sampling BOAM received ERROR: info=" + this.info + ",ulSpectrumSamplingStatus=TcpStatus.FAILED");
                        }
                        catch (FroNotAccessibleException e) {
                            MessageLog.traceError(THIS_CLASS, "Continuous Sampling BOAM received ERROR");
                        }
                    }
                    break block22;
                }
                if (recSig.errorCode == 12L) {
                    MessageLog.trace(4, THIS_CLASS, "Continuous sampling, samplingTimeout is met or ec received stop when waiting.");
                    if (!this.flagFailStop) {
                        MessageLog.trace(4, THIS_CLASS, "flagFailStop == false");
                        this.info = 0;
                        this.ulSpectrumSamplingStatus = 2;
                    }
                    this.flagFailStop = false;
                } else {
                    this.info = this.errorCodeMapper((int)recSig.errorCode);
                    this.ulSpectrumSamplingStatus = 3;
                    MessageLog.trace(4, THIS_CLASS, "plugAndPlay, ulSpectrumSamplingStatus=TcpStatus.FAILED");
                }
            }
            this.sendAVC("info", this.info);
            this.sendAVC("ulSpectrumSamplingStatus", this.ulSpectrumSamplingStatus);
            this.flagStopSampling = false;
            this.flagHandlingInd = false;
        }
    }

    private boolean forceDelete(File f) {
        boolean result2 = false;
        int tryCount = 0;
        while (!result2 && tryCount++ < 10) {
            MessageLog.trace(1, THIS_CLASS, "try to delete file: " + f.getName() + " try count: " + tryCount);
            result2 = f.delete();
        }
        return result2;
    }

    private String defineFileName() {
        return this.getNamePrefix() + "," + this.getMoId(this.getApiuParentLDN(this.targetAiDevice)) + "_" + this.getMoId(this.getAuxPlugInUnitLDN(this.targetAiDevice)) + "," + this.getMoId(this.targetAiDevice) + "," + new SimpleDateFormat("yyyyMMdd.HHmmssSSS").format(new Date()) + "ULSA_SAMPLE";
    }

    private String getAuxPlugInUnitLDN(String str) {
        int a = str.indexOf("AuxPlugInUnit");
        int b = str.indexOf(44, a);
        return str.substring(0, b);
    }

    private String getApiuParentLDN(String str) {
        int a = str.indexOf("AuxPlugInUnit") - 1;
        return str.substring(0, a);
    }

    private String pathJoint(String dir, String fileName) {
        char c = dir.charAt(dir.length() - 1);
        if (c == '/') {
            return dir + fileName;
        }
        return dir + "/" + fileName;
    }

    public Struct actionGetUlsaSamplingCapability(String targetRadioUnit, Coordinator context) throws MoAccessException, NoLicenseException, NoConnectionWithUnitException {
        MessageLog.traceEnter(THIS_CLASS, "actionGetUlsaSamplingCapability()");
        if (targetRadioUnit != null && !targetRadioUnit.startsWith("ManagedElement=1")) {
            targetRadioUnit = "ManagedElement=1," + targetRadioUnit;
        }
        int radioUnitFroId = this.getTargetFroId(targetRadioUnit, context);
        try {
            EqcGetUlsaCapabilityRspS recSig = ecUlsaProxy.getUlsaCapability(this.getTxIdNonTransactional(context), 0, this.froId, radioUnitFroId);
            return this.capabilityAdaption(recSig.capabilities);
        }
        catch (FroRequestFailedException e) {
            int errorCode = this.errorCodeMapper(e.getOrgErrorCode());
            if (errorCode == 52) {
                throw new NoLicenseException();
            }
            if (errorCode == 6 || errorCode == 8 || errorCode == 7) {
                throw new NoConnectionWithUnitException();
            }
            if (errorCode == 5) {
                throw new ActionAlreadyInProgressException();
            }
            throw e;
        }
    }

    private UlsaCapabilityConfigStruct capabilityAdaption(RbsUlsaCapabilityConfigT capablityConfigT) {
        UlsaCapabilityConfigStruct capabilityConfigS;
        MessageLog.traceEnter(THIS_CLASS, "capabilityAdaption()");
        int carrierRfPort1 = (int)capablityConfigT.capabilityInfo[0].carrierRfPort;
        int numSpectrumTypes1 = (int)capablityConfigT.capabilityInfo[0].numSpectrumTypes;
        int numTriggerTypes1 = (int)capablityConfigT.capabilityInfo[0].numTriggerTypes;
        boolean trigger1DataDefined1 = capablityConfigT.capabilityInfo[0].trigger1DataDefined != 0;
        long minPower1 = capablityConfigT.capabilityInfo[0].minPower;
        long maxPower1 = capablityConfigT.capabilityInfo[0].maxPower;
        int carrierRfPort2 = (int)capablityConfigT.capabilityInfo[1].carrierRfPort;
        int numSpectrumTypes2 = (int)capablityConfigT.capabilityInfo[1].numSpectrumTypes;
        int numTriggerTypes2 = (int)capablityConfigT.capabilityInfo[1].numTriggerTypes;
        boolean trigger1DataDefined2 = capablityConfigT.capabilityInfo[1].trigger1DataDefined != 0;
        long minPower2 = capablityConfigT.capabilityInfo[1].minPower;
        long maxPower2 = capablityConfigT.capabilityInfo[1].maxPower;
        int[] spectrumInfoLength = new int[2];
        for (int i = 0; i < 2; ++i) {
            spectrumInfoLength[i] = 0;
            while (spectrumInfoLength[i] < 9 && capablityConfigT.capabilityInfo[i].spectrumInfo[spectrumInfoLength[i]].minFrequency != 0) {
                int n = i;
                spectrumInfoLength[n] = spectrumInfoLength[n] + 1;
            }
        }
        if (spectrumInfoLength[0] == 0 && spectrumInfoLength[1] == 0) {
            capabilityConfigS = new UlsaCapabilityConfigStruct(carrierRfPort1, numSpectrumTypes1, numTriggerTypes1, trigger1DataDefined1, minPower1, maxPower1, carrierRfPort2, numSpectrumTypes2, numTriggerTypes2, trigger1DataDefined2, minPower2, maxPower2);
        } else if (spectrumInfoLength[0] > 0 && spectrumInfoLength[1] == 0) {
            long[] minFrequency1 = new long[spectrumInfoLength[0]];
            long[] maxFrequency1 = new long[spectrumInfoLength[0]];
            long[] flatGainBW1 = new long[spectrumInfoLength[0]];
            long[] samplingRate1 = new long[spectrumInfoLength[0]];
            long[] maxNumSamplings1 = new long[spectrumInfoLength[0]];
            long[] minFrequency2 = new long[]{0L};
            long[] maxFrequency2 = new long[]{0L};
            long[] flatGainBW2 = new long[]{0L};
            long[] samplingRate2 = new long[]{0L};
            long[] maxNumSamplings2 = new long[]{0L};
            for (int i = 0; i < spectrumInfoLength[0]; ++i) {
                minFrequency1[i] = capablityConfigT.capabilityInfo[0].spectrumInfo[i].minFrequency;
                maxFrequency1[i] = capablityConfigT.capabilityInfo[0].spectrumInfo[i].maxFrequency;
                flatGainBW1[i] = capablityConfigT.capabilityInfo[0].spectrumInfo[i].flatGainBW;
                samplingRate1[i] = capablityConfigT.capabilityInfo[0].spectrumInfo[i].samplingRate;
                maxNumSamplings1[i] = capablityConfigT.capabilityInfo[0].spectrumInfo[i].maxNumSamplings;
            }
            capabilityConfigS = new UlsaCapabilityConfigStruct(carrierRfPort1, numSpectrumTypes1, numTriggerTypes1, minFrequency1, maxFrequency1, flatGainBW1, samplingRate1, maxNumSamplings1, trigger1DataDefined1, minPower1, maxPower1, carrierRfPort2, numSpectrumTypes2, numTriggerTypes2, minFrequency2, maxFrequency2, flatGainBW2, samplingRate2, maxNumSamplings2, trigger1DataDefined2, minPower2, maxPower2);
        } else if (spectrumInfoLength[0] == 0 && spectrumInfoLength[1] > 0) {
            long[] minFrequency1 = new long[]{0L};
            long[] maxFrequency1 = new long[]{0L};
            long[] flatGainBW1 = new long[]{0L};
            long[] samplingRate1 = new long[]{0L};
            long[] maxNumSamplings1 = new long[]{0L};
            long[] minFrequency2 = new long[spectrumInfoLength[1]];
            long[] maxFrequency2 = new long[spectrumInfoLength[1]];
            long[] flatGainBW2 = new long[spectrumInfoLength[1]];
            long[] samplingRate2 = new long[spectrumInfoLength[1]];
            long[] maxNumSamplings2 = new long[spectrumInfoLength[1]];
            for (int i = 0; i < spectrumInfoLength[1]; ++i) {
                minFrequency2[i] = capablityConfigT.capabilityInfo[1].spectrumInfo[i].minFrequency;
                maxFrequency2[i] = capablityConfigT.capabilityInfo[1].spectrumInfo[i].maxFrequency;
                flatGainBW2[i] = capablityConfigT.capabilityInfo[1].spectrumInfo[i].flatGainBW;
                samplingRate2[i] = capablityConfigT.capabilityInfo[1].spectrumInfo[i].samplingRate;
                maxNumSamplings2[i] = capablityConfigT.capabilityInfo[1].spectrumInfo[i].maxNumSamplings;
            }
            capabilityConfigS = new UlsaCapabilityConfigStruct(carrierRfPort1, numSpectrumTypes1, numTriggerTypes1, minFrequency1, maxFrequency1, flatGainBW1, samplingRate1, maxNumSamplings1, trigger1DataDefined1, minPower1, maxPower1, carrierRfPort2, numSpectrumTypes2, numTriggerTypes2, minFrequency2, maxFrequency2, flatGainBW2, samplingRate2, maxNumSamplings2, trigger1DataDefined2, minPower2, maxPower2);
        } else {
            int i;
            long[] minFrequency1 = new long[spectrumInfoLength[0]];
            long[] maxFrequency1 = new long[spectrumInfoLength[0]];
            long[] flatGainBW1 = new long[spectrumInfoLength[0]];
            long[] samplingRate1 = new long[spectrumInfoLength[0]];
            long[] maxNumSamplings1 = new long[spectrumInfoLength[0]];
            long[] minFrequency2 = new long[spectrumInfoLength[1]];
            long[] maxFrequency2 = new long[spectrumInfoLength[1]];
            long[] flatGainBW2 = new long[spectrumInfoLength[1]];
            long[] samplingRate2 = new long[spectrumInfoLength[1]];
            long[] maxNumSamplings2 = new long[spectrumInfoLength[1]];
            for (i = 0; i < spectrumInfoLength[0]; ++i) {
                minFrequency1[i] = capablityConfigT.capabilityInfo[0].spectrumInfo[i].minFrequency;
                maxFrequency1[i] = capablityConfigT.capabilityInfo[0].spectrumInfo[i].maxFrequency;
                flatGainBW1[i] = capablityConfigT.capabilityInfo[0].spectrumInfo[i].flatGainBW;
                samplingRate1[i] = capablityConfigT.capabilityInfo[0].spectrumInfo[i].samplingRate;
                maxNumSamplings1[i] = capablityConfigT.capabilityInfo[0].spectrumInfo[i].maxNumSamplings;
            }
            for (i = 0; i < spectrumInfoLength[1]; ++i) {
                minFrequency2[i] = capablityConfigT.capabilityInfo[1].spectrumInfo[i].minFrequency;
                maxFrequency2[i] = capablityConfigT.capabilityInfo[1].spectrumInfo[i].maxFrequency;
                flatGainBW2[i] = capablityConfigT.capabilityInfo[1].spectrumInfo[i].flatGainBW;
                samplingRate2[i] = capablityConfigT.capabilityInfo[1].spectrumInfo[i].samplingRate;
                maxNumSamplings2[i] = capablityConfigT.capabilityInfo[1].spectrumInfo[i].maxNumSamplings;
            }
            capabilityConfigS = new UlsaCapabilityConfigStruct(carrierRfPort1, numSpectrumTypes1, numTriggerTypes1, minFrequency1, maxFrequency1, flatGainBW1, samplingRate1, maxNumSamplings1, trigger1DataDefined1, minPower1, maxPower1, carrierRfPort2, numSpectrumTypes2, numTriggerTypes2, minFrequency2, maxFrequency2, flatGainBW2, samplingRate2, maxNumSamplings2, trigger1DataDefined2, minPower2, maxPower2);
        }
        return capabilityConfigS;
    }

    private int getTargetFroId(String targetLDN, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getTargetFroId()");
        int targetFroId = -1;
        ManagedObject targetMo = MoRepository.instance().lookup(targetLDN);
        if (targetMo == null) {
            throw new MoNotFoundException("can not find MO: " + targetLDN);
        }
        if (targetMo instanceof AuxPlugInUnitMo) {
            targetFroId = ((AuxPlugInUnitMo)targetMo).getFroId(context);
            MessageLog.trace(2, THIS_CLASS, "AuxPlugInUnit FroId = " + targetFroId);
        } else if (targetMo instanceof AiDeviceMo) {
            targetFroId = ((AiDeviceMo)targetMo).getFroId(context);
            MessageLog.trace(2, THIS_CLASS, "AiDevice FroId = " + targetFroId);
        } else {
            MessageLog.trace(2, THIS_CLASS, "targetMo is not handled!!!");
        }
        return targetFroId;
    }

    private String getMoId(String targetLDN) {
        MessageLog.traceEnter(THIS_CLASS, "getId()");
        int index = targetLDN.lastIndexOf(61);
        String targetId = targetLDN.substring(index + 1);
        return targetId;
    }

    public void actionStopUlsaSampling(String targetAiDevice, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "actionStopUlsaSampling()");
        if (this.samplingType == 0 || this.ulSpectrumSamplingStatus == 3) {
            return;
        }
        if (this.samplingType == 2 && this.flagFileUploading) {
            return;
        }
        if (targetAiDevice != null && !targetAiDevice.startsWith("ManagedElement=1")) {
            targetAiDevice = "ManagedElement=1," + targetAiDevice;
        }
        if (this.getTargetFroId(targetAiDevice, context) < 0) {
            throw new ParameterValueErrorException();
        }
        if (!targetAiDevice.equals(this.targetAiDevice)) {
            throw new ActionNotAllowedException("UlSpectrumAnalyzer", "The port to stop sampling is not the same with start sampling.");
        }
        this.portId = Integer.parseInt(this.getMoId(targetAiDevice));
        if (this.samplingType == 1) {
            this.flagStopSampling = true;
        }
        try {
            EqcStopSamplingRspS cfmSig = ecUlsaProxy.stopSampling(this.getTxIdNonTransactional(context), 0, this.froId, this.portId);
            this.info = cfmSig.result;
            this.ulSpectrumSamplingStatus = 2;
        }
        catch (FroRequestFailedException e) {
            this.info = this.errorCodeMapper(e.getOrgErrorCode());
            this.ulSpectrumSamplingStatus = 3;
            MessageLog.traceError(THIS_CLASS, "StopSampling BOAM received ERROR: info = " + this.info, (Throwable)((Object)e));
        }
        this.sendAVC("info", this.info);
        this.sendAVC("ulSpectrumSamplingStatus", this.ulSpectrumSamplingStatus);
    }

    public int getUlSpectrumSamplingStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getUlSpectrumSamplingStatus(), ulSpectrumSamplingStatus = " + this.ulSpectrumSamplingStatus);
        return this.ulSpectrumSamplingStatus;
    }

    public int getInfo(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getInfo(), info = " + this.info);
        return this.info;
    }

    public String getTargetAiDevice(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getTargetAiDevice(), targetAiDevice = " + this.targetAiDevice);
        return this.targetAiDevice;
    }

    public int getSamplingType(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getSamplingType(), samplingType = " + this.samplingType);
        return this.samplingType;
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(THIS_CLASS, "getFroId()");
        return this.froId;
    }

    public String getType() {
        return "UlSpectrumAnalyzer";
    }

    public MoData getMyMoData() {
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(THIS_CLASS, "isMyMoDataPersistent()");
        return false;
    }

    public void _setSamplingType_ForTestOnly(int samplingTypeTest) {
        this.samplingType = samplingTypeTest;
    }

    public void _setUlSpectrumSamplingStatus_ForTestOnly(int ulSpectrumSamplingStatusTest) {
        this.ulSpectrumSamplingStatus = ulSpectrumSamplingStatusTest;
    }
}

