/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.Dimension;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.MainWindowView;
import se.ericsson.cello.support.gui.PropertiesHelper;
import se.ericsson.cello.support.gui.SortedArrayList;
import se.ericsson.cello.support.gui.SortedList;
import se.ericsson.cello.support.gui.TopologyModel;
import se.ericsson.cello.support.gui.ViewElementCreator;
import se.ericsson.cello.support.gui.ViewElementEvent;
import se.ericsson.cello.support.gui.ViewElementListener;
import se.ericsson.cello.support.gui.guilib.comp.IconHelper;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.ErrorReporter;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;

public abstract class AbstractViewElement
implements Comparable {
    private String name;
    protected boolean isFolder = false;
    private Boolean childrenLoaded;
    private boolean childrenAllowed = true;
    private ViewElementCreator childrencreator;
    private Vector myListeners = new Vector();
    private AbstractViewElement parent;
    private AbstractViewElement[] myChildren;
    private SortedList subordinates = SortedArrayList.synchronizedSortedArrayList(new SortedArrayList());
    private SortedList propertyElements = SortedArrayList.synchronizedSortedArrayList(new SortedArrayList());
    private TopologyModel myModel;
    private String[] indexKeys = new String[0];
    private Comparator childrenComparator;
    private String[] childrenAttributes;
    private Runnable runFireChildrenLoaded = new Runnable(){

        public void run() {
            AbstractViewElement.this.fireChildrenLoaded();
        }
    };
    private Runnable runFireChildrenChanged = new Runnable(){

        public void run() {
            AbstractViewElement.this.fireChildrenChanged();
        }
    };
    private Runnable runFireElementChanged = new Runnable(){

        public void run() {
            AbstractViewElement.this.fireElementChanged();
        }
    };
    private Runnable runFireViewElementUpdated = new Runnable(){

        public void run() {
            AbstractViewElement.this.fireViewElementUpdated();
        }
    };
    public static final Comparator UNSORTED_CHILDREN = new Comparator(){

        public int compare(Object o1, Object o2) {
            return 0;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    };

    public AbstractViewElement(String aName) {
        this.name = aName;
        this.childrenLoaded = Boolean.TRUE;
    }

    public AbstractViewElement(String aName, ViewElementCreator creator) {
        this.name = aName;
        if (creator == null) {
            throw new IllegalArgumentException();
        }
        this.childrencreator = creator;
        this.childrenLoaded = Boolean.FALSE;
    }

    public AbstractViewElement(String aName, boolean allowsChildren) {
        this.name = aName;
        this.childrenAllowed = allowsChildren;
        this.childrenLoaded = Boolean.TRUE;
    }

    public String getName() {
        return this.name;
    }

    public String getRDN() {
        return "";
    }

    public String getDN() {
        return "";
    }

    public void setIsFolder(boolean value) {
        this.isFolder = value;
    }

    public boolean getIsFolder() {
        return this.isFolder;
    }

    public boolean showReservedBy() {
        return false;
    }

    public String getReservedByTypes() {
        return "";
    }

    public Object[] getAllRelevantMOs() {
        Object[] mos = null;
        return mos;
    }

    public void setName(String newName) {
        this.name = newName;
        this.fireElementChanged();
    }

    public String toString() {
        return this.getName();
    }

    public void updateLocale(Locale aLocale) {
        this.localeHasChanged();
        if (this.childrenLoaded.equals(Boolean.TRUE)) {
            AbstractViewElement[] childList = this.getChildrenUnsorted();
            for (int i = 0; i < childList.length; ++i) {
                childList[i].updateLocale(aLocale);
            }
        }
    }

    public boolean refreshButtonNeeded() {
        return true;
    }

    protected Locale getLocale() {
        if (this.getModel() != null) {
            return this.getModel().getLocale();
        }
        return Locale.getDefault();
    }

    protected void localeHasChanged() {
    }

    protected String getResourceBundleBasename() {
        if (this.getModel() != null) {
            return this.getModel().getResourceBundleBasename();
        }
        return "";
    }

    public String translateKey(String aKey) {
        return this.translate(aKey);
    }

    public String translate(String aKey) {
        String basename = this.getResourceBundleBasename();
        try {
            ResourceBundle myBundle = GuilibResourceBundle.getBundle(basename, this.getLocale(), this.getClass().getClassLoader());
            return myBundle.getString(aKey);
        }
        catch (MissingResourceException e) {
            return aKey;
        }
    }

    public final AbstractViewElement getParent() {
        return this.parent;
    }

    public final void setParent(AbstractViewElement newParent) {
        this.parent = newParent;
    }

    public boolean childrenAreLoaded() {
        return this.childrenLoaded.equals(Boolean.TRUE);
    }

    public boolean childrenAreAllowed() {
        return this.childrenAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(final AbstractViewElement child) {
        if (child == null) {
            throw new IllegalArgumentException();
        }
        if (!this.childrenAreAllowed()) {
            throw new IllegalStateException();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            child.setParent(this);
            this.speedupAtmManagerByFillingCacheTemporaryMethod(child);
            if (child.childrenAreAllowed()) {
                SortedList sortedList = this.subordinates;
                synchronized (sortedList) {
                    this.subordinates.add(child);
                    this.fireChildAdded(child, this.subordinates.indexOf(child));
                }
            } else {
                SortedList sortedList = this.propertyElements;
                synchronized (sortedList) {
                    this.propertyElements.add(child);
                    this.fireChildAdded(child, this.propertyElements.indexOf(child));
                }
            }
        } else {
            Runnable runAddChild = new Runnable(){

                public void run() {
                    AbstractViewElement.this.addChild(child);
                }
            };
            SwingUtilities.invokeLater(runAddChild);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(final AbstractViewElement child) {
        if (child == null) {
            throw new IllegalArgumentException();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            Log.trace("removeChild thread: " + Thread.currentThread());
            int index = -1;
            if (child.childrenAreAllowed()) {
                SortedList sortedList = this.subordinates;
                synchronized (sortedList) {
                    index = this.subordinates.indexOf(child);
                    this.subordinates.remove(child);
                }
            }
            SortedList sortedList = this.propertyElements;
            synchronized (sortedList) {
                index = this.propertyElements.indexOf(child);
                this.propertyElements.remove(child);
            }
            Log.trace("removeChild setParent(null): ");
            child.setParent(null);
            Log.trace("removeChild fireRemoveNotify(): ");
            child.fireRemoveNotify();
            Log.trace("removeChild fireChildRemoved(child, index): ");
            this.fireChildRemoved(child, index);
            Log.trace("removeChild AFTER fireChildRemoved(child, index)");
        } else {
            Runnable runRemoveChild = new Runnable(){

                public void run() {
                    AbstractViewElement.this.removeChild(child);
                }
            };
            SwingUtilities.invokeLater(runRemoveChild);
        }
    }

    public void addChildAndWaitForGUIToBeUpdated(final AbstractViewElement child) {
        if (child == null) {
            throw new IllegalArgumentException();
        }
        if (!this.childrenAreAllowed()) {
            throw new IllegalStateException();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            System.out.println("!!!!!!!!++++  ERROR method addChildAndWaitForGUIToBeUpdated in class AbstractViewElement.java; This method is not supposed to be called this way.");
            Thread.dumpStack();
        } else {
            Runnable runAddChild = new Runnable(){

                public void run() {
                    AbstractViewElement.this.addChild(child);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runAddChild);
            }
            catch (Exception e) {
                System.out.println("!!!!!!!!  ERROR method addChildAndWaitForGUIToBeUpdated in class AbstractViewElement.java");
                Thread.dumpStack();
            }
        }
    }

    public void removeChildAndWaitForGUIToBeUpdated(final AbstractViewElement child) {
        if (child == null) {
            throw new IllegalArgumentException();
        }
        if (!this.childrenAreAllowed()) {
            throw new IllegalStateException();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            System.out.println("!!!!!!!!----  ERROR method removeChildAndWaitForGUIToBeUpdated in class AbstractViewElement.java; This method is not supposed to be called this way.");
            Thread.dumpStack();
        } else {
            Runnable runRemoveChild = new Runnable(){

                public void run() {
                    AbstractViewElement.this.removeChild(child);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runRemoveChild);
            }
            catch (Exception e) {
                System.out.println("!!!!!!!!  ERROR method removeChildAndWaitForGUIToBeUpdated in class AbstractViewElement.java");
                Thread.dumpStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceChild(final AbstractViewElement oldChild, final AbstractViewElement newChild) {
        if (oldChild == null || newChild == null) {
            throw new IllegalArgumentException("Arguments may not be null.");
        }
        if (oldChild.childrenAreAllowed() != newChild.childrenAreAllowed()) {
            throw new IllegalArgumentException("Subordinates cannot replace by properties or vice versa.");
        }
        if (!this.childrenAreAllowed()) {
            throw new IllegalStateException("Attempt to replace children at view element that may not have children.");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            SortedList sortedList;
            int index = -1;
            if (newChild.childrenAreAllowed()) {
                sortedList = this.subordinates;
                synchronized (sortedList) {
                    index = this.subordinates.indexOf(oldChild);
                }
            }
            sortedList = this.propertyElements;
            synchronized (sortedList) {
                index = this.propertyElements.indexOf(oldChild);
            }
            oldChild.setParent(null);
            oldChild.fireRemoveNotify();
            this.fireChildRemoved(oldChild, index);
            newChild.setParent(this);
            this.speedupAtmManagerByFillingCacheTemporaryMethod(newChild);
            this.fireChildAdded(newChild, index);
            if (newChild.childrenAreAllowed()) {
                sortedList = this.subordinates;
                synchronized (sortedList) {
                    this.subordinates.set(index, newChild);
                }
            }
            sortedList = this.propertyElements;
            synchronized (sortedList) {
                this.propertyElements.set(index, newChild);
            }
            newChild.fireElementChanged();
        } else {
            Runnable runReplaceChild = new Runnable(){

                public void run() {
                    AbstractViewElement.this.replaceChild(oldChild, newChild);
                }
            };
            SwingUtilities.invokeLater(runReplaceChild);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNotify() {
        Log.trace("removeNotify");
        this.setParent(null);
        this.setModel(null);
        this.childrencreator = null;
        this.childrenLoaded = Boolean.FALSE;
        List list = this.subordinates;
        synchronized (list) {
            this.subordinates.clear();
        }
        list = this.propertyElements;
        synchronized (list) {
            this.propertyElements.clear();
        }
        list = this.myListeners;
        synchronized (list) {
            this.myListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRemoveNotify() {
        if (SwingUtilities.isEventDispatchThread()) {
            int i;
            SortedList sortedList = this.subordinates;
            synchronized (sortedList) {
                for (i = 0; i < this.subordinates.size(); ++i) {
                    ((AbstractViewElement)this.subordinates.get(i)).fireRemoveNotify();
                }
            }
            sortedList = this.propertyElements;
            synchronized (sortedList) {
                for (i = 0; i < this.propertyElements.size(); ++i) {
                    ((AbstractViewElement)this.propertyElements.get(i)).fireRemoveNotify();
                }
            }
            this.removeNotify();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AbstractViewElement.this.fireRemoveNotify();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public int getChildCount() {
        this.loadChildrenWhenNeeded();
        return this.subordinates.size() + this.propertyElements.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildIndex(AbstractViewElement ave) {
        int index = -1;
        if (ave.childrenAreAllowed()) {
            SortedList sortedList = this.subordinates;
            synchronized (sortedList) {
                index = this.subordinates.indexOf(ave);
            }
            if (index != -1) {
                index += this.propertyElements.size();
            }
        } else {
            SortedList sortedList = this.propertyElements;
            synchronized (sortedList) {
                index = this.propertyElements.indexOf(ave);
            }
        }
        return index;
    }

    public AbstractViewElement[] getLoadedChildren() {
        if (this.childrenLoaded.equals(Boolean.TRUE)) {
            return this.myChildren;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractViewElement[] getChildren() {
        this.loadChildrenWhenNeeded();
        SortedList sortedList = this.subordinates;
        synchronized (sortedList) {
            SortedList sortedList2 = this.propertyElements;
            synchronized (sortedList2) {
                int i;
                int totalCount = this.propertyElements.size() + this.subordinates.size();
                int propertyCount = this.propertyElements.size();
                AbstractViewElement[] childList = new AbstractViewElement[totalCount];
                for (i = 0; i < propertyCount; ++i) {
                    childList[i] = (AbstractViewElement)this.propertyElements.get(i);
                }
                for (i = propertyCount; i < totalCount; ++i) {
                    childList[i] = (AbstractViewElement)this.subordinates.get(i - propertyCount);
                }
                return childList;
            }
        }
    }

    public AbstractViewElement[] getChildrenUnsorted() {
        this.loadChildrenWhenNeeded();
        int totalCount = this.propertyElements.size() + this.subordinates.size();
        int propertyCount = this.propertyElements.size();
        Object[] childList = new AbstractViewElement[totalCount];
        this.propertyElements.toArrayUnsorted(childList);
        AbstractViewElement[] subs = (AbstractViewElement[])this.subordinates.toArrayUnsorted(new AbstractViewElement[this.subordinates.size()]);
        System.arraycopy(subs, 0, childList, propertyCount, subs.length);
        return childList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractViewElement getChildAt(int index) {
        AbstractViewElement foundElt = null;
        int propertyCount = this.getPropertyElementCount();
        int totalCount = propertyCount + this.getSubordinateCount();
        if (index >= 0 && index < propertyCount) {
            SortedList sortedList = this.propertyElements;
            synchronized (sortedList) {
                foundElt = (AbstractViewElement)this.propertyElements.get(index);
            }
        } else if (index >= propertyCount && index < totalCount) {
            SortedList sortedList = this.subordinates;
            synchronized (sortedList) {
                foundElt = (AbstractViewElement)this.subordinates.get(index - propertyCount);
            }
        } else {
            foundElt = null;
        }
        return foundElt;
    }

    public AbstractViewElement[] getSubordinates() {
        this.loadChildrenWhenNeeded();
        return this.subordinates.toArray(new AbstractViewElement[this.subordinates.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractViewElement getSubordinateAt(int index) {
        this.loadChildrenWhenNeeded();
        SortedList sortedList = this.subordinates;
        synchronized (sortedList) {
            return (AbstractViewElement)this.subordinates.get(index);
        }
    }

    public int getSubordinateCount() {
        this.loadChildrenWhenNeeded();
        return this.subordinates.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexOfSubordinate(AbstractViewElement subordinate) {
        this.loadChildrenWhenNeeded();
        SortedList sortedList = this.subordinates;
        synchronized (sortedList) {
            return this.subordinates.indexOf(subordinate);
        }
    }

    public boolean hasSubordinates() {
        this.loadChildrenWhenNeeded();
        return !this.subordinates.isEmpty();
    }

    public AbstractViewElement[] getPropertyElements() {
        this.loadChildrenWhenNeeded();
        return this.propertyElements.toArray(new AbstractViewElement[this.propertyElements.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractViewElement getPropertyElementAt(int index) {
        this.loadChildrenWhenNeeded();
        SortedList sortedList = this.propertyElements;
        synchronized (sortedList) {
            return (AbstractViewElement)this.propertyElements.get(index);
        }
    }

    public int getPropertyElementCount() {
        this.loadChildrenWhenNeeded();
        return this.propertyElements.size();
    }

    public boolean hasPropertyElements() {
        this.loadChildrenWhenNeeded();
        return !this.propertyElements.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexOfPropertyElement(AbstractViewElement propertyElt) {
        this.loadChildrenWhenNeeded();
        SortedList sortedList = this.propertyElements;
        synchronized (sortedList) {
            return this.propertyElements.indexOf(propertyElt);
        }
    }

    public abstract Object getAttributeValue(String var1);

    public abstract Action[] getActions();

    public abstract Action getAction(String var1);

    public Action getDefaultAction() {
        return null;
    }

    public abstract ImageIcon getIcon();

    public Icon getOpenedIcon() {
        return this.getIcon();
    }

    public Icon getClosedIcon() {
        return this.getIcon();
    }

    public Icon getIconForTree() {
        return this.getIcon();
    }

    public Icon getIconForTable() {
        return this.getClosedIcon();
    }

    public abstract String getDetailText();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addViewElementListener(ViewElementListener listener) {
        Vector vector = this.myListeners;
        synchronized (vector) {
            if (!this.myListeners.contains(listener)) {
                this.myListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeViewElementListener(ViewElementListener listener) {
        Vector vector = this.myListeners;
        synchronized (vector) {
            this.myListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListenerToPropertyElements(ViewElementListener listener) {
        this.loadChildrenWhenNeeded();
        SortedList sortedList = this.propertyElements;
        synchronized (sortedList) {
            Iterator i = this.propertyElements.iterator();
            while (i.hasNext()) {
                ((AbstractViewElement)i.next()).addViewElementListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListenerToSubordinates(ViewElementListener listener) {
        this.loadChildrenWhenNeeded();
        SortedList sortedList = this.subordinates;
        synchronized (sortedList) {
            Iterator i = this.subordinates.iterator();
            while (i.hasNext()) {
                ((AbstractViewElement)i.next()).addViewElementListener(listener);
            }
        }
    }

    public TreePath getPathToRoot() {
        if (this.getParent() == null) {
            return new TreePath(this);
        }
        TreePath path = this.getParent().getPathToRoot();
        return path.pathByAddingChild(this);
    }

    public void refresh() {
        this.fireElementChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshChildren() {
        int i;
        SortedList sortedList = this.propertyElements;
        synchronized (sortedList) {
            for (i = 0; i < this.propertyElements.size(); ++i) {
                ((AbstractViewElement)this.propertyElements.get(i)).refresh();
            }
        }
        sortedList = this.subordinates;
        synchronized (sortedList) {
            for (i = 0; i < this.subordinates.size(); ++i) {
                ((AbstractViewElement)this.subordinates.get(i)).refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshSubtree() {
        int i;
        this.refresh();
        SortedList sortedList = this.propertyElements;
        synchronized (sortedList) {
            for (i = 0; i < this.propertyElements.size(); ++i) {
                ((AbstractViewElement)this.propertyElements.get(i)).refreshSubtree();
            }
        }
        sortedList = this.subordinates;
        synchronized (sortedList) {
            for (i = 0; i < this.subordinates.size(); ++i) {
                ((AbstractViewElement)this.subordinates.get(i)).refreshSubtree();
            }
        }
    }

    public TopologyModel getModel() {
        if (this.getParent() == null) {
            return this.myModel;
        }
        return this.getParent().getModel();
    }

    protected void setModel(TopologyModel aModel) {
        if (this.getParent() != null) {
            throw new IllegalStateException("setModel called on non-root element");
        }
        this.myModel = aModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChildrenLoaded() {
        Log.trace("fireChildrenLoaded() in thread " + Thread.currentThread().getName());
        if (SwingUtilities.isEventDispatchThread()) {
            ViewElementEvent evt = new ViewElementEvent(this, this.getPathToRoot().getPath());
            Vector vector = this.myListeners;
            synchronized (vector) {
                Iterator i = ((Vector)this.myListeners.clone()).iterator();
                while (i.hasNext()) {
                    ((ViewElementListener)i.next()).viewElementChildrenLoaded(evt);
                }
            }
        } else {
            SwingUtilities.invokeLater(this.runFireChildrenLoaded);
        }
    }

    public int getIndex() {
        int index = 0;
        if (this.parent != null) {
            index = this.childrenAreAllowed() ? this.parent.getIndexOfSubordinate(this) + this.propertyElements.size() : this.parent.getIndexOfPropertyElement(this);
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChildrenChanged() {
        Log.trace("fireChildrenChanged() in thread " + Thread.currentThread().getName());
        if (SwingUtilities.isEventDispatchThread()) {
            ViewElementEvent evt = new ViewElementEvent(this, this.getPathToRoot().getPath());
            Vector vector = this.myListeners;
            synchronized (vector) {
                Iterator i = ((Vector)this.myListeners.clone()).iterator();
                while (i.hasNext()) {
                    ((ViewElementListener)i.next()).viewElementStructureChanged(evt);
                }
            }
        } else {
            SwingUtilities.invokeLater(this.runFireChildrenChanged);
        }
    }

    protected void fireElementChanged() {
        Log.trace("fireElementChanged() in thread " + Thread.currentThread().getName());
        if (SwingUtilities.isEventDispatchThread()) {
            boolean isSubordinate = this.childrenAreAllowed();
            AbstractViewElement parent = this.getParent();
            if (parent != null) {
                if (isSubordinate) {
                    boolean sortingChanged = parent.sortSubordinates();
                } else {
                    boolean sortingChanged = parent.sortPropertyElements();
                }
                parent.fireChildrenChanged();
            } else {
                AbstractViewElement selectedElement;
                MainWindowController refMainWindowController = EmasGuilibMediator.getReference().getMainWindowReference();
                MainWindowView view = (MainWindowView)refMainWindowController.getView();
                if (refMainWindowController != null && (selectedElement = refMainWindowController.getSelectedElement()) == this) {
                    String detailText = this.getDetailText();
                    if (detailText == null) {
                        view.currentElementLabel.setText(" No information available");
                    } else {
                        view.currentElementLabel.setText(detailText);
                    }
                }
                this.fireViewElementUpdated();
            }
        } else {
            SwingUtilities.invokeLater(this.runFireElementChanged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireViewElementUpdated() {
        Log.trace("fireViewElementUpdated() in thread " + Thread.currentThread().getName());
        if (SwingUtilities.isEventDispatchThread()) {
            boolean isSubordinate = this.childrenAreAllowed();
            int index = 0;
            Object[] parentPath = null;
            AbstractViewElement parent = this.getParent();
            if (parent != null) {
                parentPath = parent.getPathToRoot().getPath();
                index = isSubordinate ? parent.getIndexOfSubordinate(this) : parent.getIndexOfPropertyElement(this);
            }
            ViewElementEvent evt = new ViewElementEvent(this, this.getPathToRoot().getPath(), index);
            Vector vector = this.myListeners;
            synchronized (vector) {
                Iterator i = ((List)this.myListeners.clone()).iterator();
                while (i.hasNext()) {
                    ((ViewElementListener)i.next()).viewElementUpdated(evt);
                }
            }
        } else {
            SwingUtilities.invokeLater(this.runFireViewElementUpdated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChildAdded(final AbstractViewElement newChild, final int index) {
        Log.trace("fireChildAdded(" + newChild + "," + index + ") in thread " + Thread.currentThread().getName());
        if (newChild == null) {
            throw new IllegalArgumentException();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ViewElementEvent evt = new ViewElementEvent(this, this.getPathToRoot().getPath(), newChild, index);
            Vector vector = this.myListeners;
            synchronized (vector) {
                Iterator i = ((List)this.myListeners.clone()).iterator();
                while (i.hasNext()) {
                    ((ViewElementListener)i.next()).viewElementInserted(evt);
                }
            }
        } else {
            Runnable runFireChildAdded = new Runnable(){

                public void run() {
                    AbstractViewElement.this.fireChildAdded(newChild, index);
                }
            };
            SwingUtilities.invokeLater(runFireChildAdded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChildRemoved(final AbstractViewElement removedChild, final int index) {
        Log.trace("fireChildRemoved(" + removedChild + "," + index + ") in thread " + Thread.currentThread().getName());
        if (removedChild == null) {
            throw new IllegalArgumentException("removedChild==null not allowed.");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ViewElementEvent evt = new ViewElementEvent(this, this.getPathToRoot().getPath(), removedChild, index);
            Vector vector = this.myListeners;
            synchronized (vector) {
                Iterator i = ((List)this.myListeners.clone()).iterator();
                while (i.hasNext()) {
                    ((ViewElementListener)i.next()).viewElementDeleted(evt);
                }
            }
        } else {
            Runnable runFireChildRemoved = new Runnable(){

                public void run() {
                    AbstractViewElement.this.fireChildRemoved(removedChild, index);
                }
            };
            SwingUtilities.invokeLater(runFireChildRemoved);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadChildren() {
        if (this.childrencreator != null) {
            AbstractViewElement[] children = this.childrencreator.expand(this);
            SortedList sortedList = this.propertyElements;
            synchronized (sortedList) {
                SortedList sortedList2 = this.subordinates;
                synchronized (sortedList2) {
                    for (int i = 0; i < children.length; ++i) {
                        if (children[i] == null) continue;
                        if (children[i].childrenAreAllowed()) {
                            this.subordinates.add(children[i]);
                        } else {
                            this.propertyElements.add(children[i]);
                        }
                        children[i].setParent(this);
                    }
                    this.childrenLoaded = Boolean.TRUE;
                }
            }
            this.fireChildrenLoaded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadChildrenWhenNeeded() {
        Boolean bl = this.childrenLoaded;
        synchronized (bl) {
            if (this.childrenLoaded.equals(Boolean.FALSE) && this.childrencreator != null) {
                AbstractViewElement[] children = this.childrencreator.expand(this);
                SortedList sortedList = this.subordinates;
                synchronized (sortedList) {
                    SortedList sortedList2 = this.propertyElements;
                    synchronized (sortedList2) {
                        for (int i = 0; i < children.length; ++i) {
                            Log.logNotify("Adding children in loadChildrenWhenNeeded()");
                            if (children[i] == null) continue;
                            children[i].setParent(this);
                            if (children[i].childrenAreAllowed()) {
                                this.subordinates.add(children[i]);
                                continue;
                            }
                            this.propertyElements.add(children[i]);
                        }
                        this.myChildren = children;
                        this.childrenLoaded = Boolean.TRUE;
                    }
                }
                Log.logNotify("Children are loaded!");
                this.fireChildrenLoaded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUpSubtree() {
        if (SwingUtilities.isEventDispatchThread()) {
            int i;
            SortedList sortedList = this.subordinates;
            synchronized (sortedList) {
                for (i = 0; i < this.subordinates.size(); ++i) {
                    ((AbstractViewElement)this.subordinates.get(i)).cleanUpSubtree();
                    ((AbstractViewElement)this.subordinates.get(i)).setParent(null);
                }
                this.subordinates.clear();
            }
            sortedList = this.propertyElements;
            synchronized (sortedList) {
                for (i = 0; i < this.propertyElements.size(); ++i) {
                    ((AbstractViewElement)this.propertyElements.get(i)).setParent(null);
                }
                this.propertyElements.clear();
            }
            this.removeNotify();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AbstractViewElement.this.cleanUpSubtree();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void sortChildren() {
        boolean sortingChanged = false;
        sortingChanged = this.sortSubordinates();
        if (sortingChanged |= this.sortPropertyElements()) {
            this.fireChildrenChanged();
        }
    }

    protected boolean sortSubordinates() {
        boolean sortingChanged = false;
        if (this.childrenComparator != UNSORTED_CHILDREN) {
            sortingChanged = this.subordinates.sort();
        }
        return sortingChanged;
    }

    protected boolean sortPropertyElements() {
        boolean sortingChanged = false;
        if (this.childrenComparator != UNSORTED_CHILDREN) {
            sortingChanged = this.propertyElements.sort();
        }
        return sortingChanged;
    }

    public void setIndexKeys(String[] newIndexKeys) {
        if (this.indexKeys.length != newIndexKeys.length) {
            this.indexKeys = new String[newIndexKeys.length];
        }
        System.arraycopy(newIndexKeys, 0, this.indexKeys, 0, this.indexKeys.length);
        this.fireElementChanged();
    }

    public String[] getIndexKeys() {
        String[] result = new String[this.indexKeys.length];
        System.arraycopy(this.indexKeys, 0, result, 0, this.indexKeys.length);
        return result;
    }

    public String getHyperlinkActionName() {
        Object[] path = this.getPathToRoot().getPath();
        StringBuffer name = new StringBuffer(this.translateKey(this.getModel().getName()));
        for (int i = 1; i < path.length; ++i) {
            name.append(" - ");
            name.append(((AbstractViewElement)path[i]).getName());
        }
        return name.toString();
    }

    public void setChildrenComparator(Comparator newChildrenComparator) {
        try {
            if (newChildrenComparator == null && this.childrenComparator != null || !((Object)newChildrenComparator).equals(this.childrenComparator)) {
                this.childrenComparator = newChildrenComparator;
                this.subordinates.setComparator(this.childrenComparator);
                this.propertyElements.setComparator(this.childrenComparator);
                if (this.childrenComparator != UNSORTED_CHILDREN) {
                    this.fireChildrenChanged();
                }
            }
        }
        catch (Exception e) {
            Log.logError("NullPointerException : " + e);
        }
    }

    public Comparable getSortKey() {
        return this.getName();
    }

    public int compareTo(Object o) {
        Comparable thisKey = this.getSortKey();
        AbstractViewElement ove = (AbstractViewElement)o;
        Comparable thatKey = ove.getSortKey();
        if (thisKey != null && thatKey != null) {
            if (thisKey instanceof String && thatKey instanceof String) {
                String thisKeyS = (String)((Object)thisKey);
                String thatKeyS = (String)((Object)thatKey);
                return thisKeyS.compareToIgnoreCase(thatKeyS);
            }
            if (thisKey.getClass() == thatKey.getClass()) {
                return this.getSortKey().compareTo(thatKey);
            }
            try {
                return this.getSortKey().compareTo(thatKey);
            }
            catch (ClassCastException e) {
                if (ove.getName().indexOf(58) != -1) {
                    return 1;
                }
                if (this.getName().indexOf(58) != -1) {
                    return -1;
                }
                return this.getName().compareToIgnoreCase(ove.getName());
            }
        }
        return this.getName().compareToIgnoreCase(ove.getName());
    }

    public void setChildrenAttributes(String[] newChildrenAttributes) {
        this.childrenAttributes = newChildrenAttributes != null ? (String[])newChildrenAttributes.clone() : null;
    }

    public String[] getChildrenAttributes() {
        if (this.childrenAttributes != null) {
            return this.childrenAttributes;
        }
        TopologyModel model = this.getModel();
        if (model == null) {
            return null;
        }
        return model.getStandardAttributes();
    }

    public boolean isLeaf() {
        if (this.childrenAreAllowed()) {
            if (this.childrenAreLoaded()) {
                return !this.hasSubordinates();
            }
            if (this.childrencreator != null) {
                return this.childrencreator.subtrees.size() == 0;
            }
            return false;
        }
        return true;
    }

    public void speedupAtmManagerByFillingCacheTemporaryMethod(AbstractViewElement newElt) {
        try {
            Class[] booleanArgument = new Class[]{Boolean.TYPE};
            Method refreshPrimary = newElt.getClass().getMethod("refreshPrimary", booleanArgument);
            Method refreshSecondary = newElt.getClass().getMethod("refreshSecondary", booleanArgument);
            Object[] argument = new Object[]{Boolean.FALSE};
            Log.trace("Caching individual element in AbstractViewElement");
            refreshSecondary.invoke((Object)newElt, argument);
            refreshPrimary.invoke((Object)newElt, argument);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            Log.logError("Unexpected error filling cache", e);
        }
    }

    protected void childrenAreNotAllowed() {
        this.childrenAllowed = false;
    }

    protected void reportException(Exception e, String msgKey, Object[] msgArgs) {
        String msg = null;
        String presentViewBundle = null;
        Properties properties = null;
        MainWindowController refMainWindowController = EmasGuilibMediator.getReference().getMainWindowReference();
        presentViewBundle = refMainWindowController.getCurrentView().getResourceBundleBasename();
        if (presentViewBundle != null) {
            properties = new PropertiesHelper("/" + presentViewBundle.replace('.', '/') + ".properties");
        }
        if (msgKey != null && !msgKey.equals("")) {
            msg = properties.getProperty(msgKey);
            if (msgArgs != null && msg != null) {
                msg = MessageFormat.format(msg, msgArgs);
            }
        }
        if (msg == null) {
            msg = "MISSING_MESSAGE_IN_BUNDLE : " + presentViewBundle;
        }
        ErrorReporter.getReporter().reportException(refMainWindowController, e, msg);
    }

    protected void showMessageDialog(String msgKey, Object[] msgArgs, String titleKey, Object[] titleArgs, int msgType, String iconName) {
        String msg = null;
        String title = null;
        String presentViewBundle = null;
        Properties properties = null;
        MainWindowController refMainWindowController = EmasGuilibMediator.getReference().getMainWindowReference();
        presentViewBundle = refMainWindowController.getCurrentView().getResourceBundleBasename();
        if (presentViewBundle != null) {
            properties = new PropertiesHelper("/" + presentViewBundle.replace('.', '/') + ".properties");
        }
        Icon icon = IconHelper.createIcon(iconName);
        if (msgKey != null && !msgKey.equals("")) {
            msg = properties.getProperty(msgKey);
            if (msgArgs != null && msg != null) {
                msg = MessageFormat.format(msg, msgArgs);
            }
        }
        if (titleKey != null && !titleKey.equals("")) {
            title = properties.getProperty(titleKey);
            if (titleArgs != null && title != null) {
                title = MessageFormat.format(title, titleArgs);
            }
        }
        if (msg == null) {
            msg = "MISSING_MESSAGE_IN_BUNDLE : " + presentViewBundle;
        }
        if (title == null) {
            title = "MISSING_TITLE";
        }
        JTextArea txt = new JTextArea(msg);
        txt.setEditable(false);
        txt.setBackground(refMainWindowController.getView().getBackground());
        txt.setFont(refMainWindowController.getView().getFont());
        txt.setLineWrap(true);
        txt.setWrapStyleWord(true);
        txt.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(txt, 20, 31);
        scrollPane.setPreferredSize(new Dimension(400, 120));
        JOptionPane pane = new JOptionPane(scrollPane, msgType);
        JDialog dialog = pane.createDialog(refMainWindowController.getView(), title);
        dialog.setResizable(true);
        dialog.show();
    }

    protected int showOptionDialog(String msgKey, Object[] msgArgs, String titleKey, Object[] titleArgs, int optionType, int msgType, String iconName, Object[] options, Object initialValue) {
        String msg = null;
        String title = null;
        String presentViewBundle = null;
        Properties properties = null;
        MainWindowController refMainWindowController = EmasGuilibMediator.getReference().getMainWindowReference();
        presentViewBundle = refMainWindowController.getCurrentView().getResourceBundleBasename();
        if (presentViewBundle != null) {
            properties = new PropertiesHelper("/" + presentViewBundle.replace('.', '/') + ".properties");
        }
        Icon icon = IconHelper.createIcon(iconName);
        if (msgKey != null && !msgKey.equals("")) {
            msg = properties.getProperty(msgKey);
            if (msgArgs != null && msg != null) {
                msg = MessageFormat.format(msg, msgArgs);
            }
            if (null == msg || msg.equals("")) {
                msg = msgKey;
            }
        }
        if (titleKey != null && !titleKey.equals("")) {
            title = properties.getProperty(titleKey);
            if (titleArgs != null && title != null) {
                title = MessageFormat.format(title, titleArgs);
            }
            if (null == title || title.equals("")) {
                title = titleKey;
            }
        }
        boolean err = false;
        if (msg == null) {
            msg = "";
            err = true;
        }
        if (title == null) {
            title = "MISSING TITLE";
            err = true;
        }
        if (err) {
            Log.logError("Message or title sent to method showConfirmDialog was null");
        }
        int result = JOptionPane.showOptionDialog(refMainWindowController.getView(), msg, title, optionType, msgType, null, options, initialValue);
        return result;
    }
}

