/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;

public class TitleUpdateService
implements MOProxy.MOListener {
    private static TitleUpdateService theOneAndOnly;
    private String attributeName;
    private MOProxy managedObject;
    private MainWindowController mwc = EmasGuilibMediator.getReference().getMainWindowReference();
    private static final String USERLABEL = "userLabel";

    protected static synchronized TitleUpdateService getInstance() {
        if (theOneAndOnly == null) {
            try {
                theOneAndOnly = new TitleUpdateService();
            }
            catch (Exception e) {
                Log.logError("Could not create instance of TitleUpdateService.", e);
            }
        }
        return theOneAndOnly;
    }

    private TitleUpdateService() {
    }

    protected void setDefaultPrefix() {
        try {
            MOProxy node = MOProxy.getRoot();
            this.setMoAttributeAsPrefix(node, USERLABEL);
        }
        catch (CSException e) {
            Log.logError("Could not retrieve name from the node", e);
        }
    }

    protected void setMoAttributeAsPrefix(MOProxy mo, String attrName) {
        try {
            this.setManagedObject(mo);
            this.setAttributeName(attrName);
            String attributeValue = mo.getAttribute(attrName).toString();
            this.updatePrefix(attributeValue);
        }
        catch (CSException e) {
            Log.logError("Could not retrieve attribute (" + attrName + ") from the MO (" + mo + ")", e);
        }
    }

    private void updatePrefix(String attributeValue) {
        String nodeT;
        int i;
        String ipAddress = "";
        String nodeType = "";
        String attr = "";
        ipAddress = EmasSystemProperties.getProperty("host");
        if (ipAddress != null && (i = ipAddress.indexOf(":")) > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(":"));
        }
        if ((nodeT = this.mwc.getString("NODETYPE", null)) != null && nodeT.length() > 0) {
            nodeType = nodeT + " ";
        }
        if (attributeValue != null && attributeValue.length() > 0) {
            attr = attributeValue;
            if (ipAddress.length() > 0) {
                attr = attr + " ";
            }
        }
        this.mwc.getApplication().getApplicationManager().updateAllPrefixes(nodeType + attr + ipAddress);
    }

    private void setManagedObject(MOProxy mo) {
        if (this.managedObject != null) {
            this.managedObject.removeMOListener(this);
        }
        this.managedObject = mo;
        this.managedObject.addMOListener(this);
    }

    private void setAttributeName(String attrName) {
        this.attributeName = attrName;
    }

    public void attributesChanged(MOProxy mo, NameValue[] nameValue) {
        for (int i = 0; i < nameValue.length; ++i) {
            if (mo.getType().equals(this.managedObject.getType())) {
                if (!nameValue[i].name.equals(this.attributeName)) continue;
                this.updatePrefix(nameValue[i].value.toString());
                continue;
            }
            Log.logError("Notification received for wrong MO! Should not be possible. Administration incorrect?");
        }
    }

    public void childCreated(MOProxy childMO) {
    }

    public void childDeleted(MOProxy childMO) {
    }

    public void cleanup() {
        this.attributeName = null;
        this.managedObject = null;
        theOneAndOnly = null;
    }
}

