/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Method;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeSelectionModel;
import se.ericsson.cello.support.gui.AbstractViewElement;
import se.ericsson.cello.support.gui.TopologyModel;
import se.ericsson.cello.support.gui.guilib.comp.Log;

class TopologyTree
extends JTree
implements TreeExpansionListener,
TreeWillExpandListener {
    public TopologyTree() {
        this.initialize();
    }

    public TopologyTree(TopologyModel model) {
        super(model);
        this.initialize();
    }

    private void initialize() {
        this.setCellRenderer(new TopologyTreeRenderer());
        TreeSelectionModel selectModel = this.getSelectionModel();
        selectModel.setSelectionMode(1);
        this.addTreeExpansionListener(this);
        this.addTreeWillExpandListener(this);
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        Log.measure("tree", false);
    }

    public void treeWillCollapse(TreeExpansionEvent event) {
    }

    public void treeWillExpand(TreeExpansionEvent event) {
        Log.measure("tree", true, "Tree expand time, \"" + event.getPath() + '\"');
        this.speedupAtmManagerByTriggeringCacheTemporaryMethod((AbstractViewElement)event.getPath().getLastPathComponent());
    }

    public void speedupAtmManagerByTriggeringCacheTemporaryMethod(AbstractViewElement newElt) {
        AbstractViewElement[] children = newElt.getChildrenUnsorted();
        if (children.length > 0) {
            try {
                Class[] noArgs = new Class[]{};
                Method m1 = children[0].getClass().getMethod("ensurePrimaryCacheFilled", noArgs);
                m1.invoke((Object)children[0], (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class TopologyTreeRenderer
    extends DefaultTreeCellRenderer {
        private TopologyTreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel component = null;
            if (value != null) {
                if (value instanceof AbstractViewElement) {
                    component = new JLabel(((AbstractViewElement)value).getName());
                    if (sel) {
                        String os = System.getProperty("os.name");
                        if (os.startsWith("Windows")) {
                            component.setBackground(this.getBackgroundSelectionColor());
                            component.setForeground(this.getTextSelectionColor());
                            component.setOpaque(true);
                        } else {
                            component.setBackground(new Color(174, 178, 195));
                            component.setForeground(Color.black);
                            component.setOpaque(true);
                        }
                        if (((AbstractViewElement)value).getIsFolder()) {
                            component.setIcon(((AbstractViewElement)value).getOpenedIcon());
                        } else {
                            component.setIcon(((AbstractViewElement)value).getIconForTree());
                        }
                    } else if (((AbstractViewElement)value).getIsFolder()) {
                        component.setIcon(((AbstractViewElement)value).getClosedIcon());
                    } else {
                        component.setIcon(((AbstractViewElement)value).getIconForTree());
                    }
                } else {
                    component = new JLabel("");
                }
            }
            return component;
        }
    }
}

