/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import javax.swing.SwingUtilities;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class WaitCursorEventQueue
extends EventQueue {
    private int delayTime;
    private WaitCursorTimer waitCursorTimer;

    public WaitCursorEventQueue(int delayTime) {
        this.delayTime = delayTime;
        this.waitCursorTimer = new WaitCursorTimer();
        this.waitCursorTimer.setDaemon(true);
        this.waitCursorTimer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(AWTEvent awtEvent) {
        Object source = awtEvent.getSource();
        this.waitCursorTimer.startTimer(source);
        try {
            super.dispatchEvent(awtEvent);
        }
        catch (IllegalThreadStateException thread) {
            Log.log(5, thread.getMessage(), (Throwable)thread);
        }
        catch (Exception e) {
            Log.logError("An exception occurred while dispatching the wait cursor event");
            Log.log(5, e.getMessage(), (Throwable)e);
        }
        finally {
            this.waitCursorTimer.stopTimer();
        }
    }

    private class WaitCursorTimer
    extends Thread {
        private Object sourceObject;
        private Component parentComponent;
        private Cursor savedCursor;
        private boolean timerStarted = false;

        private WaitCursorTimer() {
        }

        synchronized void startTimer(Object source) {
            if (!this.timerStarted) {
                this.sourceObject = source;
                this.notify();
            }
        }

        synchronized void stopTimer() {
            if (this.parentComponent == null) {
                this.interrupt();
            } else {
                this.parentComponent.setCursor(this.savedCursor);
                this.parentComponent = null;
            }
        }

        public synchronized void run() {
            while (true) {
                try {
                    while (true) {
                        this.timerStarted = false;
                        this.wait();
                        this.timerStarted = true;
                        this.wait(WaitCursorEventQueue.this.delayTime);
                        this.setComponent();
                        if (this.parentComponent == null) continue;
                        this.savedCursor = this.parentComponent.getCursor();
                        if (!this.parentComponent.isShowing()) continue;
                        this.parentComponent.setCursor(Cursor.getPredefinedCursor(3));
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private void setComponent() {
            MenuContainer menuParent;
            if (this.sourceObject instanceof Component) {
                this.parentComponent = SwingUtilities.getRoot((Component)this.sourceObject);
            } else if (this.sourceObject instanceof MenuComponent && (menuParent = ((MenuComponent)this.sourceObject).getParent()) instanceof Component) {
                this.parentComponent = SwingUtilities.getRoot((Component)menuParent);
            }
        }
    }
}

