/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import se.ericsson.cello.support.gui.gengui.LabelledField;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public abstract class EntryField
extends LabelledField
implements FocusListener,
KeyListener {
    public JTextField textField = null;
    private ActionListener actionListener = null;
    private String actionCommand = null;
    private String text = null;
    protected boolean faultyValueEntered = false;
    protected Color myRedColor;

    public EntryField(String translations, String tag, Integer length) {
        super(translations, tag);
        Log.trace("Constructor()");
        this.myRedColor = new Color(204, 0, 0);
        this.textField = new JTextField(length);
        this.textField.addFocusListener(this);
        this.textField.addKeyListener(this);
        this.add(this.textField);
        this.toolTipBundle = "se.ericsson.cello.support.gui.gengui.resources.language.ToolTip";
        this.toolTipTag = this.getTag();
    }

    public EntryField(String tag, Integer length) {
        super(tag);
        Log.trace("EntryField()");
        this.myRedColor = new Color(204, 0, 0);
        this.textField = new JTextField(length);
        this.textField.addFocusListener(this);
        this.textField.addKeyListener(this);
        this.add(this.textField);
    }

    public void setActionListener(ActionListener aListener, String aCommand) {
        this.actionListener = aListener;
        this.actionCommand = aCommand;
    }

    abstract boolean isValidSyntax();

    abstract boolean fillInValue(String var1);

    abstract String getTag();

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.updateFieldValue();
    }

    private void updateFieldValue() {
        boolean newValue = false;
        String newText = this.textField.getText();
        if (newText.equals("")) {
            this.faultyValueEntered = false;
            newValue = this.fillInValue(newText);
        } else if (this.isValidSyntax()) {
            this.faultyValueEntered = false;
            newValue = this.fillInValue(newText);
            this.textField.setForeground(Color.black);
        } else {
            newValue = this.fillInValue("");
            this.faultyValueEntered = true;
            this.textField.setForeground(this.myRedColor);
        }
        if (!newText.equals(this.text)) {
            this.text = newText;
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 0, "ENTRYFIELD_FILLEDIN"));
            }
        }
        if (this.actionListener != null && newValue && !this.actionCommand.equals("ENTRYFIELD_FILLEDIN")) {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, this.actionCommand));
        }
    }

    public boolean isFilledIn() {
        return !this.textField.getText().trim().equals("") && this.isValidSyntax();
    }

    public boolean faultyValueEntered() {
        return this.faultyValueEntered;
    }

    public void focusGained(FocusEvent e) {
        this.text = this.textField.getText();
    }

    public void focusLost(FocusEvent e) {
        Log.trace("focusLost()");
        this.updateFieldValue();
        if (!e.isTemporary() && !this.textField.getText().equals("") && this.faultyValueEntered) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Toolkit.getDefaultToolkit().beep();
                }
            });
        }
    }

    public Object getFieldComponent() {
        Log.trace("getFieldComponent()");
        return this.textField;
    }

    public void updateLocale(Locale locale) {
        super.updateLocale(locale);
        this.translateTooltip(locale);
    }

    public void setBackgroundOfFilledInValue(Color color) {
        if (this.textField != null) {
            this.textField.setBackground(color);
        }
    }
}

