/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import se.ericsson.cello.support.gui.gengui.ComponentBoxLayout;
import se.ericsson.cello.support.gui.gengui.GenButton;
import se.ericsson.cello.support.gui.gengui.GenCheckBox;
import se.ericsson.cello.support.gui.gengui.GenComboBox;
import se.ericsson.cello.support.gui.gengui.GenDateField;
import se.ericsson.cello.support.gui.gengui.GenFloatField;
import se.ericsson.cello.support.gui.gengui.GenGroupBox;
import se.ericsson.cello.support.gui.gengui.GenGuiAlreadyStartedException;
import se.ericsson.cello.support.gui.gengui.GenIPAddressField;
import se.ericsson.cello.support.gui.gengui.GenIntegerField;
import se.ericsson.cello.support.gui.gengui.GenLabelField;
import se.ericsson.cello.support.gui.gengui.GenLeftRightPanel;
import se.ericsson.cello.support.gui.gengui.GenList;
import se.ericsson.cello.support.gui.gengui.GenListTranslatableString;
import se.ericsson.cello.support.gui.gengui.GenRadioButtonField;
import se.ericsson.cello.support.gui.gengui.GenStringField;
import se.ericsson.cello.support.gui.gengui.GenTabbedPane;
import se.ericsson.cello.support.gui.gengui.GenTranslatableStringComboBox;
import se.ericsson.cello.support.gui.gengui.GuiConstants;
import se.ericsson.cello.support.gui.gengui.SyntaxException;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class GenGui
extends JPanel {
    public static final int BOTTOM_PANEL = 0;
    public static final int RIGHT_PANEL = 1;
    private GenButton myEscButton;
    private GenButton myDefaultButton;
    private boolean bShouldSetButtonSizes = true;
    private JPanel attributePanel;
    private JPanel buttonPanel;
    private JPanel rightButtonPanel;
    private JScrollPane attrScrollPane;
    private Vector comps;
    private String defaultTranslations;
    private boolean running = false;
    private GenGui gengui;
    private FocusAdapter myFocusLostListener;
    private Vector myButtons;
    private GenButton myPresentButton;
    private Runnable doSetMeDefault = new Runnable(){

        public void run() {
            if (null != GenGui.this.gengui.getRootPane()) {
                GenGui.this.gengui.getRootPane().setDefaultButton(GenGui.this.myPresentButton);
            }
        }
    };
    private Runnable doSetDefaultButtonRunnable = new Runnable(){

        public void run() {
            if (null != GenGui.this.gengui.getRootPane()) {
                GenGui.this.gengui.getRootPane().setDefaultButton(GenGui.this.myDefaultButton);
            }
        }
    };

    public GenGui(String translations) {
        this();
        this.defaultTranslations = translations;
    }

    public GenGui() {
        Log.trace("GenGui()");
        this.comps = new Vector();
        this.initGui();
    }

    public void start() {
        Log.trace("GenGui start()");
        if (this.bShouldSetButtonSizes) {
            this.setSizesForButtons();
        }
        this.setVisible(true);
        this.running = true;
        if (null != this.myDefaultButton) {
            try {
                SwingUtilities.invokeLater(this.doSetDefaultButtonRunnable);
            }
            catch (Exception e) {
                Log.trace("GenGui exception in doSetDefaultButtonRunnable");
            }
            int len = this.myButtons.size();
            for (int i = 0; i < len; ++i) {
                ((Component)this.myButtons.elementAt(i)).addFocusListener(this.myFocusLostListener);
            }
        }
    }

    public void stop() {
        if (null != this.myEscButton) {
            this.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
            this.myEscButton = null;
        }
        if (this.myDefaultButton != null) {
            int len = this.myButtons.size();
            for (int i = 0; i < len; ++i) {
                GenButton tmpButton = (GenButton)this.myButtons.elementAt(i);
                if (null == tmpButton || null == this.myFocusLostListener) continue;
                tmpButton.removeFocusListener(this.myFocusLostListener);
            }
            this.myFocusLostListener = null;
            this.myDefaultButton = null;
        }
    }

    public GenGroupBox addGroupBox(String translations, String titleTag) throws GenGuiAlreadyStartedException {
        Log.trace("addGroupBoxButton()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenGroupBox comp = new GenGroupBox(translations, titleTag);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenGroupBox addGroupBox(String titleTag) throws GenGuiAlreadyStartedException {
        return this.addGroupBox(this.defaultTranslations, titleTag);
    }

    public GenLabelField addLabelField(String translations, String labelTag, String labelFieldText) throws GenGuiAlreadyStartedException {
        Log.trace("addLabelField()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenLabelField comp = new GenLabelField(translations, labelTag, labelFieldText);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenLabelField addLabelField(String labelTag) throws GenGuiAlreadyStartedException {
        Log.trace("addLabelField()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenLabelField comp = new GenLabelField(this.defaultTranslations, labelTag);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenLabelField addLabelField(String labelTag, String labelFieldText) throws GenGuiAlreadyStartedException {
        return this.addLabelField(this.defaultTranslations, labelTag, labelFieldText);
    }

    public GenIntegerField addIntegerField(String translations, String labelTag, Integer length, Integer initialValue) throws GenGuiAlreadyStartedException {
        Log.trace("addIntegerField()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenIntegerField comp = new GenIntegerField(translations, labelTag, length);
        comp.setValue(initialValue);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenIntegerField addIntegerField(String labelTag, Integer length) throws GenGuiAlreadyStartedException {
        Log.trace("addIntegerField()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenIntegerField comp = new GenIntegerField(this.defaultTranslations, labelTag, length);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenStringField addStringField(String translations, String labelTag, Integer length, String initialValue) throws GenGuiAlreadyStartedException {
        Log.trace("addStringField()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenStringField comp = new GenStringField(translations, labelTag, length);
        comp.setValue(initialValue);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenStringField addStringField(String labelTag, Integer length) throws GenGuiAlreadyStartedException {
        Log.trace("addStringField()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenStringField comp = new GenStringField(this.defaultTranslations, labelTag, length);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenIPAddressField addIPAddressField(String translations, String labelTag, String initialValue) throws GenGuiAlreadyStartedException, SyntaxException {
        Log.trace("addIPAddressField()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenIPAddressField comp = new GenIPAddressField(translations, labelTag);
        comp.setValue(initialValue);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenIPAddressField addIPAddressField(String labelTag) throws GenGuiAlreadyStartedException {
        Log.trace("addIPAddressField()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenIPAddressField comp = new GenIPAddressField(this.defaultTranslations, labelTag);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenDateField addDateField(String translations, String labelTag, Date initialValue) throws GenGuiAlreadyStartedException {
        Log.trace("addDateField()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenDateField comp = new GenDateField(translations, labelTag);
        comp.setValue(initialValue);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenDateField addDateField(String labelTag) throws GenGuiAlreadyStartedException {
        Log.trace("addDateField()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenDateField comp = new GenDateField(this.defaultTranslations, labelTag);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenFloatField addFloatField(String translations, String labelTag, Integer length, Float initialValue) throws GenGuiAlreadyStartedException {
        Log.trace("addFloatField()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenFloatField comp = new GenFloatField(translations, labelTag, length);
        comp.setValue(initialValue);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenFloatField addFloatField(String labelTag, Integer length) throws GenGuiAlreadyStartedException {
        Log.trace("addFloatField()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenFloatField comp = new GenFloatField(this.defaultTranslations, labelTag, length);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenList addListField(String translations, String labelTag, String[] items) throws GenGuiAlreadyStartedException {
        Log.trace("addListField()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenList comp = new GenList(translations, labelTag, items);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenList addListField(String labelTag, String[] items) throws GenGuiAlreadyStartedException {
        Log.trace("addListField()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenList comp = new GenList(this.defaultTranslations, labelTag, items);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenListTranslatableString addListTranslatableString(String translations, String labelTag, String[] items) throws GenGuiAlreadyStartedException {
        Log.trace("addListTranslatableString()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenListTranslatableString comp = new GenListTranslatableString(translations, labelTag, items);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenListTranslatableString addListTranslatableString(String labelTag, String[] items) throws GenGuiAlreadyStartedException {
        Log.trace("addListTranslatableString()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenListTranslatableString comp = new GenListTranslatableString(this.defaultTranslations, labelTag, items);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenRadioButtonField addRadioButtonField(String translations, String labelTag, String[] items) throws GenGuiAlreadyStartedException {
        Log.trace("addRadioButtonField()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenRadioButtonField comp = new GenRadioButtonField(translations, labelTag, items);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenRadioButtonField addRadioButtonField(String labelTag, String[] items) throws GenGuiAlreadyStartedException {
        Log.trace("addRadioButtonField()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenRadioButtonField comp = new GenRadioButtonField(this.defaultTranslations, labelTag, items);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenComboBox addComboBox(String translations, String labelTag, String[] items) throws GenGuiAlreadyStartedException {
        Log.trace("addComboBox()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenComboBox comp = new GenComboBox(translations, labelTag, items);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenComboBox addComboBox(String labelTag, String[] items) throws GenGuiAlreadyStartedException {
        Log.trace("addComboBox()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenComboBox comp = new GenComboBox(this.defaultTranslations, labelTag, items);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenTranslatableStringComboBox addTranslatableStringComboBox(String translations, String labelTag, String[] items) throws GenGuiAlreadyStartedException {
        Log.trace("addTranslatableStringComboBox()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenTranslatableStringComboBox comp = new GenTranslatableStringComboBox(translations, labelTag, items);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenTranslatableStringComboBox addTranslatableStringComboBox(String labelTag, String[] items) throws GenGuiAlreadyStartedException {
        Log.trace("addTranslatableStringComboBox()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenTranslatableStringComboBox comp = new GenTranslatableStringComboBox(this.defaultTranslations, labelTag, items);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenCheckBox addCheckBox(String translations, String labelTag, String[] items) throws GenGuiAlreadyStartedException {
        Log.trace("addCheckBox()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenCheckBox comp = new GenCheckBox(translations, labelTag, items);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenCheckBox addCheckBox(String labelTag, String[] items) throws GenGuiAlreadyStartedException {
        Log.trace("addCheckBox()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenCheckBox comp = new GenCheckBox(this.defaultTranslations, labelTag, items);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenButton addButton(String labelTag) throws GenGuiAlreadyStartedException {
        return this.addButton(this.defaultTranslations, labelTag, 0);
    }

    public GenButton addButton(String labelTag, int side) throws GenGuiAlreadyStartedException {
        Log.trace("addButton(String,int)");
        return this.addButton(this.defaultTranslations, labelTag, side);
    }

    public GenButton addButton(String translations, String labelTag) throws GenGuiAlreadyStartedException {
        return this.addButton(translations, labelTag, 0);
    }

    public GenButton addButton(String translations, String labelTag, int side) throws GenGuiAlreadyStartedException {
        Log.trace("addButton(String,String,int)");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        if (side != 0 && side != 1) {
            throw new IllegalArgumentException("Illegal value for side=" + side);
        }
        GenButton comp = null;
        comp = null == translations ? new GenButton(labelTag) : new GenButton(translations, labelTag);
        this.comps.add(comp);
        this.myButtons.addElement(comp);
        if (this.bShouldSetButtonSizes) {
            comp.setPreferredSize(new Dimension(100, GuiConstants.HEIGHT_BUTTON));
        }
        switch (side) {
            case 0: {
                this.buttonPanel.add(comp);
                break;
            }
            case 1: {
                JPanel aButtonPanel = new JPanel();
                aButtonPanel.setLayout(new FlowLayout(0));
                aButtonPanel.add(comp);
                this.rightButtonPanel.add(aButtonPanel);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for side=" + side);
            }
        }
        return comp;
    }

    public void setButtonSizes(boolean b) {
        this.bShouldSetButtonSizes = b;
    }

    public void setEscButton(GenButton button) {
        this.myEscButton = button;
        final Runnable enableToolTip = new Runnable(){

            public void run() {
                ToolTipManager.sharedInstance().setEnabled(true);
            }
        };
        final Runnable doEscRunnable = new Runnable(){

            public void run() {
                ToolTipManager.sharedInstance().setEnabled(false);
                GenGui.this.myEscButton.invokeAction();
                try {
                    SwingUtilities.invokeLater(enableToolTip);
                }
                catch (Exception e) {
                    Log.trace("GenGui exception in when re-enabling tooltip");
                    e.printStackTrace();
                }
            }
        };
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    SwingUtilities.invokeLater(doEscRunnable);
                }
                catch (Exception e) {
                    Log.trace("GenGui exception in doEscRunnable");
                    e.printStackTrace();
                }
            }
        }, "", KeyStroke.getKeyStroke(27, 0, false), 2);
    }

    public void setDefaultButton(GenButton button) {
        this.myDefaultButton = button;
    }

    public GenTabbedPane addGenTabbedPane(String translations, String[] tabTags) throws GenGuiAlreadyStartedException {
        Log.trace("addGenTabbedPane()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenTabbedPane comp = new GenTabbedPane(translations, tabTags);
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenLeftRightPanel addLeftRightPanel() throws GenGuiAlreadyStartedException {
        Log.trace("addLeftRightPanel()");
        if (this.running) {
            throw new GenGuiAlreadyStartedException();
        }
        GenLeftRightPanel comp = new GenLeftRightPanel();
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public GenTabbedPane addGenTabbedPane(String[] tabTags) throws GenGuiAlreadyStartedException {
        return this.addGenTabbedPane(this.defaultTranslations, tabTags);
    }

    public Component add(Component comp) {
        this.comps.add(comp);
        this.attributePanel.add(comp);
        return comp;
    }

    public JPanel getRightButtonPanel() {
        return this.rightButtonPanel;
    }

    private void initGui() {
        Log.trace("initGui()");
        this.gengui = this;
        this.attributePanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.rightButtonPanel = new JPanel();
        this.attributePanel.setLayout(new ComponentBoxLayout(this.attributePanel));
        this.attrScrollPane = new JScrollPane(this.attributePanel, 20, 30);
        this.attrScrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.attrScrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        this.buttonPanel.setLayout(new FlowLayout(2, 4, 6));
        this.rightButtonPanel.setLayout(new ComponentBoxLayout(this.rightButtonPanel));
        this.setLayout(new BorderLayout());
        this.add((Component)this.attrScrollPane, "Center");
        this.add((Component)this.buttonPanel, "South");
        this.add((Component)this.rightButtonPanel, "East");
        this.myFocusLostListener = new FocusAdapter(){

            public void focusGained(FocusEvent ev) {
                GenGui.this.myPresentButton = (GenButton)ev.getSource();
                try {
                    SwingUtilities.invokeLater(GenGui.this.doSetMeDefault);
                }
                catch (Exception e) {
                    Log.trace("GenGui exception in doSetMeDefault");
                }
            }

            public void focusLost(FocusEvent ev) {
                if (ev.isTemporary()) {
                    return;
                }
                boolean buttonHasFocus = false;
                int len = GenGui.this.myButtons.size();
                for (int i = 0; i < len; ++i) {
                    if (!((GenButton)GenGui.this.myButtons.elementAt(i)).hasFocus()) continue;
                    buttonHasFocus = true;
                    break;
                }
                if (!buttonHasFocus) {
                    try {
                        SwingUtilities.invokeLater(GenGui.this.doSetDefaultButtonRunnable);
                    }
                    catch (Exception e) {
                        Log.trace("GenGui exception in doSetDefaultButtonRunnable");
                    }
                }
            }
        };
        this.myButtons = new Vector(4);
    }

    private void setSizesForButtons() {
        Component aButton;
        Component aButtonPanel;
        int i;
        Log.trace("GenGui:setSizesForButtons");
        int max = 100;
        int maxH = GuiConstants.HEIGHT_BUTTON;
        for (i = 0; i < this.rightButtonPanel.getComponentCount(); ++i) {
            aButtonPanel = this.rightButtonPanel.getComponent(i);
            if (!(aButtonPanel instanceof JPanel) || !((aButton = ((JPanel)aButtonPanel).getComponent(0)) instanceof JButton)) continue;
            if (aButton.getPreferredSize().width > max) {
                max = aButton.getPreferredSize().width;
            }
            if (aButton.getMaximumSize().height <= maxH) continue;
            maxH = aButton.getMaximumSize().height;
        }
        for (i = 0; i < this.rightButtonPanel.getComponentCount(); ++i) {
            aButtonPanel = this.rightButtonPanel.getComponent(i);
            if (!(aButtonPanel instanceof JPanel) || !((aButton = ((JPanel)aButtonPanel).getComponent(0)) instanceof JButton)) continue;
            ((JButton)aButton).setPreferredSize(new Dimension(max, maxH));
            ((JPanel)aButtonPanel).setMaximumSize(new Dimension(max + 8, maxH + 6));
        }
    }
}

