/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Color;
import java.util.StringTokenizer;
import se.ericsson.cello.support.gui.gengui.EntryField;
import se.ericsson.cello.support.gui.gengui.SyntaxException;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class GenIPAddressField
extends EntryField {
    private String value = null;
    private static final Integer IPADDRESS_LENGTH = new Integer(12);
    private boolean logicalNamesAllowed = false;

    public GenIPAddressField(String translations, String tag) {
        super(translations, tag, IPADDRESS_LENGTH);
    }

    public GenIPAddressField(String translations, String tag, Integer length) {
        super(translations, tag, length);
    }

    public GenIPAddressField(String tag) {
        super(tag, IPADDRESS_LENGTH);
    }

    public GenIPAddressField(String tag, Integer length) {
        super(tag, length);
    }

    public void setValue(String newValue) throws SyntaxException {
        Log.trace("setValue()");
        if (!this.checkValue(newValue)) {
            throw new SyntaxException();
        }
        this.textField.setForeground(Color.black);
        this.value = newValue;
        this.faultyValueEntered = false;
        this.textField.setText(this.value);
    }

    public String getValue() throws SyntaxException {
        Log.trace("getValue()");
        return this.value;
    }

    protected boolean isValidSyntax() {
        Log.trace("isValidSyntax()");
        return this.checkValue(this.textField.getText());
    }

    private boolean checkValue(String ip) {
        Log.trace("checkValue()");
        if (this.logicalNamesAllowed) {
            return true;
        }
        StringTokenizer tokens = new StringTokenizer(ip, ".", true);
        if (tokens.countTokens() != 7) {
            return ip.equals("");
        }
        if (this.isValidIpPart(tokens.nextToken())) {
            tokens.nextToken();
            if (this.isValidIpPart(tokens.nextToken())) {
                tokens.nextToken();
                if (this.isValidIpPart(tokens.nextToken())) {
                    tokens.nextToken();
                    if (this.isValidIpPart(tokens.nextToken())) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isValidIpPart(String part) {
        int test = 0;
        try {
            test = Integer.parseInt(part);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return test >= 0 && test <= 255;
    }

    protected boolean fillInValue(String text) {
        Log.trace("fillInValue()");
        if (text.equals("")) {
            if (this.value == null) {
                return false;
            }
            this.value = null;
            return true;
        }
        if (this.value != null) {
            if (this.value.equals(text)) {
                return false;
            }
            this.value = text;
            return true;
        }
        this.value = text;
        return true;
    }

    public void allowLogicalNames(boolean allow) {
        this.logicalNamesAllowed = allow;
    }

    public boolean logicalNamesAllowed() {
        return this.logicalNamesAllowed;
    }

    protected String getTag() {
        if (this.logicalNamesAllowed) {
            return "GENIPADDRESSFIELD_AND_LOGICALNAMES";
        }
        return "GENIPADDRESSFIELD";
    }
}

