/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Color;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JTextField;
import se.ericsson.cello.support.gui.gengui.EntryField;
import se.ericsson.cello.support.gui.gengui.InputVerifier;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class GenStringField
extends EntryField {
    protected String value = null;
    private InputVerifier myVerifier = null;
    private JTextField testTF = null;
    public static final InputVerifier isdnVerifier = new InputVerifier(){

        public boolean verify(JComponent input) {
            String text = ((JTextField)input).getText();
            boolean test = false;
            if (text.equals("")) {
                test = true;
            } else if (text.length() <= 15 && text.length() > 0) {
                try {
                    Long dummy = new Long(text);
                    if (!text.startsWith("0")) {
                        test = true;
                    }
                }
                catch (NumberFormatException n) {
                    // empty catch block
                }
            }
            return test;
        }
    };
    public static final InputVerifier addressInformationVerifier = new InputVerifier(){
        private String possibleCharacters = "1234567890ABCabc*?";

        public boolean verify(JComponent input) {
            StringTokenizer b;
            String text = ((JTextField)input).getText();
            boolean test = false;
            if (text.equals("")) {
                test = true;
            } else if (text.length() >= 1 && text.length() <= 37 && (b = new StringTokenizer(text, this.possibleCharacters)).countTokens() == 0) {
                test = true;
            }
            return test;
        }
    };
    public static final InputVerifier timeVerifier = new InputVerifier(){
        private int hours = 0;
        private int minutes = 0;
        private int seconds = 0;
        private boolean displaySeconds = false;

        public void displaySeconds(boolean b) {
            this.displaySeconds = b;
        }

        public boolean verify(JComponent input) {
            boolean test = false;
            String text = ((JTextField)input).getText();
            if (text.equals("")) {
                test = true;
            } else {
                StringTokenizer b = new StringTokenizer(text, ":");
                if (this.displaySeconds) {
                    if (b.countTokens() == 3) {
                        try {
                            this.hours = new Integer(b.nextToken());
                            this.minutes = new Integer(b.nextToken());
                            this.seconds = new Integer(b.nextToken());
                            if (this.hours >= 0 && this.hours < 24 && this.minutes >= 0 && this.minutes < 60 && this.seconds >= 0 && this.seconds < 60) {
                                test = true;
                            }
                        }
                        catch (NumberFormatException e) {}
                    }
                } else if (b.countTokens() == 2) {
                    try {
                        this.hours = new Integer(b.nextToken());
                        this.minutes = new Integer(b.nextToken());
                        if (this.hours >= 0 && this.hours < 24 && this.minutes >= 0 && this.minutes < 60) {
                            test = true;
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            return test;
        }
    };
    public static final InputVerifier UserLabelVerifier = new InputVerifier(){

        public boolean verify(JComponent input) {
            JTextField sf = (JTextField)input;
            boolean result = true;
            String name = sf.getText();
            if (name.length() <= 128) {
                String nonValidCharacters = "'|^\u00a4";
                for (int i = 0; i < name.length(); ++i) {
                    if (nonValidCharacters.indexOf(name.charAt(i)) == -1) continue;
                    result = false;
                    break;
                }
                return result;
            }
            return false;
        }
    };

    public GenStringField(String translations, String tag, Integer length) {
        super(translations, tag, length);
        Log.trace("");
        this.testTF = new JTextField();
    }

    public GenStringField(String tag, Integer length) {
        super(tag, length);
        Log.trace("GenStringField()");
        this.testTF = new JTextField();
    }

    public boolean setValue(String setValue) {
        Log.trace("setValue()");
        this.testTF.setText(setValue);
        if (null == this.myVerifier || this.myVerifier.verify(this.testTF)) {
            this.textField.setForeground(Color.black);
            this.textField.setText(setValue);
            this.value = setValue;
            this.faultyValueEntered = false;
            this.testTF.setText("");
            return true;
        }
        this.testTF.setText("");
        return false;
    }

    public String getValue() {
        Log.trace("getValue()");
        return this.value;
    }

    protected boolean isValidSyntax() {
        Log.trace("isValidSyntax()");
        if (this.myVerifier != null) {
            return this.myVerifier.verify(this.textField);
        }
        return true;
    }

    public void setInputVerifier(InputVerifier verifier) {
        this.myVerifier = verifier;
    }

    public boolean fillInValue(String text) {
        Log.trace("fillInValue()");
        String newValue = text;
        if (this.value != null) {
            if (this.value.equals(newValue)) {
                return false;
            }
            this.value = newValue;
            return true;
        }
        this.value = newValue;
        return true;
    }

    protected String getTag() {
        return null;
    }
}

