/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JOptionPane;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractPresenter;
import se.ericsson.cello.support.gui.guilib.infra.DialogViewContainer;
import se.ericsson.cello.support.gui.guilib.infra.ViewContainer;

class DialogPresenter
extends AbstractPresenter {
    DialogPresenter() {
    }

    ViewContainer createViewContainer() {
        return this.createDialogViewContainer(false);
    }

    ViewContainer createDialogViewContainer(boolean modal) {
        Window window;
        ViewContainer viewContainer = this.getParentPresenter().getViewContainer();
        if (viewContainer == null) {
            viewContainer = this.getApplication().getApplicationPresenter().getViewContainer();
        }
        if ((window = viewContainer.getWindow()) == null) {
            window = JOptionPane.getRootFrame();
            Log.logNotify("Reusing swing dialog parent: " + window);
        }
        try {
            viewContainer = window instanceof Frame ? new DialogViewContainer((Frame)window, modal) : new DialogViewContainer((Dialog)window, modal);
            viewContainer.init(this);
        }
        catch (Throwable t) {
            String msg = "Could not create dialog view";
            Log.logError(msg, t);
            Log.assertion(false, msg);
        }
        return viewContainer;
    }

    void init() {
        this.getView().init();
        this.getController().init();
        this.getViewContainer().setView(this.getView());
    }

    void dispose() {
        if (this.getApplication() != null && this.getApplication().getApplicationPresenter() != null && this.getApplication().getApplicationPresenter().getViewContainer() != null) {
            this.getApplication().getApplicationPresenter().getViewContainer().doValidate();
        }
        super.dispose();
    }
}

