/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;
import se.ericsson.cello.support.gui.guilib.infra.AbstractDialogController;
import se.ericsson.cello.support.gui.guilib.infra.Application;
import se.ericsson.cello.support.gui.guilib.infra.PrintPreviewView;
import se.ericsson.cello.support.gui.guilib.infra.Printout;
import se.ericsson.cello.support.gui.guilib.infra.PrintoutImpl;

class PrintPreviewController
extends AbstractDialogController {
    private int m_widthPage;
    private int m_heigthPage;
    private int orientation;
    private Printable target;
    private Printout printout;
    private PrintPreviewView printPreviewView;
    private PrintListener printListener = new PrintListener();
    private CloseListener closeListener = new CloseListener();
    private RefreshListener refreshListener = new RefreshListener();
    private ComboScaleListener comboScaleListener = new ComboScaleListener();
    private ResolutionListener resolutionListener = new ResolutionListener();

    PrintPreviewController() {
    }

    public void init() {
        this.printPreviewView = (PrintPreviewView)this.getView();
        this.printPreviewView.printButton.addActionListener(this.printListener);
        this.printPreviewView.closeButton.addActionListener(this.closeListener);
        this.printPreviewView.refreshButton.addActionListener(this.refreshListener);
        String[] scales = new String[]{"10 %", "25 %", "50 %", "100 %"};
        for (int i = 0; i < scales.length; ++i) {
            this.printPreviewView.comboScale.addItem(scales[i]);
        }
        this.printPreviewView.comboScale.setSelectedItem(scales[3]);
        this.printPreviewView.comboScale.setEditable(true);
        this.printPreviewView.comboScale.addActionListener(this.comboScaleListener);
        this.printPreviewView.resolutionButton.addActionListener(this.resolutionListener);
    }

    public void afterVisible() {
        this.printout = (Printout)this.resolveObject("infra.printout.Printout");
        this.target = (PrintoutImpl)this.resolveObject("infra.printout.PrintoutImpl");
        this.orientation = (Integer)this.resolveObject("infra.printout.Orientation");
        PrinterJob prJob = PrinterJob.getPrinterJob();
        PageFormat pgFormat = prJob.defaultPage();
        pgFormat.setOrientation(this.orientation);
        if (pgFormat.getHeight() == 0.0 || pgFormat.getWidth() == 0.0) {
            this.stopDialog();
            return;
        }
        this.m_widthPage = (int)pgFormat.getWidth();
        this.m_heigthPage = (int)pgFormat.getHeight();
        int scale = 10;
        int width = this.m_widthPage * scale / 100;
        int heigth = this.m_heigthPage * scale / 100;
        int pageIndex = 0;
        try {
            while (true) {
                BufferedImage imge = new BufferedImage(this.m_widthPage, this.m_heigthPage, 1);
                Graphics gh = imge.getGraphics();
                gh.setColor(Color.white);
                gh.fillRect(0, 0, this.m_widthPage, this.m_heigthPage);
                if (this.target.print(gh, pgFormat, pageIndex) == 0) {
                    PagePreview pP = new PagePreview(width, heigth, imge);
                    this.printPreviewView.previewContainer.add(pP);
                    ++pageIndex;
                    continue;
                }
                break;
            }
        }
        catch (PrinterException e) {
            e.printStackTrace();
            System.err.println("Report printing error: " + e.toString());
        }
        this.updatePreview();
        this.printout.previewStarted();
    }

    public void stop() {
        this.printPreviewView.printButton.removeActionListener(this.printListener);
        this.printPreviewView.closeButton.removeActionListener(this.closeListener);
        this.printPreviewView.refreshButton.removeActionListener(this.refreshListener);
        this.printPreviewView.comboScale.removeActionListener(this.comboScaleListener);
        this.printPreviewView.resolutionButton.removeActionListener(this.resolutionListener);
    }

    private void updatePreview() {
        this.printPreviewView.setCursor(Application.WAIT_CURSOR);
        int scaleValue = 100;
        int resolution = this.printPreviewView.resolutionButton.isSelected() ? 4 : 1;
        String strs = this.printPreviewView.comboScale.getSelectedItem().toString();
        if (strs.endsWith("%")) {
            strs = strs.substring(0, strs.length() - 1);
        }
        strs = strs.trim();
        try {
            scaleValue = Integer.parseInt(strs);
        }
        catch (NumberFormatException ex) {
            return;
        }
        int width = this.m_widthPage * scaleValue / 100;
        int heigth = this.m_heigthPage * scaleValue / 100;
        Component[] comps = this.printPreviewView.previewContainer.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof PagePreview)) continue;
            PagePreview pp = (PagePreview)comps[i];
            pp.setScaledSize(width, heigth, resolution);
        }
        this.printPreviewView.previewContainer.doLayout();
        this.printPreviewView.previewContainer.getParent().getParent().validate();
        this.printPreviewView.myPaint();
        this.printPreviewView.setCursor(Application.DEFAULT_CURSOR);
    }

    private class RefreshListener
    implements ActionListener {
        private RefreshListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PrintPreviewController.this.updatePreview();
        }
    }

    private static class ResolutionListener
    implements ActionListener {
        private ResolutionListener() {
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class ComboScaleListener
    implements ActionListener {
        private ComboScaleListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PrintPreviewController.this.updatePreview();
        }
    }

    private class CloseListener
    implements ActionListener {
        private CloseListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PrintPreviewController.this.stopDialog();
        }
    }

    private class PrintListener
    implements ActionListener {
        private PrintListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Thread printThread = new Thread(){

                public void run() {
                    try {
                        PrinterJob prnJob = PrinterJob.getPrinterJob();
                        PageFormat pageFormat = prnJob.pageDialog(prnJob.defaultPage());
                        prnJob.setPrintable(PrintPreviewController.this.target, pageFormat);
                        if (!prnJob.printDialog()) {
                            return;
                        }
                        prnJob.print();
                    }
                    catch (PrinterException ex) {
                        ex.printStackTrace();
                    }
                }
            };
            printThread.start();
        }
    }

    static class PagePreview
    extends JPanel {
        private int width;
        private int height;
        private Image imageFullScale;
        private Image imageScaled;

        public PagePreview(int width, int height, Image source) {
            this.imageFullScale = source;
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
            this.setScaledSize(width, height, 1);
        }

        public void setScaledSize(int width, int height, int resolution) {
            this.width = width;
            this.height = height;
            this.imageScaled = this.imageFullScale.getScaledInstance(width, height, resolution);
            this.imageScaled.flush();
        }

        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(this.width + insets.left + insets.right, this.height + insets.top + insets.bottom);
        }

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.drawImage(this.imageScaled, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), this);
            this.paintBorder(g2);
        }
    }
}

