/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.table;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import se.ericsson.cello.support.gui.guilib.table.SortedTable;
import se.ericsson.cello.support.gui.guilib.table.TableMap;

public class SortedTableModel
extends TableMap {
    private int[] indexes;
    private int indexesLength = 0;
    private Vector sortingColumn = new Vector();
    private int compare;
    private boolean[] ascendingColumn;
    private ListMouseListener list_MouseListener = null;
    private JTableHeader tableHeader = null;
    private SortedTable table;
    private boolean setSortOnRowInsertDelete = false;
    private int clickedColumn = 0;

    public SortedTableModel(TableModel m) {
        this.setModel(m);
    }

    void setModel(TableModel m) {
        super.setModel(m);
        this.ascendingColumn = new boolean[m.getColumnCount()];
        for (int i = 0; i < this.ascendingColumn.length; ++i) {
            this.ascendingColumn[i] = true;
        }
        this.reallocateIndex();
    }

    int getIndex(int row) {
        if (row < this.indexesLength && row >= 0) {
            return this.indexes[row];
        }
        throw new ArrayIndexOutOfBoundsException(row + "not in 0.." + (this.indexesLength - 1));
    }

    int getPresentedIndex(int originalRow) {
        for (int i = 0; i < this.indexesLength; ++i) {
            if (originalRow != this.indexes[i]) continue;
            int presentedRow = i;
            return presentedRow;
        }
        throw new ArrayIndexOutOfBoundsException(originalRow + " not in 0.." + (this.indexesLength - 1));
    }

    private int compareRowsByColumn(int row1, int row2, int column) {
        Object object2;
        Object object1 = this.model.getValueAt(row1, column);
        if (object1 == (object2 = this.model.getValueAt(row2, column))) {
            return 0;
        }
        if (object1 == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (this.model.getColumnName(column) == "ALARM_ID" || this.model.getColumnName(column) == "ALARMID") {
            try {
                int lastIndexOfUnderscore_o1 = object1.toString().lastIndexOf("_");
                String stringNumber_o1 = object1.toString().substring(lastIndexOfUnderscore_o1 + 1);
                int numberFromTheString_o1 = Integer.parseInt(stringNumber_o1);
                int lastIndexOfUnderscore_o2 = object2.toString().lastIndexOf("_");
                String stringNumber_o2 = object2.toString().substring(lastIndexOfUnderscore_o2 + 1);
                int numberFromTheString_o2 = Integer.parseInt(stringNumber_o2);
                if (numberFromTheString_o1 < numberFromTheString_o2) {
                    return -1;
                }
                if (numberFromTheString_o1 > numberFromTheString_o2) {
                    return 1;
                }
                return 0;
            }
            catch (Exception e) {
                return object1.toString().compareTo(object2.toString());
            }
        }
        if (object1 instanceof Comparable) {
            try {
                return ((Comparable)object1).compareTo(object2);
            }
            catch (ClassCastException e) {
                return object1.toString().compareTo(object2.toString());
            }
        }
        if (object1.getClass() == object2.getClass() && object1.getClass() == Integer.class) {
            return ((Integer)object1).compareTo((Integer)object2);
        }
        if (object1.getClass() == object2.getClass() && object1.getClass() == Boolean.class) {
            if (((Boolean)object1).equals(object2)) {
                return 0;
            }
            if (((Boolean)object1).booleanValue()) {
                return 1;
            }
            return -1;
        }
        return object1.toString().compareTo(object2.toString());
    }

    private int compare(int r1, int r2) {
        ++this.compare;
        for (int level = 0; level < this.sortingColumn.size(); ++level) {
            Integer column = (Integer)this.sortingColumn.elementAt(level);
            int result = this.compareRowsByColumn(r1, r2, column);
            if (result == 0) continue;
            return this.ascendingColumn[column] ? result : -result;
        }
        return 0;
    }

    private void reallocateIndex() {
        int rows = this.model.getRowCount();
        if (this.indexes == null || this.indexes.length < rows) {
            this.indexes = new int[rows];
        }
        for (int row = 0; row < rows; ++row) {
            this.indexes[row] = row;
        }
        this.indexesLength = rows;
        if (this.ascendingColumn.length != this.model.getColumnCount()) {
            this.ascendingColumn = new boolean[this.model.getColumnCount()];
            for (int i = 0; i < this.ascendingColumn.length; ++i) {
                this.ascendingColumn[i] = true;
            }
        }
    }

    public void tableChanged(TableModelEvent event) {
        int selectedRow = -1;
        int[] selectedRows = null;
        if (this.table != null) {
            selectedRow = this.table.getOriginalSelectedRow();
            selectedRows = this.table.getOriginalSelectedRows();
        }
        if (event.getType() == 1 || event.getType() == -1 || event.getFirstRow() == -1) {
            this.reallocateIndex();
            if (this.table != null) {
                this.table.editingStopped(new ChangeEvent(this));
            }
            if (this.setSortOnRowInsertDelete) {
                if (event.getFirstRow() == -1) {
                    this.sortingColumn.removeAllElements();
                }
                int column = 0;
                if (this.sortingColumn.size() != 0) {
                    column = (Integer)this.sortingColumn.elementAt(0);
                }
                this.sortByColumn(column);
            }
            this.sortByColumn(this.clickedColumn);
        }
        if (event.getFirstRow() == -1) {
            super.tableChanged(new TableModelEvent(this, -1));
        } else {
            TableModelEvent e = new TableModelEvent(this);
            super.tableChanged(e);
        }
        if (this.table != null && selectedRow != -1) {
            if (this.indexesLength < selectedRow + 1 || event.getFirstRow() == selectedRow) {
                this.table.clearSelection();
            } else {
                for (int i = 0; i < this.indexesLength; ++i) {
                    if (this.indexes[i] != selectedRow) continue;
                    selectedRow = i;
                    break;
                }
                this.table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                block1: for (int j = 0; j < selectedRows.length; ++j) {
                    for (int i = 0; i < this.indexesLength; ++i) {
                        if (this.indexes[i] != selectedRows[j]) continue;
                        this.table.getSelectionModel().addSelectionInterval(i, i);
                        continue block1;
                    }
                }
            }
        }
    }

    protected void checkCurrentModel() {
        if (this.indexesLength != this.model.getRowCount()) {
            this.reallocateIndex();
        }
    }

    private void sort() {
        this.checkCurrentModel();
        this.compare = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexesLength);
    }

    void doSort() {
        boolean temp = this.setSortOnRowInsertDelete;
        this.setSortOnRowInsertDelete = false;
        int column = 0;
        if (this.sortingColumn.size() != 0) {
            column = (Integer)this.sortingColumn.elementAt(0);
        }
        this.sortByColumn(column);
        this.setSortOnRowInsertDelete = temp;
    }

    private void shuttlesort(int[] from, int[] to, int l, int h) {
        if (h - l < 2) {
            return;
        }
        int m = (l + h) / 2;
        this.shuttlesort(to, from, l, m);
        this.shuttlesort(to, from, m, h);
        int p = l;
        int q = m;
        if (h - l >= 4 && this.compare(from[m - 1], from[m]) <= 0) {
            for (int k = l; k < h; ++k) {
                to[k] = from[k];
            }
            return;
        }
        for (int j = l; j < h; ++j) {
            to[j] = q >= h || p < m && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    private void swap(int m, int n) {
        int tmp = this.indexes[m];
        this.indexes[m] = this.indexes[n];
        this.indexes[n] = tmp;
    }

    public Object getValueAt(int row, int column) {
        this.checkCurrentModel();
        return this.model.getValueAt(this.indexes[row], column);
    }

    public void setValueAt(Object value, int row, int column) {
        this.checkCurrentModel();
        if (row < this.getRowCount()) {
            this.model.setValueAt(value, this.indexes[row], column);
        }
    }

    private void sortByColumn(int column) {
        this.sortingColumn.removeAllElements();
        this.sortingColumn.addElement(new Integer(column));
        this.sort();
        TableModelEvent e = new TableModelEvent(this);
        super.tableChanged(e);
    }

    void addMouseListenerToHeaderInTable(SortedTable table) {
        this.table = table;
        table.setColumnSelectionAllowed(false);
        this.tableHeader = table.getTableHeader();
        this.list_MouseListener = new ListMouseListener(this);
        this.tableHeader.addMouseListener(this.list_MouseListener);
    }

    public void removeMouseListenerToHeaderInTable() {
        if (this.list_MouseListener != null) {
            this.tableHeader.removeMouseListener(this.list_MouseListener);
        }
    }

    public void setSortOnRowInsertDelete(boolean setSortOnRowInsertDelete) {
        this.setSortOnRowInsertDelete = setSortOnRowInsertDelete;
    }

    public void resetClickedColumn() {
        this.clickedColumn = 0;
    }

    private class ListMouseListener
    extends MouseAdapter {
        SortedTableModel sorter = null;

        public ListMouseListener(SortedTableModel s) {
            this.sorter = s;
        }

        public void mouseClicked(MouseEvent e) {
            int row = -1;
            int selectedRow = SortedTableModel.this.table.getSelectedRow();
            if (selectedRow > -1) {
                row = SortedTableModel.this.indexes[selectedRow];
            }
            SortedTableModel.this.table.editingStopped(new ChangeEvent(this));
            TableColumnModel columnModel = SortedTableModel.this.table.getColumnModel();
            int columnIndex = columnModel.getColumnIndexAtX(e.getX());
            int column = SortedTableModel.this.table.convertColumnIndexToModel(columnIndex);
            SortedTableModel.this.clickedColumn = column;
            if (e.getClickCount() == 1 && column != -1) {
                ((SortedTableModel)this.sorter).ascendingColumn[column] = !SortedTableModel.this.ascendingColumn[column];
                this.sorter.sortByColumn(column);
            }
            if (row > -1) {
                for (int i = 0; i < SortedTableModel.this.indexesLength; ++i) {
                    if (SortedTableModel.this.indexes[i] != row) continue;
                    SortedTableModel.this.table.setRowSelectionInterval(i, i);
                    break;
                }
            }
        }
    }
}

