/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import se.ericsson.cello.support.logging.Level;
import se.ericsson.cello.support.logging.LogManager;
import se.ericsson.cello.support.logging.LogRecord;
import se.ericsson.cello.support.logging.SimpleFormatter;
import se.ericsson.cello.support.logging.StreamHandler;

public class ConsoleHandler
extends StreamHandler {
    private void configure() {
        LogManager managerLog = LogManager.getLogManager();
        String cnamed = ConsoleHandler.class.getName();
        Level handlerLevel = managerLog.getLevelProperty(cnamed + ".level", Level.INFO);
        System.out.println(" Level of consoler handler set to : " + handlerLevel);
        this.setLevel(handlerLevel);
        this.setFilter(managerLog.getFilterProperty(cnamed + ".filter", null));
        this.setFormatter(managerLog.getFormatterProperty(cnamed + ".formatter", new SimpleFormatter()));
        try {
            this.setEncoding(managerLog.getStringProperty(cnamed + ".encoding", null));
        }
        catch (Exception ex) {
            try {
                this.setEncoding(null);
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
    }

    public ConsoleHandler() {
        this.sealedder = false;
        this.configure();
        this.sealedder = true;
        this.setOutputStream(System.err);
    }

    public void publish(LogRecord record) {
        super.publish(record);
        this.flush();
    }

    public void close() {
        this.flush();
    }
}

