/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.mgr;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.mgr.AbstractConfirmApplication;
import se.ericsson.cello.support.mgr.ConfirmApplicationView;

public abstract class AbstractConfirmApplicationController
extends AbstractApplicationController
implements ActionListener {
    protected ConfirmApplicationView view;
    protected AbstractConfirmApplication myApplication;

    protected void init() {
        this.myApplication = (AbstractConfirmApplication)this.getApplication();
        this.view = (ConfirmApplicationView)this.getView();
        this.myApplication.setTitle(this.myApplication.getConfirmTitle(), null);
        String moHelpName = this.myApplication.getMOHelpName();
        this.view.setConfirmText(this.myApplication.getConfirmMessage());
        if (this.myApplication.moHelpButtonNeeded()) {
            this.view.moHelpButton.putClientProperty("HELP_KEY", "class " + moHelpName);
            this.view.moHelpButton.putClientProperty("HELP_ENABLE", "");
            this.view.moHelpButton.putClientProperty("TITLE", "YES");
        }
        if (this.myApplication.helpButtonNeeded()) {
            this.view.putClientProperty("HELP_KEY", this.myApplication.getHelpTag());
            this.view.helpButton.putClientProperty("HELP_KEY", this.myApplication.getHelpTag());
            this.view.helpButton.putClientProperty("HELP_ENABLE", "");
        }
        this.setButtonListeners();
    }

    protected void stop() {
        this.view.yesButton.removeActionListener(this);
        this.view.noButton.removeActionListener(this);
    }

    protected void setButtonListeners() {
        this.view.yesButton.setActionListener(this, "YES");
        this.view.noButton.setActionListener(this, "NO");
    }

    protected void afterVisible() {
        this.setDefaultFocusNoButton();
    }

    public void setDefaultFocusNoButton() {
        this.view.noButton.requestFocus();
    }

    public void setDefaultFocusYesButton() {
        this.view.yesButton.requestFocus();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("YES")) {
            this.performAction();
            this.myApplication.stopApplication();
        } else {
            this.myApplication.stopApplication();
        }
    }

    public boolean canStop() {
        return true;
    }

    public void setConfirmationMessage(String aText, Object[] args) {
        this.view.setConfirmText(this.getString(aText, args));
    }

    public abstract void performAction();
}

