/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.proxy;

import BasicConfig.ProcessingFailure;
import BasicConfig.Session;
import BasicConfig.TransactionFailure;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import org.omg.CORBA.NO_PERMISSION;
import se.ericsson.cello.support.logging.Level;
import se.ericsson.cello.support.logging.Logger;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.CSFacade;
import se.ericsson.cello.support.proxy.ExceptionHandler;

public class Transaction {
    public Session session;
    public static final Session SESSION_NULL = null;
    private static Logger transactionLog = Logger.getLogger("se.ericsson.cello.support.moproxy.transactionLog");
    private static Logger moExceptionLog = Logger.getLogger("se.ericsson.cello.support.moproxy.moExceptionLog");
    private String defaultSessionId_EMAS = "EMAS_session";

    public Transaction() throws CSException {
        this("", -1);
    }

    public Transaction(String sessionId) throws CSException {
        this(sessionId, -1);
    }

    public Transaction(int timeout) throws CSException {
        this("", timeout);
    }

    public Transaction(String sessionId, int timeout) throws CSException {
        if (sessionId == null || sessionId.trim() == "") {
            sessionId = this.defaultSessionId_EMAS;
        }
        long startTime = System.currentTimeMillis();
        CSFacade cs = CSFacade.getInstance();
        this.session = cs.createSession(sessionId, timeout);
        Long duration = new Long(System.currentTimeMillis() - startTime);
        transactionLog.log(Level.FINE, "Start transaction", new Object[]{"", "", "Transaction " + this.hashCode(), "Start", duration, this.whoCalled()});
    }

    public String get_session_id() {
        return this.session.get_session_id();
    }

    public void restart() throws CSException {
        long startTime = System.currentTimeMillis();
        try {
            this.session.restart();
        }
        catch (ProcessingFailure e) {
            moExceptionLog.log(Level.FINE, "ProcessingFailure exception", new Object[]{"", "", "Transaction " + this.hashCode(), "Restart", new Long(-1L), this.whoCalled(), "ProcessingFailure exception"});
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new Object[]{"", "", "Transaction " + this.hashCode(), "Restart", new Long(-1L), this.whoCalled(), "CORBA::NO_PERMISSION exception"});
            throw ExceptionHandler.map(e, "AUTH_READ_ERROR");
        }
        Long duration = new Long(System.currentTimeMillis() - startTime);
        transactionLog.log(Level.FINE, "Restart transaction", new Object[]{"", "", "Transaction " + this.hashCode(), "Restart", duration, this.whoCalled()});
    }

    public static void cleanup() {
        transactionLog = null;
        moExceptionLog = null;
    }

    public void begin() throws CSException {
        this.begin(-1);
    }

    public void begin(int operationTimeout) throws CSException {
        try {
            this.session.begin(operationTimeout);
        }
        catch (ProcessingFailure e) {
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            throw ExceptionHandler.map(e, "AUTH_READ_ERROR");
        }
    }

    public void rollback() throws CSException {
        Long duration;
        long startTime = System.currentTimeMillis();
        try {
            this.session.rollback();
            duration = new Long(System.currentTimeMillis() - startTime);
        }
        catch (TransactionFailure e) {
            moExceptionLog.log(Level.FINE, "TransactionFailure exception", new Object[]{"", "", "Transaction " + this.hashCode(), "Rollback", new Long(-1L), this.whoCalled(), "TransactionFailure exception"});
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new Object[]{"", "", "Transaction " + this.hashCode(), "Rollback", new Long(-1L), this.whoCalled(), "CORBA::NO_PERMISSION exception"});
            throw ExceptionHandler.map(e, "AUTH_READ_ERROR");
        }
        duration = new Long(System.currentTimeMillis() - startTime);
        transactionLog.log(Level.FINE, "Rollback transaction", new Object[]{"", "", "Transaction " + this.hashCode(), "Rollback", duration, this.whoCalled()});
    }

    public void commit() throws CSException {
        long startTime = System.currentTimeMillis();
        try {
            this.session.commit();
        }
        catch (TransactionFailure e) {
            moExceptionLog.log(Level.FINE, "TransactionFailure exception", new Object[]{"", "", "Transaction " + this.hashCode(), "Commit", new Long(-1L), this.whoCalled(), "TransactionFailure exception"});
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new Object[]{"", "", "Transaction " + this.hashCode(), "Commit", new Long(-1L), this.whoCalled(), "CORBA::NO_PERMISSION exception"});
            throw ExceptionHandler.map(e, "AUTH_READ_ERROR");
        }
        Long duration = new Long(System.currentTimeMillis() - startTime);
        transactionLog.log(Level.FINE, "Commit transaction", new Object[]{"", "", "Transaction " + this.hashCode(), "Commit", duration, this.whoCalled()});
    }

    public void end() throws CSException {
        long startTime = System.currentTimeMillis();
        try {
            this.session.end();
        }
        catch (TransactionFailure e) {
            moExceptionLog.log(Level.FINE, "TransactionFailure exception", new Object[]{"", "", "Transaction " + this.hashCode(), "End", new Long(-1L), this.whoCalled(), "TransactionFailure exception"});
            throw ExceptionHandler.map(e, "");
        }
        catch (NO_PERMISSION e) {
            moExceptionLog.log(Level.FINE, "CORBA::NO_PERMISSION exception", new Object[]{"", "", "Transaction " + this.hashCode(), "End", new Long(-1L), this.whoCalled(), "CORBA::NO_PERMISSION exception"});
            throw ExceptionHandler.map(e, "AUTH_READ_ERROR");
        }
        Long duration = new Long(System.currentTimeMillis() - startTime);
        transactionLog.log(Level.FINE, "End transaction", new Object[]{"", "", "Transaction " + this.hashCode(), "End", duration, this.whoCalled()});
    }

    private String whoCalled() {
        Throwable th = new Throwable();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        StringTokenizer st = new StringTokenizer(sw.toString(), "\n");
        boolean found = false;
        String token = null;
        if (st.hasMoreTokens()) {
            token = st.nextToken();
        }
        while (st.hasMoreTokens() && !found) {
            token = st.nextToken();
            if (token.indexOf("se.ericsson.cello.support.proxy") != -1) continue;
            token = token.trim();
            found = true;
        }
        return token;
    }
}

