/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.fm.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.UIManager;

public class BevelArrowIcon
implements Icon {
    public static final int UP_DIRECTION = 0;
    public static final int DOWN_DIRECTION = 1;
    private static final int D_SIZE = 11;
    private Color e1;
    private Color e2;
    private Color fillColor;
    private int s;
    private int direct;

    public BevelArrowIcon(int direc, boolean isRaised, boolean isPressedView) {
        if (isRaised) {
            if (isPressedView) {
                this.init(UIManager.getColor("controlLtHighlight"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlShadow"), 11, direc);
            } else {
                this.init(UIManager.getColor("controlHighlight"), UIManager.getColor("controlShadow"), UIManager.getColor("control"), 11, direc);
            }
        } else if (isPressedView) {
            this.init(UIManager.getColor("controlDkShadow"), UIManager.getColor("controlLtHighlight"), UIManager.getColor("controlShadow"), 11, direc);
        } else {
            this.init(UIManager.getColor("controlShadow"), UIManager.getColor("controlHighlight"), UIManager.getColor("control"), 11, direc);
        }
    }

    public BevelArrowIcon(Color e1, Color e2, Color fill, int size, int direction) {
        this.init(e1, e2, fill, size, direction);
    }

    public void paintIcon(Component c, Graphics graph, int i, int j) {
        switch (this.direct) {
            case 1: {
                this.drawDownArrow(graph, i, j);
                break;
            }
            case 0: {
                this.drawUpArrow(graph, i, j);
            }
        }
    }

    public int getIconWidth() {
        return this.s;
    }

    public int getIconHeight() {
        return this.s;
    }

    private void init(Color e1, Color e2, Color fill, int size, int direction) {
        this.e1 = e1;
        this.e2 = e2;
        this.fillColor = fill;
        this.s = size;
        this.direct = direction;
    }

    private Graphics drawDownLine(Graphics g, int xi, int yi) {
        int xo = xi + 1;
        int yo = yi + 2;
        int ds = this.s - 6;
        while (yo + 1 < yi + this.s) {
            g.setColor(this.e1);
            g.drawLine(xo, yo, xo + 1, yo);
            g.drawLine(xo, yo + 1, xo + 1, yo + 1);
            if (0 < ds) {
                g.setColor(this.fillColor);
                g.drawLine(xo + 2, yo, xo + 1 + ds, yo);
                g.drawLine(xo + 2, yo + 1, xo + 1 + ds, yo + 1);
            }
            g.setColor(this.e2);
            g.drawLine(xo + ds + 2, yo, xo + ds + 3, yo);
            g.drawLine(xo + ds + 2, yo + 1, xo + ds + 3, yo + 1);
            ++xo;
            yo += 2;
            ds -= 2;
        }
        return g;
    }

    private void drawDownArrow(Graphics g, int xi, int yi) {
        g.setColor(this.e1);
        g.drawLine(xi, yi, xi + this.s - 1, yi);
        g.drawLine(xi, yi + 1, xi + this.s - 3, yi + 1);
        g.setColor(this.e2);
        g.drawLine(xi + this.s - 2, yi + 1, xi + this.s - 1, yi + 1);
        g = this.drawDownLine(g, xi, yi);
        g.setColor(this.e1);
        g.drawLine(xi + this.s / 2, yi + this.s - 1, xi + this.s / 2, yi + this.s - 1);
    }

    private Graphics drawUpLine(Graphics g, int xu, int yu) {
        int xo = xu + this.s / 2;
        g.drawLine(xo, yu, xo, yu);
        --xo;
        int yo = yu + 1;
        int d = 0;
        while (yo + 3 < yu + this.s) {
            g.setColor(this.e1);
            g.drawLine(xo, yo, xo + 1, yo);
            g.drawLine(xo, yo + 1, xo + 1, yo + 1);
            if (0 < d) {
                g.setColor(this.fillColor);
                g.drawLine(xo + 2, yo, xo + 1 + d, yo);
                g.drawLine(xo + 2, yo + 1, xo + 1 + d, yo + 1);
            }
            g.setColor(this.e2);
            g.drawLine(xo + d + 2, yo, xo + d + 3, yo);
            g.drawLine(xo + d + 2, yo + 1, xo + d + 3, yo + 1);
            --xo;
            yo += 2;
            d += 2;
        }
        return g;
    }

    private void drawUpArrow(Graphics g, int xu, int yu) {
        g.setColor(this.e1);
        g = this.drawUpLine(g, xu, yu);
        g.setColor(this.e1);
        g.drawLine(xu, yu + this.s - 3, xu + 1, yu + this.s - 3);
        g.setColor(this.e2);
        g.drawLine(xu + 2, yu + this.s - 2, xu + this.s - 1, yu + this.s - 2);
        g.drawLine(xu, yu + this.s - 1, xu + this.s, yu + this.s - 1);
    }
}

