/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.fm.common;

import java.util.ResourceBundle;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;

public class EventType
implements Comparable {
    private static ResourceBundle myBundle = null;
    public static EventType CommunicationAlarm = new EventType("x1");
    public static EventType ProcessingAlarm = new EventType("x2");
    public static EventType EnvironmentAlarm = new EventType("x3");
    public static EventType QoSAlarm = new EventType("x4");
    public static EventType EquipmentAlarm = new EventType("x5");
    private String myEventTypeState;
    private String myPresentationString = "";

    private EventType(String eventTypeState) {
        if (myBundle == null) {
            String languageKey = "se.ericsson.cello.emas.fm.resources.language.FaultManagementLanguage";
            myBundle = GuilibResourceBundle.getBundle((String)languageKey, (ClassLoader)this.getClass().getClassLoader());
        }
        this.myEventTypeState = eventTypeState;
        if (this.myEventTypeState.equals("x1")) {
            this.myPresentationString = myBundle.getString("ET_COMMUNICATIONS_ALARM_STRING");
        } else if (this.myEventTypeState.equals("x2")) {
            this.myPresentationString = myBundle.getString("ET_PROCESSING_ERROR_ALARM_STRING");
        } else if (this.myEventTypeState.equals("x3")) {
            this.myPresentationString = myBundle.getString("ET_ENVIRONMENTAL_ALARM_STRING");
        } else if (this.myEventTypeState.equals("x4")) {
            this.myPresentationString = myBundle.getString("ET_QUALITY_OF_SERVICE_ALARM_STRING");
        } else if (this.myEventTypeState.equals("x5")) {
            this.myPresentationString = myBundle.getString("ET_EQUIPMENT_ALARM_STRING");
        }
    }

    public static EventType getEventType(String eventState) {
        EventType eventType = null;
        if (eventState.equals("x1")) {
            eventType = CommunicationAlarm;
        } else if (eventState.equals("x2")) {
            eventType = ProcessingAlarm;
        } else if (eventState.equals("x3")) {
            eventType = EnvironmentAlarm;
        } else if (eventState.equals("x4")) {
            eventType = QoSAlarm;
        } else if (eventState.equals("x5")) {
            eventType = EquipmentAlarm;
        }
        return eventType;
    }

    public String getEventTypeStringValue() {
        return this.myEventTypeState;
    }

    public int compareTo(Object obj) {
        if (obj instanceof EventType) {
            return this.myPresentationString.compareTo(String.valueOf(obj));
        }
        throw new ClassCastException();
    }

    public String toString() {
        return this.myPresentationString;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EventType) {
            String value = ((EventType)obj).getEventTypeStringValue();
            return this.myEventTypeState.equals(value);
        }
        return false;
    }

    public int hashCode() {
        return this.myEventTypeState.hashCode();
    }
}

