/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.fm.elv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.omg.TimeBase.UtcT;
import se.ericsson.cello.emas.fm.common.EventEventType;
import se.ericsson.cello.emas.fm.common.ExtendedEventType;
import se.ericsson.cello.emas.fm.common.RowDataInterface;
import se.ericsson.cello.emas.fm.common.TimeFormatter;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class EventLogRecord
implements RowDataInterface {
    private int numberOfTypeValuePairs;
    private List additionalInformationType = new ArrayList();
    private List additionalInformationValue = new ArrayList();
    private Map myAttributeValue = new HashMap();
    private boolean errorInRecord = true;

    public EventLogRecord(String tokenString) {
        this.fillAttributes(this.parseTokens(tokenString));
    }

    public Object getValueAt(String colName) {
        return this.myAttributeValue.get(colName);
    }

    public String getAdditionalInfo(ResourceBundle bundle) {
        StringBuffer strBuf = new StringBuffer();
        String fontName = new String("Arial");
        strBuf.append("<html>");
        strBuf.append("<FONT FACE=");
        strBuf.append('\"');
        strBuf.append(fontName);
        strBuf.append('\"');
        strBuf.append(">");
        strBuf.append("<font size = -1>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("EVENT_TIME_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(TimeFormatter.setTimeFormat(this.getStringValue("EVENT_TIME")));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("EVENT_TYPE_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("EVENT_EVENT_TYPE"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("EXTENDED_EVENT_TYPE_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("EXTENDED_EVENT_TYPE"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("SPECIFIC_EVENT_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("SPECIFIC_EVENT"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("ADDITIONAL_TEXT_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("ADDITIONAL_TEXT"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("MANAGED_OBJECT_CLASS_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("MANAGED_OBJECT_CLASS"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("MANAGED_OBJECT_INSTANCE_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("MANAGED_OBJECT_INSTANCE"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("NOTIFICATION_ID_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("NOTIFICATION_ID"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("SYSTEM_DN_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("SYSTEM_DN"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("ADDITIONAL_INFORMATION_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append("<ul>");
        for (int i = 0; i < this.numberOfTypeValuePairs; ++i) {
            strBuf.append("<li>");
            strBuf.append(this.additionalInformationType.get(i));
            strBuf.append(": ");
            strBuf.append(this.additionalInformationValue.get(i));
            strBuf.append("</li>");
        }
        strBuf.append("</ul>");
        strBuf.append("<BR>");
        strBuf.append("</font>");
        strBuf.append("</html>");
        return strBuf.toString();
    }

    public String getLineForWriting() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(TimeFormatter.setTimeFormat(this.getStringValue("EVENT_TIME")));
        strBuf.append(";");
        strBuf.append(this.getStringValue("EVENT_EVENT_TYPE"));
        strBuf.append(";");
        strBuf.append(this.getStringValue("EXTENDED_EVENT_TYPE"));
        strBuf.append(";");
        strBuf.append(this.getStringValue("SPECIFIC_EVENT"));
        strBuf.append(";");
        String tmpAddText = this.getStringValue("ADDITIONAL_TEXT");
        tmpAddText = tmpAddText.replace('\n', ' ');
        tmpAddText = tmpAddText.replace('\t', ' ');
        tmpAddText = tmpAddText.replace('\r', ' ');
        strBuf.append(tmpAddText);
        strBuf.append(";");
        strBuf.append(this.getStringValue("MANAGED_OBJECT_CLASS"));
        strBuf.append(";");
        strBuf.append(this.getStringValue("MANAGED_OBJECT_INSTANCE"));
        strBuf.append(";");
        strBuf.append(this.getStringValue("NOTIFICATION_ID"));
        strBuf.append(";");
        strBuf.append(this.getStringValue("SYSTEM_DN"));
        strBuf.append(";");
        for (int i = 0; i < this.numberOfTypeValuePairs; ++i) {
            strBuf.append(this.additionalInformationType.get(i));
            strBuf.append(": ");
            String tmp1 = (String)this.additionalInformationValue.get(i);
            tmp1 = tmp1.replace('\n', ' ');
            tmp1 = tmp1.replace('\t', ' ');
            tmp1 = tmp1.replace('\r', ' ');
            strBuf.append(tmp1);
            strBuf.append(" | ");
        }
        strBuf.append(";");
        strBuf.append("\n");
        return strBuf.toString();
    }

    public String toString() {
        return this.myAttributeValue.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EventLogRecord) {
            EventLogRecord elr = (EventLogRecord)obj;
            String uniqIdObj = elr.getNotificationId();
            String uniqIdThis = this.getNotificationId();
            return uniqIdObj.equals(uniqIdThis);
        }
        return false;
    }

    public int hashCode() {
        return this.getStringValue("NOTIFICATION_ID").hashCode();
    }

    private List parseTokens(String s) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, ";", true);
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            tokens.add(tmp);
        }
        return tokens;
    }

    private void fillAttributes(List tokens) {
        try {
            int index = 0;
            String domainName = (String)tokens.get(index);
            this.myAttributeValue.put("DOMAIN_NAME", domainName);
            String type = (String)tokens.get(index += 2);
            EventEventType tmpEventType = EventEventType.getEventType(type);
            String eventType = tmpEventType.toString();
            this.myAttributeValue.put("EVENT_EVENT_TYPE", eventType);
            ExtendedEventType extendedEventType = ExtendedEventType.getExtendedEventType((String)tokens.get(index += 2));
            this.myAttributeValue.put("EXTENDED_EVENT_TYPE", extendedEventType);
            String managedObjectClass = (String)tokens.get(index += 2);
            this.myAttributeValue.put("MANAGED_OBJECT_CLASS", managedObjectClass);
            String managedObjectInstance = (String)tokens.get(index += 2);
            this.myAttributeValue.put("MANAGED_OBJECT_INSTANCE", managedObjectInstance);
            String notificationId = (String)tokens.get(index += 2);
            this.myAttributeValue.put("NOTIFICATION_ID", notificationId);
            String eventTime = (String)tokens.get(index += 2);
            String systemDN = "";
            if (!((String)tokens.get(index += 2)).equals(";")) {
                systemDN = (String)tokens.get(index);
                index += 2;
            } else {
                systemDN = "";
                ++index;
            }
            this.myAttributeValue.put("SYSTEM_DN", systemDN);
            String specificEvent = (String)tokens.get(index);
            this.myAttributeValue.put("SPECIFIC_EVENT", specificEvent);
            String additionalText = "";
            if (!((String)tokens.get(index += 2)).equals(";")) {
                additionalText = (String)tokens.get(index);
                index += 2;
            } else {
                additionalText = "";
                ++index;
            }
            this.myAttributeValue.put("ADDITIONAL_TEXT", additionalText);
            String timeZone = (String)tokens.get(index);
            if ((index += 2) > tokens.size() - 1) {
                this.numberOfTypeValuePairs = 0;
            } else {
                try {
                    this.numberOfTypeValuePairs = new Integer(((String)tokens.get(index)).trim());
                }
                catch (Exception x1) {
                    Log.trace((String)("Alarmlog error: numberOfTypeValuePairs, index=" + index));
                    this.numberOfTypeValuePairs = 0;
                }
                index += 2;
                for (int x = 0; x < this.numberOfTypeValuePairs; ++x) {
                    if (!((String)tokens.get(index)).equals(";")) {
                        this.additionalInformationType.add((String)tokens.get(index));
                        index += 2;
                    } else {
                        this.additionalInformationType.add("");
                        ++index;
                    }
                    if (!((String)tokens.get(index)).equals(";")) {
                        this.additionalInformationValue.add((String)tokens.get(index));
                        index += 2;
                        continue;
                    }
                    this.additionalInformationValue.add("");
                    ++index;
                }
            }
            int inacclo = 0;
            short inacchi = 0;
            short tdf = 0;
            UtcT utcT_eventTime = new UtcT(new Long(eventTime).longValue(), inacclo, inacchi, tdf);
            String time = Long.toString(utcT_eventTime.time);
            this.myAttributeValue.put("EVENT_TIME", time);
        }
        catch (Exception e) {
            this.errorInRecord = false;
        }
    }

    public String getEventTime() {
        return (String)this.myAttributeValue.get("EVENT_TIME");
    }

    public String getEventType() {
        String et = (String)this.myAttributeValue.get("EVENT_EVENT_TYPE");
        return et;
    }

    public ExtendedEventType getExtendedEventType() {
        return (ExtendedEventType)this.myAttributeValue.get("EXTENDED_EVENT_TYPE");
    }

    public String getSpecificEvent() {
        return (String)this.myAttributeValue.get("SPECIFIC_EVENT");
    }

    public String getNotificationId() {
        return (String)this.myAttributeValue.get("NOTIFICATION_ID");
    }

    public boolean getErrorInRecord() {
        return this.errorInRecord;
    }

    private String getStringValue(String tag) {
        return this.myAttributeValue.get(tag).toString();
    }
}

