/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportsystemconfiguration.helper;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.swmanagement.ConfigurationVersionMo;
import se.ericsson.cello.swmanagement.LoadModuleMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.xml.Parser;
import se.ericsson.crbs.omf.mao.xml.ParserFactory;
import se.ericsson.crbs.omf.mao.xml.XMLElement;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationFailedException;

public class CabinetParametersHelper {
    private static final String CABINET_TYPE_START_STRING_RBS = "RBS";
    private static final String CABINET_TYPE_START_STRING_POWER = "POWER";
    private static final String CABINET_TYPE_START_STRING_RACK = "RACK";
    private static final int CABINET_TYPE_LENGTH_RBS = 7;
    private static final int CABINET_TYPE_LENGTH_POWER = 9;
    private static final int CABINET_TYPE_LENGTH_RACK = 4;
    private static final char SPACE_CHARACTER = ' ';
    private static final Class THIS_CLASS = CabinetParametersHelper.class;
    public static final String CABINETPAR_CXC_CRBS = "CXC2010275/";
    public static final String XML_FILE_NAME = "RbsCabinetParametersLm.xml";
    public static final String XML_FILE_SUBPATH = "cabinet" + File.separator;
    public static final String ATTRIBUTE_CLIMATE_REGULATION_SYSTEM = "climateRegulationSystem";
    public static final int NO_OF_CABINET_PARAMETERS = 100;
    public static final String MANAGED_ELEMENT_LDN = "ManagedElement=1";
    private static final String CONFIGURATION_VERSION_LDN = "ManagedElement=1,SwManagement=1,ConfigurationVersion=1";
    public static final String CABINET_LDN = "ManagedElement=1,Equipment=1,Cabinet=1";
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static Object parseLock = new Object();
    private static String cabinetType;
    private static String climateRegulationSystem;
    private static String loadModuleFilePath;
    private static Integer[] cabinetParametersProfileStandard;
    private static Integer[] cabinetParametersProfileExtended;
    private static int defaultNumberExternalNodes;

    public static boolean isValidProductName(String string, GenericMaoContext genericMaoContext) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "isValidProductName() -- productName: " + string);
        String string2 = CabinetParametersHelper.extractProductNameFromCabinetPID(string);
        boolean bl = CabinetParametersHelper.getSupportedCabinetTypes(genericMaoContext).contains(string2);
        logger.traceReturn(THIS_CLASS, "isValidProductName() -- result: " + bl);
        return bl;
    }

    public static String removeSpaces(String string) {
        logger.traceEnter(THIS_CLASS, "removeSpaces() - text: " + string);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (' ' == c) continue;
            stringBuffer.append(c);
        }
        String string2 = stringBuffer.toString();
        logger.traceReturn(THIS_CLASS, "removeSpaces() -- result: " + string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getSupportedCabinetTypes(GenericMaoContext genericMaoContext) throws MoAccessException {
        Object object = parseLock;
        synchronized (object) {
            logger.traceEnter(THIS_CLASS, "supportedCabinetTypes()");
            String string = CabinetParametersHelper.getLocalLoadModuleFilePath(genericMaoContext);
            ArrayList<String> arrayList = new ArrayList<String>();
            Parser parser = null;
            try {
                parser = CabinetParametersHelper.createParser(string, genericMaoContext);
            }
            catch (IOException iOException) {
                throw new SupportSystemConfigurationFailedException("Failed to open CabinetParameters file: " + iOException.getMessage());
            }
            List list = parser.getXMLelements();
            if (list == null) {
                throw new SupportSystemConfigurationFailedException("Could not parse CabinetParameters file, invalid XML.");
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                XMLElement xMLElement = (XMLElement)iterator.next();
                String string2 = xMLElement.getAttributes().getValue("type");
                logger.traceDebug(THIS_CLASS, "Found cabinetType = " + string2 + " in xml-file");
                arrayList.add(string2);
            }
            logger.traceReturn(THIS_CLASS, "supportedCabinetTypes()");
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer[] getCabinetParametersProfileStandard(String string, String string2, GenericMaoContext genericMaoContext, Coordinator coordinator) throws MoAccessException {
        Object object = parseLock;
        synchronized (object) {
            CabinetParametersHelper.parseIfNecessary(string, string2, genericMaoContext, coordinator);
            return cabinetParametersProfileStandard;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer[] getCabinetParametersProfileExtended(String string, String string2, GenericMaoContext genericMaoContext, Coordinator coordinator) throws MoAccessException {
        Object object = parseLock;
        synchronized (object) {
            CabinetParametersHelper.parseIfNecessary(string, string2, genericMaoContext, coordinator);
            return cabinetParametersProfileExtended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDefaultNumberExternalNodes(GenericMaoContext genericMaoContext, Coordinator coordinator) throws MoAccessException {
        String string = null;
        String string2 = null;
        Object object = parseLock;
        synchronized (object) {
            CabinetParametersHelper.parseIfNecessary(string, string2, genericMaoContext, coordinator);
            return defaultNumberExternalNodes;
        }
    }

    private static void parseIfNecessary(String string, String string2, GenericMaoContext genericMaoContext, Coordinator coordinator) throws MoAccessException {
        if (genericMaoContext == null) {
            throw new SupportSystemConfigurationFailedException("Failed to parse CabinetParameters due to internal error (no genericMaoContext)");
        }
        String string3 = null;
        string3 = string == null || string.trim().equals("") ? CabinetParametersHelper.filterCabinetType(CabinetParametersHelper.getProductNameFromManagedElementMO(genericMaoContext, coordinator)) : CabinetParametersHelper.extractProductNameFromCabinetPID(string);
        String string4 = CabinetParametersHelper.getLocalLoadModuleFilePath(genericMaoContext);
        String string5 = string2;
        if (!(cabinetType != null && loadModuleFilePath != null && climateRegulationSystem != null && string5 != null && string3.equalsIgnoreCase(cabinetType) && string4.equals(loadModuleFilePath) && string5.equals(climateRegulationSystem))) {
            CabinetParametersHelper.parseCabinetParametersFile(string3, string5, string4, genericMaoContext);
        }
    }

    private static void parseCabinetParametersFile(String string, String string2, String string3, GenericMaoContext genericMaoContext) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getCabinetParametersFromFile() - cabinetType: " + string);
        Parser parser = null;
        try {
            parser = CabinetParametersHelper.createParser(string3, genericMaoContext);
        }
        catch (IOException iOException) {
            throw new SupportSystemConfigurationFailedException("Failed to open CabinetParameters file: " + iOException.getMessage());
        }
        List list = parser.getXMLelements();
        if (list == null) {
            throw new SupportSystemConfigurationFailedException("Could not parse CabinetParameters file, invalid XML.");
        }
        String string4 = "";
        String string5 = "";
        String string6 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement = (XMLElement)iterator.next();
            String string7 = xMLElement.getAttributes().getValue("type");
            logger.traceDebug(THIS_CLASS, "Found cabinetType = " + string7 + " in xml-file");
            if (!string.equalsIgnoreCase(string7)) continue;
            logger.traceDebug(THIS_CLASS, "Found wanted cabinetType in xml-file");
            Iterator iterator2 = xMLElement.getChildren().iterator();
            while (iterator2.hasNext()) {
                XMLElement xMLElement2 = (XMLElement)iterator2.next();
                logger.traceDebug(THIS_CLASS, "Found xmlParameter = " + xMLElement2 + " in xml-file");
                if (ATTRIBUTE_CLIMATE_REGULATION_SYSTEM.equalsIgnoreCase(xMLElement2.getType())) {
                    String string8 = xMLElement2.getAttributes().getValue("value");
                    String string9 = xMLElement2.getAttributes().getValue("type");
                    logger.traceDebug(THIS_CLASS, "Found climateRegulationSystem = " + string8 + " (" + string9 + ") in xml-file");
                    if (string2 == null || !string2.equalsIgnoreCase(string8)) continue;
                    logger.traceDebug(THIS_CLASS, "Found wanted ClimateRegulationSystem in xml-file");
                    Iterator iterator3 = xMLElement2.getChildren().iterator();
                    while (iterator3.hasNext()) {
                        XMLElement xMLElement3 = (XMLElement)iterator3.next();
                        if ("ProfileStandard".equalsIgnoreCase(xMLElement3.getType())) {
                            logger.traceDebug(THIS_CLASS, "Found Standard Cabinet Parameters in xml-file");
                            string4 = xMLElement3.getAttributes().getValue("value");
                            bl = true;
                            continue;
                        }
                        if (!"ProfileExtended".equalsIgnoreCase(xMLElement3.getType())) continue;
                        logger.traceDebug(THIS_CLASS, "Found Extended Cabinet Parameters in xml-file");
                        string5 = xMLElement3.getAttributes().getValue("value");
                        bl2 = true;
                    }
                    continue;
                }
                if (!"ExternalNodes".equalsIgnoreCase(xMLElement2.getType())) continue;
                string6 = xMLElement2.getAttributes().getValue("value");
                logger.traceDebug(THIS_CLASS, "Found ExternalNodes = " + string6 + " in xml-file");
                bl3 = true;
            }
        }
        if (string2 != null) {
            if (!bl && !bl2) {
                throw new SupportSystemConfigurationFailedException("Cabinet type: " + string + " with Climate Regulation System: " + string2 + " is not supported!");
            }
            cabinetParametersProfileStandard = bl ? CabinetParametersHelper.commaSeparatedValueStringToCabinetParameters(string4) : CabinetParametersHelper.commaSeparatedValueStringToCabinetParameters(string5);
            cabinetParametersProfileExtended = bl2 ? CabinetParametersHelper.commaSeparatedValueStringToCabinetParameters(string5) : CabinetParametersHelper.commaSeparatedValueStringToCabinetParameters(string4);
        }
        if (bl3) {
            try {
                defaultNumberExternalNodes = Integer.parseInt(string6);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SupportSystemConfigurationFailedException("Cabinet type: " + string + " has invalid value for default number of ExternalNode's!");
            }
        } else {
            defaultNumberExternalNodes = 0;
        }
        cabinetType = string;
        climateRegulationSystem = string2;
        loadModuleFilePath = string3;
    }

    public static String getProductNameFromManagedElementMO(GenericMaoContext genericMaoContext, Coordinator coordinator) throws MoAccessException {
        ManagedElementMo managedElementMo = (ManagedElementMo)genericMaoContext.getMoRepositoryWrapper().lookup(MANAGED_ELEMENT_LDN);
        if (null == managedElementMo) {
            throw new SupportSystemConfigurationFailedException("Can't find ManagedElement=1");
        }
        return managedElementMo.getProductName(coordinator);
    }

    private static String filterCabinetType(String string) {
        String string2 = CabinetParametersHelper.removeSpaces(string);
        if (string2 != null && (string2.endsWith("L") || string2.endsWith("W") || string2.endsWith("G"))) {
            string2 = CabinetParametersHelper.filterCabinetType(string2.substring(0, string2.length() - 1));
        }
        return string2;
    }

    public static String extractProductNameFromCabinetPID(String string) {
        logger.traceEnter(THIS_CLASS, "extractProductNameFromCabinetPID() -- productName: " + string);
        String string2 = CabinetParametersHelper.removeSpaces(string.toUpperCase());
        int n = string2.indexOf(CABINET_TYPE_START_STRING_RBS);
        int n2 = string2.indexOf(CABINET_TYPE_START_STRING_POWER);
        int n3 = string2.indexOf(CABINET_TYPE_START_STRING_RACK);
        String string3 = n >= 0 && string2.length() >= n + 7 ? string2.substring(n, n + 7) : (n2 >= 0 && string2.length() >= n2 + 9 ? string2.substring(n2, n2 + 9) : (n3 >= 0 && string2.length() >= n3 + 4 ? string2.substring(n3, n3 + 4) : ""));
        if ("RBS6201".equals(string3)) {
            logger.traceGeneral(THIS_CLASS, "Changing RBS6201 to RBS6201V2");
            string3 = "RBS6201V2";
        }
        logger.traceReturn(THIS_CLASS, "extractProductNameFromCabinetPID()");
        return string3;
    }

    private static String getFilePathFromLoadModuleMo(GenericMaoContext genericMaoContext) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getFilePathFromLoadModuleMo()");
        String string = null;
        ConfigurationVersionMo configurationVersionMo = (ConfigurationVersionMo)genericMaoContext.getMoRepositoryWrapper().lookup(CONFIGURATION_VERSION_LDN);
        UpgradePackageMo upgradePackageMo = (UpgradePackageMo)configurationVersionMo.getCurrentUpgradePackage(null);
        ManagedObject[] managedObjectArray = upgradePackageMo.getLoadModuleList(null);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            ManagedObject managedObject = managedObjectArray[i];
            if (managedObject.getRelativeDistinguishedName().indexOf(CABINETPAR_CXC_CRBS) <= -1) continue;
            string = ((LoadModuleMo)managedObject).getLoadModuleFilePath(null);
            logger.traceDebug(THIS_CLASS, "Read local path from Loadmodule " + managedObject.getLocalDistinguishedName());
            break;
        }
        if (string == null) {
            throw new MoNotFoundException("Loadmodule CXC2010275/ is missing in current upgrade package: " + upgradePackageMo.getRelativeDistinguishedName() + ". Unable to set cabinet parameters.");
        }
        logger.traceReturn(THIS_CLASS, "getFilePathFromLoadModuleMo() = '" + string + "'");
        return string;
    }

    private static Integer[] commaSeparatedValueStringToCabinetParameters(String string) {
        logger.traceEnter(THIS_CLASS, "commaSeparatedValueStringToCabinetParameters()");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Integer[] integerArray = new Integer[100];
        int n = 0;
        while (stringTokenizer.hasMoreTokens() && n < 100) {
            integerArray[n++] = Integer.valueOf(stringTokenizer.nextToken().trim());
        }
        if (n < 100) {
            Integer n2 = Integer.valueOf("0");
            for (int i = n; i < 100; ++i) {
                integerArray[i] = n2;
            }
        }
        logger.traceReturn(THIS_CLASS, "commaSeparatedValueStringToCabinetParameters()");
        return integerArray;
    }

    private static Parser createParser(String string, GenericMaoContext genericMaoContext) throws IOException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "createParser()");
        if (string == null) {
            throw new IOException("File RbsCabinetParametersLm.xml could not be found on node.");
        }
        String string2 = string.endsWith(XML_FILE_NAME) ? string.substring(0, string.length() - XML_FILE_NAME.length()) : (string.endsWith(File.separator) ? string + XML_FILE_SUBPATH : string + File.separator + XML_FILE_SUBPATH);
        logger.traceReturn(THIS_CLASS, "createParser() - path: " + string2 + ", file: " + XML_FILE_NAME);
        ParserFactory parserFactory = genericMaoContext.getParserFactory();
        return parserFactory.createParser(XML_FILE_NAME, string2);
    }

    private static String getLocalLoadModuleFilePath(GenericMaoContext genericMaoContext) throws MoAccessException {
        String string = "";
        string = "TRUE".equalsIgnoreCase(System.getProperty("UNIT_TEST")) ? System.getProperty("user.home") : CabinetParametersHelper.getFilePathFromLoadModuleMo(genericMaoContext);
        return string;
    }
}

