/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.file.nodeinformation.parser;

import java.io.PrintStream;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;
import se.ericsson.cello.configurationversion.file.nodeinformation.parser.ApplicationConfigurationElement;
import se.ericsson.cello.configurationversion.file.nodeinformation.parser.BackupRestoreInfoElement;
import se.ericsson.cello.configurationversion.file.nodeinformation.parser.NodeID_Element;
import se.ericsson.cello.configurationversion.file.nodeinformation.parser.NodeInformationAttributeName;
import se.ericsson.cello.configurationversion.file.nodeinformation.parser.NodeInformationRootElementName;
import se.ericsson.cello.configurationversion.file.nodeinformation.parser.NodeInformationSubElementName;
import se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreDataHandler;
import se.ericsson.cello.su.xmlparser.base.BackupRestoreXML_RootElement;
import se.ericsson.cello.su.xmlparser.base.UnknownXML_AttributeException;
import se.ericsson.cello.su.xmlparser.base.ValidateException;
import se.ericsson.cello.su.xmlparser.base.XML_ElementInterface;
import se.ericsson.cello.su.xmlparser.base.XML_Exception;
import se.ericsson.cello.sudom.parser.dom.util.locator.LocatorProxy;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class NodeInformationElement
extends BackupRestoreXML_RootElement {
    private NodeID_Element myNodeID_Element = null;
    private ApplicationConfigurationElement myApplicationConfigurationElement = null;
    private BackupRestoreInfoElement myBackupRestoreInfoElement = null;

    public NodeInformationElement(String string) {
        super("<!DOCTYPE NodeInformation>", "<!--DOCTYPE NodeInformation SYSTEM \"file:///..\\nodeinformation.dtd\"-->", new LocatorImpl());
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "NodeInformationElement( int aVersion )", "aVersionValue: " + string);
        }
        if (BackupRestoreDataHandler.greaterThanVersion("2", string)) {
            Trace.error(this.getClass(), "NodeInformationElement(String aVersion) ", "Version used when creating NodeInformationElement is larger than handled by the system.\n\taVersion: " + string + "\n\tHighest supported version " + "2" + " will be used.");
            string = "2";
        }
        BackupRestoreDataHandler.instance().setCurrentNodeInformationInfo(string);
    }

    public NodeInformationElement(AttributeList attributeList, Locator locator) throws UnknownXML_AttributeException {
        super("<!DOCTYPE NodeInformation>", "<!--DOCTYPE NodeInformation SYSTEM \"file:///..\\nodeinformation.dtd\"-->", locator);
        Object object;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "NodeInformationElement(AttributeList anAttributeList, Locator aLocator", "anAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        String string = attributeList.getValue(NodeInformationAttributeName.Version.getValue());
        boolean bl = false;
        if (BackupRestoreDataHandler.greaterThanVersion("2", string)) {
            object = "XML file " + BackupRestoreDataHandler.instance().getCurrentFileName() + "." + "\n\tThe attribute '" + NodeInformationAttributeName.Version.getValue() + "'" + " in element '" + NodeInformationRootElementName.NodeInformation + "'" + " has a value that is not supported: '" + string + "'." + "\n\tHighest supported version '" + "2" + "' will be used." + "\n\tUnknown XML elements and attributes will be ignored.";
            Trace.warning(this.getClass(), "NodeInformationElement(AttributeList anAttributeList, Locator aLocator)", (String)object);
            string = "2";
            bl = true;
        }
        BackupRestoreDataHandler.instance().setCurrentVersion(string, bl);
        object = NodeInformationAttributeName.verifyNames(attributeList);
        if (object == null || ((String[])object).length > 0) {
            NodeInformationElement.reportUnknownAttribute(this.getClass(), "NodeInformationElement(AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), NodeInformationRootElementName.NodeInformation.getValue(), object, locator);
        }
    }

    public XML_ElementInterface createChild(String string, AttributeList attributeList, Locator locator) throws XML_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createChild(String anElementName, AttributeList anAttributeList, Locator aLocator)", "anElementName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if (string.equals(NodeInformationSubElementName.NodeID.getValue())) {
            return this.createNodeID_Element(attributeList, locator);
        }
        if (string.equals(NodeInformationSubElementName.ApplicationConfiguration.getValue())) {
            return this.createApplicationConfigurationElement(attributeList, locator);
        }
        if (BackupRestoreDataHandler.instance().currentVersionEqualTo("2") && string.equals(NodeInformationSubElementName.BackupRestoreInfo.getValue())) {
            return this.createBackupRestoreInfo(attributeList, locator);
        }
        return NodeInformationElement.reportUnknownElement(this.getClass(), "createChild(String anElementName, AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), NodeInformationRootElementName.NodeInformation.getValue(), string, locator);
    }

    public ApplicationConfigurationElement getApplicationConfigurationElement() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getApplicationConfigurationElement()");
        }
        return this.myApplicationConfigurationElement;
    }

    public NodeID_Element getNodeID_Element() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNodeID_Element()");
        }
        return this.myNodeID_Element;
    }

    public BackupRestoreInfoElement getBackupRestoreInfoElement() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getBackupRestoreInfoElement()");
        }
        return this.myBackupRestoreInfoElement;
    }

    public String getVersion() {
        return BackupRestoreDataHandler.instance().getCurrentVersion();
    }

    public void print(PrintStream printStream) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "print(PrintStream aPrintStream)", "aPrintStream: " + printStream);
        }
        this.print(printStream, "");
    }

    public void print(PrintStream printStream, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "print(PrintStream aPrintStream, String anIndentation)", "aPrintStream: " + printStream + "\n\tanIndentation: " + string);
        }
        super.print(printStream);
        printStream.println(string + "<" + NodeInformationRootElementName.NodeInformation.getValue());
        printStream.println("  " + string + NodeInformationAttributeName.Version.getValue() + " = \"" + BackupRestoreDataHandler.instance().getCurrentVersion() + "\"");
        printStream.println("  " + string + ">");
        if (this.myNodeID_Element != null) {
            this.myNodeID_Element.print(printStream, "  " + string);
        }
        if (this.myApplicationConfigurationElement != null) {
            this.myApplicationConfigurationElement.print(printStream, "  " + string);
        }
        if (this.myBackupRestoreInfoElement != null) {
            this.myBackupRestoreInfoElement.print(printStream, "  " + string);
        }
        printStream.println();
        printStream.println(string + "</" + NodeInformationRootElementName.NodeInformation.getValue() + ">");
    }

    public void setApplicationConfigurationElement(ApplicationConfigurationElement applicationConfigurationElement) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setApplicationConfigurationElement(ApplicationConfigurationElement anApplicationConfigurationElement", "anApplicationConfigurationElement: " + applicationConfigurationElement);
        }
        this.myApplicationConfigurationElement = applicationConfigurationElement;
    }

    public void setNodeID_Element(NodeID_Element nodeID_Element) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setNodeID_Element(NodeID_Element aNodeID_Element)", "aNodeID_Element: " + nodeID_Element);
        }
        this.myNodeID_Element = nodeID_Element;
    }

    public void setBackupRestoreInfoElement(BackupRestoreInfoElement backupRestoreInfoElement) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setBackupRestoreInfoElement(BackupRestoreInfoElement aBackupRestoreInfoElement)", "aBackupRestoreInfoElement: " + backupRestoreInfoElement);
        }
        this.myBackupRestoreInfoElement = backupRestoreInfoElement;
    }

    public void validate() throws ValidateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validate( )");
        }
        NodeInformationAttributeName.Version.validate(BackupRestoreDataHandler.instance().getCurrentVersion(), this.getLocator());
        NodeInformationSubElementName.NodeID.validate(this.myNodeID_Element, super.getLocator());
        NodeInformationSubElementName.ApplicationConfiguration.validate(this.myApplicationConfigurationElement, super.getLocator());
        NodeInformationSubElementName.BackupRestoreInfo.validate(this.myBackupRestoreInfoElement, super.getLocator());
        if (this.myNodeID_Element != null) {
            this.myNodeID_Element.validate();
        }
        if (this.myApplicationConfigurationElement != null) {
            this.myApplicationConfigurationElement.validate();
        }
        if (this.myBackupRestoreInfoElement != null) {
            this.myBackupRestoreInfoElement.validate();
        }
    }

    private XML_ElementInterface createApplicationConfigurationElement(AttributeList attributeList, Locator locator) throws XML_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createApplicationConfigurationElement(AttributeList anAttributeList, Locator aLocator)", "anAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if (this.myApplicationConfigurationElement == null) {
            this.myApplicationConfigurationElement = new ApplicationConfigurationElement(attributeList, locator);
            return this.myApplicationConfigurationElement;
        }
        return NodeInformationElement.errorMoreElementsThanExpected(this.getClass(), "createApplicationConfigurationElement(AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), NodeInformationRootElementName.NodeInformation.getValue(), NodeInformationSubElementName.ApplicationConfiguration.getValue(), locator);
    }

    private XML_ElementInterface createBackupRestoreInfo(AttributeList attributeList, Locator locator) throws XML_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createBackupRestoreInfo(AttributeList anAttributeList, Locator aLocator)", "anAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if (this.myBackupRestoreInfoElement == null) {
            this.myBackupRestoreInfoElement = new BackupRestoreInfoElement(attributeList, locator);
            return this.myBackupRestoreInfoElement;
        }
        return NodeInformationElement.errorMoreElementsThanExpected(this.getClass(), "createBackupRestoreInfo(AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), NodeInformationRootElementName.NodeInformation.getValue(), NodeInformationSubElementName.BackupRestoreInfo.getValue(), locator);
    }

    private XML_ElementInterface createNodeID_Element(AttributeList attributeList, Locator locator) throws XML_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createNodeID_Element(AttributeList anAttributeList, Locator aLocator)", "anAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if (this.myNodeID_Element == null) {
            this.myNodeID_Element = new NodeID_Element(attributeList, locator);
            return this.myNodeID_Element;
        }
        return NodeInformationElement.errorMoreElementsThanExpected(this.getClass(), "createNodeID_Element(AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), NodeInformationRootElementName.NodeInformation.getValue(), NodeInformationSubElementName.NodeID.getValue(), locator);
    }
}

