/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.main;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import se.ericsson.cello.commandlog.logcontentcontrol.InspectorRepository;
import se.ericsson.cello.commandlog.logcontentcontrol.LogContentInspector;
import se.ericsson.cello.configurationversion.main.BackupTimer;
import se.ericsson.cello.configurationversion.main.ConfigurationVersionAlarm;
import se.ericsson.cello.configurationversion.main.ConfigurationVersionMoImpl;
import se.ericsson.cello.configurationversion.main.event.actionresult.ActionExecuted;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionPutToFTP_ServerInformation;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.DetailedActivityEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.MainActivityEvent;
import se.ericsson.cello.configurationversion.main.exception.ActionNotAllowedException;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.exception.FunctionBusyException;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionActivateRobustReconfigurationHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionCancelRestoreHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionChangeRestoreConfirmationTimeoutHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionConfirmRestoreHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionCreateHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionDeactivateRobustReconfigurationHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionDeleteHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionExportHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionForcedRestoreHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionImportHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionRemoveFromRollbackListHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionRestoreHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionSetFirstInRollbackListHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionSetStartableHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionVerifyRestoreHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_AttributeCorruptedUpgradePackagesHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_AttributeMissingUpgradePackagesHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_AttributeRestoreConfirmationDeadlineHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_AttributeRollbackListHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_AttributeStartableConfigurationVersionHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_AttributeStoredConfigurationVersionsHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_ConfigCountdownActivatedHandler;
import se.ericsson.cello.configurationversion.main.handler.CV_RestoreRobustReconfigurationActivatedHandler;
import se.ericsson.cello.configurationversion.main.interfaces.CV_ActionProgressAndResultInterface;
import se.ericsson.cello.configurationversion.main.interfaces.CV_MO_AttributeHandlerSetInterface;
import se.ericsson.cello.configurationversion.main.interfaces.ConfigurationVersionMoInterface;
import se.ericsson.cello.configurationversion.main.interfaces.UP_CV_Information;
import se.ericsson.cello.configurationversion.preupgrade.CV_PreUpgradeRelationHandler;
import se.ericsson.cello.configurationversion.service.ServiceDecider;
import se.ericsson.cello.configurationversion.util.enumer.CV_ActionResultAttributeName;
import se.ericsson.cello.configurationversion.util.enumer.CV_MO_AttributeName;
import se.ericsson.cello.configurationversion.util.handler.SignalHandler;
import se.ericsson.cello.configurationversion.verify.base.VerifyProperties;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.suaccess.RestartNodeProxy;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.moframework.AccessControlHelper;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoPermissionException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.su.froproxy.cv.interfaces.CV_UsageResultInformation;
import se.ericsson.cello.su.froproxy.cv.interfaces.OsaCvCountdownAttributes;
import se.ericsson.cello.su.froproxy.cv.interfaces.OsaCvMgmntProxyAccess;
import se.ericsson.cello.su.froproxy.cv.interfaces.VerifyCVsInformation;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.create.UpgradePackageCreator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.VerifyCVsToBeCreatedResult;
import se.ericsson.cello.upgradepackage.util.mohandler.factory.MO_HandlerFactoryInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradetrace.main.UpgradeTraceMoImpl;

public class ConfigurationVersionMoExtension
extends ConfigurationVersionMoImpl
implements ActionListener,
Resource,
CV_ActionProgressAndResultInterface,
CV_MO_AttributeHandlerSetInterface,
ConfigurationVersionMoInterface,
LogContentInspector {
    private static final boolean AUTO_CREATION_ON = true;
    private static final String AUTO_CREATION_TIME = "04:00";
    private static final String COMMENT = "Daily autocreated CV.";
    private static final String NOT_AVAILABLE = "Not Available";
    private static final String AUTO_CREATED_C_V_IS_TURNED_ON_BACKUP = "autoCreatedCVIsTurnedOnBackup";
    private static final int ROLL_BACK_COUNTER = 0;
    private static final int ROLL_BACK_INIT_MAX = 10000;
    private static final int ROLL_BACK_INIT_MIN = 1;
    private boolean txOnAutoCreatedCVIsTurnedOn = false;
    private boolean txOnTimeForAutoCreatedCV = false;
    private static final int MIN_CONFIG_ADM_COUNTDOWN = 300;
    private static final int MAX_CONFIG_ADM_COUNTDOWN = 86400;
    private static final int THE_ONE_AND_ONLY_FRO_ID = 1;
    private static final int ONE_AUTO_CV = 1;
    private static final int MO_DATA_REVISION_7 = 7000;
    private static final int MO_DATA_REVISION_LATEST = 7000;
    private StructAttribute myActionResult = null;
    private SequenceAttribute myAdditionalActionResultData = null;
    private SequenceAttribute myCorruptedUpgradePackages = null;
    private IntegerAttribute myCurrentDetailedActivity = null;
    private IntegerAttribute myCurrentMainActivity = null;
    private SequenceAttribute myMissingUpgradePackages = null;
    private OsaCvMgmntProxyAccess cvProxy = (OsaCvMgmntProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaCvMgmntProxyAccess.class);
    private BackupTimer timer;
    private Coordinator coordinator = null;
    private int myTrueCurrentDetailedActivity = 0;
    private int myTrueCurrentMainActivity = 0;
    private MoData data;
    private StringAttribute userLabel = null;
    private StringAttribute timeForAutoCreatedCV = null;
    private BooleanAttribute autoCreatedCVIsTurnedOn = null;
    private BooleanAttribute autoCreatedCVIsTurnedOnBackup = null;
    private ReferenceAttribute currentUpgradePackage = null;
    private CV_AttributeStoredConfigurationVersionsHandler myStoredConfigurationVersionsHandler = null;
    private CV_AttributeCorruptedUpgradePackagesHandler myCorruptedUpgradePackagesHandler = null;
    private CV_AttributeMissingUpgradePackagesHandler myMissingUpgradePackagesHandler = null;
    private CV_AttributeRestoreConfirmationDeadlineHandler myRestoreConfirmationDeadlineHandler = null;
    private CV_AttributeRollbackListHandler myRollbackListHandler = null;
    private CV_AttributeStartableConfigurationVersionHandler myStartableConfigurationVersionHandler = null;
    private CV_ConfigCountdownActivatedHandler configCountdownActivatedHandler = null;

    public ConfigurationVersionMoExtension(ManagedObject managedObject) throws MoNameAlreadyTakenException {
        super(managedObject, "ConfigurationVersion", "1", null);
        this.setInstance(this);
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ConfigurationVersionMoExtension ()");
        }
        this.myStoredConfigurationVersionsHandler = new CV_AttributeStoredConfigurationVersionsHandler(true);
        this.myCorruptedUpgradePackagesHandler = new CV_AttributeCorruptedUpgradePackagesHandler(this);
        this.myMissingUpgradePackagesHandler = new CV_AttributeMissingUpgradePackagesHandler(this);
        this.myRestoreConfirmationDeadlineHandler = new CV_AttributeRestoreConfirmationDeadlineHandler();
        this.myRollbackListHandler = new CV_AttributeRollbackListHandler(true);
        this.myStartableConfigurationVersionHandler = new CV_AttributeStartableConfigurationVersionHandler(true);
        this.configCountdownActivatedHandler = new CV_ConfigCountdownActivatedHandler(this);
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "ConfigurationVersion");
    }

    public int actionActivateRobustReconfiguration(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionActivateRobustReconfiguration(Coordinator aCoordinator)", "aCoordinator: " + SuLib.toString(coordinator));
        }
        if (!ConfigurationVersionMoExtension.reloadTraceProperties()) {
            Trace.warning(this.getClass(), "actionActivateRobustReconfiguration(Coordinator aCoordinator)", "Could not find an instance of UpgradeTrace MO, reloadTraceProperties failed (ignored)");
        }
        Trace.log1(this.getClass(), "actionActivateRobustReconfiguration(Coordinator aCoordinator)", "Start Action - Activate Robust Reconfiguration");
        Trace.flushToTraceFile();
        try {
            AccessControlHelper.performAccessControl();
            CV_ActionActivateRobustReconfigurationHandler cV_ActionActivateRobustReconfigurationHandler = new CV_ActionActivateRobustReconfigurationHandler(this);
            int n = cV_ActionActivateRobustReconfigurationHandler.activateRobustReconfiguration(this.getConfigCountdownActivated(null), this.getAutoCreatedCVIsTurnedOn(null));
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionActivateRobustReconfiguration(Coordinator aCoordinator)", "End Action - Activate Robust Reconfiguration, activation initiated\n");
            }
            int n2 = n;
            return n2;
        }
        catch (NoPermissionException noPermissionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionActivateRobustReconfiguration(Coordinator aCoordinator)", "aCoordinator: " + SuLib.toString(coordinator) + "\n\tNoPermissionException caught." + "\n\tNoPermissionException: " + (Object)((Object)noPermissionException));
            }
            throw noPermissionException;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionActivateRobustReconfiguration(Coordinator aCoordinator)", "aCoordinator: " + SuLib.toString(coordinator) + "\n\tConfigurationVersionException caught." + "\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "actionActivateRobustReconfiguration(Coordinator aCoordinator)", "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tactionActivateRobustReconfiguration(Coordinator aCoordinator)" + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    public void actionCancelRestore(Coordinator coordinator) throws MoAccessException {
        if (!ConfigurationVersionMoExtension.reloadTraceProperties()) {
            Trace.warning(this.getClass(), "actionCancelRestore(Coordinator aCoordinator)", "Could not find an instance of UpgradeTrace MO, reloadTraceProperties failed (ignored)");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionCancelRestore(Coordinator aCoordinator)", "aCoordinator: " + SuLib.toString(coordinator));
        }
        Trace.log1(this.getClass(), "actionCancelRestore(Coordinator aCoordinator)", "Start Action - Cancel Restore");
        Trace.flushToTraceFile();
        try {
            AccessControlHelper.performAccessControl();
            CV_ActionCancelRestoreHandler cV_ActionCancelRestoreHandler = new CV_ActionCancelRestoreHandler(this);
            cV_ActionCancelRestoreHandler.cancelRestore();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionCancelRestore(Coordinator aCoordinator)", "End Action - Cancel Restore, cancellation initiated\n");
            }
        }
        catch (NoPermissionException noPermissionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionCancelRestore(Coordinator aCoordinator)", "NoPermissionException caught.\n\tNoPermissionException: " + (Object)((Object)noPermissionException));
            }
            throw noPermissionException;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionCancelRestore(Coordinator aCoordinator)", "ConfigurationVersionException caught.\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "actionCancelRestore(Coordinator aCoordinator)", "\n\taCoordinator: " + SuLib.toString(coordinator) + "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tactionCancelRestore(Coordinator aCoordinator)" + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    public void actionChangeRestoreConfirmationDeadline(int n, Coordinator coordinator) throws MoAccessException {
        if (!ConfigurationVersionMoExtension.reloadTraceProperties()) {
            Trace.warning(this.getClass(), "actionChangeRestoreConfirmationDeadline(int aTimeoutValueInMinutes, Coordinator aCoordinator)", "Could not find an instance of UpgradeTrace MO, reloadTraceProperties failed (ignored)");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionChangeRestoreConfirmationDeadline(int aTimeoutValueInMinutes, Coordinator aCoordinator)", "aTimeoutValueInMinutes: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        Trace.log1(this.getClass(), "actionChangeRestoreConfirmationDeadline(int aTimeoutValueInMinutes, Coordinator aCoordinator)", "Start Action - Change Restore Confirmation Deadline");
        Trace.flushToTraceFile();
        try {
            AccessControlHelper.performAccessControl();
            CV_ActionChangeRestoreConfirmationTimeoutHandler cV_ActionChangeRestoreConfirmationTimeoutHandler = new CV_ActionChangeRestoreConfirmationTimeoutHandler(this);
            cV_ActionChangeRestoreConfirmationTimeoutHandler.changeRestoreConfirmationTimeout(n);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionChangeRestoreConfirmationDeadline(int aTimeoutValueInMinutes, Coordinator aCoordinator)", "End Action - Change Restore Confirmation Deadline\n");
            }
        }
        catch (NoPermissionException noPermissionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionChangeRestoreConfirmationDeadline(int aTimeoutValueInMinutes, Coordinator aCoordinator)", "NoPermissionException caught.\n\tNoPermissionException: " + (Object)((Object)noPermissionException));
            }
            throw noPermissionException;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionChangeRestoreConfirmationDeadline(int aTimeoutValueInMinutes, Coordinator aCoordinator)", "ConfigurationVersionException caught.\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            if (configurationVersionException.originalMoAccessException != null) {
                throw configurationVersionException.originalMoAccessException;
            }
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "actionChangeRestoreConfirmationDeadline(int aTimeoutValueInMinutes, Coordinator aCoordinator)", "aTimeoutValueInMinutes: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator) + "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tactionChangeRestoreConfirmationDeadline(int aTimeoutValueInMinutes, Coordinator aCoordinator)" + "\n\taTimeoutValueInMinutes: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    public int actionConfirmRestore(Coordinator coordinator) throws MoAccessException {
        if (!ConfigurationVersionMoExtension.reloadTraceProperties()) {
            Trace.warning(this.getClass(), "actionConfirmRestore(Coordinator aCoordinator)", "Could not find an instance of UpgradeTrace MO, reloadTraceProperties failed (ignored)");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionConfirmRestore(Coordinator aCoordinator)", "aCoordinator: " + SuLib.toString(coordinator));
        }
        Trace.log1(this.getClass(), "actionConfirmRestore(Coordinator aCoordinator)", "Start Action - Confirm Restore");
        Trace.flushToTraceFile();
        try {
            AccessControlHelper.performAccessControl();
            UpgradePackageMo upgradePackageMo = null;
            String string = "";
            try {
                upgradePackageMo = (UpgradePackageMo)this.getCurrentUpgradePackage(null);
            }
            catch (MoRemovedException moRemovedException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "actionConfirmRestore(Coordinator aCoordinator)", "MoRemovedException caught,\n\tthe referenced current Upgrade Package is not present, it must be re-created before it's possible to create a CV,\n\tMoRemovedException info: " + moRemovedException.toString() + "\n\tsending 'null' as reference for current Upgrade Package.");
                }
                string = moRemovedException.getVariablesAsString();
            }
            CV_ActionConfirmRestoreHandler cV_ActionConfirmRestoreHandler = new CV_ActionConfirmRestoreHandler(this);
            int n = cV_ActionConfirmRestoreHandler.confirmRestore(upgradePackageMo, string);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionConfirmRestore(Coordinator aCoordinator)", "End Action - Confirm Restore, confirmation initiated\n");
            }
            int n2 = n;
            return n2;
        }
        catch (NoPermissionException noPermissionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionConfirmRestore(Coordinator aCoordinator)", "NoPermissionException caught.\n\tNoPermissionException: " + (Object)((Object)noPermissionException));
            }
            throw noPermissionException;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionConfirmRestore(Coordinator aCoordinator)", "ConfigurationVersionException caught.\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "actionConfirmRestore(Coordinator aCoordinator)", "aCoordinator: " + SuLib.toString(coordinator) + "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tactionConfirmRestore(Coordinator aCoordinator)" + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    public void actionCreate(String string, String string2, int n, String string3, String string4, Coordinator coordinator) throws MoAccessException {
        if (!ConfigurationVersionMoExtension.reloadTraceProperties()) {
            Trace.warning(this.getClass(), "actionCreate(String configurationVersionName, String identity, int type, String operatorName, String comment, Coordinator c)", "Could not find an instance of UpgradeTrace MO, reloadTraceProperties failed (ignored).");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionCreate(String configurationVersionName, String identity, int type, String operatorName, String comment, Coordinator c)", "configurationVersionName: " + string + "\n\tidentity: " + string2 + "\n\ttype: " + n + "\n\toperatorName: " + string3 + "\n\tcomment: " + string4 + "\n\tc: " + SuLib.toString(coordinator));
        }
        Trace.log1(this.getClass(), "actionCreate(String configurationVersionName, String identity, int type, String operatorName, String comment, Coordinator c)", "Start Action - Create\n\tConfiguration version name: " + string);
        Trace.flushToTraceFile();
        try {
            AccessControlHelper.performAccessControl();
            if (n != 9) {
                if (n != 0 && n != 2 && n != 3 && n != 5) {
                    throw new ValueOutOfRangeException("configurationVersionType", "ConfigurationVersion");
                }
            } else {
                PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
                Collection collection = pIU_MO_HandlerInterface.getAllPIU_MOs();
                if (collection.size() != 1) {
                    throw new ActionNotAllowedException("Not allowed to create a standalone CV when more than one PlugInUnit configured. Number of configured PlugInUnit MOs: " + collection.size());
                }
            }
            this.create(string, string2, n, NOT_AVAILABLE, string3, string4, false);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionCreate(String configurationVersionName, String identity, int type, String operatorName, String comment, Coordinator c)", "End Action - Create\n");
            }
        }
        catch (ActionNotAllowedException actionNotAllowedException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionCreate(String configurationVersionName, String identity, int type, String operatorName, String comment, Coordinator c)", "ActionNotAllowedException caught.\n\tActionNotAllowedException: " + (Object)((Object)actionNotAllowedException) + "\n\tActionNotAllowedException data: " + actionNotAllowedException.toString());
            }
            throw actionNotAllowedException;
        }
        catch (ValueOutOfRangeException valueOutOfRangeException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionCreate(String configurationVersionName, String identity, int type, String operatorName, String comment, Coordinator c)", "ValueOutOfRangeException caught.\n\tValueOutOfRangeException: " + (Object)((Object)valueOutOfRangeException) + "\n\tValueOutOfRangeException data: " + valueOutOfRangeException.toString());
            }
            throw valueOutOfRangeException;
        }
        catch (NoPermissionException noPermissionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionCreate(String configurationVersionName, String identity, int type, String operatorName, String comment, Coordinator c)", "NoPermissionException caught.\n\tNoPermissionException: " + (Object)((Object)noPermissionException));
            }
            throw noPermissionException;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionCreate(String configurationVersionName, String identity, int type, String operatorName, String comment, Coordinator c)", "ConfigurationVersionException caught.\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            if (configurationVersionException.originalMoAccessException != null) {
                throw configurationVersionException.originalMoAccessException;
            }
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "actionCreate(String configurationVersionName, String identity, int type, String operatorName, String comment, Coordinator c)", "configurationVersionName: " + string + "\n\tidentity: " + string2 + "\n\ttype: " + n + "\n\toperatorName: " + string3 + "\n\tcomment: " + string4 + "\n\tc: " + SuLib.toString(coordinator) + "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tactionCreate(String configurationVersionName, String identity, int type, String operatorName, String comment, Coordinator c)" + "\n\tconfigurationVersionName: " + string + "\n\tidentity: " + string2 + "\n\ttype: " + n + "\n\toperatorName: " + string3 + "\n\tcomment: " + string4 + "\n\tc: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    public int actionDeactivateRobustReconfiguration(Coordinator coordinator) throws MoAccessException {
        if (!ConfigurationVersionMoExtension.reloadTraceProperties()) {
            Trace.warning(this.getClass(), "actionDeactivateRobustReconfiguration(Coordinator aCoordinator)", "Could not find an instance of UpgradeTrace MO, reloadTraceProperties failed (ignored)");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionDeactivateRobustReconfiguration(Coordinator aCoordinator)", "aCoordinator: " + SuLib.toString(coordinator));
        }
        Trace.log1(this.getClass(), "actionDeactivateRobustReconfiguration(Coordinator aCoordinator)", "Start Action - Deactivate Robust Reconfiguration");
        Trace.flushToTraceFile();
        try {
            AccessControlHelper.performAccessControl();
            CV_ActionDeactivateRobustReconfigurationHandler cV_ActionDeactivateRobustReconfigurationHandler = new CV_ActionDeactivateRobustReconfigurationHandler(this);
            int n = cV_ActionDeactivateRobustReconfigurationHandler.deactivateRobustReconfiguration(this.getConfigCountdownActivated(null), this.getAutoCreatedCVIsTurnedOnBackup(null));
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionDeactivateRobustReconfiguration(Coordinator aCoordinator)", "End Action - Deactivate Robust Reconfiguration, deactivation initiated\n");
            }
            int n2 = n;
            return n2;
        }
        catch (NoPermissionException noPermissionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionDeactivateRobustReconfiguration(Coordinator aCoordinator)", "aCoordinator: " + SuLib.toString(coordinator) + "\n\tNoPermissionException caught." + "\n\tNoPermissionException: " + (Object)((Object)noPermissionException));
            }
            throw noPermissionException;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionDeactivateRobustReconfiguration(Coordinator aCoordinator)", "aCoordinator: " + SuLib.toString(coordinator) + "\n\tConfigurationVersionException caught." + "\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "actionDeactivateRobustReconfiguration(Coordinator aCoordinator)", "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tactionDeactivateRobustReconfiguration(Coordinator aCoordinator)" + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    public void actionDelete(String string, Coordinator coordinator) throws MoAccessException {
        if (!ConfigurationVersionMoExtension.reloadTraceProperties()) {
            Trace.warning(this.getClass(), "actionDelete(String configurationVersionName, Coordinator c)", "Could not find an instance of UpgradeTrace MO, reloadTraceProperties failed (ignored)");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionDelete(String configurationVersionName, Coordinator c)", "configurationVersionName: " + string + "\n\tc: " + SuLib.toString(coordinator));
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "actionDelete(String configurationVersionName, Coordinator c)", "Start Action - Delete\n\tConfiguration version name: " + string);
        }
        Trace.flushToTraceFile();
        try {
            AccessControlHelper.performAccessControl();
            CV_ActionDeleteHandler cV_ActionDeleteHandler = new CV_ActionDeleteHandler(this);
            cV_ActionDeleteHandler.delete(string);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionDelete(String configurationVersionName, Coordinator c)", "End Action - Delete\n");
            }
        }
        catch (NoPermissionException noPermissionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionDelete(String configurationVersionName, Coordinator c)", "NoPermissionException caught.\n\tNoPermissionException: " + (Object)((Object)noPermissionException));
            }
            throw noPermissionException;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionDelete(String configurationVersionName, Coordinator c)", "ConfigurationVersionException caught.\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "actionDelete(String configurationVersionName, Coordinator c)", "configurationVersionName: " + string + "\n\tc: " + SuLib.toString(coordinator) + "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tactionDelete(String configurationVersionName, Coordinator c)" + "\n\tconfigurationVersionName: " + string + "\n\tc: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    public int actionForcedRestore(String string, int n, Coordinator coordinator) throws MoAccessException {
        if (!ConfigurationVersionMoExtension.reloadTraceProperties()) {
            Trace.warning(this.getClass(), "actionForcedRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)", "Could not find an instance of UpgradeTrace MO, reloadTraceProperties failed (ignored)");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionForcedRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)", "aCvName: " + string + "\n\taCvAutoConfigurationInformation: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        Trace.log1(this.getClass(), "actionForcedRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)", "Start Action - Forced Restore\n\tConfiguration version name: " + string);
        Trace.flushToTraceFile();
        try {
            AccessControlHelper.performAccessControl();
            CV_ActionForcedRestoreHandler cV_ActionForcedRestoreHandler = new CV_ActionForcedRestoreHandler(this);
            UpgradePackageMo upgradePackageMo = (UpgradePackageMo)this.getCurrentUpgradePackage(null);
            int n2 = cV_ActionForcedRestoreHandler.forcedRestore(string, n, upgradePackageMo);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionForcedRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)", "End Action - Forced Restore, restore initiated\n");
            }
            int n3 = n2;
            return n3;
        }
        catch (NoPermissionException noPermissionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionForcedRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)", "NoPermissionException caught.\n\tNoPermissionException: " + (Object)((Object)noPermissionException));
            }
            throw noPermissionException;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionForcedRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)", "ConfigurationVersionException caught.\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (MoRemovedException moRemovedException) {
            Trace.error(this.getClass(), "actionForcedRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)", "MoRemovedException caught, \n\tthe referenced current Upgrade Package is not present, it must be re-created before trying to execute action Forced Restore,\n\tMoRemovedException info: " + moRemovedException.toString() + "\n\taCvName: " + string + "\n\taCvAutoConfigurationInformation: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator));
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tactionForcedRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)" + "\n\tMoRemovedException caught, " + "\n\tthe referenced current Upgrade Package is not present, " + "it must be re-created before trying to execute action Forced Restore," + "\n\tMoRemovedException info: " + moRemovedException.toString() + "\n\taCvName: " + string + "\n\taCvAutoConfigurationInformation: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "actionForcedRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)", "aCvName: " + string + "\n\taCvAutoConfigurationInformation: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator) + "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tactionForcedRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)" + "\n\taCvName: " + string + "\n\taCvAutoConfigurationInformation: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    public int actionGetFromFtpServer(String string, String string2, String string3, String string4, Coordinator coordinator) throws MoAccessException {
        if (!ConfigurationVersionMoExtension.reloadTraceProperties()) {
            Trace.warning(this.getClass(), "actionGetFromFtpServer(String aFilePathAndCvBackupZipName, String anFtpServerIpAddress, String anFtpServerUserId, String anFtpServerPassword, Coordinator aCoordinator)", "Could not find an instance of UpgradeTrace MO, reloadTraceProperties failed (ignored)");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionGetFromFtpServer(String aFilePathAndCvBackupZipName, String anFtpServerIpAddress, String anFtpServerUserId, String anFtpServerPassword, Coordinator aCoordinator)", "aFilePathAndCvBackupZipName: " + string + "\n\tanFtpServerIpAddress: " + string2 + "\n\tanFtpServerUserId: " + string3 + "\n\tanFtpServerPassword: *****" + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        Trace.log1(this.getClass(), "actionGetFromFtpServer(String aFilePathAndCvBackupZipName, String anFtpServerIpAddress, String anFtpServerUserId, String anFtpServerPassword, Coordinator aCoordinator)", "Start Action - Get From Ftp Server\n\tFilepath and CV backup zip name: " + string);
        Trace.flushToTraceFile();
        try {
            AccessControlHelper.performAccessControl();
            if (string3.length() == 0) {
                string3 = "anonymous";
            }
            if (string4.length() == 0) {
                string4 = "anonymous";
            } else {
                UpgradePackageCreator.validateForIllegalCharacters(string4);
            }
            CV_ActionImportHandler cV_ActionImportHandler = new CV_ActionImportHandler(this);
            int n = cV_ActionImportHandler.importCV(string, string2, string3, string4);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionGetFromFtpServer(String aFilePathAndCvBackupZipName, String anFtpServerIpAddress, String anFtpServerUserId, String anFtpServerPassword, Coordinator aCoordinator)", "End Action - Get From Ftp Server, get initiated\n");
            }
            int n2 = n;
            return n2;
        }
        catch (NoPermissionException noPermissionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionGetFromFtpServer(String aFilePathAndCvBackupZipName, String anFtpServerIpAddress, String anFtpServerUserId, String anFtpServerPassword, Coordinator aCoordinator)", "NoPermissionException caught.\n\tNoPermissionException: " + (Object)((Object)noPermissionException));
            }
            throw noPermissionException;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionGetFromFtpServer(String aFilePathAndCvBackupZipName, String anFtpServerIpAddress, String anFtpServerUserId, String anFtpServerPassword, Coordinator aCoordinator)", "ConfigurationVersionException caught.\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "actionGetFromFtpServer(String aFilePathAndCvBackupZipName, String anFtpServerIpAddress, String anFtpServerUserId, String anFtpServerPassword, Coordinator aCoordinator)", "aFilePathAndCvBackupZipName: " + string + "\n\tanFtpServerIpAddress: " + string2 + "\n\tanFtpServerUserId: " + string3 + "\n\tanFtpServerPassword: *****" + "\n\taCoordinator: " + SuLib.toString(coordinator) + "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tactionGetFromFtpServer(String aFilePathAndCvBackupZipName, String anFtpServerIpAddress, String anFtpServerUserId, String anFtpServerPassword, Coordinator aCoordinator)" + "\n\taFilePathAndCvBackupZipName: " + string + "\n\tanFtpServerIpAddress: " + string2 + "\n\tanFtpServerUserId: " + string3 + "\n\tanFtpServerPassword: *****" + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionPerformed(ActionEvent act)", "act: " + actionEvent);
        }
        if (!(actionEvent.getActionCommand().equals("stopped") || this.verifyIfCVCanBeCreated() && this.autocreate())) {
            this.raiseConfigurationVersionAlarm();
        }
    }

    private boolean verifyIfCVCanBeCreated() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyIfCVCanBeCreated()");
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            VerifyCVsToBeCreatedResult verifyCVsToBeCreatedResult = configurationVersionMO_HandlerInterface.verifyNumberOfCVsToBeCreated(1);
            if (verifyCVsToBeCreatedResult.equals(VerifyCVsToBeCreatedResult.Confirmed)) {
                return true;
            }
            if (verifyCVsToBeCreatedResult.equals(VerifyCVsToBeCreatedResult.NumberOfCVsExceeded)) {
                Trace.info(this.getClass(), "verifyIfCVCanBeCreated()", "Max number of CVs Exceeded for autoCreate CV");
                return false;
            }
            if (verifyCVsToBeCreatedResult.equals(VerifyCVsToBeCreatedResult.NoAvailableMemoryForCVs)) {
                Trace.info(this.getClass(), "verifyIfCVCanBeCreated()", "There is not enough space on the node for autoCreate CV");
                return false;
            }
            return false;
        }
        catch (ConfigurationVersionMO_HandlerException configurationVersionMO_HandlerException) {
            Trace.error(this.getClass(), "verifyIfCVCanBeCreated()", "Problem while verifying if new autoCreate Cv can be created " + (Object)((Object)configurationVersionMO_HandlerException));
            return false;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyIfCVCanBeCreated()", "Problem while verifying if new autoCreate Cv can be created " + throwable);
            return false;
        }
    }

    private void raiseConfigurationVersionAlarm() {
        AdditionalInfo[] additionalInfoArray;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "raiseConfigurationVersionAlarm()");
        }
        String string = "Au";
        try {
            additionalInfoArray = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            string = additionalInfoArray.createNameForDailyAutoCV(this.currentUpgradePackage.getValue(null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("Create and set CV as startable failed for CV", string)};
        ConfigurationVersionAlarm.instance().raiseAlarm(additionalInfoArray);
    }

    public int actionPutToFtpServer(String string, String string2, String string3, String string4, String string5, String string6, Coordinator coordinator) throws MoAccessException {
        if (!ConfigurationVersionMoExtension.reloadTraceProperties()) {
            Trace.warning(this.getClass(), "actionPutToFtpServer(String aCvName, String aPathOnFtpServer, String aCvBackupNameOnFtpServer, String anFtpServerIpAddress, String anFtpServerUserId, String anFtpServerPassword, Coordinator aCoordinator)", "Could not find an instance of UpgradeTrace MO, reloadTraceProperties failed (ignored)");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionPutToFtpServer(String aCvName, String aPathOnFtpServer, String aCvBackupNameOnFtpServer, String anFtpServerIpAddress, String anFtpServerUserId, String anFtpServerPassword, Coordinator aCoordinator)", "aCvName: " + string + "\n\taPathOnFtpServer: " + string2 + "\n\taCvBackupNameOnFtpServer: " + string3 + "\n\tanFtpServerIpAddress: " + string4 + "\n\tanFtpServerUserId: " + string5 + "\n\tanFtpServerPassword: *****" + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        Trace.log1(this.getClass(), "actionPutToFtpServer(String aCvName, String aPathOnFtpServer, String aCvBackupNameOnFtpServer, String anFtpServerIpAddress, String anFtpServerUserId, String anFtpServerPassword, Coordinator aCoordinator)", "Start Action - Put To Ftp Server\n\tConfiguration version name: " + string);
        Trace.flushToTraceFile();
        try {
            AccessControlHelper.performAccessControl();
            if (string5.length() == 0) {
                string5 = "anonymous";
            }
            if (string6.length() == 0) {
                string6 = "anonymous";
            } else {
                UpgradePackageCreator.validateForIllegalCharacters(string6);
            }
            CV_ActionExportHandler cV_ActionExportHandler = new CV_ActionExportHandler(this);
            int n = cV_ActionExportHandler.export(string, string2, string3, string4, string5, string6);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionPutToFtpServer(String aCvName, String aPathOnFtpServer, String aCvBackupNameOnFtpServer, String anFtpServerIpAddress, String anFtpServerUserId, String anFtpServerPassword, Coordinator aCoordinator)", "End Action - Put To Ftp Server, put initiated\n");
            }
            int n2 = n;
            return n2;
        }
        catch (NoPermissionException noPermissionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionPutToFtpServer(String aCvName, String aPathOnFtpServer, String aCvBackupNameOnFtpServer, String anFtpServerIpAddress, String anFtpServerUserId, String anFtpServerPassword, Coordinator aCoordinator)", "NoPermissionException caught.\n\tNoPermissionException: " + (Object)((Object)noPermissionException));
            }
            throw noPermissionException;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionPutToFtpServer(String aCvName, String aPathOnFtpServer, String aCvBackupNameOnFtpServer, String anFtpServerIpAddress, String anFtpServerUserId, String anFtpServerPassword, Coordinator aCoordinator)", "ConfigurationVersionException caught.\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "actionPutToFtpServer(String aCvName, String aPathOnFtpServer, String aCvBackupNameOnFtpServer, String anFtpServerIpAddress, String anFtpServerUserId, String anFtpServerPassword, Coordinator aCoordinator)", "aCvName: " + string + "\n\taPathOnFtpServer: " + string2 + "\n\taCvBackupNameOnFtpServer: " + string3 + "\n\tanFtpServerIpAddress: " + string4 + "\n\tanFtpServerUserId: " + string5 + "\n\tanFtpServerPassword: *****" + "\n\taCoordinator: " + SuLib.toString(coordinator) + "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tactionPutToFtpServer(String aCvName, String aPathOnFtpServer, String aCvBackupNameOnFtpServer, String anFtpServerIpAddress, String anFtpServerUserId, String anFtpServerPassword, Coordinator aCoordinator)" + "\n\taCvName: " + string + "\n\taPathOnFtpServer: " + string2 + "\n\taCvBackupNameOnFtpServer: " + string3 + "\n\tanFtpServerIpAddress: " + string4 + "\n\tanFtpServerUserId: " + string5 + "\n\tanFtpServerPassword: *****" + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    public void actionRemoveFromRollbackList(String string, Coordinator coordinator) throws MoAccessException {
        if (!ConfigurationVersionMoExtension.reloadTraceProperties()) {
            Trace.warning(this.getClass(), "actionRemoveFromRollbackList(String configurationVersionName, Coordinator c)", "Could not find an instance of UpgradeTrace MO, reloadTraceProperties failed (ignored)");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionRemoveFromRollbackList(String configurationVersionName, Coordinator c)", "configurationVersionName: " + string + "\n\tc: " + SuLib.toString(coordinator));
        }
        Trace.log1(this.getClass(), "actionRemoveFromRollbackList(String configurationVersionName, Coordinator c)", "Start Action - Remove From Rollback List\n\tConfiguration version name: " + string);
        Trace.flushToTraceFile();
        try {
            AccessControlHelper.performAccessControl();
            CV_ActionRemoveFromRollbackListHandler cV_ActionRemoveFromRollbackListHandler = new CV_ActionRemoveFromRollbackListHandler(this);
            cV_ActionRemoveFromRollbackListHandler.removeFromRollbackList(string);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionRemoveFromRollbackList(String configurationVersionName, Coordinator c)", "End Action - Remove From Rollback List\n");
            }
        }
        catch (NoPermissionException noPermissionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionRemoveFromRollbackList(String configurationVersionName, Coordinator c)", "NoPermissionException caught.\n\tNoPermissionException: " + (Object)((Object)noPermissionException));
            }
            throw noPermissionException;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionRemoveFromRollbackList(String configurationVersionName, Coordinator c)", "ConfigurationVersionException caught.\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "actionRemoveFromRollbackList(String configurationVersionName, Coordinator c)", "configurationVersionName: " + string + "\n\tc: " + SuLib.toString(coordinator) + "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tactionRemoveFromRollbackList(String configurationVersionName, Coordinator c)" + "\n\tconfigurationVersionName: " + string + "\n\tc: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    public int actionRestore(String string, int n, Coordinator coordinator) throws MoAccessException {
        if (!ConfigurationVersionMoExtension.reloadTraceProperties()) {
            Trace.warning(this.getClass(), " actionRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)", "Could not find an instance of UpgradeTrace MO, reloadTraceProperties failed (ignored)");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)", "aCvName: " + string + "\n\taCvAutoConfigurationInformation: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        Trace.log1(this.getClass(), "actionRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)", "Start Action - Restore\n\tConfiguration version name: " + string);
        Trace.flushToTraceFile();
        try {
            AccessControlHelper.performAccessControl();
            CV_ActionRestoreHandler cV_ActionRestoreHandler = new CV_ActionRestoreHandler(this);
            UpgradePackageMo upgradePackageMo = (UpgradePackageMo)this.getCurrentUpgradePackage(null);
            int n2 = cV_ActionRestoreHandler.restore(string, n, upgradePackageMo);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)", "End Action - Restore, restore initiated\n");
            }
            int n3 = n2;
            return n3;
        }
        catch (NoPermissionException noPermissionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)", "NoPermissionException caught.\n\tNoPermissionException: " + (Object)((Object)noPermissionException));
            }
            throw noPermissionException;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)", "ConfigurationVersionException caught.\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (MoRemovedException moRemovedException) {
            Trace.error(this.getClass(), "actionRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)", "MoRemovedException caught, \n\tthe referenced current Upgrade Package is not present, it must be re-created before trying to execute action Restore,\n\tMoRemovedException info: " + moRemovedException.toString() + "\n\taCvName: " + string + "\n\taCvAutoConfigurationInformation: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator));
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tactionRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)" + "\n\tMoRemovedException caught, " + "\n\tthe referenced current Upgrade Package is not present, " + "it must be re-created before trying to execute action Restore," + "\n\tMoRemovedException info: " + moRemovedException.toString() + "\n\taCvName: " + string + "\n\taCvAutoConfigurationInformation: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "actionRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)", "aCvName: " + string + "\n\taCvAutoConfigurationInformation: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator) + "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tactionRestore(String aCvName, int aCvAutoConfigurationInformation, Coordinator aCoordinator)" + "\n\taCvName: " + string + "\n\taCvAutoConfigurationInformation: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    public void actionSetFirstRollbackList(String string, Coordinator coordinator) throws MoAccessException {
        if (!ConfigurationVersionMoExtension.reloadTraceProperties()) {
            Trace.warning(this.getClass(), "actionSetFirstRollbackList(String configurationVersionName, Coordinator c)", "Could not find an instance of UpgradeTrace MO, reloadTraceProperties failed (ignored)");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionSetFirstRollbackList(String configurationVersionName, Coordinator c)", "configurationVersionName: " + string + "\n\tc: " + SuLib.toString(coordinator));
        }
        Trace.log1(this.getClass(), "actionSetFirstRollbackList(String configurationVersionName, Coordinator c)", "Start Action - Set First Rollback List\n\tConfiguration version name: " + string);
        Trace.flushToTraceFile();
        try {
            AccessControlHelper.performAccessControl();
            CV_ActionSetFirstInRollbackListHandler cV_ActionSetFirstInRollbackListHandler = new CV_ActionSetFirstInRollbackListHandler(this);
            cV_ActionSetFirstInRollbackListHandler.setFirstInRollbackList(string);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionSetFirstRollbackList(String configurationVersionName, Coordinator c)", "End Action - Set First Rollback List\n");
            }
        }
        catch (NoPermissionException noPermissionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionSetFirstRollbackList(String configurationVersionName, Coordinator c)", "NoPermissionException caught.\n\tNoPermissionException: " + (Object)((Object)noPermissionException));
            }
            throw noPermissionException;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionSetFirstRollbackList(String configurationVersionName, Coordinator c)", "ConfigurationVersionException caught.\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "actionSetFirstRollbackList(String configurationVersionName, Coordinator c)", "configurationVersionName: " + string + "\n\tc: " + SuLib.toString(coordinator) + "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tactionSetFirstRollbackList(String configurationVersionName, Coordinator c)" + "\n\tconfigurationVersionName: " + string + "\n\tc: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    public void actionSetStartable(String string, Coordinator coordinator) throws MoAccessException {
        if (!ConfigurationVersionMoExtension.reloadTraceProperties()) {
            Trace.warning(this.getClass(), "actionSetStartable(String configurationVersionName, Coordinator c)", "Could not find an instance of UpgradeTrace MO, reloadTraceProperties failed (ignored)");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionSetStartable(String configurationVersionName, Coordinator c)", "configurationVersionName: " + string + "\n\tc: " + SuLib.toString(coordinator));
        }
        Trace.log1(this.getClass(), "actionSetStartable(String configurationVersionName, Coordinator c)", "Start Action - Set Startable\n\tConfiguration version name: " + string);
        Trace.flushToTraceFile();
        try {
            AccessControlHelper.performAccessControl();
            CV_ActionSetStartableHandler cV_ActionSetStartableHandler = new CV_ActionSetStartableHandler(this);
            cV_ActionSetStartableHandler.setStartable(string, false);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionSetStartable(String configurationVersionName, Coordinator c)", "End Action - Set Startable\n");
            }
        }
        catch (NoPermissionException noPermissionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionSetStartable(String configurationVersionName, Coordinator c)", "NoPermissionException caught.\n\tNoPermissionException: " + (Object)((Object)noPermissionException));
            }
            throw noPermissionException;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionSetStartable(String configurationVersionName, Coordinator c)", "ConfigurationVersionException caught.\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "actionSetStartable(String configurationVersionName, Coordinator c)", "configurationVersionName: " + string + "\n\tc: " + SuLib.toString(coordinator) + "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tactionSetStartable(String configurationVersionName, Coordinator c)" + "\n\tconfigurationVersionName: " + string + "\n\tc: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    public int actionVerifyRestore(String string, Coordinator coordinator) throws MoAccessException {
        if (!ConfigurationVersionMoExtension.reloadTraceProperties()) {
            Trace.warning(this.getClass(), "actionVerifyRestore(String aCvName, Coordinator aCoordinator)", "Could not find an instance of UpgradeTrace MO, reloadTraceProperties failed (ignored)");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionVerifyRestore(String aCvName, Coordinator aCoordinator)", "aCvName: " + string + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        Trace.log1(this.getClass(), "actionVerifyRestore(String aCvName, Coordinator aCoordinator)", "Start Action - Verify Restore\n\tConfiguration version name: " + string);
        Trace.flushToTraceFile();
        try {
            AccessControlHelper.performAccessControl();
            CV_ActionVerifyRestoreHandler cV_ActionVerifyRestoreHandler = new CV_ActionVerifyRestoreHandler(this);
            int n = cV_ActionVerifyRestoreHandler.verifyRestore(string);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionVerifyRestore(String aCvName, Coordinator aCoordinator)", "End Action - Verify Restore, verification initiated\n");
            }
            int n2 = n;
            return n2;
        }
        catch (NoPermissionException noPermissionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionVerifyRestore(String aCvName, Coordinator aCoordinator)", "NoPermissionException caught.\n\tNoPermissionException: " + (Object)((Object)noPermissionException));
            }
            throw noPermissionException;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "actionVerifyRestore(String aCvName, Coordinator aCoordinator)", "ConfigurationVersionException caught.\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "actionVerifyRestore(String aCvName, Coordinator aCoordinator)", "aCvName: " + string + "\n\taCoordinator: " + SuLib.toString(coordinator) + "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tactionVerifyRestore(String aCvName, Coordinator aCoordinator)" + "\n\taCvName: " + string + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    public void createForVerSpec(String string, int n, String string2, String string3, boolean bl) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createForVerSpec(String aCV_Name, int aType, String anUpgradePackageDocumentId, String aComment, boolean anIsLongTimeoutValueToBeUsed)", "aCV_Name: " + string + "\n\taType: " + n + "\n\tanUpgradePackageDocumentId: " + string2 + "\n\taComment: " + string3 + "\n\tanIsLongTimeoutValueToBeUsed: " + bl);
        }
        this.create(string, "", n, string2, "Cello Packet Platform", string3, bl);
    }

    public synchronized void commit() {
        block8: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "commit( )");
            }
            try {
                if (this.txOnAutoCreatedCVIsTurnedOn && !this.txOnTimeForAutoCreatedCV) {
                    this.startOrStopAutoCv();
                } else if (!this.txOnAutoCreatedCVIsTurnedOn && this.txOnTimeForAutoCreatedCV) {
                    this.changeTimeValue();
                } else if (this.txOnAutoCreatedCVIsTurnedOn && this.txOnTimeForAutoCreatedCV) {
                    this.changeTimeAndAutoCv();
                }
                this.resetIndications();
                this.coordinator = null;
            }
            catch (Exception exception) {
                if (!Trace.valid(this.getClass(), 22)) break block8;
                Trace.debug(this.getClass(), 22, "commit( )", "Exception caught when trying to commit the current transaction,\n\tException: " + exception.toString());
            }
        }
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "delete(Coordinator c)", "c: " + SuLib.toString(coordinator));
        }
        throw new UndeletableMoException((ManagedObject)this);
    }

    public Struct getActionResult(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getActionResult(Coordinator aCoordinator)", "aCoordinator: " + coordinator);
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.myActionResult.getValue(coordinator);
    }

    public Struct[] getAdditionalActionResultData(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAdditionalActionResultData(Coordinator aCoordinator)", "aCoordinator: " + coordinator);
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Enumeration enumeration = this.myAdditionalActionResultData.elements();
        Struct[] structArray = new Struct[this.myAdditionalActionResultData.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            structArray[n] = ((StructAttribute)enumeration.nextElement()).getValue(coordinator);
            ++n;
        }
        return structArray;
    }

    public boolean getAutoCreatedCVIsTurnedOn(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAutoCreatedCVIsTurnedOn(Coordinator c)", "c: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.autoCreatedCVIsTurnedOn.getValue(coordinator);
    }

    public Struct[] getCorruptedUpgradePackages(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCorruptedUpgradePackages(Coordinator aCoordinator)", "aCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
            return this.myCorruptedUpgradePackagesHandler.convertSequenceAttributeOfStructAttributesToStructArray(this.myCorruptedUpgradePackages, coordinator);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getCorruptedUpgradePackages(Coordinator aCoordinator)", "ConfigurationVersionException caught.\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
    }

    public int getCurrentDetailedActivity(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCurrentDetailedActivity(Coordinator aCoordinator)", "aCoordinator: " + SuLib.toString(coordinator));
        }
        return this.myTrueCurrentDetailedActivity;
    }

    public String getCurrentLoadedConfigurationVersion(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCurrentLoadedConfigurationVersion(Coordinator c)", "c: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        CV_UsageResultInformation cV_UsageResultInformation = this.cvProxy.sendOsaCvGetCvUsageReq();
        if (cV_UsageResultInformation.result != 0) {
            this.handlErrorResult(cV_UsageResultInformation.result);
        }
        return cV_UsageResultInformation.loadedCV;
    }

    public int getCurrentMainActivity(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCurrentMainActivity(Coordinator aCoordinator)", "aCoordinator: " + SuLib.toString(coordinator));
        }
        return this.myTrueCurrentMainActivity;
    }

    public ManagedObject getCurrentUpgradePackage(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCurrentUpgradePackage(Coordinator c)", "c: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.currentUpgradePackage.getValue(coordinator);
    }

    public String getExecutingCv(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getExecutingCv(Coordinator c)", "c: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        CV_UsageResultInformation cV_UsageResultInformation = this.cvProxy.sendOsaCvGetCvUsageReq();
        if (cV_UsageResultInformation.result != 0) {
            this.handlErrorResult(cV_UsageResultInformation.result);
        }
        return cV_UsageResultInformation.executingCV;
    }

    public String getLastCreatedCv(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLastCreatedCv ( Coordinator c )", "c : " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        CV_UsageResultInformation cV_UsageResultInformation = this.cvProxy.sendOsaCvGetCvUsageReq();
        if (cV_UsageResultInformation.result != 0) {
            this.handlErrorResult(cV_UsageResultInformation.result);
        }
        return cV_UsageResultInformation.lastCreatedCV;
    }

    public String[] getListOfHtmlResultFiles(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getListOfHtmlResults( Coordinator aCoordinator )", "aCoordinator: " + SuLib.toString(coordinator));
        }
        VerifyProperties verifyProperties = new VerifyProperties();
        String string = verifyProperties.cvCMA_FileDisk + verifyProperties.getCV_CMA_CV_Path() + "/";
        String[] stringArray = null;
        Vector<String> vector = new Vector<String>();
        try {
            File file = new File(string);
            if (file.exists()) {
                stringArray = file.list();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        String[] stringArray2;
                        File file2 = new File(string + stringArray[i] + "/");
                        if (!file2.isDirectory()) continue;
                        if (Trace.valid(this.getClass(), 20)) {
                            Trace.debug(this.getClass(), 20, "getListOfHtmlResultFiles( )Directory: " + string + stringArray[i] + " found.");
                        }
                        if ((stringArray2 = file2.list()) == null) continue;
                        for (int j = 0; j < stringArray2.length; ++j) {
                            if (!new File(string + stringArray[i] + "/" + stringArray2[j]).isFile() || !stringArray2[j].endsWith(".html")) continue;
                            vector.addElement(string + file2.getName() + "/" + stringArray2[j]);
                            if (!Trace.valid(this.getClass(), 20)) continue;
                            Trace.debug(this.getClass(), 20, "getListOfHtmlResultFiles( )File: " + stringArray2[j] + " found.");
                        }
                    }
                }
            } else if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getListOfHtmlResultFiles()", "Directory not found. Path: " + string);
            }
            String[] stringArray3 = new String[vector.size()];
            vector.toArray(stringArray3);
            return stringArray3;
        }
        catch (Throwable throwable) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getListOfHtmlResultFiles()", "Throwable caught,\n\tPath: " + string + "\n\tThrowable: " + throwable);
            }
            throw new ConfigurationVersionException(throwable.toString());
        }
    }

    public Struct[] getMissingUpgradePackages(Coordinator coordinator) throws MoAccessException {
        try {
            this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
            return this.myMissingUpgradePackagesHandler.convertSequenceAttributeOfStructAttributesToStructArray(this.myMissingUpgradePackages, coordinator);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getMissingUpgradePackages(Coordinator aCoordinator)", "ConfigurationVersionException caught.\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
    }

    public String getRestoreConfirmationDeadline(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRestoreConfirmationDeadline(Coordinator aCoordinator)", "aCoordinator: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.myRestoreConfirmationDeadlineHandler.get();
    }

    public int getRollbackCounter(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRollbackCounter(Coordinator c)", "c: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        CV_UsageResultInformation cV_UsageResultInformation = this.cvProxy.sendOsaCvGetCvUsageReq();
        if (cV_UsageResultInformation.result != 0) {
            this.handlErrorResult(cV_UsageResultInformation.result);
        }
        return cV_UsageResultInformation.getCounterValue();
    }

    public int getRollbackInitCounterValue(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRollbackInitCounterValue(Coordinator c)", "c: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        CV_UsageResultInformation cV_UsageResultInformation = this.cvProxy.sendOsaCvGetCvUsageReq();
        return cV_UsageResultInformation.rollbackCounterValue;
    }

    public int getRollbackInitTimerValue(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRollbackInitTimerValue(Coordinator c)", "c: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        CV_UsageResultInformation cV_UsageResultInformation = this.cvProxy.sendOsaCvGetCvUsageReq();
        return cV_UsageResultInformation.rollbackTimerValue;
    }

    public String[] getRollbackList(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRollbackList(Coordinator c)", "c: " + SuLib.toString(coordinator));
        }
        try {
            this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
            return this.myRollbackListHandler.get();
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getRollbackList(Coordinator c)", "ConfigurationVersionException caught.\n\tc: " + SuLib.toString(coordinator) + "\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
    }

    public boolean getRollbackOn(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRollbackOn(Coordinator c)", "c: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        CV_UsageResultInformation cV_UsageResultInformation = this.cvProxy.sendOsaCvGetCvUsageReq();
        return cV_UsageResultInformation.isRollbackOn();
    }

    public String getStartableConfigurationVersion(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getStartableConfigurationVersion(Coordinator c)", "c: " + SuLib.toString(coordinator));
        }
        try {
            this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
            String string = this.myStartableConfigurationVersionHandler.get();
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getStartableConfigurationVersion(Coordinator c)", "RETURNS - theCV: " + string);
            }
            return string;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getStartableConfigurationVersion(Coordinator c)", "ConfigurationVersionException caught.\n\tc: " + SuLib.toString(coordinator) + "\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
    }

    public Struct[] getStoredConfigurationVersions(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getStoredConfigurationVersions(Coordinator c)", "c: " + SuLib.toString(coordinator));
        }
        try {
            this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
            return this.myStoredConfigurationVersionsHandler.get();
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getStoredConfigurationVersions(Coordinator c)", "ConfigurationVersionException caught.\n\tc: " + SuLib.toString(coordinator) + "\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
    }

    public String getStoredConfigurationVersionName(Struct struct) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getStoredConfigurationVersionName (Struct aStoredConfigurationVersion)", "aStoredConfigurationVersion: " + SuLib.toString(struct));
        }
        if (struct != null) {
            return (String)struct.getValue("name");
        }
        return null;
    }

    public String getStoredConfigurationVersionType(Struct struct) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getStoredConfigurationVersionType (Struct aStoredConfigurationVersion)", "aStoredConfigurationVersion: " + SuLib.toString(struct));
        }
        if (struct != null) {
            return (String)struct.getValue("type");
        }
        return null;
    }

    public String getTimeForAutoCreatedCV(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getTimeForAutoCreatedCV(Coordinator c)", "c: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.timeForAutoCreatedCV.getValue(coordinator);
    }

    public String getType() {
        return "ConfigurationVersion";
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUserLabel(Coordinator c)", "c: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public synchronized boolean prepare() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "prepare( )");
        }
        return true;
    }

    public void recover(MoData moData) {
        this.data = moData;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "recover(MoData recoveredData)", "recoveredData: " + moData);
        }
        if (this.data.getRevision() == 7000) {
            this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
            RestartNodeProxy.restartIfNull((Object)this.userLabel, (String)"userLabel, corrupt database");
            this.timeForAutoCreatedCV = (StringAttribute)moData.getAttribute("timeForAutoCreatedCV");
            RestartNodeProxy.restartIfNull((Object)this.timeForAutoCreatedCV, (String)"timeForAutoCreatedCV, corrupt database");
            this.autoCreatedCVIsTurnedOn = (BooleanAttribute)moData.getAttribute("autoCreatedCVIsTurnedOn");
            RestartNodeProxy.restartIfNull((Object)this.autoCreatedCVIsTurnedOn, (String)"autoCreatedCVIsTurnedOn, corrupt database");
            this.autoCreatedCVIsTurnedOnBackup = (BooleanAttribute)moData.getAttribute(AUTO_CREATED_C_V_IS_TURNED_ON_BACKUP);
            RestartNodeProxy.restartIfNull((Object)this.autoCreatedCVIsTurnedOnBackup, (String)"autoCreatedCVIsTurnedOnBackup, corrupt database");
            this.currentUpgradePackage = (ReferenceAttribute)moData.getAttribute("currentUpgradePackage");
            RestartNodeProxy.restartIfNull((Object)this.currentUpgradePackage, (String)"currentUpgradePackage, corrupt database");
            this.myActionResult = (StructAttribute)this.data.getAttribute(CV_MO_AttributeName.ActionResult.getValue());
            if (this.myActionResult == null) {
                this.myActionResult = new StructAttribute(CV_MO_AttributeName.ActionResult.getValue(), true);
                IntegerAttribute integerAttribute = new IntegerAttribute(CV_ActionResultAttributeName.ActionId.getValue(), false, 1);
                this.myActionResult.addElement((Attribute)integerAttribute);
                StringAttribute stringAttribute = new StringAttribute(CV_ActionResultAttributeName.Time.getValue(), false, "");
                this.myActionResult.addElement((Attribute)stringAttribute);
                IntegerAttribute integerAttribute2 = new IntegerAttribute(CV_ActionResultAttributeName.InvokedAction.getValue(), false, new InvokedActionPutToFTP_ServerInformation().getIdentifier());
                this.myActionResult.addElement((Attribute)integerAttribute2);
                IntegerAttribute integerAttribute3 = new IntegerAttribute(CV_ActionResultAttributeName.MainResult.getValue(), false, new ActionExecuted().getIdentifier());
                this.myActionResult.addElement((Attribute)integerAttribute3);
                StringAttribute stringAttribute2 = new StringAttribute(CV_ActionResultAttributeName.ConfigurationVersionName.getValue(), false, "");
                this.myActionResult.addElement((Attribute)stringAttribute2);
                StringAttribute stringAttribute3 = new StringAttribute(CV_ActionResultAttributeName.PathToDetailedInformation.getValue(), false, "");
                this.myActionResult.addElement((Attribute)stringAttribute3);
                this.data.registerPersistentAttr((Attribute)this.myActionResult);
            }
            RestartNodeProxy.restartIfNull((Object)this.myActionResult, (String)"myActionResult, corrupt database");
            this.myAdditionalActionResultData = (SequenceAttribute)this.data.getAttribute(CV_MO_AttributeName.AdditionalActionResultData.getValue());
            if (this.myAdditionalActionResultData == null) {
                this.myAdditionalActionResultData = new SequenceAttribute(CV_MO_AttributeName.AdditionalActionResultData.getValue(), true);
                this.data.registerPersistentAttr((Attribute)this.myAdditionalActionResultData);
            }
            RestartNodeProxy.restartIfNull((Object)this.myAdditionalActionResultData, (String)"myAdditionalActionResultData, corrupt database");
            this.myCorruptedUpgradePackages = (SequenceAttribute)this.data.getAttribute(CV_MO_AttributeName.CorruptedUpgradePackages.getValue());
            if (this.myCorruptedUpgradePackages == null) {
                this.myCorruptedUpgradePackages = new SequenceAttribute(CV_MO_AttributeName.CorruptedUpgradePackages.getValue(), true);
                this.data.registerPersistentAttr((Attribute)this.myCorruptedUpgradePackages);
            }
            RestartNodeProxy.restartIfNull((Object)this.myCorruptedUpgradePackages, (String)"myCorruptedUpgradePackages, corrupt database");
            this.myCurrentDetailedActivity = (IntegerAttribute)this.data.getAttribute(CV_MO_AttributeName.CurrentDetailedActivity.getValue());
            if (this.myCurrentDetailedActivity == null) {
                this.myCurrentDetailedActivity = new IntegerAttribute(CV_MO_AttributeName.CurrentDetailedActivity.getValue(), true, 0);
                this.data.registerPersistentAttr((Attribute)this.myCurrentDetailedActivity);
            }
            RestartNodeProxy.restartIfNull((Object)this.myCurrentDetailedActivity, (String)"myCurrentDetailedActivity, corrupt database");
            this.myCurrentMainActivity = (IntegerAttribute)this.data.getAttribute(CV_MO_AttributeName.CurrentMainActivity.getValue());
            if (this.myCurrentMainActivity == null) {
                this.myCurrentMainActivity = new IntegerAttribute(CV_MO_AttributeName.CurrentMainActivity.getValue(), true, 0);
                this.data.registerPersistentAttr((Attribute)this.myCurrentMainActivity);
            }
            RestartNodeProxy.restartIfNull((Object)this.myCurrentMainActivity, (String)"myCurrentMainActivity, corrupt database");
            this.myMissingUpgradePackages = (SequenceAttribute)this.data.getAttribute(CV_MO_AttributeName.MissingUpgradePackages.getValue());
            if (this.myMissingUpgradePackages == null) {
                this.myMissingUpgradePackages = new SequenceAttribute(CV_MO_AttributeName.MissingUpgradePackages.getValue(), true);
                this.data.registerPersistentAttr((Attribute)this.myMissingUpgradePackages);
            }
            RestartNodeProxy.restartIfNull((Object)this.myMissingUpgradePackages, (String)"myMissingUpgradePackages, corrupt database");
            new ServiceDecider(this).initiateThread();
            ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "ConfigurationVersion");
        } else {
            RestartNodeProxy.restartIfNull(null, (String)("Wrong Mo data revision for ConfigurationVersionMo: Revision = " + this.data.getRevision()));
        }
        this.cvProxy.registerForNotifications(null, (MaoFroIndicationSubscriber)this, 1);
    }

    public void recoverConfigCountdown() {
        new CV_RestoreRobustReconfigurationActivatedHandler(this).initiateThread();
    }

    public synchronized void registerData() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "registerData( )");
        }
        if (this.data == null) {
            try {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(1800);
                this.coordinator = control.getCoordinator();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "registerData( )", "Cello_CMA txId = " + this.coordinator.getTransactionID() + "\n\ttimeout = 1800 sec");
                }
                this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, this.coordinator);
                this.userLabel = new StringAttribute("userLabel", true);
                this.userLabel.setValue("");
                this.data.registerPersistentAttr((Attribute)this.userLabel);
                this.timeForAutoCreatedCV = new StringAttribute("timeForAutoCreatedCV", true);
                this.timeForAutoCreatedCV.setValue(AUTO_CREATION_TIME);
                this.data.registerPersistentAttr((Attribute)this.timeForAutoCreatedCV);
                this.autoCreatedCVIsTurnedOn = new BooleanAttribute("autoCreatedCVIsTurnedOn", true, true);
                this.autoCreatedCVIsTurnedOn.setValue(true);
                this.data.registerPersistentAttr((Attribute)this.autoCreatedCVIsTurnedOn);
                this.autoCreatedCVIsTurnedOnBackup = new BooleanAttribute(AUTO_CREATED_C_V_IS_TURNED_ON_BACKUP, false, false);
                this.data.registerPersistentAttr((Attribute)this.autoCreatedCVIsTurnedOnBackup);
                this.currentUpgradePackage = new ReferenceAttribute("currentUpgradePackage", true);
                this.currentUpgradePackage.setValue(null);
                this.data.registerPersistentAttr((Attribute)this.currentUpgradePackage);
                this.myActionResult = new StructAttribute(CV_MO_AttributeName.ActionResult.getValue(), true);
                IntegerAttribute integerAttribute = new IntegerAttribute(CV_ActionResultAttributeName.ActionId.getValue(), false, 1);
                this.myActionResult.addElement((Attribute)integerAttribute);
                StringAttribute stringAttribute = new StringAttribute(CV_ActionResultAttributeName.Time.getValue(), false, "");
                this.myActionResult.addElement((Attribute)stringAttribute);
                IntegerAttribute integerAttribute2 = new IntegerAttribute(CV_ActionResultAttributeName.InvokedAction.getValue(), false, new InvokedActionPutToFTP_ServerInformation().getIdentifier());
                this.myActionResult.addElement((Attribute)integerAttribute2);
                IntegerAttribute integerAttribute3 = new IntegerAttribute(CV_ActionResultAttributeName.MainResult.getValue(), false, new ActionExecuted().getIdentifier());
                this.myActionResult.addElement((Attribute)integerAttribute3);
                StringAttribute stringAttribute2 = new StringAttribute(CV_ActionResultAttributeName.ConfigurationVersionName.getValue(), false, "");
                this.myActionResult.addElement((Attribute)stringAttribute2);
                StringAttribute stringAttribute3 = new StringAttribute(CV_ActionResultAttributeName.PathToDetailedInformation.getValue(), false, "");
                this.myActionResult.addElement((Attribute)stringAttribute3);
                this.data.registerPersistentAttr((Attribute)this.myActionResult);
                this.myAdditionalActionResultData = new SequenceAttribute(CV_MO_AttributeName.AdditionalActionResultData.getValue(), true);
                this.data.registerPersistentAttr((Attribute)this.myAdditionalActionResultData);
                this.myCorruptedUpgradePackages = new SequenceAttribute(CV_MO_AttributeName.CorruptedUpgradePackages.getValue(), true);
                this.data.registerPersistentAttr((Attribute)this.myCorruptedUpgradePackages);
                this.myCurrentDetailedActivity = new IntegerAttribute(CV_MO_AttributeName.CurrentDetailedActivity.getValue(), true, 0);
                this.data.registerPersistentAttr((Attribute)this.myCurrentDetailedActivity);
                this.myCurrentMainActivity = new IntegerAttribute(CV_MO_AttributeName.CurrentMainActivity.getValue(), true, 0);
                this.data.registerPersistentAttr((Attribute)this.myCurrentMainActivity);
                this.myMissingUpgradePackages = new SequenceAttribute(CV_MO_AttributeName.MissingUpgradePackages.getValue(), true);
                this.data.registerPersistentAttr((Attribute)this.myMissingUpgradePackages);
                this.data.setRevision(7000);
                this.cvProxy.registerForNotifications(this.coordinator, (MaoFroIndicationSubscriber)this, 1);
                this.data.handleTransaction(this.coordinator, MoData.WRITE_ACCESS);
                control.getTerminator().commit();
                this.coordinator = null;
            }
            catch (TransactionRequiredException transactionRequiredException) {
                Trace.error(this.getClass(), "registerData( )", "TransactionRequiredException caught when trying to instantiate necessary attributes at start of ConfigurationVersion.", transactionRequiredException);
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                Trace.error(this.getClass(), "registerData( )", "TransactionRolledBackException caught when trying to instantiate necessary attributes at start of ConfigurationVersion.", transactionRolledBackException);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                Trace.error(this.getClass(), "registerData( )", "InactiveTransactionException caught when trying to instantiate necessary attributes at start of ConfigurationVersion.", inactiveTransactionException);
            }
            catch (MoAccessException moAccessException) {
                Trace.error(this.getClass(), "registerData( )", "MoAccessException caught when trying to instantiate necessary attributes at start of ConfigurationVersion.", moAccessException);
            }
        }
        try {
            this.startBackupTimer(this.timeForAutoCreatedCV.getValue(null));
            if (!this.autoCreatedCVIsTurnedOn.getValue(null)) {
                this.timer.stop();
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "registerData( )", "MoAccessException caught when trying to start or stop auto creation timer at start of ConfigurationVersion.", moAccessException);
        }
    }

    public synchronized void rollback() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "rollback( )");
        }
        this.resetIndications();
    }

    public void setActionResultValue(int n, String string, int n2, int n3, String string2, String string3, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setActionResultValue(int anActionId, String aTime, int anInvokedAction, int aMainResult, String aConfigurationVersionName, String aPathToDetailedInformation, Coordinator aCoordinator)", "anActionId: " + n + "\n\taTime: " + string + "\n\tanInvokedAction: " + n2 + "\n\taMainResult: " + n3 + "\n\taConfigurationVersionName: " + string2 + "\n\taPathToDetailedInformation: " + string3 + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        IntegerAttribute integerAttribute = (IntegerAttribute)this.myActionResult.getElement(CV_ActionResultAttributeName.ActionId.getValue(), coordinator);
        integerAttribute.setValue(n);
        StringAttribute stringAttribute = (StringAttribute)this.myActionResult.getElement(CV_ActionResultAttributeName.Time.getValue(), coordinator);
        stringAttribute.setValue(string);
        IntegerAttribute integerAttribute2 = (IntegerAttribute)this.myActionResult.getElement(CV_ActionResultAttributeName.InvokedAction.getValue(), coordinator);
        integerAttribute2.setValue(n2);
        IntegerAttribute integerAttribute3 = (IntegerAttribute)this.myActionResult.getElement(CV_ActionResultAttributeName.MainResult.getValue(), coordinator);
        integerAttribute3.setValue(n3);
        StringAttribute stringAttribute2 = (StringAttribute)this.myActionResult.getElement(CV_ActionResultAttributeName.ConfigurationVersionName.getValue(), coordinator);
        stringAttribute2.setValue(string2);
        StringAttribute stringAttribute3 = (StringAttribute)this.myActionResult.getElement(CV_ActionResultAttributeName.PathToDetailedInformation.getValue(), coordinator);
        stringAttribute3.setValue(string3);
    }

    public void setAdditionalActionResultDataValue(StructAttribute[] structAttributeArray, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setAdditionalActionResultDataValue(StructAttribute[] anActionResult, Coordinator aCoordinator)", "anAdditionalActionResultData: " + SuLib.toString(structAttributeArray) + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.myAdditionalActionResultData.setValue((Attribute[])structAttributeArray);
    }

    public void setAutoCreatedCVIsTurnedOn(boolean bl, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setAutoCreatedCVIsTurnedOn(boolean value, Coordinator c)", "value: " + bl + "\n\tc: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.registerResource(coordinator);
        this.txOnAutoCreatedCVIsTurnedOn = true;
        this.autoCreatedCVIsTurnedOn.setValue(bl);
    }

    public void setCorruptedUpgradePackagesValue(StructAttribute[] structAttributeArray, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCorruptedUpgradePackagesValue(StructAttribute[] aCorruptedUpgradePackages, Coordinator aCoordinator)", "aCorruptedUpgradePackages: " + SuLib.toString(structAttributeArray) + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.myCorruptedUpgradePackages.setValue((Attribute[])structAttributeArray);
    }

    public void setCurrentDetailedActivityValue(DetailedActivityEvent detailedActivityEvent, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCurrentDetailedActivityValue(DetailedActivityEvent aCurrentDetailedActivity, Coordinator aCoordinator)", "aCurrentDetailedActivity: " + detailedActivityEvent + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = this.myCurrentDetailedActivity.getValue(coordinator);
        this.myCurrentDetailedActivity.setValue(detailedActivityEvent.getIdentifier());
        if (detailedActivityEvent.getIdentifier() != 30 && detailedActivityEvent.getIdentifier() != 31 && detailedActivityEvent.getIdentifier() != 32) {
            this.sendActivityChangeNotification(CV_MO_AttributeName.CurrentDetailedActivity.getValue(), detailedActivityEvent.getIdentifier(), this.myTrueCurrentDetailedActivity, n, coordinator);
        }
        this.myTrueCurrentDetailedActivity = detailedActivityEvent.getIdentifier();
    }

    public void setCurrentMainActivityValue(MainActivityEvent mainActivityEvent, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCurrentMainActivityValue(MainActivityEvent aCurrentMainActivity, Coordinator aCoordinator)", "aCurrentMainActivity: " + mainActivityEvent + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = this.myCurrentMainActivity.getValue(coordinator);
        this.myCurrentMainActivity.setValue(mainActivityEvent.getIdentifier());
        if (mainActivityEvent.getIdentifier() != 13 && mainActivityEvent.getIdentifier() != 14) {
            this.sendActivityChangeNotification(CV_MO_AttributeName.CurrentMainActivity.getValue(), mainActivityEvent.getIdentifier(), this.myTrueCurrentMainActivity, n, coordinator);
        }
        this.myTrueCurrentMainActivity = mainActivityEvent.getIdentifier();
    }

    public void setMissingUpgradePackagesValue(StructAttribute[] structAttributeArray, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setMissingUpgradePackagesValue(StructAttribute[] aMissingUpgradePackages, Coordinator aCoordinator)", "aMissingUpgradePackages: " + SuLib.toString(structAttributeArray) + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.myMissingUpgradePackages.setValue((Attribute[])structAttributeArray);
    }

    public void setRollbackCounter(int n, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setRollbackCounter(int value, Coordinator c)", "value: " + n + "\n\tc: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        boolean bl = false;
        if (n < 1 || n > 10000) {
            bl = true;
        } else if (!this.getRollbackOn(coordinator)) {
            bl = true;
        }
        if (bl) {
            throw new ValueOutOfRangeException("rollbackCounter", "ConfigurationVersion");
        }
        if (this.cvProxy.sendOsaCvSetRollbackCounter(n) != 0) {
            throw new FroNotAccessibleException("ConfigurationVersion", "cvFro");
        }
    }

    public void setRollbackCounterForSU(int n, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setRollbackCounterForSU(int value, Coordinator c)", "value: " + n + "\n\tc: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        boolean bl = false;
        if (n < 0) {
            bl = true;
        } else if (!this.getRollbackOn(coordinator)) {
            bl = true;
        }
        if (bl) {
            throw new ValueOutOfRangeException("rollbackCounter", "ConfigurationVersion");
        }
        if (this.cvProxy.sendOsaCvSetRollbackCounter(n) != 0) {
            throw new FroNotAccessibleException("ConfigurationVersion", "cvFro");
        }
    }

    public void setRollbackInitCounterValue(int n, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setRollbackInitCounterValue(int value, Coordinator c)", "value: " + n + "\n\tc: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n < 1 || n > 10000) {
            throw new ValueOutOfRangeException("rollbackInitCounterValue", "ConfigurationVersion");
        }
        String[] stringArray = new String[]{"rollbackInitCounterValue"};
        Object[] objectArray = new Object[]{new Integer(n)};
        ConfigurationVersionMoExtension.sendChangeNotification(this, stringArray, objectArray, coordinator);
        int n2 = this.cvProxy.sendOsaCvInitRollbackReq(0, 0, n);
        if (n2 != 0) {
            this.handlErrorResult(n2);
        }
    }

    public void setRollbackInitTimerValue(int n, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setRollbackInitTimerValue(int value, Coordinator c)", "value: " + n + "\n\tc: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n < 1 || n > 10000) {
            throw new ValueOutOfRangeException("rollbackInitTimerValue", "ConfigurationVersion");
        }
        String[] stringArray = new String[]{"rollbackInitTimerValue"};
        Object[] objectArray = new Object[]{new Integer(n)};
        ConfigurationVersionMoExtension.sendChangeNotification(this, stringArray, objectArray, coordinator);
        int n2 = this.cvProxy.sendOsaCvInitRollbackReq(0, n, 0);
        if (n2 != 0) {
            this.handlErrorResult(n2);
        }
    }

    public void setRollbackOn(boolean bl, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setRollbackOn(boolean value, Coordinator c)", "value: " + bl + "\n\tc: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = bl ? 1 : 2;
        String[] stringArray = new String[]{"rollbackOn"};
        Object[] objectArray = new Object[]{bl};
        ConfigurationVersionMoExtension.sendChangeNotification(this, stringArray, objectArray, coordinator);
        int n2 = this.cvProxy.sendOsaCvInitRollbackReq(n, 0, 0);
        if (n2 != 0) {
            this.handlErrorResult(n2);
        }
    }

    public void setTimeForAutoCreatedCV(String string, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setTimeForAutoCreatedCV(String value, Coordinator c)", "value: " + string + "\n\tc: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.checkInputTime(string);
        this.registerResource(coordinator);
        this.txOnTimeForAutoCreatedCV = true;
        this.timeForAutoCreatedCV.setValue(string);
    }

    public void setConfigAdmCountdown(int n, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setConfigAdmCountdown(int value, Coordinator c)", "value: " + n + "\n\tc: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        MoAttributeValidator.checkIntegerAttribute((String)"configAdmCountdown", (int)n, (int)300, (int)86400, (String)"ConfigurationVersion");
        int n2 = this.cvProxy.sendOsaCvSetConfigAdmCountdownReq(n);
        if (n2 != 0) {
            this.handlErrorResult(n2);
        }
        String[] stringArray = new String[]{"configAdmCountdown"};
        Object[] objectArray = new Object[]{new Integer(n)};
        ConfigurationVersionMoExtension.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public int getConfigAdmCountdown(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConfigAdmCountdown(Coordinator c)", "c: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaCvCountdownAttributes osaCvCountdownAttributes = this.cvProxy.sendOsaCvGetCountdownAttributesReq();
        if (osaCvCountdownAttributes.getResult() != 0) {
            this.handlErrorResult(osaCvCountdownAttributes.getResult());
        }
        return osaCvCountdownAttributes.getConfigAdmCountdown();
    }

    public int getConfigOpCountdown(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConfigOpCountdown(Coordinator c)", "c: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaCvCountdownAttributes osaCvCountdownAttributes = this.cvProxy.sendOsaCvGetCountdownAttributesReq();
        if (osaCvCountdownAttributes.getResult() != 0) {
            this.handlErrorResult(osaCvCountdownAttributes.getResult());
        }
        return osaCvCountdownAttributes.getConfigOpCountdown();
    }

    public boolean getConfigCountdownActivated(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConfigCountdownActivated(Coordinator c)", "c: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaCvCountdownAttributes osaCvCountdownAttributes = this.cvProxy.sendOsaCvGetCountdownAttributesReq();
        if (osaCvCountdownAttributes.getResult() != 0) {
            this.handlErrorResult(osaCvCountdownAttributes.getResult());
        }
        return osaCvCountdownAttributes.getConfigCountdownActivated();
    }

    public void setConfigCountdownActivated(boolean bl, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setConfigCountdownActivated(boolean value, Coordinator c)", "value: " + bl + "\n\tc: " + SuLib.toString(coordinator));
        }
        this.configCountdownActivatedHandler.setConfigCountdownActivated(bl, coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setUserLabel(String value, Coordinator c)", "value: " + string + "\n\tc: " + SuLib.toString(coordinator));
        }
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"ConfigurationVersion", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public void upgradeSetCurrentUpgradePackage(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "upgradeSetCurrentUpgradePackage(ManagedObject value, Coordinator c)", "value: " + managedObject + "\n\tc: " + SuLib.toString(coordinator));
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.currentUpgradePackage.setValue(managedObject);
    }

    public UP_CV_Information getUP_CV_Information(String string) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUP_CV_Information ( String anUpgradePackageDocumentId )", "anUpgradePackageDocumentId: " + string);
        }
        return this.cvProxy.sendSignalOsaCvListUpCvReq(string);
    }

    public void deleteCVsRelatedToUP(String string) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteCVsRelatedToUP ( String anUpgradePackageDocumentId )", "anUpgradePackageDocumentId: " + string);
        }
        this.cvProxy.sendSignalOsaCvRemoveCvReq(string);
    }

    public VerifyCVsInformation checkIfNumberOfCVsMayBeCreated(int n) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkIfNumberOfCVsMayBeCreated(int aNumberOfCvs)", "aNumberOfCvs: " + n);
        }
        return this.cvProxy.sendOsaCvPreCheckBeforeSuReq(n);
    }

    public String[] getPreUpgradedCVs(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPreUpgradedCVs( Coordinator aCoordinator )", "aCoordinator: " + SuLib.toString(coordinator));
        }
        return CV_PreUpgradeRelationHandler.getInstance().getAllPreUpgradedCVs(null);
    }

    private boolean autocreate() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "autocreate( )");
        }
        String string = null;
        String string2 = "";
        try {
            MO_HandlerFactoryInterface mO_HandlerFactoryInterface = (MO_HandlerFactoryInterface)ServiceLocatorFacade.getRepository().getService(MO_HandlerFactoryInterface.class);
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = mO_HandlerFactoryInterface.getConfigurationVersionMO_HandlerInterface();
            string = configurationVersionMO_HandlerInterface.createNameForDailyAutoCV(this.currentUpgradePackage.getValue(null));
            string2 = this.createNewCVName(string);
            try {
                CV_UsageResultInformation cV_UsageResultInformation = this.cvProxy.sendOsaCvGetCvUsageReq();
                if (cV_UsageResultInformation.result != 0) {
                    this.handlErrorResult(cV_UsageResultInformation.result);
                }
                String string3 = cV_UsageResultInformation.startableCV;
                String[] stringArray = cV_UsageResultInformation.rollbackList;
                this.checkIfStartableInRollbacklist(string3, stringArray);
                this.actionSetFirstRollbackList(string3, null);
            }
            catch (Exception exception) {
                Trace.info(this.getClass(), "autocreate()", "Exception caught at configuration of the rollbackList, autocreate CV will proceed. Exception: " + exception);
            }
            this.create(string2, this.getNamingAttributeValue(), 4, NOT_AVAILABLE, "Cello Packet Platform", COMMENT, false);
            this.actionSetStartable(string2, null);
        }
        catch (FunctionBusyException functionBusyException) {
            Trace.info(this.getClass(), "autocreate( )", "cannot Auto Create CV,ConfigurationVersion MO is busy with another task");
            return false;
        }
        catch (MoRemovedException moRemovedException) {
            Trace.error(this.getClass(), "autocreate( )", "MoRemovedException caught when trying to auto create a daily CV, \n\tthe referenced current Upgrade Package is not present, it must be re-created before it's possible to create a CV,\n\tMoRemovedException info: " + moRemovedException.toString());
            return false;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "autocreate( )", "Exception caught when trying to auto create a daily CV.", throwable);
            return false;
        }
        return true;
    }

    private void changeBackupTime(String string) throws ValueOutOfRangeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "changeBackupTime(String value)", "value: " + string);
        }
        this.timer.stop();
        this.timer.removeActionListener(this);
        this.startBackupTimer(string);
    }

    private void changeTimeAndAutoCv() throws ValueOutOfRangeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "changeTimeAndAutoCv( )");
        }
        try {
            this.changeBackupTime(this.timeForAutoCreatedCV.getValue(this.coordinator));
        }
        catch (Exception exception) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "changeTimeAndAutoCv( )", "Exception caught when trying to change both auto CV timer value and auto CV on/off,\n\tException: " + exception.toString() + "\n\tthrowing ValueOutOfRangeException");
            }
            throw new ValueOutOfRangeException("timeForAutoCreatedCV", "ConfigurationVersion");
        }
        if (!this.autoCreatedCVIsTurnedOn.getValue(this.coordinator)) {
            this.timer.stop();
        }
    }

    private void changeTimeValue() throws ValueOutOfRangeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "changeTimeValue( )");
        }
        try {
            this.changeBackupTime(this.timeForAutoCreatedCV.getValue(this.coordinator));
        }
        catch (Exception exception) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "changeTimeValue( )", "Exception caught when trying to change auto CV timer value,\n\tException: " + exception.toString() + "\n\tthrowing ValueOutOfRangeException");
            }
            throw new ValueOutOfRangeException("timeForAutoCreatedCV", "ConfigurationVersion");
        }
        if (!this.autoCreatedCVIsTurnedOn.getValue(null)) {
            this.timer.stop();
        }
    }

    private void checkIfStartableInRollbacklist(String string, String[] stringArray) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkIfStartableInRollbacklist(String aStartable, String[] aRollbacklist)", "aStartable: " + string + "\n\taRollbacklist: " + SuLib.toString(stringArray));
        }
        boolean bl = false;
        for (int i = 0; !bl && i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            Trace.info(this.getClass(), "checkIfStartableInRollbacklist(String aStartable, String[] aRollbacklist)", "About to remove startableCV " + string + " from the rollbacklist.");
            bl = true;
            this.actionRemoveFromRollbackList(string, null);
        }
    }

    private void checkInputTime(String string) throws ValueOutOfRangeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkInputTime(String value)", "value: " + string);
        }
        int[] nArray = new int[2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() != 2) {
            throw new ValueOutOfRangeException("timeForAutoCreatedCV", "ConfigurationVersion");
        }
        try {
            nArray[0] = Integer.parseInt(stringTokenizer.nextToken());
            nArray[1] = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            throw new ValueOutOfRangeException("timeForAutoCreatedCV", "ConfigurationVersion");
        }
        if (nArray[0] < 0 || nArray[0] > 23 || nArray[1] < 0 || nArray[1] > 59) {
            throw new ValueOutOfRangeException("timeForAutoCreatedCV", "ConfigurationVersion");
        }
    }

    private void create(String string, String string2, int n, String string3, String string4, String string5, boolean bl) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "create(String configurationVersionName, String identity, int type, String upPackageId, String operatorName, String comment, boolean anIsLongCreationTimeoutValueToBeUsed)", "configurationVersionName: " + string + "\n\tidentity: " + string2 + "\n\ttype: " + n + "\n\tupPackageId: " + string3 + "\n\toperatorName: " + string4 + "\n\tcomment: " + string5 + "\n\tanIsLongCreationTimeoutValueToBeUsed: " + bl);
        }
        try {
            CV_ActionCreateHandler cV_ActionCreateHandler = new CV_ActionCreateHandler(this);
            cV_ActionCreateHandler.create((UpgradePackageMo)this.currentUpgradePackage.getValue(null), string, string2, n, string3, string4, string5, bl);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "create(String configurationVersionName, String identity, int type, String upPackageId, String operatorName, String comment)", "ConfigurationVersionException caught.\n\tconfigurationVersionName: " + string + "\n\tidentity: " + string2 + "\n\ttype: " + n + "\n\tupPackageId: " + string3 + "\n\toperatorName: " + string4 + "\n\tcomment: " + string5 + "\n\tThrowable: " + (Object)((Object)configurationVersionException) + "\n\tThrowable data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (MoRemovedException moRemovedException) {
            Trace.error(this.getClass(), "create(String configurationVersionName, String identity, int type, String upPackageId, String operatorName, String comment)", "MoRemovedException caught, \n\tthe referenced current Upgrade Package is not present, it must be re-created before it's possible to create a CV,\n\tMoRemovedException info: " + moRemovedException.toString() + "\n\tconfigurationVersionName: " + string + "\n\tidentity: " + string2 + "\n\ttype: " + n + "\n\tupPackageId: " + string3 + "\n\toperatorName: " + string4 + "\n\tcomment: " + string5);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tcreate(String configurationVersionName, String identity, int type, String upPackageId, String operatorName, String comment)" + "\n\tMoRemovedException caught, " + "\n\tthe referenced current Upgrade Package is not present, " + "it must be re-created before it's possible to create a CV," + "\n\tMoRemovedException info: " + moRemovedException.toString() + "\n\tconfigurationVersionName: " + string + "\n\tidentity: " + string2 + "\n\ttype: " + n + "\n\tupPackageId: " + string3 + "\n\toperatorName: " + string4 + "\n\tcomment: " + string5);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "create(String configurationVersionName, String identity, int type, String upPackageId, String operatorName, String comment)", "configurationVersionName: " + string + "\n\tidentity: " + string2 + "\n\ttype: " + n + "\n\tupPackageId: " + string3 + "\n\toperatorName: " + string4 + "\n\tcomment: " + string5 + "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tcreate(String configurationVersionName, String identity, int type, String upPackageId, String operatorName, String comment)" + "\n\tconfigurationVersionName: " + string + "\n\tidentity: " + string2 + "\n\ttype: " + n + "\n\tupPackageId: " + string3 + "\n\toperatorName: " + string4 + "\n\tcomment: " + string5 + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void handlErrorResult(int n) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handlErrorResult(int result)", "result: " + n);
        }
        SignalHandler signalHandler = new SignalHandler();
        signalHandler.checkResult(n);
    }

    private synchronized void registerResource(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "registerResource(Coordinator key)", "key: " + SuLib.toString(coordinator));
        }
        if (this.coordinator == null || !this.coordinator.isSameTransaction(coordinator)) {
            this.coordinator = coordinator;
            try {
                this.coordinator.registerResource((Resource)this);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                Trace.error(this.getClass(), "registerResource(Coordinator key)", "InactiveTransactionException caught when trying to register a resource in a transaction.\n\tkey: " + SuLib.toString(coordinator), inactiveTransactionException);
                throw new TransactionRequiredException();
            }
        }
    }

    private void resetIndications() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "resetIndications( )");
        }
        this.txOnAutoCreatedCVIsTurnedOn = false;
        this.txOnTimeForAutoCreatedCV = false;
    }

    private void sendActivityChangeNotification(String string, int n, int n2, int n3, Coordinator coordinator) {
        if (Trace.valid(ConfigurationVersionMoExtension.class, 20)) {
            Trace.debug(ConfigurationVersionMoExtension.class, 20, "sendActivityChangeNotification(String anNameOfAcvitityAttribute, int aNewValue, int anOldValue, int anOldValueInDB, Coordinator aCoordinator)", "anNameOfAcvitityAttribute: " + string + "\n\taNewValue: " + n + "\n\tanOldValue: " + n2 + "\n\tanOldValueInDB: " + n3 + "\n\tcontext: " + SuLib.toString(coordinator));
        }
        if (n != n2 && n == n3) {
            String[] stringArray = new String[]{string};
            Object[] objectArray = new Object[]{new Integer(n)};
            ConfigurationVersionMoExtension.sendChangeNotification(this, stringArray, objectArray, coordinator);
        }
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        if (Trace.valid(ConfigurationVersionMoExtension.class, 20)) {
            Trace.debug(ConfigurationVersionMoExtension.class, 20, "sendChangeNotification(ManagedObject mo, String[] attrNames, Object[] newValues, Coordinator context)", "mo: " + managedObject + "\n\tattrNames: " + SuLib.toString(stringArray) + "\n\tnewValues: " + SuLib.toString(objectArray) + "\n\tcontext: " + SuLib.toString(coordinator));
        }
        NotificationSender notificationSender = NotificationSender.instance();
        if (coordinator == null) {
            notificationSender.pushAVC(managedObject, stringArray, objectArray);
        } else {
            notificationSender.pushAVC(managedObject, stringArray, objectArray, coordinator);
        }
    }

    private void startBackupTimer(String string) throws ValueOutOfRangeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "startBackupTimer(String value)", "value: " + string);
        }
        this.timer = new BackupTimer(string);
        this.timer.addActionListener(this);
        this.timer.start();
    }

    private void startOrStopAutoCv() throws ValueOutOfRangeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "startOrStopAutoCv( )");
        }
        if (this.autoCreatedCVIsTurnedOn.getValue(this.coordinator)) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    public String createNewCVName(String string) throws Exception {
        Struct[] structArray = this.getStoredConfigurationVersions(null);
        for (int i = 0; i < structArray.length; ++i) {
            String string2 = "";
            string2 = (String)structArray[i].getValue("name");
            if (!string.equals(string2)) continue;
            string = this.modifiedCV(string);
            i = 0;
        }
        return string;
    }

    public String modifiedCV(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        String string2 = "";
        int n = 0;
        String string3 = "";
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreElements()) {
            vector.add(stringTokenizer.nextToken());
            ++n;
        }
        String[] stringArray = new String[n];
        vector.toArray(stringArray);
        string3 = stringArray[stringArray.length - 2] + stringArray[stringArray.length - 1];
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmm");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyMMdd_HHmm");
        Date date = simpleDateFormat.parse(string3);
        calendar.setTime(date);
        int n2 = calendar.get(12);
        calendar.set(12, n2 + 1);
        date = calendar.getTime();
        for (int i = 0; i < stringArray.length - 2; ++i) {
            string2 = string2 + stringArray[i] + "_";
        }
        return string2 + simpleDateFormat2.format(date);
    }

    public Object[] hideHazardousAttributeValues(AttrList attrList) {
        return null;
    }

    public Object[] hideHazardousActionParameters(String string, Object[] objectArray) {
        try {
            int n;
            if (string.equalsIgnoreCase("getFromFtpServer")) {
                n = 3;
            } else if (string.equalsIgnoreCase("putToFtpServer")) {
                n = 5;
            } else {
                return null;
            }
            objectArray[n] = "*****";
            return objectArray;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.info(this.getClass(), (String)("In hideHazardousActionParameters, not able to hide hazardous parameters" + runtimeException));
            return null;
        }
    }

    private static boolean reloadTraceProperties() {
        boolean bl = false;
        MoIterator moIterator = MoRepository.instance().lookupType("UpgradeTrace");
        if (moIterator != null) {
            UpgradeTraceMoImpl upgradeTraceMoImpl = (UpgradeTraceMoImpl)moIterator.nextElement();
            upgradeTraceMoImpl.reloadTraceProperties();
            bl = true;
        }
        return bl;
    }

    public void setAutoCreatedCVIsTurnedOnBackup(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.autoCreatedCVIsTurnedOnBackup.setValue(bl);
    }

    public boolean getAutoCreatedCVIsTurnedOnBackup(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.autoCreatedCVIsTurnedOnBackup.getValue(coordinator);
    }

    public static Integer getMoDataRevision() {
        return new Integer(7000);
    }
}

