/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.restore;

import java.util.EventObject;
import se.ericsson.cello.configurationversion.base.CV_SubFunctionController;
import se.ericsson.cello.configurationversion.base.IllegalInputDataException;
import se.ericsson.cello.configurationversion.base.InsufficientDiskSpaceOnNodeException;
import se.ericsson.cello.configurationversion.base.ResponseEvent;
import se.ericsson.cello.configurationversion.base.ResponseRejectedInfosEvent;
import se.ericsson.cello.configurationversion.cancelrestore.RestoreCancelInterface;
import se.ericsson.cello.configurationversion.cancelrestore.RestoreCanceller;
import se.ericsson.cello.configurationversion.control.CV_Controller;
import se.ericsson.cello.configurationversion.file.autoconfiguration.create.AutoConfigurationDataFileCreator;
import se.ericsson.cello.configurationversion.file.autoconfiguration.create.AutoConfigurationDataFileCreatorException;
import se.ericsson.cello.configurationversion.file.autoconfiguration.parser.SettingModeValue;
import se.ericsson.cello.configurationversion.file.base.FilePath;
import se.ericsson.cello.configurationversion.file.ipnetworkdata.create.IP_NetworkDataFileCreator;
import se.ericsson.cello.configurationversion.main.event.actionresult.ActionAdditionalResultData;
import se.ericsson.cello.configurationversion.main.event.actionresult.ActionInformationResultInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.CV_ActionResultDataTypeOfInvokedActionValue;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionForcedRestoreInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionRestoreInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.RestoreManuallyCancelledInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.UnspecifiedErrorInformation;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.ExecutionFailedEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.IdleEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.NodeRestartRequestEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.RestoreCancelledEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.RestoreInitiatedEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.RestoreRequestedEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.SavingRollbackCVEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.MainIdleEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.RestoringDownloadedBackupCV_Event;
import se.ericsson.cello.configurationversion.main.exception.CVFileSystemErrorException;
import se.ericsson.cello.configurationversion.main.exception.CVLLPErrorException;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.util.CV_ActionResultCreator;
import se.ericsson.cello.configurationversion.restore.RestoreCancelledException;
import se.ericsson.cello.configurationversion.restore.RestoreException;
import se.ericsson.cello.configurationversion.restore.RestoreProperties;
import se.ericsson.cello.configurationversion.restore.RestoreRejectedEvent;
import se.ericsson.cello.configurationversion.restore.RestoreRequestEvent;
import se.ericsson.cello.configurationversion.restore.VariantOfRestoreActionNotAllowedException;
import se.ericsson.cello.configurationversion.util.additionalinfo.AdditionalInformationContainer;
import se.ericsson.cello.configurationversion.util.additionalinfo.AdditionalInformationCreator;
import se.ericsson.cello.configurationversion.util.handler.CV_DoesNotExistException;
import se.ericsson.cello.configurationversion.util.handler.RestoreCV_Handler;
import se.ericsson.cello.configurationversion.util.progresshandler.CV_ProgressInformationHandler;
import se.ericsson.cello.configurationversion.util.progresshandler.NotifyingConfigurationVersionPropertyName;
import se.ericsson.cello.configurationversion.verify.base.VerifyException;
import se.ericsson.cello.configurationversion.verify.base.VerifyProperties;
import se.ericsson.cello.configurationversion.verify.control.RestoreVerifier;
import se.ericsson.cello.configurationversion.verify.event.VerifyConfirmedDetailedEvent;
import se.ericsson.cello.configurationversion.verify.event.VerifyRejectedDetailedEvent;
import se.ericsson.cello.configurationversion.verify.html.HtmlGenerator;
import se.ericsson.cello.configurationversion.verify.html.VerifyResultInfo;
import se.ericsson.cello.managedelement.suaccess.ManagedElementMoSU_Access;
import se.ericsson.cello.mao.RestartReasonEnum;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.su.froproxy.cv.interfaces.OsaCvMgmntProxyAccess;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;

public class Restorer
extends CV_SubFunctionController
implements RestoreCancelInterface,
Runnable {
    private BlockingQueue myQueue = new BlockingQueue();
    private RestoreCanceller myRestoreCanceller = null;
    private boolean myIsRestoreToBeCancelled = false;

    public Restorer() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "Restorer()");
        }
    }

    public void initiateThread() {
        new Thread((Runnable)this, "Restorer").start();
    }

    public void cancelExecutionOfRestore(RestoreCanceller restoreCanceller) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "cancelExecutionOfRestore(RestoreCanceller aRestoreCanceller)", "aRestoreCanceller: " + restoreCanceller);
        }
        this.myRestoreCanceller = restoreCanceller;
        this.myIsRestoreToBeCancelled = true;
    }

    public void restoreRequest(String string, int n, boolean bl, UpgradePackageMo upgradePackageMo) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "restoreRequest(String aCV_Name, int aCvAutoConfigurationInformation, boolean anIsForcedRestoreRequested, UpgradePackageMo aCurrentUpgradePackage)", "aCV_Name: " + string + "\n\taCvAutoConfigurationInformation: " + n + "\n\tanIsForcedRestoreRequested: " + bl + "\n\taCurrentUpgradePackage: " + upgradePackageMo);
        }
        RestoreRequestEvent restoreRequestEvent = new RestoreRequestEvent(this, string, n, bl, upgradePackageMo);
        this.myQueue.enqueue((Object)restoreRequestEvent);
    }

    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run()");
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run ( )", "New thread handling restore of a downloaded CV has been started.");
        }
        EventObject eventObject = null;
        try {
            eventObject = (EventObject)this.myQueue.dequeue();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "run ()", "Received event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
            }
            if (eventObject instanceof RestoreRequestEvent) {
                this.handleRestoreRequest((RestoreRequestEvent)eventObject);
            } else {
                Trace.warning(this.getClass(), "run ()", "Unexected event received (ignored)\n\tReceived event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
            }
        }
        catch (RestoreException restoreException) {
            Trace.info(this.getClass(), "run()", "RestoreException caught while waiting for an event or executing an received event (this should not happen).\n\ttheRequestEvent: " + eventObject + "\n\tException data: " + restoreException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "run()", "Exception caught while waiting for an event or executing an received event.theRequestEvent: " + eventObject, throwable);
            if (eventObject instanceof RestoreRequestEvent) {
                this.setActionRejectedResult(new UnspecifiedErrorInformation(), throwable.toString(), ((RestoreRequestEvent)eventObject).cvName, ((RestoreRequestEvent)eventObject).isForcedRestoreRequested);
            } else {
                this.setActionRejectedResult(new UnspecifiedErrorInformation(), throwable.toString() + "\n\tReceived request event: " + eventObject, "", false);
            }
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
            CV_Controller.instance().restoreResponse(false);
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run ( )", "Thread handling the restore of a CV is now stopped.");
        }
        Trace.flushToTraceFile();
    }

    private void copyNeededCV_FilesToC(String string, String string2) throws RestoreException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "copyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)", "aCV_Name: " + string + "\n\taTmpFilePath: " + string2);
        }
        OsaCvMgmntProxyAccess osaCvMgmntProxyAccess = (OsaCvMgmntProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaCvMgmntProxyAccess.class);
        try {
            int n = osaCvMgmntProxyAccess.sendOsaCvCopyFilesFromCvReq(string, string2);
            if (n == 0) {
                return;
            }
            if (n == 6) {
                throw new CV_DoesNotExistException("Could not copy the requested restore files to C disk due to the CV does not exist.\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2);
            }
            if (n == 12) {
                throw new InsufficientDiskSpaceOnNodeException("Could not copy the requested restore files to C disk due to insufficient disk space on the Node.\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2);
            }
            if (n == 2) {
                throw new CVFileSystemErrorException("ConfigurationVersion", "Could not copy the requested restore files to C disk due to File System Error.\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2);
            }
            if (n == 4) {
                throw new CVLLPErrorException("ConfigurationVersion", "Could not copy the requested restore files to C disk due LLP error.\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2);
            }
            throw new RestoreException("Could not copy the requested restore files to C disk due to the reason cause " + n + " (" + osaCvMgmntProxyAccess.getResultMsg(n) + ")." + "\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)" + "\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw new RestoreException(configurationVersionException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "copyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)", "Throwable caught.\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2, throwable);
            throw new RestoreException("Class name: " + this.getClass().getName() + "\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)" + "\n\taTmpFilePath: " + string2 + "\n\taCV_Name: " + string + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void createRestoreRollbackCV(UpgradePackageMo upgradePackageMo, String string, boolean bl) throws RestoreException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createRestoreRollbackCV(UpgradePackageMo aCurrentUpgradePackage, String aCV_ToBeRestored, boolean anIsForcedRestoreRequested)", "aCurrentUpgradePackage: " + upgradePackageMo + "\n\taCV_ToBeRestored: " + string + "\n\tanIsForcedRestoreRequested: " + bl);
        }
        try {
            RestoreCV_Handler restoreCV_Handler = new RestoreCV_Handler();
            restoreCV_Handler.configureCV_DataBeforeRestart(upgradePackageMo, string, bl);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw new RestoreException(configurationVersionException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createRestoreRollbackCV(UpgradePackageMo aCurrentUpgradePackage, String aCV_ToBeRestored, boolean anIsForcedRestoreRequested)", "Throwable caught.\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taCV_ToBeRestored: " + string + "\n\tanIsForcedRestoreRequested: " + bl, throwable);
            throw new RestoreException("Class name: " + this.getClass().getName() + "\n\tcreateRestoreRollbackCV(UpgradePackageMo aCurrentUpgradePackage, String aCV_ToBeRestored, boolean anIsForcedRestoreRequested)" + "\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taCV_ToBeRestored: " + string + "\n\tanIsForcedRestoreRequested: " + bl + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleRestoreRequest(RestoreRequestEvent restoreRequestEvent) throws RestoreException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "aRestoreRequestEvent: " + restoreRequestEvent);
        }
        String string = null;
        AdditionalInformationCreator additionalInformationCreator = new AdditionalInformationCreator();
        ResponseEvent responseEvent = null;
        try {
            try {
                RestoreProperties restoreProperties = new RestoreProperties();
                FilePath filePath = new FilePath();
                string = filePath.createValidCV_RootFilePath(restoreProperties.cvCMA_FileDisk, restoreProperties.getCV_RestoreFilesPath());
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new RestoringDownloadedBackupCV_Event(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new RestoreRequestedEvent(this));
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "Validates input parameters.");
                }
                this.validateInputData(restoreRequestEvent);
                this.restoreToBeAborted();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "Verify that the choosen CV is possible to use for restore (auto-verifyRestore).");
                }
                RestoreVerifier restoreVerifier = new RestoreVerifier();
                restoreVerifier.initiateThread();
                responseEvent = restoreVerifier.autoVerifyRestore(restoreRequestEvent.cvName);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "Determine if it is allowed to continue with restore.");
                }
                this.determineIfRestoreIsAllowed(restoreRequestEvent.isForcedRestoreRequested, responseEvent);
                this.restoreToBeAborted();
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new RestoreInitiatedEvent(this));
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "Copying files from CV to C disk.");
                }
                this.copyNeededCV_FilesToC(restoreRequestEvent.cvName, string);
                additionalInformationCreator.activate();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "Saving auto-configuration data.");
                }
                this.saveAutoConfigMode(string, restoreRequestEvent.cvAutoConfigurationInformation);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "Saving IP address information.");
                }
                this.saveIP_AddressData(string);
                this.restoreToBeAborted();
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new SavingRollbackCVEvent(this));
                this.createRestoreRollbackCV(restoreRequestEvent.currentUpgradePackage, restoreRequestEvent.cvName, restoreRequestEvent.isForcedRestoreRequested);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new NodeRestartRequestEvent(this));
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "Restarts the node (sleeps " + restoreProperties.sleepTimeoutValueBeforeRestartNode + " ms. before requesting restart).");
                }
                TimeHandler.sleep(restoreProperties.sleepTimeoutValueBeforeRestartNode);
                this.restoreToBeAborted();
                CV_Controller.instance().restoreResponse(true);
                this.restartNode(new RestartReasonEnum(23, this.getClass()));
            }
            catch (RestoreCancelledException restoreCancelledException) {
                this.writeToHTML_File(responseEvent);
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new RestoreManuallyCancelledInformation(), restoreCancelledException.toString(), restoreRequestEvent.cvName, restoreRequestEvent.isForcedRestoreRequested);
                this.deleteCreatedFiles(string);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new RestoreCancelledEvent(this));
                this.myRestoreCanceller.cancelRestoreAllowed(false);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                CV_Controller.instance().restoreResponse(false);
                Object var9_14 = null;
                Trace.log1(this.getClass(), "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                Trace.flushToTraceFile();
                return;
            }
            catch (VariantOfRestoreActionNotAllowedException variantOfRestoreActionNotAllowedException) {
                this.deleteCreatedFiles(string);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                CV_Controller.instance().restoreResponse(false);
                Object var9_15 = null;
                Trace.log1(this.getClass(), "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                Trace.flushToTraceFile();
                return;
            }
            catch (VerifyException verifyException) {
                this.writeToHTML_File(responseEvent);
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new UnspecifiedErrorInformation(), verifyException.toString(), restoreRequestEvent.cvName, restoreRequestEvent.isForcedRestoreRequested);
                this.deleteCreatedFiles(string);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                CV_Controller.instance().restoreResponse(false);
                Object var9_16 = null;
                Trace.log1(this.getClass(), "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                Trace.flushToTraceFile();
                return;
            }
            catch (ConfigurationVersionException configurationVersionException) {
                this.writeToHTML_File(responseEvent);
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new UnspecifiedErrorInformation(), configurationVersionException.toString(), restoreRequestEvent.cvName, restoreRequestEvent.isForcedRestoreRequested);
                this.deleteCreatedFiles(string);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                CV_Controller.instance().restoreResponse(false);
                Object var9_17 = null;
                Trace.log1(this.getClass(), "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                Trace.flushToTraceFile();
                return;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "Exception caugth,\n\taRestoreRequestEvent: " + restoreRequestEvent, throwable);
                this.writeToHTML_File(responseEvent);
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new UnspecifiedErrorInformation(), throwable.toString(), restoreRequestEvent.cvName, restoreRequestEvent.isForcedRestoreRequested);
                this.deleteCreatedFiles(string);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                CV_Controller.instance().restoreResponse(false);
                Object var9_18 = null;
                Trace.log1(this.getClass(), "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                Trace.flushToTraceFile();
                return;
            }
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_19 = null;
            Trace.log1(this.getClass(), "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "Cleaning up.");
            additionalInformationCreator.deactivate();
            Trace.flushToTraceFile();
            throw throwable;
        }
        Trace.log1(this.getClass(), "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "Cleaning up.");
        additionalInformationCreator.deactivate();
        Trace.flushToTraceFile();
    }

    private void determineIfRestoreIsAllowed(boolean bl, ResponseEvent responseEvent) throws RestoreException, VariantOfRestoreActionNotAllowedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "determineIfRestoreIsAllowed(boolean anIsForcedRestoreRequested, ResponseEvent aVerifyResponseEvent)", "anIsForcedRestoreRequested: " + bl + "\n\taVerifyResponseEvent: " + responseEvent);
        }
        if (responseEvent instanceof VerifyConfirmedDetailedEvent) {
            this.determineIfRestoreIsAllowed(bl, (VerifyConfirmedDetailedEvent)responseEvent);
        } else if (responseEvent instanceof VerifyRejectedDetailedEvent) {
            this.determineIfRestoreIsAllowed(bl, (VerifyRejectedDetailedEvent)responseEvent);
        } else {
            Trace.error(this.getClass(), "determineIfRestoreIsAllowed(boolean anIsForcedRestoreRequested, ResponseEvent aVerifyResponseEvent)", "Unexpected verify response event received.\n\tanIsForcedRestoreRequested: " + bl + "\n\taVerifyResponseEvent: " + responseEvent);
            throw new RestoreException("Class name: " + this.getClass().getName() + "\n\tdetermineIfRestoreIsAllowed(boolean anIsForcedRestoreRequested, ResponseEvent aVerifyResponseEvent)" + "\n\tUnexpected verify response event received." + "\n\tanIsForcedRestoreRequested: " + bl + "\n\taVerifyResponseEvent: " + responseEvent);
        }
    }

    private void determineIfRestoreIsAllowed(boolean bl, VerifyConfirmedDetailedEvent verifyConfirmedDetailedEvent) throws RestoreException, VariantOfRestoreActionNotAllowedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "determineIfRestoreIsAllowed(boolean anIsForcedRestoreRequested, VerifyConfirmedDetailedEvent aVerifyConfirmedDetailedEvent)", "anIsForcedRestoreRequested: " + bl + "\n\taVerifyConfirmedDetailedEvent: " + verifyConfirmedDetailedEvent);
        }
        boolean bl2 = true;
        CV_ActionResultDataTypeOfInvokedActionValue cV_ActionResultDataTypeOfInvokedActionValue = null;
        try {
            if (bl) {
                if (!verifyConfirmedDetailedEvent.getRestoreVariantActionsAllowed().isActionForcedRestoreAllowed()) {
                    bl2 = false;
                    cV_ActionResultDataTypeOfInvokedActionValue = new InvokedActionForcedRestoreInformation();
                }
            } else if (!verifyConfirmedDetailedEvent.getRestoreVariantActionsAllowed().isActionRestoreAllowed()) {
                bl2 = false;
                cV_ActionResultDataTypeOfInvokedActionValue = new InvokedActionRestoreInformation();
            }
            if (!bl2) {
                String string = this.writeToHTML_File(verifyConfirmedDetailedEvent);
                verifyConfirmedDetailedEvent.setPathToDetailedInformation(string);
                CV_ActionResultCreator cV_ActionResultCreator = new CV_ActionResultCreator();
                cV_ActionResultCreator.createActionResult(verifyConfirmedDetailedEvent, cV_ActionResultDataTypeOfInvokedActionValue, true);
                this.firePropertyChangeCorruptedUPs(verifyConfirmedDetailedEvent.getCorruptedUPs(), verifyConfirmedDetailedEvent.getMissingUPs());
                this.firePropertyChangeMissingUPs(verifyConfirmedDetailedEvent.getMissingUPs());
                throw new VariantOfRestoreActionNotAllowedException("Action " + cV_ActionResultDataTypeOfInvokedActionValue.getName() + " is not allowed to execute according to the verify restore phase.");
            }
        }
        catch (VariantOfRestoreActionNotAllowedException variantOfRestoreActionNotAllowedException) {
            throw variantOfRestoreActionNotAllowedException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "determineIfRestoreIsAllowed(boolean anIsForcedRestoreRequested, VerifyConfirmedDetailedEvent aVerifyConfirmedDetailedEvent)", "Throwable caught.anIsForcedRestoreRequested: " + bl + "\n\taVerifyConfirmedDetailedEvent: " + verifyConfirmedDetailedEvent + throwable);
            throw new RestoreException("Class name: " + this.getClass().getName() + "\n\tdetermineIfRestoreIsAllowed(boolean anIsForcedRestoreRequested, VerifyConfirmedDetailedEvent aVerifyConfirmedDetailedEvent)" + "\n\tThrowable caught." + "anIsForcedRestoreRequested: " + bl + "\n\taVerifyConfirmedDetailedEvent: " + verifyConfirmedDetailedEvent + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void determineIfRestoreIsAllowed(boolean bl, VerifyRejectedDetailedEvent verifyRejectedDetailedEvent) throws RestoreException, VariantOfRestoreActionNotAllowedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "determineIfRestoreIsAllowed(boolean anIsForcedRestoreRequested, VerifyRejectedDetailedEvent aVerifyRejectedDetailedEvent)", "anIsForcedRestoreRequested: " + bl + "\n\taVerifyRejectedDetailedEvent: " + verifyRejectedDetailedEvent);
        }
        boolean bl2 = true;
        CV_ActionResultDataTypeOfInvokedActionValue cV_ActionResultDataTypeOfInvokedActionValue = null;
        try {
            if (bl) {
                if (!verifyRejectedDetailedEvent.getRestoreVariantActionsAllowed().isActionForcedRestoreAllowed()) {
                    bl2 = false;
                    cV_ActionResultDataTypeOfInvokedActionValue = new InvokedActionForcedRestoreInformation();
                }
            } else if (!verifyRejectedDetailedEvent.getRestoreVariantActionsAllowed().isActionRestoreAllowed()) {
                bl2 = false;
                cV_ActionResultDataTypeOfInvokedActionValue = new InvokedActionRestoreInformation();
            }
            if (!bl2) {
                Object object;
                String string = this.writeToHTML_File(verifyRejectedDetailedEvent);
                verifyRejectedDetailedEvent.setPathToDetailedInformation(string);
                if (verifyRejectedDetailedEvent.getActionInformationResultErrorInformation() != null) {
                    object = new ActionAdditionalResultData((ActionInformationResultInformation)verifyRejectedDetailedEvent.getActionInformationResultErrorInformation(), verifyRejectedDetailedEvent.getAdditionalInformationToActionInformation());
                    verifyRejectedDetailedEvent.getAdditionalResultDataVerificationResultInformations().add(object);
                }
                object = new CV_ActionResultCreator();
                ((CV_ActionResultCreator)object).createActionResult(verifyRejectedDetailedEvent, cV_ActionResultDataTypeOfInvokedActionValue);
                this.firePropertyChangeCorruptedUPs(verifyRejectedDetailedEvent.getCorruptedUPs(), verifyRejectedDetailedEvent.getMissingUPs());
                this.firePropertyChangeMissingUPs(verifyRejectedDetailedEvent.getMissingUPs());
                throw new VariantOfRestoreActionNotAllowedException("Action " + cV_ActionResultDataTypeOfInvokedActionValue.getName() + " is not allowed to execute according to the verify restore phase.");
            }
        }
        catch (VariantOfRestoreActionNotAllowedException variantOfRestoreActionNotAllowedException) {
            throw variantOfRestoreActionNotAllowedException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "determineIfRestoreIsAllowed(boolean anIsForcedRestoreRequested, VerifyRejectedDetailedEvent aVerifyRejectedDetailedEvent)", "Throwable caught.anIsForcedRestoreRequested: " + bl + "\n\taVerifyRejectedDetailedEvent: " + verifyRejectedDetailedEvent + throwable);
            throw new RestoreException("Class name: " + this.getClass().getName() + "\n\tdetermineIfRestoreIsAllowed(boolean anIsForcedRestoreRequested, VerifyRejectedDetailedEvent aVerifyRejectedDetailedEvent)" + "\n\tThrowable caught." + "anIsForcedRestoreRequested: " + bl + "\n\taVerifyRejectedDetailedEvent: " + verifyRejectedDetailedEvent + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void restartNode(RestartReasonEnum restartReasonEnum) throws RestoreException {
        String string = "restartNode(RestartReasonEnum aReason)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string);
        }
        try {
            Trace.flushToTraceFile();
            ManagedElementMoSU_Access managedElementMoSU_Access = (ManagedElementMoSU_Access)MibMgr.instance().getMib().getRootMo();
            managedElementMoSU_Access.systemInitiatedRestartFromSU(0, restartReasonEnum.getValue(), "", null);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught." + throwable);
            throw new RestoreException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void restoreToBeAborted() throws RestoreCancelledException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "restoreToBeAborted()");
        }
        if (this.myIsRestoreToBeCancelled) {
            throw new RestoreCancelledException("The execution of restore is cancelled due to request from outside.");
        }
    }

    private void saveAutoConfigMode(String string, int n) throws RestoreException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "saveAutoConfigMode(String aRestoreCV_DirPath, int aCvAutoConfigurationInformation)", "aRestoreCV_DirPath: " + string + "\n\taCvAutoConfigurationInformation: " + n);
        }
        try {
            AutoConfigurationDataFileCreator autoConfigurationDataFileCreator = new AutoConfigurationDataFileCreator();
            autoConfigurationDataFileCreator.createFile("1", string + "/", SettingModeValue.translateValue(n), false);
        }
        catch (AutoConfigurationDataFileCreatorException autoConfigurationDataFileCreatorException) {
            throw new RestoreException("Class name: " + this.getClass().getName() + "\n\tsaveAutoConfigMode(String aRestoreCV_FilePath, int aCvAutoConfigurationInformation)" + "\n\taCvAutoConfigurationInformation: " + n + "\n\tAutoConfigurationDataFileCreatorException caught." + "\n\tThrowable data: " + autoConfigurationDataFileCreatorException.toString());
        }
        catch (Throwable throwable) {
            throw new RestoreException("Class name: " + this.getClass().getName() + "\n\tsaveAutoConfigMode(String aRestoreCV_FilePath, int aCvAutoConfigurationInformation)" + "\n\taCvAutoConfigurationInformation: " + n + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void saveIP_AddressData(String string) throws RestoreException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "saveIP_AddressData(String aRestoreCV_DirPath)", "aRestoreCV_DirPath: " + string);
        }
        try {
            OsaCvMgmntProxyAccess osaCvMgmntProxyAccess = (OsaCvMgmntProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaCvMgmntProxyAccess.class);
            boolean bl = true;
            if (!SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_3", (Object)osaCvMgmntProxyAccess)) {
                bl = false;
            }
            IP_NetworkDataFileCreator iP_NetworkDataFileCreator = new IP_NetworkDataFileCreator();
            iP_NetworkDataFileCreator.createFile("1", string + "/", bl, true);
            iP_NetworkDataFileCreator.createFile("3", string + "/", bl, true);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw new RestoreException(configurationVersionException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "saveIP_AddressData()", "Throwable caught." + throwable);
            throw new RestoreException("Class name: " + this.getClass().getName() + "\n\tsaveIP_AddressData()" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void setActionRejectedResult(ActionInformationResultInformation actionInformationResultInformation, String string, String string2, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setActionRejectedResult(ActionInformationResultErrorInformation anActionResultErrorInformation, String anAdditionalInformationToActionInformation, String aCV_Name, boolean anIsForcedRestoreRequested)", "anActionResultErrorInformation: " + actionInformationResultInformation + "\n\tanAdditionalInformationToActionInformation: " + string + "\n\taCV_Name: " + string2 + "\n\tanIsForcedRestoreRequested: " + bl);
        }
        this.setActionRejectedResult(new AdditionalInformationContainer(), actionInformationResultInformation, string, string2, bl);
    }

    private void setActionRejectedResult(AdditionalInformationContainer additionalInformationContainer, ActionInformationResultInformation actionInformationResultInformation, String string, String string2, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setActionRejectedResult(AdditionalInformationContainer anAdditionalInformationContainer, ActionInformationResultErrorInformation anActionResultErrorInformation, String anAdditionalInformationToActionInformation, String aCV_Name, boolean anIsForcedRestoreRequested)", "anAdditionalInformationContainer: " + additionalInformationContainer + "\n\tanActionResultErrorInformation: " + actionInformationResultInformation + "\n\tanAdditionalInformationToActionInformation: " + string + "\n\taCV_Name: " + string2 + "\n\tanIsForcedRestoreRequested: " + bl);
        }
        try {
            CV_ActionResultCreator cV_ActionResultCreator = new CV_ActionResultCreator();
            RestoreRejectedEvent restoreRejectedEvent = new RestoreRejectedEvent(this, additionalInformationContainer.getTraceInfos(), additionalInformationContainer.getTraceWarnings(), additionalInformationContainer.getTraceErrors(), actionInformationResultInformation, string, string2);
            CV_ActionResultDataTypeOfInvokedActionValue cV_ActionResultDataTypeOfInvokedActionValue = null;
            cV_ActionResultDataTypeOfInvokedActionValue = bl ? new InvokedActionForcedRestoreInformation() : new InvokedActionRestoreInformation();
            cV_ActionResultCreator.createActionResult(restoreRejectedEvent, cV_ActionResultDataTypeOfInvokedActionValue);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setActionRejectedResult(AdditionalInformationContainer anAdditionalInformationContainer, ActionInformationResultErrorInformation anActionResultErrorInformation, String anAdditionalInformationToActionInformation, String aCV_Name, boolean anIsForcedRestoreRequested)", "Throwable caugth when attempting to set the attribute actionResult (ignored).\n\tanAdditionalInformationContainer: " + additionalInformationContainer + "\n\tanActionResultErrorInformation: " + actionInformationResultInformation + "\n\tanAdditionalInformationToActionInformation: " + string + "\n\taCV_Name: " + string2 + "\n\tanIsForcedRestoreRequested: " + bl, throwable);
        }
    }

    private void validateInputData(RestoreRequestEvent restoreRequestEvent) throws IllegalInputDataException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validateInputData(RestoreRequestEvent aRestoreRequestEvent)", "aRestoreRequestEvent: " + restoreRequestEvent);
        }
        this.validateMandatoryString("cvName", restoreRequestEvent.cvName);
        if (restoreRequestEvent.cvAutoConfigurationInformation < 0 || restoreRequestEvent.cvAutoConfigurationInformation > 2) {
            throw new IllegalInputDataException("The parameter cvAutoConfigurationInformation must have a value between 0-2.\n\tInput value: " + restoreRequestEvent.cvAutoConfigurationInformation);
        }
        int n = 40;
        this.validateLengthOfString(restoreRequestEvent.cvName, n, "The max length of the parameter 'cvName' is " + n + " characters." + "\n\tcvName: " + restoreRequestEvent.cvName);
    }

    private String writeToHTML_File(ResponseEvent responseEvent) throws RestoreException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeToHTML_File(ResponseEvent aResponseEvent)", "aResponseEvent: " + responseEvent);
        }
        VerifyResultInfo verifyResultInfo = null;
        try {
            if (responseEvent instanceof VerifyConfirmedDetailedEvent) {
                verifyResultInfo = ((VerifyConfirmedDetailedEvent)responseEvent).getVerifyResultInfo();
            } else if (responseEvent instanceof VerifyRejectedDetailedEvent) {
                verifyResultInfo = ((VerifyRejectedDetailedEvent)responseEvent).getVerifyResultInfo();
            } else {
                Trace.warning(this.getClass(), "writeToHTML_File(ResponseEvent aResponseEvent)", "Unexpected type of event received (no HTML report is generated).\n\taResponseEvent: " + responseEvent);
                return "";
            }
            VerifyProperties verifyProperties = new VerifyProperties();
            String string = verifyProperties.cvCMA_FileDisk + verifyProperties.getCV_CMA_CV_Path() + "/" + responseEvent.getCV_Name();
            FilePath filePath = new FilePath();
            filePath.createDirPath(string);
            filePath.removeFilesInDirectory(string);
            Integer n = TimeHandler.createActionId();
            String string2 = string + "/";
            String string3 = n + verifyProperties.getHTML_FileSuffix();
            HtmlGenerator htmlGenerator = new HtmlGenerator();
            htmlGenerator.generateVerificationHtml(string2, string3, verifyResultInfo);
            if (responseEvent instanceof ResponseRejectedInfosEvent) {
                ((ResponseRejectedInfosEvent)responseEvent).setPathToDetailedInformation(string2 + string3);
            }
            return string2 + string3;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "writeToHTML_File(ResponseEvent aResponseEvent)", "Throwable caught.\n\taResponseEvent: " + responseEvent, throwable);
            throw new RestoreException("Class name: " + this.getClass().getName() + "\n\twriteToHTML_File(ResponseEvent aResponseEvent)" + "\n\taResponseEvent: " + responseEvent + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }
}

