/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.verify.swintegrity;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.configurationversion.verify.swintegrity.LM_Data;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.enumer.ActivatedTypeOfUP;

public class UP_LM_Relation {
    public ProductDataContainer upProductData = null;
    public ActivatedTypeOfUP activatedTypeOfUP = null;
    public boolean isExecutingUP = false;
    public Collection corruptedLoadModules = new LinkedList();
    public Collection corruptedSignatureModules = new LinkedList();
    public Collection missingLoadModules = new LinkedList();
    public Collection missingSignatureModules = new LinkedList();

    public UP_LM_Relation(ProductDataContainer productDataContainer, ActivatedTypeOfUP activatedTypeOfUP, boolean bl) {
        this.upProductData = productDataContainer;
        this.activatedTypeOfUP = activatedTypeOfUP;
        this.isExecutingUP = bl;
    }

    public void addCorruptedLM(LM_Data lM_Data) {
        this.logCorruptedLM_ToBeAdded(lM_Data);
        this.corruptedLoadModules.add(lM_Data);
    }

    public void addMissingLM(LM_Data lM_Data) {
        this.logMissingLM_ToBeAdded(lM_Data);
        this.missingLoadModules.add(lM_Data);
    }

    public void addCorruptedSM(LM_Data lM_Data) {
        this.logCorruptedSM_ToBeAdded(lM_Data);
        this.corruptedSignatureModules.add(lM_Data);
    }

    public void addMissingSM(LM_Data lM_Data) {
        this.logMissingSM_ToBeAdded(lM_Data);
        this.missingSignatureModules.add(lM_Data);
    }

    public boolean isAnyCorruptedLM_Critical() {
        Iterator iterator = this.corruptedLoadModules.iterator();
        LM_Data lM_Data = null;
        while (iterator.hasNext()) {
            lM_Data = (LM_Data)iterator.next();
            if (!lM_Data.isCriticalForRestore) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyMissingLM_Critical() {
        Iterator iterator = this.missingLoadModules.iterator();
        LM_Data lM_Data = null;
        while (iterator.hasNext()) {
            lM_Data = (LM_Data)iterator.next();
            if (!lM_Data.isCriticalForRestore) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyCorruptedSM_Critical() {
        Iterator iterator = this.corruptedSignatureModules.iterator();
        LM_Data lM_Data = null;
        while (iterator.hasNext()) {
            lM_Data = (LM_Data)iterator.next();
            if (!lM_Data.isCriticalForRestore) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyMissingSM_Critical() {
        Iterator iterator = this.missingSignatureModules.iterator();
        LM_Data lM_Data = null;
        while (iterator.hasNext()) {
            lM_Data = (LM_Data)iterator.next();
            if (!lM_Data.isCriticalForRestore) continue;
            return true;
        }
        return false;
    }

    private void logCorruptedLM_ToBeAdded(LM_Data lM_Data) {
        if (Trace.valid(this.getClass(), 40)) {
            boolean bl = this.isDuplicate(lM_Data.productNumberAndRevision, this.corruptedLoadModules);
            Trace.debug("logCorruptedLM_ToBeAdded(LM_Data anLM_Data)", "CorruptedLM prodNo: " + lM_Data.productNumberAndRevision.getProductNumber() + ", rev: " + lM_Data.productNumberAndRevision.getRevision() + ", is duplicate: " + bl + ", is critical: " + lM_Data.isCriticalForRestore);
        }
    }

    private void logMissingLM_ToBeAdded(LM_Data lM_Data) {
        if (Trace.valid(this.getClass(), 40)) {
            boolean bl = this.isDuplicate(lM_Data.productNumberAndRevision, this.missingLoadModules);
            Trace.debug("logCorruptedLM_ToBeAdded(LM_Data anLM_Data)", "MissingLM prodNo: " + lM_Data.productNumberAndRevision.getProductNumber() + ", rev: " + lM_Data.productNumberAndRevision.getRevision() + ", is duplicate: " + bl + ", is critical: " + lM_Data.isCriticalForRestore);
        }
    }

    private void logCorruptedSM_ToBeAdded(LM_Data lM_Data) {
        if (Trace.valid(this.getClass(), 40)) {
            boolean bl = this.isDuplicate(lM_Data.productNumberAndRevision, this.corruptedSignatureModules);
            Trace.debug("logCorruptedSM_ToBeAdded(LM_Data anLM_Data)", "CorruptedSM prodNo: " + lM_Data.productNumberAndRevision.getProductNumber() + ", rev: " + lM_Data.productNumberAndRevision.getRevision() + ", is duplicate: " + bl + ", is critical: " + lM_Data.isCriticalForRestore);
        }
    }

    private void logMissingSM_ToBeAdded(LM_Data lM_Data) {
        if (Trace.valid(this.getClass(), 40)) {
            boolean bl = this.isDuplicate(lM_Data.productNumberAndRevision, this.missingSignatureModules);
            Trace.debug("logCorruptedSM_ToBeAdded(LM_Data anLM_Data)", "MissingSM prodNo: " + lM_Data.productNumberAndRevision.getProductNumber() + ", rev: " + lM_Data.productNumberAndRevision.getRevision() + ", is duplicate: " + bl + ", is critical: " + lM_Data.isCriticalForRestore);
        }
    }

    private boolean isDuplicate(ProductNumberAndRevision productNumberAndRevision, Collection collection) {
        Iterator iterator = collection.iterator();
        ProductNumberAndRevision productNumberAndRevision2 = null;
        while (iterator.hasNext()) {
            productNumberAndRevision2 = ((LM_Data)iterator.next()).productNumberAndRevision;
            if (!productNumberAndRevision2.equals(productNumberAndRevision)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "\n\tupProductData: " + this.upProductData + "\n\tactivatedTypeOfUP: " + this.activatedTypeOfUP + "\n\tisExecutingUP: " + this.isExecutingUP + "\n\tCorrupted LoadModules: " + this.corruptedLoadModules + "\n\tCorrupted Signature Modules: " + this.corruptedSignatureModules + "\n\tMissing Load Modules: " + this.missingLoadModules + "\n\tMissing Signature Modules: " + this.missingSignatureModules;
    }
}

